/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.Property;

public class CustomProperties
extends HashMap<Long, CustomProperty> {
    private final TreeBidiMap<Long, String> dictionary = new TreeBidiMap();
    private boolean isPure = true;

    @Override
    public CustomProperty put(String name, CustomProperty cp) {
        if (name == null) {
            this.isPure = false;
            return null;
        }
        if (!name.equals(cp.getName())) {
            throw new IllegalArgumentException("Parameter \"name\" (" + name + ") and custom property's name (" + cp.getName() + ") do not match.");
        }
        super.remove(this.dictionary.getKey((Object)name));
        this.dictionary.put((Comparable)Long.valueOf(cp.getID()), (Comparable)((Object)name));
        return super.put(cp.getID(), cp);
    }

    private Object put(CustomProperty customProperty) throws ClassCastException {
        Long oldId;
        String name = customProperty.getName();
        Long l = oldId = name == null ? null : (Long)this.dictionary.getKey((Object)name);
        if (oldId != null) {
            customProperty.setID(oldId);
        } else {
            long lastKey = this.dictionary.isEmpty() ? 0L : (Long)this.dictionary.lastKey();
            customProperty.setID(Math.max(lastKey, 31L) + 1L);
        }
        return this.put(name, customProperty);
    }

    public Object remove(String name) {
        Long id = (Long)this.dictionary.removeValue((Object)name);
        return super.remove(id);
    }

    @Override
    public Object put(String name, String value) {
        Property p = new Property(-1L, 31L, value);
        return this.put(new CustomProperty(p, name));
    }

    @Override
    public Object put(String name, Long value) {
        Property p = new Property(-1L, 20L, value);
        return this.put(new CustomProperty(p, name));
    }

    @Override
    public Object put(String name, Double value) {
        Property p = new Property(-1L, 5L, value);
        return this.put(new CustomProperty(p, name));
    }

    @Override
    public Object put(String name, Integer value) {
        Property p = new Property(-1L, 3L, value);
        return this.put(new CustomProperty(p, name));
    }

    @Override
    public Object put(String name, Boolean value) {
        Property p = new Property(-1L, 11L, value);
        return this.put(new CustomProperty(p, name));
    }

    public Object get(String name) {
        Long id = (Long)this.dictionary.getKey((Object)name);
        CustomProperty cp = (CustomProperty)super.get(id);
        return cp != null ? cp.getValue() : null;
    }

    @Override
    public Object put(String name, Date value) {
        Property p = new Property(-1L, 64L, value);
        return this.put(new CustomProperty(p, name));
    }

    @Override
    public Set keySet() {
        return this.dictionary.values();
    }

    public Set<String> nameSet() {
        return this.dictionary.values();
    }

    public Set<String> idSet() {
        return this.dictionary.values();
    }

    public void setCodepage(int codepage) {
        Property p = new Property(1L, 2L, codepage);
        this.put(new CustomProperty(p));
    }

    Map<Long, String> getDictionary() {
        return this.dictionary;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof Long && this.dictionary.containsKey(key) || this.dictionary.containsValue(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof CustomProperty) {
            return super.containsValue(value);
        }
        for (CustomProperty cp : super.values()) {
            if (cp.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public int getCodepage() {
        CustomProperty cp = (CustomProperty)this.get(1);
        return cp == null ? -1 : (Integer)cp.getValue();
    }

    public boolean isPure() {
        return this.isPure;
    }

    public void setPure(boolean isPure) {
        this.isPure = isPure;
    }
}

