/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.commands;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.CommandInvoker;
import Gbt.core.commands.CommandTask;
import Gbt.core.engines.DefaultTaskManager;
import Gbt.core.engines.EngineThreadPoolFactory;
import Gbt.core.engines.EngineThreadPoolTypes;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.Update.PreUpdateCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class UpdateInvoker
implements CommandInvoker {
    private static final String INVOKE_POOL_NAME = "Update Invoker";
    private int invokeCount = 0;
    private int successCount = 0;
    private List<AbstractCommand> commandList = new ArrayList<AbstractCommand>();
    private List<CommandTaskRecords> commandTaskRecords = new ArrayList<CommandTaskRecords>();
    private boolean isPreserve = true;
    private String tftpIP;
    private String tftpPath;

    public void setTftpIP(String tftpIP) {
        this.tftpIP = tftpIP;
    }

    public void setTftpPath(String tftpPath) {
        this.tftpPath = tftpPath;
    }

    @Override
    public void invoke(AbstractCommandBuilder ... builders) {
        this.invoke(Arrays.asList(builders));
    }

    @Override
    public void invoke(List<AbstractCommandBuilder> builderList) {
        CommandTaskRecords records;
        this.successCount = 0;
        this.invokeCount = builderList.size();
        this.commandList.clear();
        this.commandTaskRecords.clear();
        for (AbstractCommandBuilder abstractCommandBuilder : builderList) {
            if (!(abstractCommandBuilder instanceof PreUpdateCommand.Builder)) continue;
            this.commandList.add(abstractCommandBuilder.build());
        }
        int ckeckOkCount = 0;
        for (AbstractCommand abstractCommand : this.commandList) {
            if (!abstractCommand.checkAll()) {
                try {
                    abstractCommand.close();
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            ++ckeckOkCount;
        }
        if (ckeckOkCount != this.invokeCount) {
            return;
        }
        DefaultTaskManager defaultTaskManager = new DefaultTaskManager(((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName(INVOKE_POOL_NAME)).setThreadNumber(this.commandList.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build());
        for (AbstractCommand command : this.commandList) {
            defaultTaskManager.addEngineTask(new CommandTask(command));
        }
        defaultTaskManager.executeTasks();
        this.commandList.clear();
        for (String taskID : defaultTaskManager.getAllResults().keySet()) {
            records = (CommandTaskRecords)defaultTaskManager.getAllResults().get(taskID);
            if (records.getStates().isPass()) {
                this.commandList.add(new MainUpdateCommand.Builder().setPreUpdateFWInfo(records.getCommand(PreUpdateCommand.class).getCommandResults().get(0)).setPreserveConfig(this.isPreserve).setTFTPIP(this.tftpIP).setTFTPPath(this.tftpPath).build());
                continue;
            }
            this.commandTaskRecords.add(records);
        }
        try {
            defaultTaskManager.close();
        }
        catch (Exception exception) {
            Object var3_7 = null;
        }
        if (this.commandList.isEmpty()) {
            return;
        }
        ckeckOkCount = 0;
        for (AbstractCommand command : this.commandList) {
            if (!command.checkAll()) {
                try {
                    command.close();
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            ++ckeckOkCount;
        }
        if (ckeckOkCount != this.commandList.size()) {
            return;
        }
        DefaultTaskManager defaultTaskManager2 = new DefaultTaskManager(((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName(INVOKE_POOL_NAME)).setThreadNumber(this.commandList.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build());
        for (AbstractCommand command : this.commandList) {
            defaultTaskManager2.addEngineTask(new CommandTask(command));
        }
        defaultTaskManager2.executeTasks();
        this.commandList.clear();
        for (String taskID : defaultTaskManager2.getAllResults().keySet()) {
            records = (CommandTaskRecords)defaultTaskManager2.getAllResults().get(taskID);
            this.commandTaskRecords.add(records);
            if (!records.getStates().isPass()) continue;
            ++this.successCount;
        }
        try {
            defaultTaskManager2.close();
        }
        catch (Exception exception) {
            Object var3_10 = null;
        }
    }

    @Override
    public int getTotalCount() {
        return this.invokeCount;
    }

    @Override
    public int getSuccessCount() {
        return this.successCount;
    }

    @Override
    public List<CommandTaskRecords> getCommandTaskRecords() {
        return this.commandTaskRecords;
    }
}

