/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines;

import Gbt.core.engines.EngineServices;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractEngineServices
extends Observable
implements EngineServices {
    protected String engineType;
    protected boolean unloadTag;

    protected <T extends EngineServiceBuilder<T>> AbstractEngineServices(T builder) {
        this.engineType = builder.engineType;
        this.unloadTag = false;
        for (Observer engineController : builder.engineControllers) {
            this.addObserver(engineController);
        }
    }

    public String getEngineType() {
        return this.engineType;
    }

    public boolean isUnload() {
        return this.unloadTag;
    }

    public static abstract class EngineServiceBuilder<T extends EngineServiceBuilder<T>> {
        protected String engineType = "unknown";
        protected List<Observer> engineControllers;

        protected EngineServiceBuilder() {
            if (this.engineControllers == null) {
                this.engineControllers = new ArrayList<Observer>();
            }
        }

        protected abstract T getThis();

        public abstract AbstractEngineServices build();

        public T setEngineType(String engineType) {
            this.engineType = engineType;
            return this.getThis();
        }

        public T addEngineControllers(Observer engineController) {
            this.engineControllers.add(engineController);
            return this.getThis();
        }

        public String getEngineType() {
            return this.engineType;
        }

        public List<Observer> getEngineControllers() {
            return this.engineControllers;
        }
    }
}

