/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.jsonapi;

import Gbt.core.jsonapi.JacksonCommonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJSONPOJO {
    public final <T extends AbstractJSONPOJO> T castConcreteJSON(Class<T> clazz) {
        if (this.getClass() == clazz) {
            try {
                return (T)((AbstractJSONPOJO)clazz.cast(this));
            }
            catch (ClassCastException cce) {
                cce.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public final boolean saveAs(File fileName) {
        try {
            JacksonCommonUtil.getUtil().writeJSONFile(fileName, (Object)this);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public final Map<String, Object> parserToFormData() {
        Method[] methods;
        HashMap<String, Object> formDataMap = new HashMap<String, Object>();
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(JsonProperty.class)) continue;
            String jsonPropertyName = method.getAnnotation(JsonProperty.class).value();
            if (!method.getName().toLowerCase().contains(jsonPropertyName.toLowerCase())) continue;
            try {
                Object dataValue = method.invoke((Object)this, new Object[0]);
                if (dataValue == null) continue;
                formDataMap.put(jsonPropertyName, dataValue);
            }
            catch (IllegalAccessException | InvocationTargetException ie) {
                break;
            }
        }
        return formDataMap;
    }

    public final Map<String, Object> parserToFormData(String propertyName) {
        Method[] methods;
        HashMap<String, Object> formDataMap = new HashMap<String, Object>();
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(JsonProperty.class)) continue;
            String jsonPropertyName = method.getAnnotation(JsonProperty.class).value();
            if (!method.getName().toLowerCase().contains(jsonPropertyName.toLowerCase())) continue;
            try {
                Object dataValue = method.invoke((Object)this, new Object[0]);
                if (dataValue == null || !jsonPropertyName.equals(propertyName)) continue;
                formDataMap.put(jsonPropertyName, dataValue);
            }
            catch (IllegalAccessException | InvocationTargetException ie) {
                break;
            }
        }
        return formDataMap;
    }

    public final boolean checkFieldsFullNull() {
        Method[] methods = this.getClass().getMethods();
        int countA = 0;
        int countB = 0;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(JsonProperty.class)) continue;
            ++countA;
            String jsonPropertyName = method.getAnnotation(JsonProperty.class).value();
            if (!method.getName().toLowerCase().contains(jsonPropertyName.toLowerCase())) continue;
            try {
                Object dataValue = method.invoke((Object)this, new Object[0]);
                if (dataValue != null) continue;
                ++countB;
            }
            catch (IllegalAccessException | InvocationTargetException ie) {
                break;
            }
        }
        return countB == countA;
    }

    public final JavaType parseJavaType() {
        return JacksonCommonUtil.getUtil().getTypeFactory().constructType(this.getClass());
    }

    public final JsonNode parseJsonNode() {
        return JacksonCommonUtil.getUtil().readRootNode(this);
    }

    public String toString() {
        return JacksonCommonUtil.getUtil().getPrettyPrintString(this);
    }
}

