/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.redfish;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.JsonSchemasManager;
import Gbt.core.jsonapi.JsonSchemasResourceTypes;
import Gbt.core.redfish.RedfishResourceTypes;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class RedfishSchemasManager
extends JsonSchemasManager<RedfishResourceTypes> {
    private static final String REDFISH_SCHEMAS_PROPERTIES_PATH = "/properties/redfishSchemas.properties";
    private static volatile RedfishSchemasManager manager;

    private RedfishSchemasManager() {
        this.loadSchemasProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final RedfishSchemasManager getManager() {
        if (manager != null) return manager;
        Class<RedfishSchemasManager> clazz = RedfishSchemasManager.class;
        synchronized (RedfishSchemasManager.class) {
            if (manager != null) return manager;
            manager = new RedfishSchemasManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    @Override
    public JsonSchema getSchema(JsonSchemasResourceTypes schemaType) {
        return schemaType instanceof RedfishResourceTypes ? (JsonSchema)this.schemas.get(schemaType) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadSchemasProperties() {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream(REDFISH_SCHEMAS_PROPERTIES_PATH));
            for (Object key : props.keySet()) {
                RedfishResourceTypes type = RedfishResourceTypes.parse(key.toString());
                JsonSchema jsonSchema = this.loadJsonSchemasFromResources(type.getSchemaPath() + props.getProperty(key.toString()));
                if (jsonSchema == null) continue;
                this.schemas.put(type, jsonSchema);
            }
        }
        catch (IOException ioe) {
            ioe.getMessage();
        }
        finally {
            props.clear();
        }
    }

    @Override
    protected JsonSchema loadJsonSchemasFromResources(String jsonSchemaFilePath) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(jsonSchemaFilePath);
            return JacksonCommonUtil.getUtil().readJsonSchemaNode(inputStream);
        }
        catch (ProcessingException | IOException exp) {
            return null;
        }
    }
}

