/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Chassis;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Chassis.ChassisLastPowerEvent;
import Gbt.utility.Chassis.ChassisPowerCommand;
import Gbt.utility.Chassis.ChassisResponseData;
import com.veraxsystems.vxipmi.common.TypeConverter;

public enum ChassisPowerIpmiOptions implements GbtIPMIOptions<ChassisPowerCommand.Builder>
{
    STATUS(1, "Get chassis status", 1),
    CONTROL(2, "Set chassis command", 2);

    private static final String STATUS_ITEM = "Get chassis status";
    private static final String CONTROL_ITEM = "Set chassis command";
    private final int optionCode;
    private final String item;
    private final byte cmd;

    private ChassisPowerIpmiOptions(int optionCode, String item, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 0;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(ChassisPowerCommand.Builder commandArgs) {
        switch (this) {
            case STATUS: {
                return null;
            }
            case CONTROL: {
                return new byte[]{TypeConverter.intToByte(commandArgs.chassisType.getCode())};
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        switch (this) {
            case STATUS: {
                if (gbtResponseData.getAllResponseData().length > 4 || gbtResponseData.getAllResponseData().length < 3) {
                    return new NullJSONData().setError(true).setMessages("Response data length not correct.");
                }
                ChassisResponseData statusData = new ChassisResponseData();
                statusData.parseCurrentPowerState(gbtResponseData.getResponseData(0));
                statusData.setLastPowerEvent(ChassisLastPowerEvent.parse(gbtResponseData.getResponseData(1)));
                statusData.parseMiscChassisState(gbtResponseData.getResponseData(2));
                if (gbtResponseData.getAllResponseData().length > 3) {
                    statusData.parseFrontPanelButtonCapabilities(gbtResponseData.getResponseData(3));
                }
                return statusData;
            }
            case CONTROL: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown parse option of chassis command.");
    }
}

