/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Chassis;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.Chassis.ChassisIdentifyState;
import Gbt.utility.Chassis.ChassisLastPowerEvent;
import Gbt.utility.Chassis.PowerRestorePolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;

public final class ChassisResponseData
extends AbstractJSONPOJO {
    private Boolean powerOn = Boolean.FALSE;
    private Boolean powerOverload = Boolean.FALSE;
    private Boolean powerInterlock = Boolean.FALSE;
    private Boolean powerFault = Boolean.FALSE;
    private Boolean powerControlFault = Boolean.FALSE;
    private PowerRestorePolicy powerRestorePolicy;
    private ChassisLastPowerEvent lastPowerEvent;
    private Boolean chassisIntrusionActive = Boolean.FALSE;
    private Boolean frontPanelLockoutActive = Boolean.FALSE;
    private Boolean driveFault = Boolean.FALSE;
    private Boolean coolingFault = Boolean.FALSE;
    private Boolean chassisIdentifyCommandSupported = Boolean.FALSE;
    private ChassisIdentifyState chassisIdentifyState;
    private Boolean standbyButtonDisabledAllowed = Boolean.FALSE;
    private Boolean diagnosticInterruptButtonDisabledAllowed = Boolean.FALSE;
    private Boolean resetButtonDisabledAllowed = Boolean.FALSE;
    private Boolean powerOffButtonDisableAllowed = Boolean.FALSE;
    private Boolean standbyButtonDisabled = Boolean.FALSE;
    private Boolean diagnosticInterruptButtonDisabled = Boolean.FALSE;
    private Boolean resetButtonDisabled = Boolean.FALSE;
    private Boolean powerOffButtonDisabled = Boolean.FALSE;

    @JsonProperty(value="PowerOn")
    public Boolean getPowerOn() {
        return this.powerOn;
    }

    public void setPowerOn(Boolean powerOn) {
        this.powerOn = powerOn;
    }

    @JsonProperty(value="PowerOverload")
    public Boolean getPowerOverload() {
        return this.powerOverload;
    }

    public void setPowerOverload(Boolean powerOverload) {
        this.powerOverload = powerOverload;
    }

    @JsonProperty(value="PowerInterlock")
    public Boolean getPowerInterlock() {
        return this.powerInterlock;
    }

    public void setPowerInterlock(Boolean powerInterlock) {
        this.powerInterlock = powerInterlock;
    }

    @JsonProperty(value="PowerFault")
    public Boolean getPowerFault() {
        return this.powerFault;
    }

    public void setPowerFault(Boolean powerFault) {
        this.powerFault = powerFault;
    }

    @JsonProperty(value="PowerControlFault")
    public Boolean getPowerControlFault() {
        return this.powerControlFault;
    }

    public void setPowerControlFault(Boolean powerControlFault) {
        this.powerControlFault = powerControlFault;
    }

    @JsonProperty(value="PowerRestorePolicy")
    public PowerRestorePolicy getPowerRestorePolicy() {
        return this.powerRestorePolicy;
    }

    public void setPowerRestorePolicy(PowerRestorePolicy powerRestorePolicy) {
        this.powerRestorePolicy = powerRestorePolicy;
    }

    @JsonProperty(value="LastPowerEvent")
    public ChassisLastPowerEvent getLastPowerEvent() {
        return this.lastPowerEvent;
    }

    public void setLastPowerEvent(ChassisLastPowerEvent lastPowerEvent) {
        this.lastPowerEvent = lastPowerEvent;
    }

    @JsonProperty(value="ChassisIntrusionActive")
    public Boolean getChassisIntrusionActive() {
        return this.chassisIntrusionActive;
    }

    public void setChassisIntrusionActive(Boolean chassisIntrusionActive) {
        this.chassisIntrusionActive = chassisIntrusionActive;
    }

    @JsonProperty(value="FrontPanelLockoutActive")
    public Boolean getFrontPanelLockoutActive() {
        return this.frontPanelLockoutActive;
    }

    public void setFrontPanelLockoutActive(Boolean frontPanelLockoutActive) {
        this.frontPanelLockoutActive = frontPanelLockoutActive;
    }

    @JsonProperty(value="DriveFault")
    public Boolean getDriveFault() {
        return this.driveFault;
    }

    public void setDriveFault(Boolean driveFault) {
        this.driveFault = driveFault;
    }

    @JsonProperty(value="CoolingFault")
    public Boolean getCoolingFault() {
        return this.coolingFault;
    }

    public void setCoolingFault(Boolean coolingFault) {
        this.coolingFault = coolingFault;
    }

    @JsonProperty(value="ChassisIdentifyCommandSupported")
    public Boolean getChassisIdentifyCommandSupported() {
        return this.chassisIdentifyCommandSupported;
    }

    public void setChassisIdentifyCommandSupported(Boolean chassisIdentifyCommandSupported) {
        this.chassisIdentifyCommandSupported = chassisIdentifyCommandSupported;
    }

    @JsonProperty(value="ChassisIdentifyState")
    public ChassisIdentifyState getChassisIdentifyState() {
        return this.chassisIdentifyState;
    }

    public void setChassisIdentifyState(ChassisIdentifyState chassisIdentifyState) {
        this.chassisIdentifyState = chassisIdentifyState;
    }

    @JsonProperty(value="StandbyButtonDisabledAllowed")
    public Boolean getStandbyButtonDisabledAllowed() {
        return this.standbyButtonDisabledAllowed;
    }

    public void setStandbyButtonDisabledAllowed(Boolean standbyButtonDisabledAllowed) {
        this.standbyButtonDisabledAllowed = standbyButtonDisabledAllowed;
    }

    @JsonProperty(value="DiagnosticInterruptButtonDisabledAllowed")
    public Boolean getDiagnosticInterruptButtonDisabledAllowed() {
        return this.diagnosticInterruptButtonDisabledAllowed;
    }

    public void setDiagnosticInterruptButtonDisabledAllowed(Boolean diagnosticInterruptButtonDisabledAllowed) {
        this.diagnosticInterruptButtonDisabledAllowed = diagnosticInterruptButtonDisabledAllowed;
    }

    @JsonProperty(value="ResetButtonDisabledAllowed")
    public Boolean getResetButtonDisabledAllowed() {
        return this.resetButtonDisabledAllowed;
    }

    public void setResetButtonDisabledAllowed(Boolean resetButtonDisabledAllowed) {
        this.resetButtonDisabledAllowed = resetButtonDisabledAllowed;
    }

    @JsonProperty(value="PowerOffButtonDisableAllowed")
    public Boolean getPowerOffButtonDisableAllowed() {
        return this.powerOffButtonDisableAllowed;
    }

    public void setPowerOffButtonDisableAllowed(Boolean powerOffButtonDisableAllowed) {
        this.powerOffButtonDisableAllowed = powerOffButtonDisableAllowed;
    }

    @JsonProperty(value="StandbyButtonDisabled")
    public Boolean getStandbyButtonDisabled() {
        return this.standbyButtonDisabled;
    }

    public void setStandbyButtonDisabled(Boolean standbyButtonDisabled) {
        this.standbyButtonDisabled = standbyButtonDisabled;
    }

    @JsonProperty(value="DiagnosticInterruptButtonDisabled")
    public Boolean getDiagnosticInterruptButtonDisabled() {
        return this.diagnosticInterruptButtonDisabled;
    }

    public void setDiagnosticInterruptButtonDisabled(Boolean diagnosticInterruptButtonDisabled) {
        this.diagnosticInterruptButtonDisabled = diagnosticInterruptButtonDisabled;
    }

    @JsonProperty(value="ResetButtonDisabled")
    public Boolean getResetButtonDisabled() {
        return this.resetButtonDisabled;
    }

    public void setResetButtonDisabled(Boolean resetButtonDisabled) {
        this.resetButtonDisabled = resetButtonDisabled;
    }

    @JsonProperty(value="PowerOffButtonDisabled")
    public Boolean getPowerOffButtonDisabled() {
        return this.powerOffButtonDisabled;
    }

    public void setPowerOffButtonDisabled(Boolean powerOffButtonDisabled) {
        this.powerOffButtonDisabled = powerOffButtonDisabled;
    }

    public void parseCurrentPowerState(byte currentPowerState) {
        block7: for (int i = 0; i < 5; ++i) {
            byte val = (byte)(currentPowerState & TypeConverter.intToByte(1 << i));
            switch (val) {
                case 1: {
                    this.setPowerOn(Boolean.TRUE);
                    continue block7;
                }
                case 2: {
                    this.setPowerOverload(Boolean.TRUE);
                    continue block7;
                }
                case 4: {
                    this.setPowerInterlock(Boolean.TRUE);
                    continue block7;
                }
                case 8: {
                    this.setPowerFault(Boolean.TRUE);
                    continue block7;
                }
                case 16: {
                    this.setPowerControlFault(Boolean.TRUE);
                    continue block7;
                }
            }
        }
        this.setPowerRestorePolicy(PowerRestorePolicy.parse(currentPowerState));
    }

    public void parseMiscChassisState(byte miscChassisState) {
        block7: for (int i = 0; i < 7; ++i) {
            byte val = (byte)(miscChassisState & TypeConverter.intToByte(1 << i));
            switch (val) {
                case 1: {
                    this.setChassisIntrusionActive(Boolean.TRUE);
                    continue block7;
                }
                case 2: {
                    this.setFrontPanelLockoutActive(Boolean.TRUE);
                    continue block7;
                }
                case 4: {
                    this.setDriveFault(Boolean.TRUE);
                    continue block7;
                }
                case 8: {
                    this.setCoolingFault(Boolean.TRUE);
                    continue block7;
                }
                case 64: {
                    this.setChassisIdentifyCommandSupported(Boolean.TRUE);
                    continue block7;
                }
            }
        }
        if (this.getChassisIdentifyCommandSupported().booleanValue()) {
            this.setChassisIdentifyState(ChassisIdentifyState.parseInt(miscChassisState));
        }
    }

    public void parseFrontPanelButtonCapabilities(byte frontPanelButtonCapabilities) {
        block10: for (int i = 0; i < 8; ++i) {
            byte val = (byte)(frontPanelButtonCapabilities & TypeConverter.intToByte(1 << i));
            switch (val) {
                case 1: {
                    this.setPowerOffButtonDisabled(Boolean.TRUE);
                    continue block10;
                }
                case 2: {
                    this.setResetButtonDisabled(Boolean.TRUE);
                    continue block10;
                }
                case 4: {
                    this.setDiagnosticInterruptButtonDisabled(Boolean.TRUE);
                    continue block10;
                }
                case 8: {
                    this.setStandbyButtonDisabled(Boolean.TRUE);
                    continue block10;
                }
                case 16: {
                    this.setPowerOffButtonDisableAllowed(Boolean.TRUE);
                    continue block10;
                }
                case 32: {
                    this.setResetButtonDisabledAllowed(Boolean.TRUE);
                    continue block10;
                }
                case 64: {
                    this.setDiagnosticInterruptButtonDisabledAllowed(Boolean.TRUE);
                    continue block10;
                }
                case -128: {
                    this.setStandbyButtonDisabledAllowed(Boolean.TRUE);
                    continue block10;
                }
            }
        }
    }
}

