/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;

public class GbtFileReadPDF {
    private GbtFileReadPDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getReadText(String filePath) {
        String output = null;
        PDDocument document = null;
        PDFTextStripper stripper = null;
        try {
            document = PDDocument.load((String)filePath);
            if (document.isEncrypted()) {
                document.decrypt("");
            }
            stripper = new PDFTextStripper();
            output = stripper.getText(document);
        }
        catch (IOException e) {
            System.out.println(filePath + " read I/O error.");
            String string = output;
            return string;
        }
        catch (CryptographyException e) {
            System.out.println(filePath + " error decrypt.");
            String string = output;
            return string;
        }
        finally {
            if (document != null && stripper != null) {
                try {
                    document.close();
                    stripper = null;
                }
                catch (IOException e) {
                    System.out.println(filePath + " resources close error.");
                }
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getReadText(String filePath, int startPageValue, int endPageValue) {
        String output = null;
        PDDocument document = null;
        PDFTextStripper stripper = null;
        try {
            document = PDDocument.load((String)filePath);
            if (document.isEncrypted()) {
                document.decrypt("");
            }
            stripper = new PDFTextStripper();
            stripper.setStartPage(startPageValue);
            stripper.setEndPage(endPageValue);
            output = stripper.getText(document);
        }
        catch (IOException e) {
            System.out.println(filePath + " read I/O error.");
            String string = output;
            return string;
        }
        catch (CryptographyException e) {
            System.out.println(filePath + " error decrypt.");
            String string = output;
            return string;
        }
        finally {
            if (document != null && stripper != null) {
                try {
                    document.close();
                    stripper = null;
                }
                catch (IOException e) {
                    System.out.println(filePath + " resources close error.");
                }
            }
        }
        return output;
    }

    public static final List<String> getReadList(String filePath) {
        String result = GbtFileReadPDF.getReadText(filePath);
        if (result != null) {
            String[] originalTextArray;
            ArrayList<String> records = new ArrayList<String>();
            for (String oneline : originalTextArray = result.split("\n")) {
                if (oneline.length() <= 1) continue;
                records.add(oneline.trim());
            }
            return records;
        }
        return null;
    }

    public static final List<String> getReadList(String filePath, int startPageValue, int endPageValue) {
        String result = GbtFileReadPDF.getReadText(filePath, startPageValue, endPageValue);
        if (result != null) {
            String[] originalTextArray;
            ArrayList<String> records = new ArrayList<String>();
            for (String oneline : originalTextArray = result.split("\n")) {
                if (oneline.length() <= 1) continue;
                records.add(oneline.trim());
            }
            return records;
        }
        return null;
    }
}

