/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HDDInfo;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.HDDInfo.HwInfoCollection;
import Gbt.utility.HDDInfo.data.HwInfoFullData;
import Gbt.utility.HDDInfo.parsers.HwInfoParser;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.menu.GbtUtility;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.util.List;

public final class HwInfoCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "hwinfo";
    private GbtIPMICommandReceiver ipmiReceiver;
    private static final String REMOTE_FILE_NAME = "/var/smash/smbios_ex.bin";

    protected HwInfoCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                break;
            }
            case AMI: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor.");
                return false;
            }
        }
        File dumpFile = new File(GbtUtility.getResultsRootPath() + "/" + COMMAND_NAME + "/" + ((Builder)this.commandArgs).bmcIP + "_SMBIOS.bin");
        if (!this.ipmiReceiver.getSMBIOSAndHDDInfo(handle, REMOTE_FILE_NAME, dumpFile, 1, COMMAND_NAME, this.commandID)) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Download SMBIOS file fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        HwInfoFullData hwInfoFullData = new HwInfoFullData();
        HwInfoParser parser = HwInfoCollection.CPU_INFO.createParser(dumpFile);
        List<AbstractJSONPOJO> deviceInfos = parser.parseHwInfo();
        if (deviceInfos.isEmpty()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] No CPU info.");
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get CPU info.");
            for (AbstractJSONPOJO data : deviceInfos) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, data.toString());
            }
            hwInfoFullData.setCpuInfo(deviceInfos);
        }
        parser = HwInfoCollection.MEM_INFO.createParser(dumpFile);
        deviceInfos = parser.parseHwInfo();
        if (deviceInfos.isEmpty()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] No memory info.");
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get memory info.");
            for (AbstractJSONPOJO data : deviceInfos) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, data.toString());
            }
            hwInfoFullData.setMemInfo(deviceInfos);
        }
        parser = HwInfoCollection.HDD_INFO.createParser(dumpFile);
        deviceInfos = parser.parseHwInfo();
        if (deviceInfos.isEmpty()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] No HDD info.");
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get HDD info.");
            for (AbstractJSONPOJO data : deviceInfos) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, data.toString());
            }
            hwInfoFullData.setHddInfo(deviceInfos);
        }
        parser = HwInfoCollection.LAN_INFO.createParser(dumpFile);
        deviceInfos = parser.parseHwInfo();
        if (deviceInfos.isEmpty()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] No LAN info.");
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get LAN info.");
            for (AbstractJSONPOJO data : deviceInfos) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, data.toString());
            }
            hwInfoFullData.setLanInfo(deviceInfos);
        }
        this.commandResults.add(hwInfoFullData);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                return this.args.length == 0;
            }
            return this.bmcIP != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public HwInfoCommand build() {
            return new HwInfoCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }
    }
}

