/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HpmUpdate;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.LocalCmdRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GctIpmitoolCommandReceiver;
import Gbt.core.rest.RESTServices;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.BIOSUpdateFWInfo;
import Gbt.utility.Update.fwInfo.BMCUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.Update.fwInfo.PldmUpdateFWInfo;
import Gbt.utility.Update.fwInfo.ScpUpdateFWInfo;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.monitor.MonitorMemoryUsageThread;
import Gbt.utility.rest.options.UpdateServiceOptions;
import Gbt.utility.rest.services.HpmUpdateService;
import Gbt.utility.rest.services.UpdateService;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.math.BigInteger;

public final class HpmUpdateCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "hpmupdate";
    private static final int MAX_RETRY_COUNT = 15;
    private static final String GCTIPMITOOL_CMD_GRACEUPDATE = "graceupdate FWPKG";
    private static final String GCTIPMITOOL_CMD_UPDATE_MAINBMC = "update MAIN_BMC";
    private static final String GCTIPMITOOL_CMD_UPDATE_BACKUPBMC = "update BACKUP_BMC";
    private static final String GCTIPMITOOL_CMD_UPDATE_MAINBIOS = "update MAIN_BIOS";
    private static final String GCTIPMITOOL_CMD_UPDATE_BACKUPBIOS = "update BACKUP_BIOS";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected HpmUpdateCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME + "_" + ((Builder)this.commandArgs).updateType.toString();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI connection fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        BMCInfoJSONData bmcInfo = this.ipmiReceiver.getBmcInfo(handle, ((Builder)this.commandArgs).bmcIP, COMMAND_NAME, this.commandID);
        if (bmcInfo == null) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Get BMC info fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC info fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        switch (((Builder)this.commandArgs).updateType) {
            case BMC: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                BMCUpdateFWInfo bmcUpdInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(BMCUpdateFWInfo.class);
                bmcUpdInfo.setIsHpmUpdate(true);
                bmcUpdInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Current Rev : " + bmcUpdInfo.getCurrentVersion() + " \tNew Rev : " + bmcUpdInfo.getNewVersion());
                if (((Builder)this.commandArgs).skip && CommonFunction.isVersionEqual(bmcUpdInfo.getCurrentVersion(), bmcUpdInfo.getNewVersion())) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Skip same FW version update.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(false).setMessages("Skip same FW version update."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return true;
                }
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_MAINBMC, bmcUpdInfo)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                bmcUpdInfo.setBackupFlag(BigInteger.valueOf(0L));
                if (this.HpmUpdateBmcProcess(bmcUpdInfo, handle)) break;
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
            case BIOS: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                BIOSUpdateFWInfo biosUpdInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(BIOSUpdateFWInfo.class);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] New Rev : " + biosUpdInfo.getVersion());
                if (((Builder)this.commandArgs).preupdateFWInfo instanceof PldmUpdateFWInfo && ((Builder)this.commandArgs).gctIpmiMode) {
                    PldmUpdateFWInfo pldmUpdInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(PldmUpdateFWInfo.class);
                    if (this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_GRACEUPDATE, pldmUpdInfo)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_MAINBIOS, biosUpdInfo)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (this.HpmRestUpdateProcess(biosUpdInfo, handle)) break;
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
            case SCP: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                ScpUpdateFWInfo scpUpdInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(ScpUpdateFWInfo.class);
                if (this.HpmRestUpdateProcess(scpUpdInfo, handle)) break;
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
            case EROT: 
            case VBIOS: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                PldmUpdateFWInfo pldmUpdateFWInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(PldmUpdateFWInfo.class);
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_GRACEUPDATE, pldmUpdateFWInfo)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (this.HpmRestUpdateProcess(pldmUpdateFWInfo, handle)) break;
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
            default: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unknown update type.");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Unknown update type."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        this.commandResults.add(new NullJSONData().setError(false).setMessages("Update success."));
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    private final boolean HpmRestUpdateProcess(CommonUpdateFWInfo fwinfo, ConnectionHandle handle) {
        HpmUpdateService restServices = new HpmUpdateService(this.loggerWriter);
        restServices.setLogDirPath(this.getCommandName());
        UpdateServiceOptions restServicesOptions = UpdateServiceOptions.parse(fwinfo.getUpdateType());
        if (!((RESTServices)restServices).readJsonData(fwinfo, restServicesOptions)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Can not read the Json payload instance."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Can not read the Json request payload file.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, ((Builder)this.commandArgs).debug)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Open rest session fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Open rest session fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).execute(((Builder)this.commandArgs).bmcIP, restServicesOptions)) {
            ((RESTServices)restServices).closeSession(((Builder)this.commandArgs).bmcIP);
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.addAll(restServices.getJsonResults());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        ((RESTServices)restServices).closeSession(((Builder)this.commandArgs).bmcIP);
        this.commandResults.addAll(restServices.getJsonResults());
        return true;
    }

    private boolean HpmUpdateBmcProcess(CommonUpdateFWInfo fwinfo, ConnectionHandle handle) {
        UpdateService restServices = new UpdateService(this.loggerWriter);
        restServices.setLogDirPath(this.getCommandName());
        UpdateServiceOptions restServicesOptions = UpdateServiceOptions.parse(fwinfo.getUpdateType());
        if (!((RESTServices)restServices).readJsonData(fwinfo, restServicesOptions)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Can not read the Json payload instance."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Can not read the Json request payload file.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, ((Builder)this.commandArgs).debug)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Open rest session fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Open rest session fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).execute(((Builder)this.commandArgs).bmcIP, restServicesOptions)) {
            ((RESTServices)restServices).closeSession(((Builder)this.commandArgs).bmcIP);
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.addAll(restServices.getJsonResults());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        ((RESTServices)restServices).closeSession(((Builder)this.commandArgs).bmcIP);
        this.commandResults.addAll(restServices.getJsonResults());
        return true;
    }

    private boolean updateFirmwareByGctIpmitool(String cmdOption, CommonUpdateFWInfo fwInfo) {
        long threadId = Thread.currentThread().getId();
        MonitorMemoryUsageThread monitorMemoryUsageThread = new MonitorMemoryUsageThread();
        monitorMemoryUsageThread.setloggerWriter(this.loggerWriter);
        monitorMemoryUsageThread.setCommandName(this.getCommandName());
        monitorMemoryUsageThread.setCommandId(this.commandID);
        monitorMemoryUsageThread.setThreadId(threadId);
        monitorMemoryUsageThread.setShowAll(false);
        monitorMemoryUsageThread.setLogLevel(GbtLogLevel.DEBUG);
        monitorMemoryUsageThread.setInterval(3000L);
        monitorMemoryUsageThread.start();
        String cmd = cmdOption + " " + fwInfo.getImagePath();
        LocalCmdRecords gctipmitoolRecords = GctIpmitoolCommandReceiver.getInstance().executeCommand(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, cmd, GbtLogLevel.INFO, this.getCommandName(), this.commandID);
        if (gctipmitoolRecords.getResults().toLowerCase().contains("fail") || gctipmitoolRecords.getErrors().toLowerCase().contains("fail")) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate gctIpmiTool fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + gctipmitoolRecords.getErrors());
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Gbtipmitool execute fail."));
            monitorMemoryUsageThread.shutdown();
            return false;
        }
        monitorMemoryUsageThread.shutdown();
        return true;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        protected UpdateType updateType = UpdateType.UNKNOWN;
        protected File fwImage;
        protected boolean preserveConfig = false;
        private boolean skip = false;
        protected AbstractJSONPOJO preupdateFWInfo;
        private boolean debug = false;
        private boolean gctIpmiMode = false;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(HpmUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "0.0.0.0_hpmupdate", "BMC IP address is null.");
                return false;
            }
            if (this.args != null && this.args.length > 0) {
                this.updateType = this.args.length > 1 ? UpdateType.parse(this.args[0], this.args[1]) : UpdateType.parse(this.args[0], null);
                this.commandLineParser(this.args);
            }
            if (this.updateType == UpdateType.UNKNOWN) {
                this.loggerWriter.appendPath(HpmUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + HpmUpdateCommand.COMMAND_NAME, "[" + this.bmcIP + "] Unknown update type.");
                return false;
            }
            if (this.preupdateFWInfo == null) {
                this.loggerWriter.appendPath(HpmUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + HpmUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] Update FW info data is null.");
                return false;
            }
            if (this.fwImage == null) {
                this.loggerWriter.appendPath(HpmUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + HpmUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] No FW image path.");
                return false;
            }
            if (!this.fwImage.exists()) {
                this.loggerWriter.appendPath(HpmUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + HpmUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] FW image not exist.");
                return false;
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public HpmUpdateCommand build() {
            return new HpmUpdateCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.preupdateFWInfo = null;
            this.updateType = null;
            this.fwImage = null;
            this.skip = false;
            this.preserveConfig = false;
            this.debug = false;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this.getThis();
        }

        public Builder setFWImage(String imagePath) {
            this.fwImage = new File(imagePath);
            return this.getThis();
        }

        public Builder setFWImage(File imagePath) {
            if (imagePath.getName().toLowerCase().indexOf(".hpm") > 0 && imagePath.exists()) {
                this.fwImage = imagePath;
            }
            return this.getThis();
        }

        public Builder setSkip(boolean skip) {
            this.skip = skip;
            return this.getThis();
        }

        public Builder setPreserveConfig(boolean preserve) {
            this.preserveConfig = preserve;
            return this.getThis();
        }

        public Builder setGctIpmiMode(boolean gctIpmiMode) {
            this.gctIpmiMode = gctIpmiMode;
            return this.getThis();
        }

        public Builder setPreUpdateFWInfo(AbstractJSONPOJO info) {
            if (info instanceof BMCUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(BMCUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(BMCUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(BMCUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            } else if (info instanceof BIOSUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(BIOSUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(BIOSUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(BIOSUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            } else if (info instanceof ScpUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(ScpUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(ScpUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(ScpUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            } else if (info instanceof PldmUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(PldmUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(PldmUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(PldmUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            }
            return this.getThis();
        }

        private void commandLineParser(String[] args) {
            int startPosition = 1;
            if (args[0].equals("cpld")) {
                startPosition = 2;
            }
            block12: for (int i = startPosition; i < args.length; ++i) {
                switch (args[i]) {
                    case "skip": {
                        this.skip = true;
                        continue block12;
                    }
                    case "debug": {
                        this.debug = true;
                        continue block12;
                    }
                    case "preserve": {
                        this.preserveConfig = true;
                        continue block12;
                    }
                    case "gctipmi": {
                        this.gctIpmiMode = true;
                        continue block12;
                    }
                }
            }
        }
    }
}

