/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.LoadDefault;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.CompressFile;
import Gbt.utility.LoadDefault.LoadDefault;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.Scanner;

public final class LoadDefaultCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "loaddf";
    private final GbtIPMICommandReceiver ipmiReceiver;
    public static final String checksum = "check";

    protected LoadDefaultCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[ IPMI command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, " Command arguments check fail.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCInfoJSONData bmcInfo = this.ipmiReceiver.getBmcInfo(handle, ((Builder)this.commandArgs).bmcIP, COMMAND_NAME, this.commandID);
        if (bmcInfo == null) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Get BMC info fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC info fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        boolean result = false;
        if (((Builder)this.commandArgs).loadBMC) {
            if (!this.setLoadDefault(handle)) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "End process.");
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            if (((Builder)this.commandArgs).loadBMC) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Do you want to reset BMC? (Y/N): ");
                Scanner scanner = new Scanner(System.in);
                String answer = scanner.next();
                if (answer.equalsIgnoreCase("Y") || answer.equalsIgnoreCase("Yes")) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Wait..... ");
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException e) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "sleep fail....!");
                    }
                }
                scanner.close();
            }
        } else if (((Builder)this.commandArgs).cancel) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Are you sure to send cancel command(Y/N)?");
            Scanner scanner = new Scanner(System.in);
            String answer = scanner.next();
            if ((answer.equalsIgnoreCase("Y") || answer.equalsIgnoreCase("Yes")) && this.ipmiReceiver.sendCancel(handle, COMMAND_NAME, this.commandID)) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                scanner.close();
                return false;
            }
            scanner.close();
        }
        result = true;
        this.commandResults.add(new NullJSONData().setError(!result).setMessages("Load default " + (result ? "success" : "fail")));
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return result;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        this.loggerWriter.close();
    }

    private boolean setLoadDefault(ConnectionHandle handle) {
        String BMCFilePath = ((Builder)this.commandArgs).bmcFilePath;
        if (((Builder)this.commandArgs).loadBMC && !this.checkBMCFile()) {
            return false;
        }
        File file = new File(BMCFilePath);
        if (((Builder)this.commandArgs).loadBMC && !file.exists()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, BMCFilePath + ", no such file.");
            return false;
        }
        ((Builder)this.commandArgs).loadDefault = new LoadDefault();
        ((Builder)this.commandArgs).loadDefault.run(((Builder)this.commandArgs).bmcIP, BMCFilePath, "", "", "", ((Builder)this.commandArgs).loadBMC, false, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "done");
        boolean keepGoing = false;
        if (!((Builder)this.commandArgs).loadDefault.isSkip() && ((Builder)this.commandArgs).loadDefault.isSuccess()) {
            keepGoing = true;
        }
        return keepGoing;
    }

    private boolean checkBMCFile() {
        String BMCFilePath = "default.conf";
        String BMCtarName = "BMCDefaultConfig";
        String[] BMCNeedFile = new String[]{"tools/default.conf", "tools/BMCDefault.sh"};
        if (BMCFilePath.contains(".conf")) {
            ArrayList<File> list = new ArrayList<File>();
            for (String bfile : BMCNeedFile) {
                list.add(new File(bfile));
            }
            try {
                CompressFile.compressTarGzFile(list, BMCtarName, false);
            }
            catch (Exception e) {
                return false;
            }
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BMC file is invalid.");
            return false;
        }
        return true;
    }

    public boolean waitAllNodesUnmount() throws Exception {
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Resetting all nodes system.");
        ((Builder)this.commandArgs).loadDefault.reInitial();
        if (!((Builder)this.commandArgs).loadDefault.resetSystem(((Builder)this.commandArgs).bmcIP)) {
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Watting for all nodes unmounted....");
        Thread.sleep(100000L);
        boolean allUnmount = false;
        while (!allUnmount) {
            allUnmount = true;
            if (!((Builder)this.commandArgs).loadDefault.isComplete()) {
                ((Builder)this.commandArgs).loadDefault.checkUnmount(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword);
                allUnmount = false;
            }
            Thread.sleep(5000L);
        }
        return ((Builder)this.commandArgs).loadDefault.isUnmount();
    }

    private boolean isIPMISendMessagesFail(AbstractJSONPOJO resp, ConnectionHandle handle) {
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return true;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
        }
        return false;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private boolean loadBMC = false;
        private boolean cancel = false;
        private LoadDefault loadDefault;
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private String bmcFilePath = "./BMCDefaultConfig.tar.gz";
        private String biosFilePath = "./BIOSDefaultFile.tar.gz";

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setBmcFilePath(String bmcFilePath) {
            this.bmcFilePath = bmcFilePath;
            return this.getThis();
        }

        public Builder setBiosFilePath(String biosFilePath) {
            this.biosFilePath = biosFilePath;
            return this.getThis();
        }

        public Builder setCommandType(String cmdType) {
            if (cmdType.equalsIgnoreCase("bmc")) {
                this.loadBMC = true;
            } else if (cmdType.equalsIgnoreCase("cancel")) {
                this.cancel = true;
            }
            return this.getThis();
        }

        @Override
        public boolean checkArgs() {
            if (this.args.length == 0) {
                return false;
            }
            if (this.args[0].equalsIgnoreCase("bmc")) {
                this.loadBMC = true;
            } else if (this.args[0].equalsIgnoreCase("cancel")) {
                this.cancel = true;
            } else {
                return false;
            }
            return this.bmcIP != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public LoadDefaultCommand build() {
            return new LoadDefaultCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }
    }
}

