/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.LogoChange;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.tftp.GlobalTFTPServer;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.CompressFile;
import Gbt.utility.bmcinfo.BMCVendor;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public final class LogoChangeCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "logochange";
    private static final String IMAGE_FILE_EXT_NAME = ".png";
    private static final String LOGO_BACKGROUND_NAME = "logo_background.png";
    private static final String LOGO_LEFT_NAME = "logo_left.png";
    private static final String LOGO_TAR_NAME = "gbt_ulogo_src";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private List<File> uploadImages;

    protected LogoChangeCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.uploadImages = new ArrayList<File>();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI connection fail."));
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, COMMAND_NAME, this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                break;
            }
            case AMI: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor.");
                return false;
            }
        }
        if (((Builder)this.commandArgs).tftpIP == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start auto detect closest IP address for BMC find the TFTP server.");
            List<InetAddress> ipAddresses = CommonFunction.getCurrentMachineIPAddresses();
            if (ipAddresses.isEmpty()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot find any network interfaces in this machine.");
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot find any network interfaces in this machine."));
                return false;
            }
            try {
                Inet4Address closedIP = CommonFunction.getClosestIPv4Address(ipAddresses, ((Builder)this.commandArgs).bmcIP);
                if (closedIP == null) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot find any site local IP addresses for TFTP server usage.");
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot find any site local IP addresses for TFTP server usage."));
                    return false;
                }
                ((Builder)this.commandArgs).tftpIP = closedIP.getHostAddress();
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Find the closest TFTP server IP for BMC usage : " + ((Builder)this.commandArgs).tftpIP);
            }
            catch (UnknownHostException ue) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unknown host of given BMC IP address.");
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Unknown host of given BMC IP address."));
                return false;
            }
        }
        File tarFile = null;
        String ue = LOGO_TAR_NAME;
        synchronized (LOGO_TAR_NAME) {
            try {
                this.prepareUploadImage(((Builder)this.commandArgs).logo_background_pic, LOGO_BACKGROUND_NAME);
                this.prepareUploadImage(((Builder)this.commandArgs).logo_left_pic, LOGO_LEFT_NAME);
                tarFile = CompressFile.compressTarFile(this.uploadImages, "./gbt_ulogo_src", false);
                if (tarFile.length() >= 50000L) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Image size only support up to 50KB.");
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    if (tarFile.exists()) {
                        tarFile.delete();
                    }
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Image size only support up to 50KB."));
                    // ** MonitorExit[ue] (shouldn't be in output)
                    return false;
                }
            }
            catch (Exception e) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, e.getMessage());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                if (tarFile != null && tarFile.exists()) {
                    tarFile.delete();
                }
                this.commandResults.add(new NullJSONData().setError(true).setMessages(e.getMessage()));
                // ** MonitorExit[ue] (shouldn't be in output)
                return false;
            }
            File dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + LOGO_TAR_NAME + ".tar");
            if (((Builder)this.commandArgs).isInnerTFTPUsed && !GlobalTFTPServer.access().startTFTPServer(((Builder)this.commandArgs).tftpPath, COMMAND_NAME, this.commandID)) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                if (tarFile.exists()) {
                    tarFile.delete();
                }
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot start TFTP server."));
                return false;
            }
            if (!GlobalTFTPServer.access().copyFileToTFTPServer(tarFile, dstImageName, COMMAND_NAME, this.commandID)) {
                if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                    GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, COMMAND_NAME, this.commandID);
                }
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                if (tarFile.exists()) {
                    tarFile.delete();
                }
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot copy file to TFTP server."));
                return false;
            }
            boolean ok = this.ipmiReceiver.logoChangeCommand(handle, COMMAND_NAME, this.commandID, ((Builder)this.commandArgs).tftpIP);
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, COMMAND_NAME, this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, COMMAND_NAME, this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            if (tarFile.exists()) {
                tarFile.delete();
            }
            this.commandResults.add(new NullJSONData().setError(!ok).setMessages("LOGO change command " + (ok ? "success." : "fail.")));
            return ok;
        }
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private void prepareUploadImage(File imagePath, String correctName) throws Exception {
        if (imagePath != null) {
            if (!imagePath.getName().equals(correctName)) {
                File newFile = new File((imagePath.getParent() == null ? "." : imagePath.getParent()) + "/" + correctName);
                if (!newFile.exists()) {
                    FileUtils.moveFile((File)imagePath, (File)newFile);
                }
                this.uploadImages.add(newFile);
            } else {
                this.uploadImages.add(imagePath);
            }
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private File logo_background_pic;
        private File logo_left_pic;
        private File tftpPath = new File("tftpTemp");
        private String tftpIP;
        private boolean isInnerTFTPUsed = true;

        @Override
        public boolean checkArgs() {
            BufferedImage image;
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "unknown_logochange", "Unknown BMC IP address.");
                return false;
            }
            if (this.args != null) {
                for (String arg : this.args) {
                    if (arg.contains("bg=")) {
                        this.setBackgroundLOGO(arg.substring(arg.lastIndexOf("bg=") + 3));
                    }
                    if (arg.contains("left=")) {
                        this.setLeftLOGO(arg.substring(arg.lastIndexOf("left=") + 5));
                    }
                    if (arg.contains("path=")) {
                        this.setTFTPPath(arg.substring(arg.lastIndexOf("path=") + 5));
                    }
                    if (!arg.contains("tftpip=")) continue;
                    this.setTFTPIP(arg.substring(arg.lastIndexOf("tftpip=") + 7));
                }
            }
            if (this.logo_left_pic == null || this.logo_background_pic == null) {
                this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] No LOGO image apply in command arguments.");
                return false;
            }
            if (this.logo_background_pic != null) {
                if (!this.logo_background_pic.getName().endsWith(LogoChangeCommand.IMAGE_FILE_EXT_NAME)) {
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] Background LOGO image is not PNG format.");
                    return false;
                }
                image = null;
                try {
                    image = ImageIO.read(this.logo_background_pic);
                }
                catch (IOException ioe) {
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] Cannot read background LOGO image.");
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] " + ioe.getMessage());
                    return false;
                }
                if (image.getHeight() > 63) {
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] Background LOGO image height pixel size is out of range.");
                    return false;
                }
            }
            if (this.logo_left_pic != null) {
                if (!this.logo_left_pic.getName().endsWith(LogoChangeCommand.IMAGE_FILE_EXT_NAME)) {
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] Left LOGO image is not PNG format.");
                    return false;
                }
                image = null;
                try {
                    image = ImageIO.read(this.logo_left_pic);
                }
                catch (IOException ioe) {
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] Cannot read left LOGO image.");
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] " + ioe.getMessage());
                    return false;
                }
                if (image.getHeight() > 63) {
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] Left LOGO image height pixel size(" + image.getHeight() + ") is out of range.");
                    return false;
                }
                if (image.getWidth() > 404) {
                    this.loggerWriter.appendPath(LogoChangeCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + LogoChangeCommand.COMMAND_NAME, "[" + this.bmcIP + "] Left LOGO image width pixel size(" + image.getWidth() + ") is out of range.");
                    return false;
                }
            }
            if (!this.tftpPath.exists()) {
                this.tftpPath.mkdir();
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public LogoChangeCommand build() {
            return new LogoChangeCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.logo_background_pic = null;
            this.logo_left_pic = null;
            this.loggerWriter = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setLOGOImages(String logo_background, String logo_left) {
            this.setBackgroundLOGO(logo_background);
            this.setLeftLOGO(logo_left);
            return this.getThis();
        }

        public Builder setBackgroundLOGO(String logo_background) {
            this.logo_background_pic = new File(logo_background);
            return this.getThis();
        }

        public Builder setBackgroundLOGO(File logo_background) {
            this.logo_background_pic = logo_background;
            return this.getThis();
        }

        public Builder setLeftLOGO(String logo_left) {
            this.logo_left_pic = new File(logo_left);
            return this.getThis();
        }

        public Builder setLeftLOGO(File logo_left) {
            this.logo_left_pic = logo_left;
            return this.getThis();
        }

        public Builder setTFTPPath(String tftpPath) {
            this.tftpPath = new File(tftpPath);
            if (!this.tftpPath.exists()) {
                this.tftpPath.mkdir();
            }
            this.isInnerTFTPUsed = false;
            return this.getThis();
        }

        public Builder setTFTPIP(String tftpIP) {
            this.tftpIP = tftpIP;
            return this.getThis();
        }

        public Builder useInnerTFTPAPI(boolean use) {
            this.isInnerTFTPUsed = use;
            return this.getThis();
        }
    }
}

