/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.MSR;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GIGABYTEChecksum;
import Gbt.utility.MSR.MSRCommand;
import Gbt.utility.MSR.NodeManagementData;
import Gbt.utility.MSR.NodeMsrReadingData;
import Gbt.utility.MSR.NodeRdCfgData;
import Gbt.utility.meversion.MeVersionData;

public enum MsrIpmiOptions implements GbtIPMIOptions<MSRCommand.Builder>
{
    GET_NODE_MANAGEMENT_DATA(0, "Get node management data"),
    GET_RD_PKG_CONFIG(1, "Get RD pkg config"),
    MSR_READ(2, "MSR read"),
    GET_ME_VERSION(3, "Get ME version");

    private static final byte NET_FN = 6;
    private static final byte CMD = 52;
    private static final String GET_NODE_MANAGEMENT_DATA_ITEM = "Get node management data";
    private static final String GET_RD_PKG_CONFIG_ITEM = "Get RD pkg config";
    private static final String MSR_READ_ITEM = "MSR read";
    private static final String GET_ME_VERSION_ITEM = "Get ME version";
    private final int optionCode;
    private final String item;

    private MsrIpmiOptions(int optionCode, String item) {
        this.optionCode = optionCode;
        this.item = item;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 6;
    }

    @Override
    public byte getCommandCode() {
        return 52;
    }

    @Override
    public byte[] rebuildRequestData(MSRCommand.Builder commandArgs) {
        switch (this) {
            case GET_NODE_MANAGEMENT_DATA: {
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, -72, 28, 32, 0, -54}, new byte[]{87, 1, 0});
            }
            case GET_RD_PKG_CONFIG: {
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, -72, 28, 32, 0, 64}, new byte[]{87, 1, 0, commandArgs.getClientAddr(), 5, 5, -95, 0, 16, 0, 0});
            }
            case MSR_READ: {
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, -72, 28, 32, 0, 70}, new byte[]{87, 1, 0, 0, 0, (byte)commandArgs.getReadPosition(), 4, 4});
            }
            case GET_ME_VERSION: {
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, 24, 28, 32, 0, 1}, new byte[0]);
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte[] mIDbuffer = new byte[3];
        switch (this) {
            case GET_NODE_MANAGEMENT_DATA: {
                if (gbtResponseData.getAllResponseData() == null) {
                    return null;
                }
                NodeManagementData nodeManagementData = new NodeManagementData();
                System.arraycopy(gbtResponseData.getAllResponseData(), 0, mIDbuffer, 0, mIDbuffer.length);
                nodeManagementData.setManufacturerID(mIDbuffer);
                nodeManagementData.setNMVersion(gbtResponseData.getResponseData(3));
                nodeManagementData.setIpmiInterfaceVersion(gbtResponseData.getResponseData(4));
                nodeManagementData.setPatchVersion(gbtResponseData.getResponseData(5));
                nodeManagementData.setMajorFirmwareRevision(gbtResponseData.getResponseData(6));
                nodeManagementData.setMinorFirmwareRevision(gbtResponseData.getResponseData(7));
                nodeManagementData.setNMSupport(gbtResponseData.getResponseData(3) > 0 ? Boolean.TRUE : Boolean.FALSE);
                return nodeManagementData;
            }
            case GET_RD_PKG_CONFIG: {
                if (gbtResponseData.getAllResponseData() == null) {
                    return null;
                }
                NodeRdCfgData nodeRdCfgData = new NodeRdCfgData();
                System.arraycopy(gbtResponseData.getAllResponseData(), 0, mIDbuffer, 0, mIDbuffer.length);
                nodeRdCfgData.setManufacturerID(mIDbuffer);
                nodeRdCfgData.setCompleteCode(gbtResponseData.getResponseData(3));
                if (nodeRdCfgData.getCompleteCode() == 64) {
                    nodeRdCfgData.setTjmax(gbtResponseData.getResponseData(6));
                } else {
                    nodeRdCfgData.setTjmax((byte)0);
                }
                return nodeRdCfgData;
            }
            case MSR_READ: {
                if (gbtResponseData.getAllResponseData() == null) {
                    return null;
                }
                NodeMsrReadingData nodeMsrReadingData = new NodeMsrReadingData();
                System.arraycopy(gbtResponseData.getAllResponseData(), 0, mIDbuffer, 0, mIDbuffer.length);
                nodeMsrReadingData.setManufacturerID(mIDbuffer);
                byte[] valueBuffer = new byte[8];
                System.arraycopy(gbtResponseData.getAllResponseData(), 3, valueBuffer, 0, valueBuffer.length);
                nodeMsrReadingData.setValues(valueBuffer);
                return nodeMsrReadingData;
            }
            case GET_ME_VERSION: {
                if (gbtResponseData.getAllResponseData() == null) {
                    return null;
                }
                MeVersionData meVersionData = new MeVersionData();
                meVersionData.setMajorVersion(String.valueOf(gbtResponseData.getResponseData(2)));
                meVersionData.setMinorVersion(String.valueOf(gbtResponseData.getResponseData(3)));
                String buildVersion = String.format("%02X ", gbtResponseData.getResponseData(12)).trim() + String.format("%02X ", gbtResponseData.getResponseData(13)).trim().toCharArray()[0];
                meVersionData.setBuildVersion(buildVersion);
                meVersionData.setFullVersion(meVersionData.getMajorVersion() + "." + meVersionData.getMinorVersion() + "." + buildVersion);
                return meVersionData;
            }
        }
        return new NullJSONData().setMessages("Unknown MSR IPMI command option.").setError(true);
    }
}

