/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.SMBIOS.SmbiosTypeBase;
import Gbt.utility.SMBIOS.WakeUpType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class SmbiosType1
extends SmbiosTypeBase {
    private UUID uuid;
    private String manufacturer;
    private String productName;
    private String version;
    private String serialNumber;
    private String SKUNumber;
    private String family;
    private WakeUpType wakeupType;

    public SmbiosType1(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        this.skipBYTES(4);
        ByteBuffer uuidBuffer = this.dealUuid(this.nextBYTES(16));
        long high = uuidBuffer.getLong();
        long low = uuidBuffer.getLong();
        this.uuid = new UUID(high, low);
        this.wakeupType = WakeUpType.parseByByte(this.nextBYTE());
        this.manufacturer = this.nextString();
        this.productName = this.nextString();
        this.version = this.nextString();
        this.serialNumber = this.nextString();
        this.SKUNumber = this.nextString();
        this.family = this.nextString();
    }

    @JsonProperty(value="Uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    @JsonProperty(value="Manufacturer")
    public String getManufacturer() {
        return this.manufacturer;
    }

    @JsonProperty(value="ProductName")
    public String getProductName() {
        return this.productName;
    }

    @JsonProperty(value="Version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="SerialNumber")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="SKUNumber")
    public String getSKUNumber() {
        return this.SKUNumber;
    }

    @JsonProperty(value="Family")
    public String getFamily() {
        return this.family;
    }

    @JsonProperty(value="WakeupType")
    public WakeUpType getWakeupType() {
        return this.wakeupType;
    }

    private ByteBuffer dealUuid(byte[] raw) {
        ByteBuffer uuid = ByteBuffer.allocate(raw.length);
        uuid.put(raw[3]);
        uuid.put(raw[2]);
        uuid.put(raw[1]);
        uuid.put(raw[0]);
        uuid.put(raw[5]);
        uuid.put(raw[4]);
        uuid.put(raw[7]);
        uuid.put(raw[6]);
        uuid.put(raw[8]);
        uuid.put(raw[9]);
        uuid.put(raw[10]);
        uuid.put(raw[11]);
        uuid.put(raw[12]);
        uuid.put(raw[13]);
        uuid.put(raw[14]);
        uuid.put(raw[15]);
        uuid.position(0);
        return uuid;
    }
}

