/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SmbiosType129
extends SmbiosTypeBase {
    private int storageType;
    private Byte portNumber;
    private String serialNumber;
    private String firmwareVersion;
    private String hddName;
    private int hddSize;
    private String sataCapabilities;
    private String securityStatus;
    private String controllerVendorID;
    private String segmentGroupNumber;
    private Byte busNumber;
    private String devicefunctionNumber;
    private String slotNumber;
    private String onBoardIndex;

    public SmbiosType129(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        byte[] storageTypeRaw = this.nextBYTES(4);
        this.portNumber = this.nextBYTE();
        this.skipBYTES(3);
        byte[] hddSizeRaw = this.nextBYTES(8);
        byte[] sataCapabilitiesRaw = this.nextBYTES(2);
        byte[] securityStatusRaw = this.nextBYTES(2);
        byte[] controllerVendorIDRaw = this.nextBYTES(2);
        byte[] segmentGroupNumberRaw = this.nextBYTES(2);
        this.busNumber = this.nextBYTE();
        byte devicefunctionNumberRaw = this.nextBYTE();
        byte[] slotNumberRaw = this.nextBYTES(2);
        byte[] onboardIndexRaw = this.nextBYTES(2);
        this.serialNumber = this.nextString();
        this.firmwareVersion = this.nextString();
        this.hddName = this.nextString();
        this.storageType = GbtCommonConverters.ByteArraytoInt(storageTypeRaw);
        this.hddSize = GbtCommonConverters.ByteArraytoInt(hddSizeRaw);
        this.sataCapabilities = GbtCommonConverters.bytesToHexReverse(sataCapabilitiesRaw);
        this.securityStatus = GbtCommonConverters.bytesToHexReverse(securityStatusRaw);
        this.controllerVendorID = GbtCommonConverters.bytesToHexReverse(controllerVendorIDRaw);
        this.segmentGroupNumber = GbtCommonConverters.bytesToHexReverse(segmentGroupNumberRaw);
        this.devicefunctionNumber = GbtCommonConverters.bytesToHex(devicefunctionNumberRaw);
        this.slotNumber = GbtCommonConverters.bytesToHexReverse(slotNumberRaw);
        this.onBoardIndex = GbtCommonConverters.bytesToHexReverse(onboardIndexRaw);
    }

    @JsonProperty(value="StorageType")
    public int getStorageType() {
        return this.storageType;
    }

    @JsonProperty(value="PortNumber")
    public Byte getPortNumber() {
        return this.portNumber;
    }

    @JsonProperty(value="SerialNumber")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="FirmwareVersion")
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @JsonProperty(value="HddName")
    public String getHddName() {
        return this.hddName;
    }

    @JsonProperty(value="HddSize")
    public int getHddSize() {
        return this.hddSize;
    }

    @JsonProperty(value="SataCapabilities")
    public String getSataCapabilities() {
        return this.sataCapabilities;
    }

    @JsonProperty(value="SecurityStatus")
    public String getSecurityStatus() {
        return this.securityStatus;
    }

    @JsonProperty(value="ControllerVendorID")
    public String getControllerVendorID() {
        return this.controllerVendorID;
    }

    @JsonProperty(value="SegmentGroupNumber")
    public String getSegmentGroupNumber() {
        return this.segmentGroupNumber;
    }

    @JsonProperty(value="BusNumber")
    public Byte getBusNumber() {
        return this.busNumber;
    }

    @JsonProperty(value="DevicefunctionNumber")
    public String getDevicefunctionNumber() {
        return this.devicefunctionNumber;
    }

    @JsonProperty(value="SlotNumber")
    public String getSlotNumber() {
        return this.slotNumber;
    }

    @JsonProperty(value="OnBoardIndex")
    public String getOnBoardIndex() {
        return this.onBoardIndex;
    }
}

