/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.LocalCmdRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GctIpmitoolCommandReceiver;
import Gbt.core.rest.RESTServices;
import Gbt.core.tftp.GlobalTFTPServer;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Update.DualImageConfig;
import Gbt.utility.Update.UpdateIPMIOptions;
import Gbt.utility.Update.UpdateStatusJSONData;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.BIOSUpdateFWInfo;
import Gbt.utility.Update.fwInfo.BMCUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CPLDUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.Update.fwInfo.FpgaUpdateFWInfo;
import Gbt.utility.Update.fwInfo.PSUUpdateFWInfo;
import Gbt.utility.Update.fwInfo.SKUUpdateFWInfo;
import Gbt.utility.bmcinfo.AdditionalDeviceSupport;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BmcDeviceIpmiOptions;
import Gbt.utility.firmwareBackup.CommandSupportStatus;
import Gbt.utility.firmwareBackup.FirmwareBackupOperateIpmiOptions;
import Gbt.utility.firmwareBackup.FirmwareBackupStatus;
import Gbt.utility.firmwareBackup.FirmwareBackupStatusIpmiOptions;
import Gbt.utility.monitor.MonitorMemoryUsageThread;
import Gbt.utility.rest.options.UpdateServiceOptions;
import Gbt.utility.rest.services.AMIRedfishUpdateService;
import Gbt.utility.rest.services.OpenBmcUpdateService;
import Gbt.utility.rest.services.UpdateService;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public final class MainUpdateCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "update";
    private static final int MAX_RETRY_COUNT = 15;
    private static final int BACKUP_WAIT_COUNT = 480;
    private static final String GCTIPMITOOL_CMD_GRACEUPDATE = "graceupdate FWPKG";
    private static final String GCTIPMITOOL_CMD_UPDATE_MAINBMC = "update MAIN_BMC";
    private static final String GCTIPMITOOL_CMD_UPDATE_BACKUPBMC = "update BACKUP_BMC";
    private static final String GCTIPMITOOL_CMD_UPDATE_MAINBIOS = "update MAIN_BIOS";
    private static final String GCTIPMITOOL_CMD_UPDATE_BACKUPBIOS = "update BACKUP_BIOS";
    private static final String GCTIPMITOOL_CMD_UPDATE_MBCPLD = "update MB_CPLD";
    private static final String GCTIPMITOOL_CMD_UPDATE_BPBCPLD = "update BPB_CPLD";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected MainUpdateCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME + "_" + ((Builder)this.commandArgs).updateType.toString();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI connection fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        switch (((Builder)this.commandArgs).bmcInfoJSONData.getBmcVendor()) {
            case AMI: 
            case OPENBMC: 
            case INSYDE: {
                break;
            }
            case VERTIV: {
                if (((Builder)this.commandArgs).tftpIP != null) break;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start auto detect closest IP address for BMC find the TFTP server.");
                List<InetAddress> ipAddresses = CommonFunction.getCurrentMachineIPAddresses();
                if (ipAddresses.isEmpty()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Can not find any network interfaces in this machine.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Can not find any network interfaces in this machine."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                try {
                    Inet4Address closedIP = CommonFunction.getClosestIPv4Address(ipAddresses, ((Builder)this.commandArgs).bmcIP);
                    if (closedIP == null) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Can not find any site local IP addresses for TFTP server usage.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("Can not find any site local IP addresses for TFTP server usage."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    ((Builder)this.commandArgs).tftpIP = closedIP.getHostAddress();
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Find the closest TFTP server IP for BMC usage : " + ((Builder)this.commandArgs).tftpIP);
                    break;
                }
                catch (UnknownHostException ue) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unknown host of given BMC IP address.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Unknown host of given BMC IP address."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
            }
        }
        switch (((Builder)this.commandArgs).updateType) {
            case CMC: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                BMCUpdateFWInfo cmcUpdInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(BMCUpdateFWInfo.class);
                cmcUpdInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Current Rev : " + cmcUpdInfo.getCurrentVersion() + " \tNew Rev : " + cmcUpdInfo.getNewVersion());
                if (((Builder)this.commandArgs).skip && CommonFunction.isVersionEqual(cmcUpdInfo.getCurrentVersion(), cmcUpdInfo.getNewVersion())) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Skip same FW version update.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                        ((Builder)this.commandArgs).tftpPath.delete();
                    }
                    this.commandResults.add(new NullJSONData().setError(false).setMessages("Skip same FW version update."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return true;
                }
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (!this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_MAINBMC, cmcUpdInfo)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                } else if (cmcUpdInfo.getBmcVendor().isAMI()) {
                    if (!this.updateAMIProcess(cmcUpdInfo, handle)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                } else {
                    File dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + cmcUpdInfo.getChecksum() + ".img");
                    if (!this.updateProcess(handle, dstImageName, UpdateIPMIOptions.BMCUpdatePhaseTransfer, UpdateIPMIOptions.BMCUpdatePhaseProcess, UpdateIPMIOptions.BMCUpdatePhaseStatus, ((Builder)this.commandArgs).updateType)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update Success.");
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                }
                if (!((Builder)this.commandArgs).preserveConfig) break;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get new BMC information.");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Device ID                 : " + ((Builder)this.commandArgs).bmcInfoJSONData.getDeviceID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Device Revision           : " + ((Builder)this.commandArgs).bmcInfoJSONData.getDeviceRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Firmware Revision         : " + ((Builder)this.commandArgs).bmcInfoJSONData.getFirmwareRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "IPMI Version              : " + ((Builder)this.commandArgs).bmcInfoJSONData.getIpmiVersion());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Manufacturer ID           : " + ((Builder)this.commandArgs).bmcInfoJSONData.getManufacturerID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Manufacturer Name         : " + ((Builder)this.commandArgs).bmcInfoJSONData.getManufacturerName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Product ID                : " + ((Builder)this.commandArgs).bmcInfoJSONData.getProductID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Platform Name             : " + ((Builder)this.commandArgs).bmcInfoJSONData.getPlatformName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Device Available          : " + ((Builder)this.commandArgs).bmcInfoJSONData.isDeviceAvailable());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Provides Device SDRs      : " + ((Builder)this.commandArgs).bmcInfoJSONData.isProvidesDeviceSDRs());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Additional Device Support : ");
                for (AdditionalDeviceSupport additionalDeviceSupport : ((Builder)this.commandArgs).bmcInfoJSONData.getAdditionalDeviceSupport()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "\t" + (Object)((Object)additionalDeviceSupport));
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Aux Firmware Rev Info     : ");
                for (String string : ((Builder)this.commandArgs).bmcInfoJSONData.getAuxFWRevInfo()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "\t" + string);
                }
                this.commandResults.add(((Builder)this.commandArgs).bmcInfoJSONData);
                break;
            }
            case BMC: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                BMCUpdateFWInfo bmcUpdInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(BMCUpdateFWInfo.class);
                bmcUpdInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Current Rev : " + bmcUpdInfo.getCurrentVersion() + " \tNew Rev : " + bmcUpdInfo.getNewVersion());
                if (((Builder)this.commandArgs).skip && CommonFunction.isVersionEqual(bmcUpdInfo.getCurrentVersion(), bmcUpdInfo.getNewVersion())) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Skip same FW version update.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                        ((Builder)this.commandArgs).tftpPath.delete();
                    }
                    this.commandResults.add(new NullJSONData().setError(false).setMessages("Skip same FW version update."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return true;
                }
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (!this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_MAINBMC, bmcUpdInfo)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    if (((Builder)this.commandArgs).backupFirmware) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Utility will update backup BMC.");
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Waiting 5 minutes for BMC restart...");
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt wait BMC restart.");
                        }
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to update 2nd SPI process.");
                        if (!this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_BACKUPBMC, bmcUpdInfo)) {
                            this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                            return false;
                        }
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update 2nd SPI BMC end.");
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    }
                } else if (bmcUpdInfo.getBmcVendor().isAMI()) {
                    bmcUpdInfo.setBackupFlag(BigInteger.valueOf(0L));
                    bmcUpdInfo.setDualImageConfig(((Builder)this.commandArgs).dualImage);
                    if (!this.updateAMIProcess(bmcUpdInfo, handle)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    if (((Builder)this.commandArgs).backupFirmware) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Utility will update backup BMC.");
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Waiting 5 minutes for BMC restart...");
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt wait BMC restart.");
                        }
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to update 2nd SPI process.");
                        bmcUpdInfo.setBackupFlag(BigInteger.valueOf(1L));
                        if (!this.updateAMIProcess(bmcUpdInfo, handle)) {
                            this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update 2nd SPI process fail."));
                            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update 2nd SPI BMC fail.");
                            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                            return false;
                        }
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update 2nd SPI BMC end.");
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    }
                } else if (bmcUpdInfo.getBmcVendor().isOpenBMC() || bmcUpdInfo.getBmcVendor().isInsyde()) {
                    if (!this.updateOpenBmcProcess(bmcUpdInfo)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                } else {
                    File file = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + bmcUpdInfo.getChecksum() + ".img");
                    if (!this.updateProcess(handle, file, UpdateIPMIOptions.BMCUpdatePhaseTransfer, UpdateIPMIOptions.BMCUpdatePhaseProcess, UpdateIPMIOptions.BMCUpdatePhaseStatus, ((Builder)this.commandArgs).updateType)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update Success.");
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                }
                if (!((Builder)this.commandArgs).preserveConfig) break;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get new BMC information.");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Device ID                 : " + ((Builder)this.commandArgs).bmcInfoJSONData.getDeviceID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Device Revision           : " + ((Builder)this.commandArgs).bmcInfoJSONData.getDeviceRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Firmware Revision         : " + ((Builder)this.commandArgs).bmcInfoJSONData.getFirmwareRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "IPMI Version              : " + ((Builder)this.commandArgs).bmcInfoJSONData.getIpmiVersion());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Manufacturer ID           : " + ((Builder)this.commandArgs).bmcInfoJSONData.getManufacturerID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Manufacturer Name         : " + ((Builder)this.commandArgs).bmcInfoJSONData.getManufacturerName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Product ID                : " + ((Builder)this.commandArgs).bmcInfoJSONData.getProductID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Platform Name             : " + ((Builder)this.commandArgs).bmcInfoJSONData.getPlatformName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Device Available          : " + ((Builder)this.commandArgs).bmcInfoJSONData.isDeviceAvailable());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Provides Device SDRs      : " + ((Builder)this.commandArgs).bmcInfoJSONData.isProvidesDeviceSDRs());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Additional Device Support : ");
                for (AdditionalDeviceSupport additionalDeviceSupport : ((Builder)this.commandArgs).bmcInfoJSONData.getAdditionalDeviceSupport()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "\t" + (Object)((Object)additionalDeviceSupport));
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Aux Firmware Rev Info     : ");
                for (String string : ((Builder)this.commandArgs).bmcInfoJSONData.getAuxFWRevInfo()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "\t" + string);
                }
                this.commandResults.add(((Builder)this.commandArgs).bmcInfoJSONData);
                break;
            }
            case BIOS: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                BIOSUpdateFWInfo bIOSUpdateFWInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(BIOSUpdateFWInfo.class);
                bIOSUpdateFWInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] New Rev : " + bIOSUpdateFWInfo.getVersion());
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (!this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_MAINBIOS, bIOSUpdateFWInfo)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    if (!((Builder)this.commandArgs).backupFirmware) break;
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Utility will update backup BIOS.");
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt waiting update 2nd BIOS.");
                    }
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to update 2nd SPI process.");
                    if (!this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_BACKUPBIOS, bIOSUpdateFWInfo)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update 2nd SPI BIOS end.");
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    break;
                }
                if (bIOSUpdateFWInfo.getBmcVendor().isAMI()) {
                    if (this.updateAMIProcess(bIOSUpdateFWInfo, handle)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (bIOSUpdateFWInfo.getBmcVendor().isOpenBMC() || bIOSUpdateFWInfo.getBmcVendor().isInsyde()) {
                    if (this.updateOpenBmcProcess(bIOSUpdateFWInfo)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                File file = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + bIOSUpdateFWInfo.getLongChecksum() + ".RBU");
                if (!this.updateProcess(handle, file, UpdateIPMIOptions.BIOSUpdatePhaseTransfer, UpdateIPMIOptions.BIOSUpdatePhaseProcess, UpdateIPMIOptions.BIOSUpdatePhaseStatus, ((Builder)this.commandArgs).updateType)) {
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update Success.");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                break;
            }
            case CPLDBPB: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                CPLDUpdateFWInfo cPLDUpdateFWInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(CPLDUpdateFWInfo.class);
                cPLDUpdateFWInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_BPBCPLD, cPLDUpdateFWInfo)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (cPLDUpdateFWInfo.getBmcVendor().isAMI()) {
                    if (this.updateAMIProcess(cPLDUpdateFWInfo, handle)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                File dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName().split("_")[0] + ".rcu");
                if (!dstImageName.exists()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] CPLD rename file is not exist, Do rename action!");
                    dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName());
                    dstImageName.renameTo(new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName().split("_")[0] + ".rcu"));
                    dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName().split("_")[0] + ".rcu");
                }
                if (!this.updateProcess(handle, dstImageName, UpdateIPMIOptions.CPLDBPBUpdatePhaseTransfer, UpdateIPMIOptions.CPLDBPBUpdatePhaseProcess, UpdateIPMIOptions.CPLDBPBUpdatePhaseStatus, ((Builder)this.commandArgs).updateType)) {
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update Success.");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                break;
            }
            case CPLDMB: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                CPLDUpdateFWInfo cpldUpdateMBFWInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(CPLDUpdateFWInfo.class);
                cpldUpdateMBFWInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_UPDATE_MBCPLD, cpldUpdateMBFWInfo)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (cpldUpdateMBFWInfo.getBmcVendor().isAMI()) {
                    if (this.updateAMIProcess(cpldUpdateMBFWInfo, handle)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                File dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName());
                dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName().split("_")[0] + ".rcu");
                if (!dstImageName.exists()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] CPLD rename file is not exist, Do rename action!");
                    dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName());
                    dstImageName.renameTo(new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName().split("_")[0] + ".rcu"));
                    dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName().split("_")[0] + ".rcu");
                }
                if (!this.updateProcess(handle, dstImageName, UpdateIPMIOptions.CPLDMBUpdatePhaseStatus, UpdateIPMIOptions.CPLDMBUpdatePhaseProcess, UpdateIPMIOptions.CPLDMBUpdatePhaseStatus, ((Builder)this.commandArgs).updateType)) {
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update Success.");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                break;
            }
            case CPLDSCM: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                CPLDUpdateFWInfo cpldUpdateMBFWInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(CPLDUpdateFWInfo.class);
                if (!cpldUpdateMBFWInfo.getBmcVendor().isAMI() || this.redfishAMIUpdateProcess(cpldUpdateMBFWInfo, handle)) break;
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
            case PSU: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                PSUUpdateFWInfo psuUpdateFWInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(PSUUpdateFWInfo.class);
                psuUpdateFWInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                if (psuUpdateFWInfo.getBmcVendor().isAMI()) {
                    if (this.updateAMIProcess(psuUpdateFWInfo, handle)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                File dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName());
                if (!this.updateProcess(handle, dstImageName, UpdateIPMIOptions.PSUUpdatePhaseTransfer, UpdateIPMIOptions.PSUUpdatePhaseProcess, UpdateIPMIOptions.PSUUpdatePhaseStatus, ((Builder)this.commandArgs).updateType)) {
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update Success.");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                break;
            }
            case SKU: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                SKUUpdateFWInfo skuUpdateFWInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(SKUUpdateFWInfo.class);
                skuUpdateFWInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                if (skuUpdateFWInfo.getBmcVendor().isAMI()) {
                    if (!this.updateAMIProcess(skuUpdateFWInfo, handle)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                        this.removeSkuRootPath();
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                } else {
                    File dstImageName = new File(((Builder)this.commandArgs).tftpPath.getAbsolutePath() + "/" + ((Builder)this.commandArgs).fwImage.getName());
                    if (!this.updateProcess(handle, dstImageName, UpdateIPMIOptions.SKUUpdatePhaseTransfer, UpdateIPMIOptions.SKUUpdatePhaseProcess, UpdateIPMIOptions.SKUUpdatePhaseStatus, ((Builder)this.commandArgs).updateType)) {
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI update process fail."));
                        this.removeSkuRootPath();
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update Success.");
                }
                this.removeSkuRootPath();
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                break;
            }
            case FPGA: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start update " + ((Builder)this.commandArgs).updateType.toString() + ".");
                FpgaUpdateFWInfo fpgaUpdInfo = ((Builder)this.commandArgs).preupdateFWInfo.castConcreteJSON(FpgaUpdateFWInfo.class);
                fpgaUpdInfo.setPreserve(((Builder)this.commandArgs).preserveConfig);
                if (((Builder)this.commandArgs).gctIpmiMode) {
                    if (this.updateFirmwareByGctIpmitool(GCTIPMITOOL_CMD_GRACEUPDATE, fpgaUpdInfo)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("GctIpmitool update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (fpgaUpdInfo.getBmcVendor().isAMI()) {
                    if (this.updateAMIProcess(fpgaUpdInfo, handle)) break;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Rest update process fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] FPGA update is not support.");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                break;
            }
            default: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unknown update type.");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Unknown update type."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        this.commandResults.add(new NullJSONData().setError(false).setMessages("Update success."));
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    private final boolean isIPMISendMessagesFail(AbstractJSONPOJO resp) {
        NullJSONData temp;
        if (resp instanceof NullJSONData && (temp = resp.castConcreteJSON(NullJSONData.class)).isError()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            return true;
        }
        return false;
    }

    private final boolean updateProcess(ConnectionHandle handle, File dstImageName, UpdateIPMIOptions transferType, UpdateIPMIOptions processType, UpdateIPMIOptions statusType, UpdateType updateType) {
        if (((Builder)this.commandArgs).isInnerTFTPUsed) {
            if (!GlobalTFTPServer.access().startTFTPServer(((Builder)this.commandArgs).tftpPath, ((Builder)this.commandArgs).tftpPort, this.getCommandName(), this.commandID)) {
                ((Builder)this.commandArgs).tftpPath.delete();
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
        } else {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Used current machine TFTP server API.");
        }
        if (!GlobalTFTPServer.access().copyFileToTFTPServer(((Builder)this.commandArgs).fwImage, dstImageName, this.getCommandName(), this.commandID)) {
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        ((Builder)this.commandArgs).fwImage = dstImageName;
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, UpdateIPMIOptions.SetTFTPPort, this.commandArgs, this.getCommandName(), this.commandID);
        if (!this.isIPMISendMessagesFail(resp)) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set TFTP port success.");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt command wait.");
            }
        }
        int count = 0;
        resp = this.ipmiReceiver.sendIPMIRawCommand(handle, transferType, this.commandArgs, this.getCommandName(), this.commandID);
        if (this.isIPMISendMessagesFail(resp)) {
            while (count < 15 && this.isIPMISendMessagesFail(resp = this.ipmiReceiver.sendIPMIRawCommand(handle, transferType, this.commandArgs, this.getCommandName(), this.commandID))) {
                if (++count == 15) {
                    GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
                    if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                        GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
                    }
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to send upload FW image IPMI command, please check out BMC LAN connection.");
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to send upload FW image IPMI command, retry again (" + count + ").");
            }
        }
        try {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        count = 0;
        while (!resp.castConcreteJSON(UpdateStatusJSONData.class).isDone() && count < 15) {
            resp = this.ipmiReceiver.sendIPMIRawCommand(handle, UpdateIPMIOptions.GetUpdateStatus, this.commandArgs, this.getCommandName(), this.commandID);
            if (this.isIPMISendMessagesFail(resp)) {
                resp = new UpdateStatusJSONData().setUpdateMessages("Failed to get transfer progress, retry again (" + ++count + ").");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                continue;
            }
            if (resp.castConcreteJSON(UpdateStatusJSONData.class).isFail()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to upload FW image, (" + ++count + ").");
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, ((Builder)this.commandArgs).preserveConfig ? UpdateIPMIOptions.PreserveBMCConfig : UpdateIPMIOptions.ClearBMCConfig, this.commandArgs, this.getCommandName(), this.commandID);
                if (this.isIPMISendMessagesFail(resp)) continue;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
                    break;
                }
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, transferType, this.commandArgs, this.getCommandName(), this.commandID);
                if (this.isIPMISendMessagesFail(resp)) continue;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
                    break;
                }
            }
            if (resp.castConcreteJSON(UpdateStatusJSONData.class).isDone()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                break;
            }
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
                break;
            }
        }
        if (this.isIPMISendMessagesFail(resp)) {
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to get upload FW image status, please check out BMC LAN connection.");
            return false;
        }
        if (!resp.castConcreteJSON(UpdateStatusJSONData.class).isDone() && count == 15) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to upload FW image.");
            return false;
        }
        count = 0;
        resp = this.ipmiReceiver.sendIPMIRawCommand(handle, processType, this.commandArgs, this.getCommandName(), this.commandID);
        if (this.isIPMISendMessagesFail(resp)) {
            while (count < 15 && this.isIPMISendMessagesFail(resp = this.ipmiReceiver.sendIPMIRawCommand(handle, processType, this.commandArgs, this.getCommandName(), this.commandID))) {
                if (++count == 15) {
                    GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
                    if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                        GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
                    }
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to start update process, please check out BMC LAN connection.");
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to start update process, retry again (" + count + ").");
            }
        }
        try {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
            Thread.sleep(10000L);
        }
        catch (InterruptedException ie) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        count = 0;
        while (!resp.castConcreteJSON(UpdateStatusJSONData.class).isStart() && count <= 15) {
            resp = this.ipmiReceiver.sendIPMIRawCommand(handle, UpdateIPMIOptions.GetUpdateStatus, this.commandArgs, this.getCommandName(), this.commandID);
            if (this.isIPMISendMessagesFail(resp)) {
                resp = new UpdateStatusJSONData().setUpdateMessages("Failed to start update progress, retry again (" + ++count + ").");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                continue;
            }
            if (resp.castConcreteJSON(UpdateStatusJSONData.class).isFail()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to start update process, send start IPMI command again (" + ++count + ").");
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, ((Builder)this.commandArgs).preserveConfig ? UpdateIPMIOptions.PreserveBMCConfig : UpdateIPMIOptions.ClearBMCConfig, this.commandArgs, this.getCommandName(), this.commandID);
                if (this.isIPMISendMessagesFail(resp)) continue;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
                    break;
                }
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, processType, this.commandArgs, this.getCommandName(), this.commandID);
                if (this.isIPMISendMessagesFail(resp)) continue;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                try {
                    Thread.sleep(2500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
                    break;
                }
            }
            if (resp.castConcreteJSON(UpdateStatusJSONData.class).isStart()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                break;
            }
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
                break;
            }
        }
        if (this.isIPMISendMessagesFail(resp)) {
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to start update process, please check out BMC LAN connection.");
            return false;
        }
        if (!resp.castConcreteJSON(UpdateStatusJSONData.class).isStart() && count > 15) {
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to start update process.");
            return false;
        }
        count = 0;
        resp = this.ipmiReceiver.sendIPMIRawCommand(handle, statusType, this.commandArgs, this.getCommandName(), this.commandID);
        if (this.isIPMISendMessagesFail(resp)) {
            while (count < 15 && this.isIPMISendMessagesFail(resp = this.ipmiReceiver.sendIPMIRawCommand(handle, statusType, this.commandArgs, this.getCommandName(), this.commandID))) {
                if (++count == 15) {
                    GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
                    if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                        GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
                    }
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to get update progress, please check out BMC LAN connection.");
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to get update progress, retry again (" + count + ").");
            }
        }
        try {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        count = 0;
        while (!resp.castConcreteJSON(UpdateStatusJSONData.class).isDone() && resp.castConcreteJSON(UpdateStatusJSONData.class).isStart()) {
            resp = this.ipmiReceiver.sendIPMIRawCommand(handle, UpdateIPMIOptions.GetUpdateStatus, this.commandArgs, this.getCommandName(), this.commandID);
            if (this.isIPMISendMessagesFail(resp)) {
                resp = new UpdateStatusJSONData().setStartTag(true).setDoneTag(false).setFailTag(false).setUpdateMessages("Failed to get update progress, retry again ... (" + ++count + ")");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                if (count <= 15) continue;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to get update progress, please check out BMC LAN connection.");
                GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
                if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                    GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
                }
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
            if (resp.castConcreteJSON(UpdateStatusJSONData.class).isFail()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
                if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                    GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
                }
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
            if (resp.castConcreteJSON(UpdateStatusJSONData.class).isDone()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
                break;
            }
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
                GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
                if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                    GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
                }
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
            resp = this.ipmiReceiver.sendIPMIRawCommand(handle, statusType, this.commandArgs, this.getCommandName(), this.commandID);
            if (this.isIPMISendMessagesFail(resp)) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unable to refresh the update progress, retry again.");
                if (++count <= 15) continue;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unable to refresh the update progress, please check out BMC LAN connection.");
                GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
                if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                    GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
                }
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + " update process has been interrupted.");
                GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
                if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                    GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
                }
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
        }
        count = 0;
        resp = this.ipmiReceiver.sendIPMIRawCommand(handle, ((Builder)this.commandArgs).preserveConfig ? UpdateIPMIOptions.PreserveBMCConfig : UpdateIPMIOptions.ClearBMCConfig, this.commandArgs, this.getCommandName(), this.commandID);
        while (this.isIPMISendMessagesFail(resp) && this.isIPMISendMessagesFail(resp = ((Builder)this.commandArgs).preserveConfig ? this.ipmiReceiver.sendIPMIRawCommand(handle, UpdateIPMIOptions.PreserveBMCConfig, this.commandArgs, this.getCommandName(), this.commandID) : this.ipmiReceiver.sendIPMIRawCommand(handle, UpdateIPMIOptions.ClearBMCConfig, this.commandArgs, this.getCommandName(), this.commandID))) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to send update terminate command, retry again.");
            if (++count <= 15) continue;
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
            if (((Builder)this.commandArgs).isInnerTFTPUsed) {
                GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
            }
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Failed to send update terminate command, please check out BMC LAN connection.");
            return false;
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(UpdateStatusJSONData.class).getUpdateMessages());
        if (!((Builder)this.commandArgs).preserveImage) {
            GlobalTFTPServer.access().removeFileFromTFTPServer(dstImageName, this.getCommandName(), this.commandID);
        }
        if (((Builder)this.commandArgs).isInnerTFTPUsed) {
            GlobalTFTPServer.access().shutdownTFTPServer(dstImageName.getParentFile(), false, this.getCommandName(), this.commandID);
        }
        switch (updateType) {
            case CMC: 
            case BMC: {
                try {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Waiting for " + (Object)((Object)updateType) + " reset complete.");
                    Thread.sleep(90000L);
                    return true;
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + updateType.toString() + ie.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    private final boolean updateAMIProcess(CommonUpdateFWInfo fwinfo, ConnectionHandle handle) {
        UpdateService restServices = new UpdateService(this.loggerWriter, ((Builder)this.commandArgs).updateServiceConnectionTimout, ((Builder)this.commandArgs).updateServiceReadTimout);
        restServices.setLogDirPath(this.getCommandName());
        UpdateServiceOptions restServicesOptions = UpdateServiceOptions.parse(fwinfo.getUpdateType());
        if (!((RESTServices)restServices).readJsonData(fwinfo, restServicesOptions)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Can not read the Json payload instance."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Can not read the Json request payload file.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, ((Builder)this.commandArgs).debug)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Open rest session fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Open rest session fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).execute(((Builder)this.commandArgs).bmcIP, restServicesOptions)) {
            ((RESTServices)restServices).closeSession(((Builder)this.commandArgs).bmcIP);
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.addAll(restServices.getJsonResults());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        ((RESTServices)restServices).closeSession(((Builder)this.commandArgs).bmcIP);
        this.commandResults.addAll(restServices.getJsonResults());
        if (((Builder)this.commandArgs).backupFirmware && fwinfo.getUpdateType() == UpdateType.BIOS) {
            if (!this.backupBIOSFirmware()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update BIOS 2nd SPI fail.");
                return false;
            }
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update BIOS 2nd SPI end.");
        }
        return true;
    }

    private final boolean updateOpenBmcProcess(CommonUpdateFWInfo fwinfo) {
        boolean updateResult = false;
        OpenBmcUpdateService restServices = new OpenBmcUpdateService(this.loggerWriter, ((Builder)this.commandArgs).updateServiceConnectionTimout, ((Builder)this.commandArgs).updateServiceReadTimout);
        restServices.setLogDirPath(this.getCommandName());
        UpdateServiceOptions restServicesOptions = UpdateServiceOptions.parse(fwinfo.getUpdateType());
        if (!((RESTServices)restServices).readJsonData(fwinfo, restServicesOptions)) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Can not read the Json payload instance."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Can not read the Json request payload file.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, ((Builder)this.commandArgs).debug)) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Open rest session fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Open rest session fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).execute(((Builder)this.commandArgs).bmcIP, restServicesOptions)) {
            this.commandResults.addAll(restServices.getJsonResults());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        this.commandResults.addAll(restServices.getJsonResults());
        if (fwinfo.getUpdateType() == UpdateType.BMC) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Wait " + ((Builder)this.commandArgs).waitBMCRestartTime + "(ms) for BMC rebooting...");
            try {
                Thread.sleep(((Builder)this.commandArgs).waitBMCRestartTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConnectionHandle newHandle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
            if (newHandle == null) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
                this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI connection fail."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
            for (int i = 0; i < 6; ++i) {
                AbstractJSONPOJO mcinfo = this.ipmiReceiver.sendIPMIRawCommand(newHandle, BmcDeviceIpmiOptions.GETDEVICEID, null, COMMAND_NAME, this.commandID);
                if (mcinfo instanceof BMCInfoJSONData) {
                    String bmcVersion = mcinfo.castConcreteJSON(BMCInfoJSONData.class).getFirmwareRevision();
                    BMCUpdateFWInfo bmcUpdateFWInfo = fwinfo.castConcreteJSON(BMCUpdateFWInfo.class);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC version after update : " + bmcVersion + ", compare with " + bmcUpdateFWInfo.getNewVersion());
                    if (CommonFunction.isVersionEqual(bmcUpdateFWInfo.getNewVersion(), bmcVersion)) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC version is same with release note.");
                        updateResult = true;
                        break;
                    }
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC version is different with release note, update fail!");
                    break;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC version fail, retry " + i + " times...");
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (newHandle != null) {
                this.ipmiReceiver.closeIPMIConnection(newHandle, this.getCommandName(), this.commandID);
            }
        } else {
            updateResult = true;
        }
        if (updateResult) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update " + (Object)((Object)fwinfo.getUpdateType()) + " success.");
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Update " + (Object)((Object)fwinfo.getUpdateType()) + " fail!");
        }
        return updateResult;
    }

    private void removeSkuRootPath() {
    }

    private boolean backupBIOSFirmware() {
        boolean result = false;
        int count = 0;
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI connection fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Starting to execute BIOS firmware backup process...");
        List<AbstractJSONPOJO> commandResults = this.ipmiReceiver.sendGbtOEMCommand(handle, FirmwareBackupOperateIpmiOptions.BIOS0_BIOS1, this.commandArgs, COMMAND_NAME, this.commandID);
        this.commandResults.addAll(commandResults);
        if (!commandResults.get(0).castConcreteJSON(CommandSupportStatus.class).getSupport().booleanValue()) {
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support update 2nd SPI.");
            return true;
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (count < 480) {
            AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, FirmwareBackupStatusIpmiOptions.GET_STATUS, this.commandArgs, COMMAND_NAME, this.commandID);
            if (resp instanceof FirmwareBackupStatus) {
                FirmwareBackupStatus status = resp.castConcreteJSON(FirmwareBackupStatus.class);
                if (status.getProgress() != null && status.getProgress().intValue() > 0) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + status.getStatus() + " : " + status.getProgress() + "%");
                } else {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + status.getStatus());
                }
                if (status.getResult() != null) {
                    result = status.getResult();
                    break;
                }
            }
            ++count;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (count >= 480) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Backup process is timeout!");
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        return result;
    }

    private boolean updateFirmwareByGctIpmitool(String cmdOption, CommonUpdateFWInfo fwInfo) {
        long threadId = Thread.currentThread().getId();
        MonitorMemoryUsageThread monitorMemoryUsageThread = new MonitorMemoryUsageThread();
        monitorMemoryUsageThread.setloggerWriter(this.loggerWriter);
        monitorMemoryUsageThread.setCommandName(this.getCommandName());
        monitorMemoryUsageThread.setCommandId(this.commandID);
        monitorMemoryUsageThread.setThreadId(threadId);
        monitorMemoryUsageThread.setShowAll(false);
        monitorMemoryUsageThread.setLogLevel(GbtLogLevel.DEBUG);
        monitorMemoryUsageThread.setInterval(3000L);
        monitorMemoryUsageThread.start();
        String cmd = cmdOption + " " + fwInfo.getImagePath();
        LocalCmdRecords gctipmitoolRecords = GctIpmitoolCommandReceiver.getInstance().executeCommand(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, cmd, GbtLogLevel.INFO, this.getCommandName(), this.commandID);
        if (gctipmitoolRecords.getResults().toLowerCase().contains("fail") || gctipmitoolRecords.getErrors().toLowerCase().contains("fail")) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate gctIpmiTool fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + gctipmitoolRecords.getErrors());
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Gbtipmitool execute fail."));
            monitorMemoryUsageThread.shutdown();
            return false;
        }
        monitorMemoryUsageThread.shutdown();
        return true;
    }

    private final boolean redfishAMIUpdateProcess(CommonUpdateFWInfo fwinfo, ConnectionHandle handle) {
        AMIRedfishUpdateService restServices = new AMIRedfishUpdateService(this.loggerWriter, ((Builder)this.commandArgs).updateServiceConnectionTimout, ((Builder)this.commandArgs).updateServiceReadTimout);
        restServices.setLogDirPath(this.getCommandName());
        UpdateServiceOptions restServicesOptions = UpdateServiceOptions.parse(fwinfo.getUpdateType());
        if (!((RESTServices)restServices).readJsonData(fwinfo, restServicesOptions)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Can not read the Json payload instance."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Can not read the Json request payload file.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, ((Builder)this.commandArgs).debug)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Open rest session fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Open rest session fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((RESTServices)restServices).execute(((Builder)this.commandArgs).bmcIP, restServicesOptions)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.addAll(restServices.getJsonResults());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        ((RESTServices)restServices).closeSession(((Builder)this.commandArgs).bmcIP);
        this.commandResults.addAll(restServices.getJsonResults());
        return true;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        protected UpdateType updateType = UpdateType.UNKNOWN;
        protected File fwImage;
        private File tftpPath = new File("tftpTemp");
        protected String tftpIP;
        protected int tftpPort = 69;
        protected boolean preserveConfig = false;
        private boolean skip = false;
        protected AbstractJSONPOJO preupdateFWInfo;
        protected BMCInfoJSONData bmcInfoJSONData;
        private boolean isInnerTFTPUsed = true;
        private boolean preserveImage = false;
        private boolean debug = false;
        private boolean backupFirmware = false;
        private DualImageConfig dualImage = DualImageConfig.UNKNOWN;
        private int updateServiceConnectionTimout = -1;
        private int updateServiceReadTimout = -1;
        private int waitBMCRestartTime = 510000;
        private boolean gctIpmiMode = false;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "0.0.0.0_update", "BMC IP address is null.");
                return false;
            }
            if (this.args != null && this.args.length > 0) {
                this.updateType = this.args.length > 1 ? UpdateType.parse(this.args[0], this.args[1]) : UpdateType.parse(this.args[0], null);
                this.commandLineParser(this.args);
            }
            if (this.updateType == UpdateType.UNKNOWN) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME, "[" + this.bmcIP + "] Unknown update type.");
                return false;
            }
            if (this.preupdateFWInfo == null) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] Update FW info data is null.");
                return false;
            }
            if (this.fwImage == null) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] No FW image path.");
                return false;
            }
            if (!this.fwImage.exists()) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] FW image not exist.");
                return false;
            }
            if (this.tftpPath == null) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] TFTP server root path is not exist.");
                return false;
            }
            if (!this.tftpPath.exists() && !this.tftpPath.mkdir()) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] Can not make root path for inner TFTP server usage.");
                return false;
            }
            if (!this.tftpPath.isDirectory()) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] TFTP server root path is not a directory.");
                return false;
            }
            if (this.tftpIP != null && !CommonFunction.isValidateIP(this.tftpIP)) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] TFTP server IP address is invalid.");
                return false;
            }
            if (this.tftpPort < 1 || this.tftpPort > 65535) {
                this.loggerWriter.appendPath(MainUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + MainUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] TFTP port is invalid.");
                return false;
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public MainUpdateCommand build() {
            return new MainUpdateCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.preupdateFWInfo = null;
            this.updateType = null;
            this.fwImage = null;
            this.tftpPath = null;
            this.tftpIP = null;
            this.tftpPort = 0;
            this.preserveConfig = false;
            this.skip = false;
            this.isInnerTFTPUsed = true;
            this.debug = false;
            this.gctIpmiMode = false;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this.getThis();
        }

        public Builder setFWImage(String imagePath) {
            if (imagePath.toLowerCase().indexOf(".img") > 0 || imagePath.toLowerCase().indexOf(".rbu") > 0 || imagePath.toLowerCase().indexOf(".vme") > 0 || imagePath.toLowerCase().indexOf(".jbc") > 0 || imagePath.toLowerCase().indexOf(".hex") > 0 || imagePath.toLowerCase().indexOf(".bin") > 0 || imagePath.toLowerCase().indexOf(".rcu") > 0 || imagePath.toLowerCase().indexOf(".ima_enc") > 0 || imagePath.toLowerCase().indexOf(".tar") > 0 || imagePath.toLowerCase().indexOf(".rpd") > 0) {
                this.fwImage = new File(imagePath);
            }
            return this.getThis();
        }

        public Builder setFWImage(File imagePath) {
            if ((imagePath.getName().toLowerCase().indexOf(".img") > 0 || imagePath.getName().toLowerCase().indexOf(".rbu") > 0 || imagePath.getName().toLowerCase().indexOf(".vme") > 0 || imagePath.getName().toLowerCase().indexOf(".jbc") > 0 || imagePath.getName().toLowerCase().indexOf(".hex") > 0 || imagePath.getName().toLowerCase().indexOf(".bin") > 0 || imagePath.getName().toLowerCase().indexOf(".rcu") > 0 || imagePath.getName().toLowerCase().indexOf(".ima_enc") > 0 || imagePath.getName().toLowerCase().indexOf(".tar") > 0) && imagePath.exists()) {
                this.fwImage = imagePath;
            }
            return this.getThis();
        }

        public Builder setTFTPPath(String tftpPath) {
            if (tftpPath != null) {
                this.tftpPath = new File(tftpPath);
                if (!this.tftpPath.exists()) {
                    this.tftpPath.mkdir();
                }
                this.isInnerTFTPUsed = false;
            }
            return this.getThis();
        }

        public Builder setTFTPPath(File tftpPath) {
            if (tftpPath == null) {
                return this.getThis();
            }
            this.tftpPath = tftpPath;
            if (!this.tftpPath.exists()) {
                this.tftpPath.mkdir();
            }
            this.isInnerTFTPUsed = false;
            return this.getThis();
        }

        public Builder setTFTPIP(String tftpIP) {
            this.tftpIP = tftpIP;
            return this.getThis();
        }

        public Builder setTFTPPort(int tftpPort) {
            this.tftpPort = tftpPort;
            return this.getThis();
        }

        public Builder setPreserveConfig(boolean preserve) {
            this.preserveConfig = preserve;
            return this.getThis();
        }

        public Builder setPreserveImage(boolean preserve) {
            this.preserveImage = preserve;
            return this.getThis();
        }

        public Builder setSkip(boolean skip) {
            this.skip = skip;
            return this.getThis();
        }

        public Builder setBackupFirmware(boolean bacupFirmware) {
            this.backupFirmware = bacupFirmware;
            return this.getThis();
        }

        public Builder setDualImage(DualImageConfig dualImage) {
            this.dualImage = dualImage;
            return this.getThis();
        }

        public Builder setPreUpdateFWInfo(AbstractJSONPOJO info) {
            if (info instanceof BMCUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(BMCUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(BMCUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(BMCUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            } else if (info instanceof BIOSUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(BIOSUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(BIOSUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(BIOSUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            } else if (info instanceof CPLDUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(CPLDUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(CPLDUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(CPLDUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            } else if (info instanceof PSUUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(PSUUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(PSUUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(PSUUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            } else if (info instanceof SKUUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(SKUUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(SKUUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(SKUUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            } else if (info instanceof FpgaUpdateFWInfo) {
                this.setBMCIP(info.castConcreteJSON(FpgaUpdateFWInfo.class).getTargetBmcIp());
                this.setUpdateType(info.castConcreteJSON(FpgaUpdateFWInfo.class).getUpdateType());
                this.setFWImage(info.castConcreteJSON(FpgaUpdateFWInfo.class).getImagePath());
                this.preupdateFWInfo = info;
            }
            return this.getThis();
        }

        public Builder setBmcInfoJSONData(BMCInfoJSONData bmcInfoJSONData) {
            this.bmcInfoJSONData = bmcInfoJSONData;
            return this.getThis();
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this.getThis();
        }

        public Builder setUpdateServiceConnectionTimout(int updateServiceConnectionTimout) {
            this.updateServiceConnectionTimout = updateServiceConnectionTimout;
            return this.getThis();
        }

        public Builder setUpdateServiceReadTimout(int updateServiceReadTimout) {
            this.updateServiceReadTimout = updateServiceReadTimout;
            return this.getThis();
        }

        public Builder setWaitBMCRestartTime(int waitBMCRestartTime) {
            this.waitBMCRestartTime = waitBMCRestartTime;
            return this.getThis();
        }

        public Builder setGctIpmiMode(boolean gctIpmiMode) {
            this.gctIpmiMode = gctIpmiMode;
            return this.getThis();
        }

        private void commandLineParser(String[] args) {
            int startPosition = 1;
            if (args[0].equals("cpld")) {
                startPosition = 2;
            }
            block16: for (int i = startPosition; i < args.length; ++i) {
                if (args[i].contains("path=")) {
                    this.setTFTPPath(args[i].substring(args[i].lastIndexOf("path=") + 5));
                    this.isInnerTFTPUsed = false;
                }
                if (args[i].contains("tftpip=")) {
                    this.setTFTPIP(args[i].substring(args[i].lastIndexOf("tftpip=") + 7));
                }
                if (args[i].contains("port=")) {
                    this.setTFTPPort(Integer.parseInt(args[i].substring(args[i].lastIndexOf("port=") + 5)));
                }
                if (args[i].contains("rt=")) {
                    this.setUpdateServiceReadTimout(Integer.parseInt(args[i].substring(args[i].lastIndexOf("rt=") + 3)));
                }
                if (args[i].contains("ct=")) {
                    this.setUpdateServiceConnectionTimout(Integer.parseInt(args[i].substring(args[i].lastIndexOf("ct=") + 3)));
                }
                if (args[i].contains("wr=")) {
                    this.setWaitBMCRestartTime(Integer.parseInt(args[i].substring(args[i].lastIndexOf("wr=") + 3)));
                }
                switch (args[i]) {
                    case "preserve": {
                        this.preserveConfig = true;
                        continue block16;
                    }
                    case "skip": {
                        this.skip = true;
                        continue block16;
                    }
                    case "debug": {
                        this.debug = true;
                        continue block16;
                    }
                    case "backupimg": {
                        this.backupFirmware = true;
                        continue block16;
                    }
                    case "dualimg": {
                        this.dualImage = DualImageConfig.BOTH_IMAGE;
                        continue block16;
                    }
                    case "gctipmi": {
                        this.gctIpmiMode = true;
                        continue block16;
                    }
                }
            }
        }
    }
}

