/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.power;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.power.PowerIpmiOptions;
import Gbt.utility.power.PowerReadingInfo;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class GetPowerReadingCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "power";
    private final GbtIPMICommandReceiver receiver;

    protected GetPowerReadingCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.receiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.receiver != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.receiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get power reading.");
        AbstractJSONPOJO commandData = this.receiver.sendIPMIRawCommand(handle, PowerIpmiOptions.READ, null, this.getCommandName(), this.commandID);
        if (this.isIPMISendMessagesFail(commandData)) {
            this.receiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        PowerReadingInfo powerReadingInfo = commandData.castConcreteJSON(PowerReadingInfo.class);
        this.commandResults.add(powerReadingInfo);
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Current power          : " + powerReadingInfo.getCurrentPower() + " (Watts)");
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Maximum power          : " + powerReadingInfo.getMaximumPower() + " (Watts)");
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Minimum power          : " + powerReadingInfo.getMinimumPower() + " (Watts)");
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Average power          : " + powerReadingInfo.getAveragePower() + " (Watts)");
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Timestamp              : " + powerReadingInfo.getTimestamp().toString());
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Sampling period        : " + powerReadingInfo.getSamplingPeriod().toString() + " (msec)");
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Power reading state is : " + (powerReadingInfo.isActivate() != false ? "Activate" : "Deactivate"));
        this.receiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private final boolean isIPMISendMessagesFail(AbstractJSONPOJO resp) {
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                return true;
            }
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
        }
        return false;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";

        @Override
        public boolean checkArgs() {
            if (this.args != null && this.args.length != 0) {
                return false;
            }
            return this.bmcIP != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public GetPowerReadingCommand build() {
            return new GetPowerReadingCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }
    }
}

