/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.factories;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.redfish.RedfishApiOptions;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.utility.redfish.options.AccountServiceApiOptions;
import Gbt.utility.redfish.options.BiosApiOptions;
import Gbt.utility.redfish.options.ChassisApiOptions;
import Gbt.utility.redfish.options.EthernetApiOptions;
import Gbt.utility.redfish.options.EventServiceApiOptions;
import Gbt.utility.redfish.options.JsonSchemasApiOptions;
import Gbt.utility.redfish.options.LogServiceApiOptions;
import Gbt.utility.redfish.options.ManagersApiOptions;
import Gbt.utility.redfish.options.MemoryApiOptions;
import Gbt.utility.redfish.options.NetworkProtocolApiOptions;
import Gbt.utility.redfish.options.PowerApiOptions;
import Gbt.utility.redfish.options.ProcessorsApiOptions;
import Gbt.utility.redfish.options.RedfishRawOptions;
import Gbt.utility.redfish.options.RegistriesApiOptions;
import Gbt.utility.redfish.options.RolesApiOptions;
import Gbt.utility.redfish.options.RootServiceApiOptions;
import Gbt.utility.redfish.options.SecureBootApiOptions;
import Gbt.utility.redfish.options.SerialInterfacesApiOptions;
import Gbt.utility.redfish.options.SessionServiceApiOptions;
import Gbt.utility.redfish.options.SystemsApiOptions;
import Gbt.utility.redfish.options.TaskServiceApiOptions;
import Gbt.utility.redfish.options.ThermalApiOptions;
import Gbt.utility.redfish.options.UpdateServiceApiOptions;
import Gbt.utility.redfish.services.AccountServiceApi;
import Gbt.utility.redfish.services.BiosApi;
import Gbt.utility.redfish.services.ChassisApi;
import Gbt.utility.redfish.services.EthernetApi;
import Gbt.utility.redfish.services.EventServiceApi;
import Gbt.utility.redfish.services.JsonSchemasApi;
import Gbt.utility.redfish.services.LogServiceApi;
import Gbt.utility.redfish.services.ManagersApi;
import Gbt.utility.redfish.services.MemoryApi;
import Gbt.utility.redfish.services.NetworkProtocolApi;
import Gbt.utility.redfish.services.PowerApi;
import Gbt.utility.redfish.services.ProcessorsApi;
import Gbt.utility.redfish.services.RedfishRawApi;
import Gbt.utility.redfish.services.RegistriesApi;
import Gbt.utility.redfish.services.RolesApi;
import Gbt.utility.redfish.services.RootServiceApi;
import Gbt.utility.redfish.services.SecureBootApi;
import Gbt.utility.redfish.services.SerialInterfacesApi;
import Gbt.utility.redfish.services.SessionServiceApi;
import Gbt.utility.redfish.services.SystemsApi;
import Gbt.utility.redfish.services.TaskServiceApi;
import Gbt.utility.redfish.services.ThermalApi;
import Gbt.utility.redfish.services.UpdateServiceApi;

public enum RedfishApiMenu {
    UNKNOWN("unknown"),
    ACCOUNTSERVICE("accountservice"),
    BIOS("bios"),
    CHASSIS("chassis"),
    ETHERNET("ethernet"),
    EVENTSERVICE("eventservice"),
    JSONSCHEMAS("jsonschemas"),
    MANAGERS("managers"),
    MEMORY("memory"),
    NETWORKPROTOCOL("networkprotocol"),
    LOGSERVICE("logservice"),
    PROCESSORS("processors"),
    POWER("power"),
    RAW("raw"),
    REGISTRIES("registries"),
    ROLES("roles"),
    ROOT("root"),
    SECUREBOOT("secureboot"),
    SERIAL("serial"),
    SESSION("session"),
    SYSTEMS("systems"),
    TASKSERVICE("taskservice"),
    THERMAL("thermal"),
    UPDATESERVICE("updateservice");

    private static final String UNKNOWN_API_NAME = "unknown";
    private static final String ACCOUNTSERVICE_API_NAME = "accountservice";
    private static final String BIOS_API_NAME = "bios";
    private static final String CHASSIS_API_NAME = "chassis";
    private static final String ETHERNET_API_NAME = "ethernet";
    private static final String EVENTSERVICE_API_NAME = "eventservice";
    private static final String JSONSCHEMA_API_NAME = "jsonschemas";
    private static final String MANAGERS_API_NAME = "managers";
    private static final String MEMORY_API_NAME = "memory";
    private static final String NETWORKPROTOCOL_API_NAME = "networkprotocol";
    private static final String LOGSERVICE_API_NAME = "logservice";
    private static final String PROCESSORS_API_NAME = "processors";
    private static final String POWER_API_NAME = "power";
    private static final String RAW_API_NAME = "raw";
    private static final String REGISTRIES_API_NAME = "registries";
    private static final String ROLES_API_NAME = "roles";
    private static final String ROOT_API_NAME = "root";
    private static final String SECUREBOOT_API_NAME = "secureboot";
    private static final String SERIAL_API_NAME = "serial";
    private static final String SESSION_API_NAME = "session";
    private static final String SYSTEMS_API_NAME = "systems";
    private static final String TASKSERVICE_API_NAME = "taskservice";
    private static final String THERMAL_API_NAME = "thermal";
    private static final String UPDATE_API_NAME = "updateservice";
    private final String apiName;

    private RedfishApiMenu(String apiName) {
        this.apiName = apiName;
    }

    public final String getApiName() {
        return this.apiName;
    }

    public String toString() {
        return this.apiName;
    }

    public final RedfishApiOptions getApiOption(String optionName) {
        if (optionName == null) {
            return RootServiceApiOptions.SHOW;
        }
        switch (this) {
            case ACCOUNTSERVICE: {
                return AccountServiceApiOptions.parse(optionName);
            }
            case BIOS: {
                return BiosApiOptions.parse(optionName);
            }
            case CHASSIS: {
                return ChassisApiOptions.parse(optionName);
            }
            case ETHERNET: {
                return EthernetApiOptions.parse(optionName);
            }
            case EVENTSERVICE: {
                return EventServiceApiOptions.parse(optionName);
            }
            case JSONSCHEMAS: {
                return JsonSchemasApiOptions.parse(optionName);
            }
            case MANAGERS: {
                return ManagersApiOptions.parse(optionName);
            }
            case MEMORY: {
                return MemoryApiOptions.parse(optionName);
            }
            case NETWORKPROTOCOL: {
                return NetworkProtocolApiOptions.parse(optionName);
            }
            case PROCESSORS: {
                return ProcessorsApiOptions.parse(optionName);
            }
            case POWER: {
                return PowerApiOptions.parse(optionName);
            }
            case RAW: {
                return RedfishRawOptions.parse(optionName);
            }
            case REGISTRIES: {
                return RegistriesApiOptions.parse(optionName);
            }
            case ROLES: {
                return RolesApiOptions.parse(optionName);
            }
            case ROOT: {
                return RootServiceApiOptions.SHOW;
            }
            case SECUREBOOT: {
                return SecureBootApiOptions.parse(optionName);
            }
            case SERIAL: {
                return SerialInterfacesApiOptions.parse(optionName);
            }
            case SESSION: {
                return SessionServiceApiOptions.parse(optionName);
            }
            case SYSTEMS: {
                return SystemsApiOptions.parse(optionName);
            }
            case TASKSERVICE: {
                return TaskServiceApiOptions.parse(optionName);
            }
            case THERMAL: {
                return ThermalApiOptions.parse(optionName);
            }
            case LOGSERVICE: {
                return LogServiceApiOptions.parse(optionName);
            }
            case UPDATESERVICE: {
                return UpdateServiceApiOptions.parse(optionName);
            }
        }
        return RootServiceApiOptions.UNKNOWN;
    }

    public final RedfishApiPayload<?, ?> getApiPayload(String bmcIpAddress, AbstractLoggerWriter loggerWriter) {
        switch (this) {
            case ACCOUNTSERVICE: {
                return new AccountServiceApi.Payload(bmcIpAddress, loggerWriter);
            }
            case BIOS: {
                return new BiosApi.Payload(bmcIpAddress, loggerWriter);
            }
            case CHASSIS: {
                return new ChassisApi.Payload(bmcIpAddress, loggerWriter);
            }
            case ETHERNET: {
                return new EthernetApi.PayLoad(bmcIpAddress, loggerWriter);
            }
            case EVENTSERVICE: {
                return new EventServiceApi.PayLoad(bmcIpAddress, loggerWriter);
            }
            case JSONSCHEMAS: {
                return new JsonSchemasApi.Payload(bmcIpAddress, loggerWriter);
            }
            case LOGSERVICE: {
                return new LogServiceApi.Payload(bmcIpAddress, loggerWriter);
            }
            case MANAGERS: {
                return new ManagersApi.Payload(bmcIpAddress, loggerWriter);
            }
            case MEMORY: {
                return new MemoryApi.Payload(bmcIpAddress, loggerWriter);
            }
            case NETWORKPROTOCOL: {
                return new NetworkProtocolApi.Payload(bmcIpAddress, loggerWriter);
            }
            case PROCESSORS: {
                return new ProcessorsApi.Payload(bmcIpAddress, loggerWriter);
            }
            case POWER: {
                return new PowerApi.Payload(bmcIpAddress, loggerWriter);
            }
            case RAW: {
                return new RedfishRawApi.PayLoad(bmcIpAddress, loggerWriter);
            }
            case REGISTRIES: {
                return new RegistriesApi.Payload(bmcIpAddress, loggerWriter);
            }
            case ROLES: {
                return new RolesApi.PayLoad(bmcIpAddress, loggerWriter);
            }
            case SECUREBOOT: {
                return new SecureBootApi.Payload(bmcIpAddress, loggerWriter);
            }
            case SERIAL: {
                return new SerialInterfacesApi.Payload(bmcIpAddress, loggerWriter);
            }
            case SESSION: {
                return new SessionServiceApi.Payload(bmcIpAddress, loggerWriter);
            }
            case SYSTEMS: {
                return new SystemsApi.Payload(bmcIpAddress, loggerWriter);
            }
            case TASKSERVICE: {
                return new TaskServiceApi.Payload(bmcIpAddress, loggerWriter);
            }
            case THERMAL: {
                return new ThermalApi.Payload(bmcIpAddress, loggerWriter);
            }
            case UPDATESERVICE: {
                return new UpdateServiceApi.Payload(bmcIpAddress, loggerWriter);
            }
        }
        return new RootServiceApi.Paylaod(bmcIpAddress, loggerWriter);
    }

    public final RedfishApiPayload<?, ?> getApiPayload(String bmcIpAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
        switch (this) {
            case ACCOUNTSERVICE: {
                return new AccountServiceApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case BIOS: {
                return new BiosApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case CHASSIS: {
                return new ChassisApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case ETHERNET: {
                return new EthernetApi.PayLoad(bmcIpAddress, username, password, loggerWriter);
            }
            case EVENTSERVICE: {
                return new EventServiceApi.PayLoad(bmcIpAddress, username, password, loggerWriter);
            }
            case JSONSCHEMAS: {
                return new JsonSchemasApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case LOGSERVICE: {
                return new LogServiceApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case MANAGERS: {
                return new ManagersApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case MEMORY: {
                return new MemoryApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case NETWORKPROTOCOL: {
                return new NetworkProtocolApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case PROCESSORS: {
                return new ProcessorsApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case POWER: {
                return new PowerApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case RAW: {
                return new RedfishRawApi.PayLoad(bmcIpAddress, username, password, loggerWriter);
            }
            case REGISTRIES: {
                return new RegistriesApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case ROLES: {
                return new RolesApi.PayLoad(bmcIpAddress, username, password, loggerWriter);
            }
            case SECUREBOOT: {
                return new SecureBootApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case SERIAL: {
                return new SerialInterfacesApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case SESSION: {
                return new SessionServiceApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case SYSTEMS: {
                return new SystemsApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case TASKSERVICE: {
                return new TaskServiceApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case THERMAL: {
                return new ThermalApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
            case UPDATESERVICE: {
                return new UpdateServiceApi.Payload(bmcIpAddress, username, password, loggerWriter);
            }
        }
        return new RootServiceApi.Paylaod(bmcIpAddress, username, password, loggerWriter);
    }

    public static final RedfishApiMenu parse(String serviceName) {
        if (serviceName == null) {
            return ROOT;
        }
        switch (serviceName.toLowerCase()) {
            case "accountservice": {
                return ACCOUNTSERVICE;
            }
            case "bios": {
                return BIOS;
            }
            case "chassis": {
                return CHASSIS;
            }
            case "ethernet": {
                return ETHERNET;
            }
            case "eventservice": {
                return EVENTSERVICE;
            }
            case "jsonschemas": {
                return JSONSCHEMAS;
            }
            case "logservice": {
                return LOGSERVICE;
            }
            case "managers": {
                return MANAGERS;
            }
            case "memory": {
                return MEMORY;
            }
            case "networkprotocol": {
                return NETWORKPROTOCOL;
            }
            case "processors": {
                return PROCESSORS;
            }
            case "power": {
                return POWER;
            }
            case "raw": {
                return RAW;
            }
            case "registries": {
                return REGISTRIES;
            }
            case "roles": {
                return ROLES;
            }
            case "root": {
                return ROOT;
            }
            case "secureboot": {
                return SECUREBOOT;
            }
            case "serial": {
                return SERIAL;
            }
            case "session": {
                return SESSION;
            }
            case "systems": {
                return SYSTEMS;
            }
            case "taskservice": {
                return TASKSERVICE;
            }
            case "thermal": {
                return THERMAL;
            }
            case "updateservice": {
                return UPDATESERVICE;
            }
        }
        return UNKNOWN;
    }
}

