/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum MemoryApiOptions implements RedfishApiOptions
{
    UNKNOWN("/redfish/v1/Systems/<id>/Memory"),
    LIST("/redfish/v1/Systems/<id>/Memory"),
    GET("/redfish/v1/Systems/<id>/Memory"),
    CHANGESTATE("/redfish/v1/Systems/<id>/Memory");

    private static final String MEMORY_URI = "/redfish/v1/Systems/<id>/Memory";
    private final String mainUri;

    private MemoryApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            case GET: {
                return "Memory ID not apply.";
            }
            case CHANGESTATE: {
                return "Memory ID not apply or request state invalid.";
            }
        }
        return "Unsupport option of the Redfish memory API.";
    }

    public String replaceSystemId(String systemID) {
        return this.getMainUri().replace("<id>", systemID);
    }

    public static final MemoryApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return MemoryApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

