/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum ProcessorsApiOptions implements RedfishApiOptions
{
    UNKNOWN("/redfish/v1/Systems/<id>/Processors"),
    LIST("/redfish/v1/Systems/<id>/Processors"),
    GET("/redfish/v1/Systems/<id>/Processors");

    private static final String PROCESSORS_URI = "/redfish/v1/Systems/<id>/Processors";
    private final String mainUri;

    private ProcessorsApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            case GET: {
                return "Processor ID not apply.";
            }
        }
        return "Unsupport option of the Redfish processors API.";
    }

    public String replaceSystemId(String systemID) {
        return this.getMainUri().replace("<id>", systemID);
    }

    public static final ProcessorsApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return ProcessorsApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

