/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.ami.config.PamConfigurationResource;
import Gbt.utility.redfish.models.common.account.AccountResource;
import Gbt.utility.redfish.models.common.account.AccountServiceResource;
import Gbt.utility.redfish.options.AccountServiceApiOptions;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class AccountServiceApi
extends RedfishApiService<Payload> {
    protected AccountServiceApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.ACCOUNTSERVICE.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(AccountServiceApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case GET: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setAccountId(Integer.parseInt(((Payload)this.servicePayload).getRestRawArgs()[1]));
                return true;
            }
            case LIST: {
                return true;
            }
            case ADD: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                return this.uploadFileValidation(RedfishResourceTypes.ManagerAccount);
            }
            case MODIFY: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 3) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setAccountId(Integer.parseInt(((Payload)this.servicePayload).getRestRawArgs()[1]));
                ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                return this.uploadFileValidation(RedfishResourceTypes.ManagerAccount);
            }
            case DELETE: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setAccountId(Integer.parseInt(((Payload)this.servicePayload).getRestRawArgs()[1]));
                return true;
            }
            case INFO: {
                return true;
            }
            case CONFIG: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                return this.uploadFileValidation(RedfishResourceTypes.AccountService);
            }
            case PAMINFO: {
                return true;
            }
            case PAMCONFIG: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                return this.uploadFileValidation(RedfishResourceTypes.AccountServiceConfigurations);
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case GET: {
                return true;
            }
            case LIST: {
                return true;
            }
            case ADD: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.ManagerAccount);
                }
                if (((Payload)this.servicePayload).accountData != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.ManagerAccount, ((Payload)this.servicePayload).accountData);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case MODIFY: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.ManagerAccount);
                }
                if (((Payload)this.servicePayload).accountData != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.ManagerAccount, ((Payload)this.servicePayload).accountData);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case DELETE: {
                return true;
            }
            case INFO: {
                return true;
            }
            case CONFIG: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.AccountService);
                }
                if (((Payload)this.servicePayload).serviceConfig != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.AccountService, ((Payload)this.servicePayload).serviceConfig);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case PAMINFO: {
                return true;
            }
            case PAMCONFIG: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.AccountServiceConfigurations);
                }
                if (((Payload)this.servicePayload).pamConfig != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.AccountServiceConfigurations, ((Payload)this.servicePayload).pamConfig);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        switch ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case GET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).accountId).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case LIST: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    if (desResp.isRedfishErrorResponse()) {
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean bl = false;
                        return bl;
                    }
                    this.responseData.add(desResp);
                    List<String> accounts = desResp.getMembersOdataId();
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Account List:");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(accounts));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case ADD: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean accounts = !desResp.isRedfishErrorResponse();
                    return accounts;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case MODIFY: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri() + "/" + ((Payload)this.servicePayload).accountId);
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).accountId).setContentType("application/json")).setHeaders("If-Match", etag)).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp2 = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp2);
                    if (desResp2.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp2.toString());
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Modify account (" + ((Payload)this.servicePayload).accountId + ") fail.");
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, desResp2.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Modify account (" + ((Payload)this.servicePayload).accountId + ") success.");
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case DELETE: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.DELETE)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).accountId).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    if (desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Delete account (" + ((Payload)this.servicePayload).accountId + ") fail.");
                        boolean desResp2 = false;
                        return desResp2;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Delete account (" + ((Payload)this.servicePayload).accountId + ") success.");
                    boolean desResp2 = true;
                    return desResp2;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case INFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean desResp2 = !desResp.isRedfishErrorResponse();
                    return desResp2;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case CONFIG: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setHeaders("If-Match", etag)).setContentType("application/json")).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp3 = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp3);
                    if (desResp3.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp3.toString());
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Modify account service config fail.");
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, desResp3.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Modify account service config success.");
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case PAMINFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean desResp3 = !desResp.isRedfishErrorResponse();
                    return desResp3;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case PAMCONFIG: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHeaders("If-Match", etag)).setHttpMethods(RESTHttpMethods.PATCH)).setServiceURI(((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    if (desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Modify account service PAM config fail.");
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Modify account service PAM config success.");
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((AccountServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, AccountServiceApiOptions> {
        private int accountId;
        private AccountResource accountData;
        private AccountServiceResource serviceConfig;
        private PamConfigurationResource pamConfig;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(AccountServiceApiOptions.UNKNOWN);
            this.accountId = 1;
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(AccountServiceApiOptions.UNKNOWN);
            this.accountId = 1;
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public AccountServiceApi build() {
            return new AccountServiceApi(this);
        }

        public Payload setAccountId(int accountId) {
            this.accountId = accountId;
            return this.getThis();
        }

        public Payload setAccountData(AccountResource accountData) {
            this.accountData = accountData;
            return this.getThis();
        }

        public Payload setServiceConfig(AccountServiceResource serviceConfig) {
            this.serviceConfig = serviceConfig;
            return this.getThis();
        }

        public Payload setPamConfig(PamConfigurationResource pamConfig) {
            this.pamConfig = pamConfig;
            return this.getThis();
        }
    }
}

