/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.common.managers.ManagerFactoryResetTypes;
import Gbt.utility.redfish.models.common.managers.ManagerResetTypes;
import Gbt.utility.redfish.models.common.managers.ManagerResourceFactoryResetAction;
import Gbt.utility.redfish.models.common.managers.ManagerResourceResetAction;
import Gbt.utility.redfish.models.common.managers.ManagerTimeUploadData;
import Gbt.utility.redfish.options.ManagersApiOptions;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

public final class ManagersApi
extends RedfishApiService<Payload> {
    protected ManagersApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.MANAGERS.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(ManagersApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setManagerId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
            case TIMESET: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setManagerId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case RESET: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setManagerId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case FRESET: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setManagerId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case TIMESET: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.Manager);
                }
                if (((Payload)this.servicePayload).getDateTime() != null) {
                    ManagerTimeUploadData updDate = new ManagerTimeUploadData().parseDateTime(((Payload)this.servicePayload).getDateTime());
                    return this.uploadDataValidation(RedfishResourceTypes.Manager, updDate);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case RESET: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                }
                if (((Payload)this.servicePayload).getResetType() != ManagerResetTypes.Unknown) {
                    ManagerResourceResetAction action = new ManagerResourceResetAction();
                    action.setResetType(((Payload)this.servicePayload).getResetType());
                    return this.uploadDataValidation(RedfishResourceTypes.Ignore, action);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case FRESET: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                }
                if (((Payload)this.servicePayload).getFactoryResetType() != ManagerFactoryResetTypes.Unknown) {
                    ManagerResourceFactoryResetAction action = new ManagerResourceFactoryResetAction();
                    action.setFactoryResetType(((Payload)this.servicePayload).getFactoryResetType());
                    return this.uploadDataValidation(RedfishResourceTypes.Ignore, action);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((Payload)this.servicePayload).getManagerId() == null) {
            ((Payload)this.servicePayload).setManagerId("Self");
        }
        switch ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).getManagerId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case TIMESET: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri() + "/" + ((Payload)this.servicePayload).getManagerId());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setContentType("application/json")).setRawJsonData(this.requestBody)).setHeaders("If-Match", etag)).setServiceURI(((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).getManagerId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case RESET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((Payload)this.servicePayload).getManagerId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case FRESET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((Payload)this.servicePayload).getManagerId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ManagersApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, ManagersApiOptions> {
        private String managerId;
        private DateTime dateTime;
        private ManagerResetTypes resetType;
        private ManagerFactoryResetTypes factoryResetType;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(ManagersApiOptions.UNKNOWN);
            this.setResetType(ManagerResetTypes.Unknown);
            this.setFactoryResetType(ManagerFactoryResetTypes.Unknown);
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(ManagersApiOptions.UNKNOWN);
            this.setResetType(ManagerResetTypes.Unknown);
            this.setFactoryResetType(ManagerFactoryResetTypes.Unknown);
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public ManagersApi build() {
            return new ManagersApi(this);
        }

        public String getManagerId() {
            return this.managerId;
        }

        public Payload setManagerId(String managerId) {
            this.managerId = managerId;
            return this.getThis();
        }

        public DateTime getDateTime() {
            return this.dateTime;
        }

        public Payload setDateTime(DateTime dateTime) {
            this.dateTime = dateTime;
            return this.getThis();
        }

        public ManagerResetTypes getResetType() {
            return this.resetType;
        }

        public Payload setResetType(ManagerResetTypes resetType) {
            this.resetType = resetType;
            return this.getThis();
        }

        public ManagerFactoryResetTypes getFactoryResetType() {
            return this.factoryResetType;
        }

        public Payload setFactoryResetType(ManagerFactoryResetTypes factoryResetType) {
            this.factoryResetType = factoryResetType;
            return this.getThis();
        }
    }
}

