/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.common.secureboot.ResetKeysTypes;
import Gbt.utility.redfish.models.common.secureboot.SecureBootResetKeysAction;
import Gbt.utility.redfish.models.common.secureboot.SecureBootResource;
import Gbt.utility.redfish.options.SecureBootApiOptions;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class SecureBootApi
extends RedfishApiService<Payload> {
    protected SecureBootApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.SECUREBOOT.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(SecureBootApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: 
            case ACTIONINFO: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
            case ENABLE: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return this.uploadDataValidation(RedfishResourceTypes.SecureBoot, new SecureBootResource().setSecureBootEnable(true));
            }
            case DISABLE: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return this.uploadDataValidation(RedfishResourceTypes.SecureBoot, new SecureBootResource().setSecureBootEnable(false));
            }
            case RESETKEY: {
                SecureBootResetKeysAction action = new SecureBootResetKeysAction();
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setResetKeysTypes(ResetKeysTypes.parse(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        if (((Payload)this.servicePayload).getResetKeysTypes() == ResetKeysTypes.Unknown) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                            return false;
                        }
                        action.setResetKeysType(((Payload)this.servicePayload).getResetKeysTypes());
                        return this.uploadDataValidation(RedfishResourceTypes.Ignore, action);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setResetKeysTypes(ResetKeysTypes.parse(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        if (((Payload)this.servicePayload).getResetKeysTypes() == ResetKeysTypes.Unknown) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                            return false;
                        }
                        action.setResetKeysType(((Payload)this.servicePayload).getResetKeysTypes());
                        return this.uploadDataValidation(RedfishResourceTypes.Ignore, action);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: 
            case ACTIONINFO: {
                return true;
            }
            case ENABLE: {
                return this.uploadDataValidation(RedfishResourceTypes.SecureBoot, new SecureBootResource().setSecureBootEnable(true));
            }
            case DISABLE: {
                return this.uploadDataValidation(RedfishResourceTypes.SecureBoot, new SecureBootResource().setSecureBootEnable(false));
            }
            case RESETKEY: {
                if (((Payload)this.servicePayload).getResetKeysTypes() == ResetKeysTypes.Unknown) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                SecureBootResetKeysAction action = new SecureBootResetKeysAction();
                action.setResetKeysType(((Payload)this.servicePayload).getResetKeysTypes());
                return this.uploadDataValidation(RedfishResourceTypes.Ignore, action);
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((Payload)this.servicePayload).getSystemId() == null) {
            ((Payload)this.servicePayload).setSystemId("Self");
        }
        switch ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: 
            case ACTIONINFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case ENABLE: 
            case DISABLE: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId()));
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setContentType("application/json")).setRawJsonData(this.requestBody)).setHeaders("If-Match", etag)).setServiceURI(((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case RESETKEY: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SecureBootApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, SecureBootApiOptions> {
        private String systemId;
        private ResetKeysTypes resetKeysTypes;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(SecureBootApiOptions.UNKNOWN);
            this.setResetKeysTypes(ResetKeysTypes.Unknown);
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(SecureBootApiOptions.UNKNOWN);
            this.setResetKeysTypes(ResetKeysTypes.Unknown);
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public SecureBootApi build() {
            return new SecureBootApi(this);
        }

        public String getSystemId() {
            return this.systemId;
        }

        public Payload setSystemId(String systemId) {
            this.systemId = systemId;
            return this.getThis();
        }

        public ResetKeysTypes getResetKeysTypes() {
            return this.resetKeysTypes;
        }

        public Payload setResetKeysTypes(ResetKeysTypes resetKeysTypes) {
            this.resetKeysTypes = resetKeysTypes;
            return this.getThis();
        }
    }
}

