/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.common.task.TaskService;
import Gbt.utility.redfish.options.TaskServiceApiOptions;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class TaskServiceApi
extends RedfishApiService<Payload> {
    protected TaskServiceApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.TASKSERVICE.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(TaskServiceApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case MODIFY: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                return this.uploadFileValidation(RedfishResourceTypes.TaskService);
            }
            case LIST: {
                return true;
            }
            case GET: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setTaskId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case LIST: {
                return true;
            }
            case MODIFY: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.TaskService);
                }
                if (((Payload)this.servicePayload).isServiceEnabled() != null) {
                    TaskService taskService = new TaskService();
                    taskService.setServiceEnabled(((Payload)this.servicePayload).isServiceEnabled());
                    return this.uploadDataValidation(RedfishResourceTypes.TaskService, taskService);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case GET: {
                if (((Payload)this.servicePayload).getTaskId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        switch ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case MODIFY: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setServiceURI(((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setHeaders("If-Match", etag)).setContentType("application/json")).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp2 = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp2);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp2.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp2.toString());
                    boolean bl = !desResp2.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case LIST: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    if (desResp.isRedfishErrorResponse()) {
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean desResp2 = false;
                        return desResp2;
                    }
                    this.responseData.add(desResp);
                    List<String> tasks = desResp.getMembersOdataId();
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Task List : ");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(tasks));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case GET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).getTaskId()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((TaskServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, TaskServiceApiOptions> {
        private String taskId;
        private Boolean serviceEnabled;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(TaskServiceApiOptions.UNKNOWN);
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(TaskServiceApiOptions.UNKNOWN);
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public TaskServiceApi build() {
            return new TaskServiceApi(this);
        }

        public String getTaskId() {
            return this.taskId;
        }

        public Payload setTaskId(String taskId) {
            this.taskId = taskId;
            return this.getThis();
        }

        public Boolean isServiceEnabled() {
            return this.serviceEnabled;
        }

        public Payload setServiceEnabled(Boolean serviceEnabled) {
            this.serviceEnabled = serviceEnabled;
            return this.getThis();
        }
    }
}

