/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.BIOSUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.Update.fwInfo.PldmUpdateFWInfo;
import Gbt.utility.Update.fwInfo.ScpUpdateFWInfo;
import Gbt.utility.rest.models.AMIRestSessionData;
import Gbt.utility.rest.models.common.RestErrorData;
import Gbt.utility.rest.models.update.HpmUpdateConfig;
import Gbt.utility.rest.models.update.HpmUpdateData;
import Gbt.utility.rest.models.update.HpmUpdateProgressResponse;
import Gbt.utility.rest.models.update.HpmUpdateResponse;
import Gbt.utility.rest.models.update.PldmFirmwareInfo;
import Gbt.utility.rest.models.update.PldmUpdateConfig;
import Gbt.utility.rest.models.update.PldmUpdateProgressResponse;
import Gbt.utility.rest.options.UpdateServiceOptions;
import Gbt.utility.rest.requests.SessionRequest;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class HpmUpdateService
extends RESTServices {
    public static final String SERVICE_NAME = "hpmupdate";
    private static final int MAX_RETRY_COUNT = 50;
    private static final int MAX_UPDATE_PROGRESS_COUNT = 5;
    private static final int MAX_UPDATE_PROGRESS_TIMEOUT = 30;
    private static final String UPDATE_MODE_URI = "/api/maintenance/hpm/updatemode";
    private static final String PRE_UPDATE_URI = "/api/maintenance/hpm/preparecomponents";
    private static final String UPLOAD_BIOS_URI = "/api/maintenance/hpm/biosfw/raw";
    private static final String UPLOAD_SCP_URI = "/api/maintenance/hpm/bootfw/raw";
    private static final String START_FLASH_URI = "/api/maintenance/hpm/flash";
    private static final String GET_UPDATE_PROGRESS_URI = "/api/maintenance/hpm/upgradestatus";
    private static final String VERIFY_IMAGE_URI = "/api/maintenance/hpm/verifyimage";
    private static final String GET_VERIFY_PROGRESS_URI = "/api/maintenance/hpm/verifyimagestatus";
    private static final String EXIT_UPDATE_MODE_URI = "/api/maintenance/hpm/exitupdatemode";
    private static final String KEEP_ALIVE_URI = "/api/maintenance/fwupdate_keepalived";
    private static final String UPLOAD_PLDM_URI = "/api/maintenance/pldm/pldmfw";
    private static final String GET_PLDM_FWINFO_URI = "/api/maintenance/pldm/getpldmfwinfo";
    private static final String DO_PLDM_UPDATE_URI = "/api/maintenance/pldm/fwupdatestatus";
    private static final String GET_PLDM_UPDATE_PROGRESS_STATUS_URI = "/api/maintenance/pldm/fwupdateprogress";
    private static final String UPD_BIOS_KEY = "hpmbios";
    private static final String UPD_SCP_KEY = "hpmbootfw";
    private static final String UPD_PLDM_KEY = "pldm";
    private CommonUpdateFWInfo updateFWInfo;
    private long dataLength = 0L;
    private long sectionFlash = 0L;
    private Client clientForLongTimeResp;

    public HpmUpdateService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        if (!(restServicesOptions instanceof UpdateServiceOptions)) {
            return false;
        }
        UpdateServiceOptions options = (UpdateServiceOptions)restServicesOptions;
        switch (options) {
            case BIOS: {
                if (!(jsonData instanceof BIOSUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(BIOSUpdateFWInfo.class);
                return true;
            }
            case SCP: {
                if (!(jsonData instanceof ScpUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(ScpUpdateFWInfo.class);
                return true;
            }
            case EROT: 
            case VBIOS: {
                if (!(jsonData instanceof PldmUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(PldmUpdateFWInfo.class);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        int componentId;
        String logName = ipAddress + "_" + this.getServiceName() + "_" + restServicesOptions.getOptionName();
        Response response = null;
        HpmUpdateResponse hpmUpdateResponse = null;
        if (this.updateFWInfo != null && this.updateFWInfo.isPldmCase().booleanValue()) {
            componentId = 16;
        } else {
            int n = componentId = this.updateFWInfo.getUpdateType() == UpdateType.BIOS ? 2 : 7;
        }
        if (!this.calculateLengthAndSection(this.updateFWInfo.getImagePath(), ipAddress, logName)) {
            return false;
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Starting HPM update mode.");
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(UPDATE_MODE_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(this.updateFWInfo.isPldmCase() != false ? "{}" : new HpmUpdateData().setImageUpdate(1 + this.updateFWInfo.getUpdateType().getHpmCode()))).setCookies(this.sessionData)).setContentType("application/json")).build();
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            hpmUpdateResponse = this.clientReceiver.deserialize(response, HpmUpdateResponse.class);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, hpmUpdateResponse.toString());
            this.jsonResults.add(hpmUpdateResponse);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] HPM update mode has started.");
            Thread.sleep(2000L);
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Stating HPM update mode fail!");
            this.restExceptionMessages(re, ipAddress, logName);
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Upgrade firmware fail."));
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt FW update process.");
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt FW update process."));
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        HpmUpdateConfig hpmPreUpdateConfig = new HpmUpdateConfig().setFwUpdateId(hpmUpdateResponse.getUniqueId()).setComponentId(componentId).setComponentDataLength(this.dataLength).setIdimageUpdate(1).setIsMmc(0);
        HpmUpdateConfig hpmExitConfig = new HpmUpdateConfig().setFwUpdateId(hpmUpdateResponse.getUniqueId());
        if (!this.hpmPreUpdate(ipAddress, hpmPreUpdateConfig, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        if (this.updateFWInfo.isPldmCase().booleanValue()) {
            return this.updatePldmCase(ipAddress, hpmUpdateResponse.getUniqueId(), hpmExitConfig, logName);
        }
        if (!this.hpmUploadBiosFirmware(ipAddress, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        HpmUpdateConfig hpmUpdateConfig = new HpmUpdateConfig().setFwUpdateId(hpmUpdateResponse.getUniqueId()).setComponentId(componentId).setComponentDataLength(this.dataLength).setIdimageUpdate(1).setSectionFlash(this.sectionFlash);
        if (!this.hpmStartFlash(ipAddress, hpmUpdateConfig, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        if (!this.waitProgressComplete(ipAddress, GET_UPDATE_PROGRESS_URI, "Flash", componentId, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        HpmUpdateConfig hpmVerifyConfig = new HpmUpdateConfig().setFwUpdateId(hpmUpdateResponse.getUniqueId()).setComponentId(componentId).setComponentDataLength(this.dataLength);
        if (!this.hpmStartVerify(ipAddress, hpmVerifyConfig, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        if (!this.waitProgressComplete(ipAddress, GET_VERIFY_PROGRESS_URI, "Verify", componentId, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        return this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openSession(String ipAddress, String username, String password, boolean debug) {
        String logName = ipAddress + "_" + this.getServiceName() + "_" + this.updateFWInfo.getUpdateType().toString();
        this.username = username;
        this.password = password;
        this.client = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, debug);
        this.clientForLongTimeResp = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, 20000, 300000, debug);
        if (this.client == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        if (this.clientForLongTimeResp == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        SessionRequest request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/x-www-form-urlencoded")).setFormData("username", username)).setFormData("password", password)).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Open session success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeSession(String ipAddress) {
        String logName = ipAddress + "_" + this.getServiceName() + "_" + this.updateFWInfo.getUpdateType().toString();
        SessionRequest request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/x-www-form-urlencoded")).setCookies(this.sessionData)).build();
        Response response = null;
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Close session success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Close session fail.");
            if (response != null) {
                this.restExceptionMessages(re, ipAddress, logName);
            }
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Close session fail."));
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (this.client != null) {
                this.sessionData = null;
                this.client.close();
            }
            if (this.clientForLongTimeResp != null) {
                this.clientForLongTimeResp.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hpmPreUpdate(String ipAddress, HpmUpdateConfig preUpdateConfig, String logName) {
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(PRE_UPDATE_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(preUpdateConfig)).setCookies(this.sessionData)).setContentType("application/json")).build();
        Future<Response> responseFuture = this.clientReceiver.asyncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
        while (!responseFuture.isDone() && !responseFuture.isCancelled()) {
            try {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for preparing components.......");
                Thread.sleep(6000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt prepare components.");
                this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt prepare components."));
                return false;
            }
        }
        try (Response response = null;){
            response = responseFuture.get();
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Prepare components success.");
            Thread.sleep(2000L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hpmUploadBiosFirmware(String ipAddress, String logName) {
        int retry = 0;
        String url = "";
        String key = "";
        if (this.updateFWInfo.isPldmCase().booleanValue()) {
            url = UPLOAD_PLDM_URI;
            key = UPD_PLDM_KEY;
        } else if (this.updateFWInfo.getUpdateType() == UpdateType.BIOS) {
            url = UPLOAD_BIOS_URI;
            key = UPD_BIOS_KEY;
        } else {
            url = UPLOAD_SCP_URI;
            key = UPD_SCP_KEY;
        }
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(url).setHttpMethods(RESTHttpMethods.POST)).setFormData(key, new File(this.updateFWInfo.getImagePath()))).setHeaders("Expect:", "")).setCookies(this.sessionData)).setContentType("multipart/form-data")).build();
        Future<Response> responseFuture = this.clientReceiver.asyncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
        while (!responseFuture.isDone() && !responseFuture.isCancelled()) {
            try {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for uploading " + (Object)((Object)this.updateFWInfo.getUpdateType()) + " firmware.......");
                Thread.sleep(6000L);
                if (retry % 3 != 0) continue;
                this.keepUpdateProgressAlive(ipAddress, logName);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt upload " + (Object)((Object)this.updateFWInfo.getUpdateType()) + " firmware.");
                this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt upload " + (Object)((Object)this.updateFWInfo.getUpdateType()) + " firmware."));
                boolean bl = false;
                return bl;
            }
            finally {
                ++retry;
            }
        }
        try (Response response = null;){
            response = responseFuture.get();
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload " + (Object)((Object)this.updateFWInfo.getUpdateType()) + " firmware success.");
            Thread.sleep(2000L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hpmStartFlash(String ipAddress, HpmUpdateConfig hpmUpdateConfig, String logName) {
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(START_FLASH_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(hpmUpdateConfig)).setCookies(this.sessionData)).setContentType("application/json")).build();
        Future<Response> responseFuture = this.clientReceiver.asyncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
        while (!responseFuture.isDone() && !responseFuture.isCancelled()) {
            try {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for starting flash.......");
                Thread.sleep(6000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt starting flash firmware.");
                this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt starting flash."));
                return false;
            }
        }
        try (Response response = null;){
            response = responseFuture.get();
            if (response.getStatus() == 500) {
                RestErrorData errData = this.clientReceiver.deserialize(response, RestErrorData.class);
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, errData.toString());
                this.jsonResults.add(errData);
                boolean bl = false;
                return bl;
            }
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Starting flash success.");
            Thread.sleep(2000L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitProgressComplete(String ipAddress, String url, String action, int componentId, String logName) {
        boolean progressResult;
        block13: {
            progressResult = true;
            Response response = null;
            int retry = 0;
            RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(url + "?COMPONENT_ID=" + componentId).setHttpMethods(RESTHttpMethods.GET)).setCookies(this.sessionData)).setContentType("application/json")).build();
            do {
                try {
                    Thread.sleep(3000L);
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    HpmUpdateProgressResponse progressData = this.clientReceiver.deserialize(response, HpmUpdateProgressResponse.class);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] " + action + " Progress : " + progressData.getProgress() + "%");
                    if (progressData.getProgress() == 100) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] " + action + " is success.");
                        progressResult = true;
                        Thread.sleep(3000L);
                        break block13;
                    }
                    if (progressData.getProgress() == -1) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] " + action + " is fail! Progress: " + progressData.getProgress() + "%");
                        progressResult = false;
                        Thread.sleep(3000L);
                        break block13;
                    }
                    retry = 0;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get " + action + " progress fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    ++retry;
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt get upgrade progress.");
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt get " + action + " progress."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
                if (retry < 5) continue;
                progressResult = false;
                break block13;
            } while (!this.isOverTime(30));
            progressResult = false;
        }
        return progressResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hpmStartVerify(String ipAddress, HpmUpdateConfig hpmVerifyConfig, String logName) {
        Response response = null;
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Starting HPM verify firmware.");
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(VERIFY_IMAGE_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(hpmVerifyConfig)).setCookies(this.sessionData)).setContentType("application/json")).build();
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            if (response.getStatus() == 500) {
                RestErrorData errData = this.clientReceiver.deserialize(response, RestErrorData.class);
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, errData.toString());
                this.jsonResults.add(errData);
                boolean bl = false;
                return bl;
            }
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] HPM verify firmware has started.");
            Thread.sleep(2000L);
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Stating HPM verify firmware fail!");
            this.restExceptionMessages(re, ipAddress, logName);
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Start HPM verify firmware fail."));
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt HPM verify firmware process.");
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt HPM verify firmware process."));
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exitUpdateMode(String ipAddress, HpmUpdateConfig hpmExitConfig, String logName) {
        Response response = null;
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Exit HPM update mode.");
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(EXIT_UPDATE_MODE_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(hpmExitConfig)).setCookies(this.sessionData)).setContentType("application/json")).build();
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Exit HPM update mode success.");
            Thread.sleep(2000L);
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Exit HPM update mode fail!");
            this.restExceptionMessages(re, ipAddress, logName);
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Exit HPM update mode fail."));
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt Exit HPM update mode process.");
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt Exit HPM update mode process."));
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return true;
    }

    private boolean calculateLengthAndSection(String imagePath, String ipAddress, String logName) {
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Calculate HPM image data length and section flash.");
        FileInputStream is = null;
        DataInputStream dis = null;
        try {
            byte[] dataLengthByteArray = new byte[4];
            byte[] sectionFlashByteArray = new byte[4];
            is = new FileInputStream(imagePath);
            dis = new DataInputStream(is);
            int length = dis.available();
            byte[] buf = new byte[length];
            dis.readFully(buf);
            ((InputStream)is).close();
            dis.close();
            System.arraycopy(buf, 65, dataLengthByteArray, 0, dataLengthByteArray.length);
            System.arraycopy(buf, 73, sectionFlashByteArray, 0, sectionFlashByteArray.length);
            this.dataLength = TypeConverter.littleEndianByteArrayToInt(dataLengthByteArray);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Calculate HPM image data length :" + this.dataLength);
            this.sectionFlash = TypeConverter.littleEndianByteArrayToInt(sectionFlashByteArray);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Calculate HPM image section flash :" + this.sectionFlash);
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Calculate HPM image data length fail!", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keepUpdateProgressAlive(String ipAddress, String logName) {
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(KEEP_ALIVE_URI).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Keep update progress alive success.");
            Thread.sleep(2000L);
            boolean bl = true;
            return bl;
        }
    }

    private boolean updatePldmCase(String ipAddress, Long uniqueId, HpmUpdateConfig hpmExitConfig, String logName) {
        if (!this.hpmUploadBiosFirmware(ipAddress, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        List<PldmFirmwareInfo> pldmFirmwareInfoList = this.getPldmFirmwareInfo(ipAddress, uniqueId, logName);
        if (pldmFirmwareInfoList == null) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        if (!this.startPldmFirmwareUpdate(ipAddress, pldmFirmwareInfoList, uniqueId, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        if (!this.waitPldmUpdateProgressComplete(ipAddress, pldmFirmwareInfoList, logName)) {
            this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
            return false;
        }
        return this.exitUpdateMode(ipAddress, hpmExitConfig, logName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PldmFirmwareInfo> getPldmFirmwareInfo(String ipAddress, long uniqueId, String logName) {
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI("/api/maintenance/pldm/getpldmfwinfo?FIRMWARE_ID=" + uniqueId).setHttpMethods(RESTHttpMethods.GET)).setCookies(this.sessionData)).setContentType("application/json")).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            List<PldmFirmwareInfo> fwInfoList = this.clientReceiver.deserialize(response, new GenericType<List<PldmFirmwareInfo>>(){});
            if (!fwInfoList.isEmpty()) {
                for (PldmFirmwareInfo info : fwInfoList) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Get FW EID:" + info.getFw_eid());
                }
                List<PldmFirmwareInfo> list = fwInfoList;
                return list;
            }
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] PLDM firmware info is empty!");
            List<PldmFirmwareInfo> list = null;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startPldmFirmwareUpdate(String ipAddress, List<PldmFirmwareInfo> fwInfoList, long uniqueId, String logName) {
        Response response = null;
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Starting PLDM firmware update.");
        PldmUpdateConfig pldmUpdateConfig = new PldmUpdateConfig();
        pldmUpdateConfig.setFwUpdateId(uniqueId).autoSetFw_eid(fwInfoList);
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DO_PLDM_UPDATE_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(pldmUpdateConfig)).setCookies(this.sessionData)).setContentType("application/json")).build();
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] PLDM update firmware progress has started.");
            Thread.sleep(2000L);
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Stating PLDM firmware update fail!");
            this.restExceptionMessages(re, ipAddress, logName);
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Start HPM verify firmware fail."));
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt PLDM firmware update process.");
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt PLDM firmware update process."));
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return true;
    }

    private boolean waitPldmUpdateProgressComplete(String ipAddress, List<PldmFirmwareInfo> fwInfoList, String logName) {
        boolean allComplete;
        boolean progressResult = true;
        int retry = 0;
        do {
            allComplete = true;
            for (PldmFirmwareInfo fwInfo : fwInfoList) {
                if (fwInfo.getUpdateStatus() != null) continue;
                allComplete = false;
                PldmUpdateProgressResponse response = this.getPldmEidUpdateProgress(ipAddress, fwInfo, logName);
                if (response != null) {
                    if (response.getUpdate_status() != null && response.getUpdate_status() != 0) {
                        fwInfo.setUpdateStatus(response.getUpdate_status() == 1);
                    }
                    retry = 0;
                } else {
                    ++retry;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
            if (retry >= 5) {
                progressResult = false;
                break;
            }
            if (!this.isOverTime(30)) continue;
            progressResult = false;
            break;
        } while (!allComplete);
        if (!progressResult) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Update progress timeout!");
            return false;
        }
        for (PldmFirmwareInfo fwInfo : fwInfoList) {
            if (!fwInfo.getUpdateStatus().booleanValue()) {
                progressResult = false;
            }
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] EID: " + fwInfo.getFw_eid() + " update result: " + (fwInfo.getUpdateStatus() != false ? "Success" : "Fail"));
        }
        return progressResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PldmUpdateProgressResponse getPldmEidUpdateProgress(String ipAddress, PldmFirmwareInfo fwInfo, String logName) {
        PldmUpdateProgressResponse progressData = null;
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI("/api/maintenance/pldm/fwupdateprogress?FW_EID=" + fwInfo.getFw_eid()).setHttpMethods(RESTHttpMethods.GET)).setCookies(this.sessionData)).setContentType("application/json")).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            progressData = this.clientReceiver.deserialize(response, PldmUpdateProgressResponse.class);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] EID:" + fwInfo.getFw_eid() + " - Update Status: " + progressData.getUpdate_status() + ", Update State:" + progressData.getUpdate_state() + ", Progress: " + progressData.getProgress() + ", Activation Method: " + progressData.getActivation_method());
        }
        return progressData;
    }
}

