/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rmc;

import com.fasterxml.jackson.annotation.JsonValue;

public enum RMCRole {
    UNKNOWN(-1, "unknown"),
    RMC_M(1, "RMC_M"),
    RMC_S(2, "RMC_S"),
    CB_5U(3, "CB_5U"),
    CB_8U(4, "CB_8U"),
    CMC(-128, "CMC");

    private static final byte UNKNOWN_CODE = -1;
    private static final byte RMC_M_CODE = 1;
    private static final byte RMC_S_CODE = 2;
    private static final byte CB_5U_CODE = 3;
    private static final byte CB_8U_CODE = 4;
    private static final byte CMC_CODE = -128;
    private static final String UNKNOWN_ITEM = "unknown";
    private static final String RMC_M_ITEM = "RMC_M";
    private static final String RMC_S_ITEM = "RMC_S";
    private static final String CB_5U_ITEM = "CB_5U";
    private static final String CB_8U_ITEM = "CB_8U";
    private static final String CMC_ITEM = "CMC";
    private final byte code;
    private final String item;

    private RMCRole(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public byte getTypeCode() {
        return this.code;
    }

    public static final RMCRole parse(String RMCRoleType) {
        switch (RMCRoleType.toUpperCase()) {
            case "RMC_M": {
                return RMC_M;
            }
            case "RMC_S": {
                return RMC_S;
            }
            case "CB_5U": {
                return CB_5U;
            }
            case "CB_8U": {
                return CB_8U;
            }
            case "CMC": {
                return CMC;
            }
        }
        return UNKNOWN;
    }
}

