/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands;

public enum PrivilegeLevel {
    NoAccess(0),
    Callback(1),
    User(2),
    Operator(3),
    Administrator(4),
    OEM(5),
    MaximumAvailable(0);

    private static final byte AL_HIGHEST_AVAILABLE = 0;
    private static final byte AL_CALLBACK = 1;
    private static final byte AL_USER = 2;
    private static final byte AL_OPERATOR = 3;
    private static final byte AL_ADMINISTRATOR = 4;
    private static final byte AL_OEM = 5;
    private final byte code;

    private PrivilegeLevel(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static final PrivilegeLevel parseByByte(byte code) {
        switch (code) {
            case 0: {
                return MaximumAvailable;
            }
            case 1: {
                return Callback;
            }
            case 2: {
                return User;
            }
            case 3: {
                return Operator;
            }
            case 4: {
                return Administrator;
            }
            case 5: {
                return OEM;
            }
        }
        return NoAccess;
    }

    public static final PrivilegeLevel parseByRawString(String priv) {
        if (priv == null) {
            return NoAccess;
        }
        switch (priv) {
            case "callback": {
                return Callback;
            }
            case "user": {
                return User;
            }
            case "operator": {
                return Operator;
            }
            case "admin": {
                return Administrator;
            }
        }
        return NoAccess;
    }
}

