/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.session;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelCipherSuitesResponseData;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanMessage;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.coding.security.ConfidentialityNone;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class GetChannelCipherSuites
extends IpmiCommandCoder {
    private byte channelNumber;
    private byte index;

    public void setChannelNumber(int channelNumber) {
        if (channelNumber < 0 || channelNumber > 15 || channelNumber == 12 || channelNumber == 13) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        this.channelNumber = TypeConverter.intToByte(channelNumber);
    }

    public int getChannelNumber() {
        return TypeConverter.byteToInt(this.channelNumber);
    }

    public void setIndex(byte index) {
        if (index > 63 || index < 0) {
            throw new IllegalArgumentException("Index " + index + " invalid must be (00h-3Fh).");
        }
        this.index = index;
    }

    public byte getIndex() {
        return this.index;
    }

    public GetChannelCipherSuites() {
        super(IpmiVersion.V20, new CipherSuite(0, 0, 0, 0), AuthenticationType.RMCPPlus);
    }

    public GetChannelCipherSuites(byte channelNumber, byte index) {
        super(IpmiVersion.V20, new CipherSuite(0, 0, 0, 0), AuthenticationType.RMCPPlus);
        this.setChannelNumber(channelNumber);
        this.setIndex(index);
    }

    @Override
    public IpmiMessage encodePayload(int messageSequenceNumber, int sessionSequenceNumber, int sessionId) {
        Ipmiv20Message message = new Ipmiv20Message(new ConfidentialityNone());
        message.setAuthenticationType(this.getAuthenticationType());
        message.setSessionID(0);
        message.setPayloadEncrypted(false);
        message.setPayloadAuthenticated(false);
        message.setSessionSequenceNumber(0);
        message.setPayloadType(PayloadType.Ipmi);
        message.setPayload(this.preparePayload(messageSequenceNumber));
        return message;
    }

    @Override
    protected IpmiLanMessage preparePayload(int sequenceNumber) {
        byte[] requestData = new byte[]{this.channelNumber, 0, TypeConverter.intToByte(0x80 | this.getIndex())};
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), requestData, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public byte getCommandCode() {
        return 84;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ApplicationRequest;
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        GetChannelCipherSuitesResponseData data = new GetChannelCipherSuitesResponseData();
        byte[] raw = message.getPayload().getIpmiCommandData();
        data.setChannelNumber(raw[0]);
        if (raw.length > 1) {
            byte[] cssData = new byte[raw.length - 1];
            System.arraycopy(raw, 1, cssData, 0, cssData.length);
            data.setCipherSuiteData(cssData);
        } else if (raw.length == 1) {
            data.setCipherSuiteData(new byte[0]);
        }
        return data;
    }
}

