/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.hslf.record.EscherPlaceholder;
import org.apache.poi.hslf.record.HSLFEscherClientDataRecord;
import org.apache.poi.util.LittleEndian;

public class HSLFEscherRecordFactory
extends DefaultEscherRecordFactory {
    private static Class<?>[] escherRecordClasses = new Class[]{EscherPlaceholder.class, HSLFEscherClientDataRecord.class};
    private static Map<Short, Constructor<? extends EscherRecord>> recordsMap = HSLFEscherRecordFactory.recordsToMap((Class[])escherRecordClasses);

    public EscherRecord createRecord(byte[] data, int offset) {
        short options = LittleEndian.getShort((byte[])data, (int)offset);
        short recordId = LittleEndian.getShort((byte[])data, (int)(offset + 2));
        Constructor<? extends EscherRecord> recordConstructor = recordsMap.get(recordId);
        if (recordConstructor == null) {
            return super.createRecord(data, offset);
        }
        EscherRecord escherRecord = null;
        try {
            escherRecord = recordConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return super.createRecord(data, offset);
        }
        escherRecord.setRecordId(recordId);
        escherRecord.setOptions(options);
        if (escherRecord instanceof EscherContainerRecord) {
            ((EscherContainerRecord)escherRecord).fillFields(data, offset, (EscherRecordFactory)this);
        }
        return escherRecord;
    }
}

