/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.imageredir;

import com.ami.kvm.jviewer.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;

public class Image {
    public static final byte SUCCESS = 0;
    public static final byte SECTOR_RANGE_ERROR = -1;
    public static final byte WRONG_MEDIA = -2;
    public static final byte MEDIUM_CHANGE = -3;
    public static final byte MEDIA_ERROR = -4;
    public static final byte NO_MEDIA = -5;
    public static final byte INVALID_PARAMS = -6;
    public static final byte UNREADABLE_MEDIA = -7;
    public static final byte REMOVAL_PREVENTED = -8;
    public static final byte UNSUPPORTED_COMMAND = -9;
    public static final byte DEVICE_PATH_TOO_LONG = -10;
    public static final byte DEVICE_ERROR = -11;
    public static final byte DEVICE_ALREADY_OPEN = -12;
    public static final byte MEDIUM_GETTING_READY = -14;
    public static final byte MEDIA_IN_USE = -15;
    public static int MAX_DEVICE_PATH_SIZE = 256;
    protected String imageFilePath = null;
    protected RandomAccessFile imageFile = null;
    protected long totalSectors;
    protected long blockSize;
    protected ByteOrder byteOrder;
    protected boolean opened = false;
    protected boolean mediaChange = false;
    FileReader fileReader = null;

    public boolean openImage(File file, String string) {
        boolean bl = true;
        try {
            this.imageFile = new RandomAccessFile(file, string);
            this.imageFilePath = file.getPath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.out.println(fileNotFoundException);
            bl = false;
        }
        return bl;
    }

    public void closeImage() {
        try {
            this.imageFile.close();
            this.imageFile = null;
        }
        catch (IOException iOException) {
            this.imageFile = null;
            Debug.out.println(iOException);
        }
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public boolean setImageFilePath(String string) {
        boolean bl;
        if (string.length() < MAX_DEVICE_PATH_SIZE) {
            this.imageFilePath = string;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public RandomAccessFile getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(RandomAccessFile randomAccessFile) {
        this.imageFile = randomAccessFile;
    }

    public long getTotalSectors() {
        return this.totalSectors;
    }

    public void setTotalSectors(long l) {
        this.totalSectors = l;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long l) {
        this.blockSize = l;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean bl) {
        this.opened = bl;
    }

    public boolean isMediaChange() {
        return this.mediaChange;
    }

    public void setMediaChange(boolean bl) {
        this.mediaChange = bl;
    }
}

