/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.imageredir.cd;

import com.ami.kvm.imageredir.IUSBSCSIPacket;
import com.ami.kvm.imageredir.Image;
import com.ami.kvm.imageredir.SCSICommandPacket;
import com.ami.kvm.isocaching.ReadAheadCache;
import com.ami.kvm.jviewer.Debug;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CDImage
extends Image {
    public static final int CD_BLOCK_SIZE = 2048;
    private static final int ISO_PRIMARY_VOLUME_DESCRIPTOR_LBA = 16;
    private static final int UDF_DOMAIN_ID_LBA = 35;
    private static final int UDF_DOMAIN_ID_OFFSET = 217;
    private static final int ISO_ID_SIZE = 5;
    private static final int UDF_DOMAIN_ID_SIZE = 19;
    private static final String ISO_ID = "CD001";
    private static final String UDF_DOMAIN_ID = "*OSTA UDF Compliant";
    private static final int MSF_BIT = 2;
    public int dataLength = 0;
    public byte[] append = new byte[20];
    private final int DATA_LENGTH_INDEX = 57;
    private final int CURRENT_INDEX = 61;
    private final int OVERALL_STATUS_INDEX = 53;
    private final int SENSE_KEY_INDEX = 54;
    private final int SENSE_CODE_INDEX = 55;
    private final int SENSE_CODE_Q_INDEX = 56;
    private ReadAheadCache readAheadCache = null;
    private boolean firstTime = false;

    public CDImage(File file) {
        if (this.openImage(file, "r")) {
            if (this.validateISOImage() == 0) {
                this.setOpened(true);
                this.setFirstTime(true);
            } else {
                this.setOpened(false);
            }
        }
        this.mediaChange = true;
    }

    public int validateISOImage() {
        int n = 0;
        byte[] byArray = new byte[2048];
        byte[] byArray2 = new byte[5];
        byte[] byArray3 = new byte[19];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        String string = null;
        String string2 = null;
        this.blockSize = 2048L;
        try {
            this.imageFile.seek(32768L);
            n = this.imageFile.read(byArray);
            if (0 == n || -1 == n) {
                n = -7;
            }
            byteBuffer.position(1);
            byteBuffer.get(byArray2);
            string = new String(byArray2);
            if (!string.equals(ISO_ID)) {
                byteBuffer.clear();
                byteBuffer.rewind();
                this.imageFile.seek(71680L);
                n = this.imageFile.read(byArray);
                if (0 == n || -1 == n) {
                    n = -7;
                }
                byteBuffer.position(217);
                byteBuffer.get(byArray3);
                string2 = new String(byArray3);
                if (string2.equals(UDF_DOMAIN_ID)) {
                    n = 0;
                    return n;
                }
                n = -2;
            } else {
                n = 0;
            }
        }
        catch (IOException iOException) {
            n = -4;
            Debug.out.println(iOException);
        }
        return n;
    }

    public int readCapacity() {
        int n = 0;
        this.blockSize = 2048L;
        try {
            this.imageFile.seek(0L);
            long l = this.imageFile.length();
            this.imageFile.seek(l);
            this.totalSectors = l / 2048L;
        }
        catch (IOException iOException) {
            n = -4;
            Debug.out.println(iOException);
        }
        n = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readCDImage(long l, int n) {
        byte[] byArray = new byte[2048 * n];
        if (this.readAheadCache == null) {
            this.readAheadCache = new ReadAheadCache(this.imageFile);
            this.readAheadCache.startThread();
            this.readAheadCache.setName("ReadAheadCache");
        }
        Object object = this.readAheadCache.getReadSync();
        synchronized (object) {
            try {
                Object object2 = this.readAheadCache.getCacheSync();
                synchronized (object2) {
                    this.readAheadCache.setSectorRequest(l, n);
                    this.readAheadCache.getCacheSync().notifyAll();
                }
                this.readAheadCache.getReadSync().wait();
                byArray = this.readAheadCache.getSectorData();
            }
            catch (InterruptedException interruptedException) {
                Debug.out.println(interruptedException);
            }
            catch (Exception exception) {
                byArray = null;
                Debug.out.println(exception);
            }
        }
        if (byArray == null) {
            this.closeImage();
        }
        return byArray;
    }

    public int executeSCSICmd(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = 0;
        SCSICommandPacket sCSICommandPacket = null;
        byte[] byArray = null;
        long l = 0L;
        long l2 = 0L;
        short s = 0;
        IUSBSCSIPacket iUSBSCSIPacket = null;
        int n2 = Math.min(byteBuffer2.remaining(), byteBuffer.remaining());
        ByteBuffer byteBuffer3 = byteBuffer.duplicate();
        byteBuffer3.limit(byteBuffer3.position() + n2);
        byteBuffer2.put(byteBuffer3);
        iUSBSCSIPacket = new IUSBSCSIPacket(byteBuffer);
        sCSICommandPacket = iUSBSCSIPacket.getCommandPkt();
        switch (sCSICommandPacket.getOpCode()) {
            case 0: {
                if (this.isFirstTime()) {
                    this.setFirstTime(false);
                    n = -3;
                } else {
                    n = this.testUnitReady();
                }
                this.setDataLength(0);
                break;
            }
            case 37: {
                if (this.isFirstTime()) {
                    this.setFirstTime(false);
                    n = -3;
                    break;
                }
                n = this.readCapacity();
                byteBuffer2.put(57, (byte)8);
                byteBuffer2.limit(70);
                byteBuffer2.position(61);
                byteBuffer2.putInt(this.mac2blong((int)(this.totalSectors - 1L)));
                byteBuffer2.putInt(this.mac2blong((int)this.blockSize));
                this.setDataLength(8);
                break;
            }
            case 40: 
            case 168: {
                l = sCSICommandPacket.getLba();
                l2 = sCSICommandPacket.getOpCode() == 40 ? (int)iUSBSCSIPacket.getCommandPkt().getCmd10().getLength() : sCSICommandPacket.getCmd12().getLength32();
                if (l >= 0L) {
                    l = this.mac2blong(sCSICommandPacket.getLba());
                } else {
                    byte[] byArray2 = ByteBuffer.allocate(8).putLong(l).array();
                    byArray2[3] = 0;
                    byArray2[2] = 0;
                    byArray2[1] = 0;
                    byArray2[0] = 0;
                    byte by = byArray2[6];
                    byte by2 = byArray2[7];
                    byArray2[7] = byArray2[4];
                    byArray2[6] = byArray2[5];
                    byArray2[4] = by2;
                    byArray2[5] = by;
                    l = ByteBuffer.wrap(byArray2).getLong();
                }
                l2 = this.mac2bshort(sCSICommandPacket.getCmd10().getLength());
                byArray = this.readCDImage(l, (int)l2);
                byteBuffer2.putInt(57, byArray.length);
                this.setDataLength(byArray.length);
                break;
            }
            case 67: {
                n = this.readTOC(sCSICommandPacket);
                s = sCSICommandPacket.getCmd10().getLength();
                if (this.dataLength > s) {
                    this.dataLength = s;
                }
                byteBuffer2.put(57, (byte)this.getDataLength());
                break;
            }
            case 27: {
                n = 0;
                break;
            }
            default: {
                n = -9;
            }
        }
        this.setErrorStatus(n, byteBuffer2);
        if (iUSBSCSIPacket.getCommandPkt().getOpCode() == 40 || iUSBSCSIPacket.getCommandPkt().getOpCode() == 168) {
            byteBuffer2.position(61);
            byteBuffer2.limit(byteBuffer2.position() + byArray.length);
            byteBuffer2.put(byArray);
        } else if (iUSBSCSIPacket.getCommandPkt().getOpCode() == 67) {
            byteBuffer2.position(61);
            byteBuffer2.limit(byteBuffer2.position() + this.append.length);
            byteBuffer2.put(this.append);
        }
        return n;
    }

    private int testUnitReady() {
        int n = this.readCapacity();
        if (n != 0) {
            return n;
        }
        return 0;
    }

    private int readTOC(SCSICommandPacket sCSICommandPacket) {
        byte by = 4;
        byte[] byArray = new byte[20];
        byte by2 = 0;
        byte by3 = sCSICommandPacket.getCmd10().getReserved6();
        by2 = this.mac2bshort((char)sCSICommandPacket.getCmd10().getLength());
        if (by3 > 1 && by3 != 170) {
            return 0;
        }
        byArray[2] = 1;
        byArray[3] = 1;
        if (by3 <= 1) {
            byArray[by++] = 0;
            byArray[by++] = 20;
            byArray[by++] = 1;
            byArray[by++] = 0;
            if ((sCSICommandPacket.getLun() & 2) == 1) {
                byArray[by++] = 0;
                byArray[by++] = 0;
                byArray[by++] = 2;
                byArray[by++] = 0;
            } else {
                byArray[by++] = 0;
                byArray[by++] = 0;
                byArray[by++] = 0;
                byArray[by++] = 0;
            }
        }
        byArray[by++] = 0;
        byArray[by++] = 22;
        byArray[by++] = -86;
        byArray[by++] = 0;
        byArray[by++] = 0;
        byArray[by++] = (byte)((this.totalSectors + 150L) / 75L / 60L);
        byArray[by++] = (byte)((this.totalSectors + 150L) / 75L % 60L);
        byArray[by++] = (byte)((this.totalSectors + 150L) % 75L);
        if (by > by2) {
            by = by2;
        }
        byArray[0] = (byte)(by - 2 >> 8 & 0xFF);
        byArray[1] = (byte)(by - 2 & 0xFF);
        this.setDataLength(by);
        System.arraycopy(byArray, 0, this.append, 0, byArray.length);
        return 0;
    }

    private void setErrorStatus(int n, ByteBuffer byteBuffer) {
        switch (n) {
            case 0: {
                byteBuffer.put(53, (byte)0);
                byteBuffer.put(54, (byte)0);
                byteBuffer.put(55, (byte)0);
                byteBuffer.put(56, (byte)0);
                break;
            }
            case -1: {
                byteBuffer.put(53, (byte)1);
                byteBuffer.put(54, (byte)5);
                byteBuffer.put(55, (byte)33);
                byteBuffer.put(56, (byte)0);
                break;
            }
            case -2: {
                byteBuffer.put(53, (byte)0);
                byteBuffer.put(54, (byte)3);
                byteBuffer.put(55, (byte)48);
                byteBuffer.put(56, (byte)1);
                break;
            }
            case -3: {
                byteBuffer.put(53, (byte)1);
                byteBuffer.put(54, (byte)6);
                byteBuffer.put(55, (byte)40);
                byteBuffer.put(56, (byte)0);
                break;
            }
            case -4: {
                byteBuffer.put(53, (byte)1);
                byteBuffer.put(54, (byte)3);
                byteBuffer.put(55, (byte)17);
                byteBuffer.put(56, (byte)0);
                break;
            }
            case -5: {
                byteBuffer.put(53, (byte)1);
                byteBuffer.put(54, (byte)2);
                byteBuffer.put(55, (byte)58);
                byteBuffer.put(56, (byte)0);
                break;
            }
            case -6: {
                byteBuffer.put(53, (byte)1);
                byteBuffer.put(54, (byte)5);
                byteBuffer.put(55, (byte)38);
                byteBuffer.put(56, (byte)0);
                break;
            }
            case -7: {
                byteBuffer.put(53, (byte)1);
                byteBuffer.put(54, (byte)3);
                byteBuffer.put(55, (byte)48);
                byteBuffer.put(56, (byte)2);
                break;
            }
            case -8: {
                byteBuffer.put(53, (byte)1);
                byteBuffer.put(54, (byte)5);
                byteBuffer.put(55, (byte)83);
                byteBuffer.put(56, (byte)2);
                break;
            }
            default: {
                byteBuffer.put(53, (byte)1);
                byteBuffer.put(54, (byte)5);
                byteBuffer.put(55, (byte)32);
                byteBuffer.put(56, (byte)0);
            }
        }
    }

    public byte mac2bshort(char c) {
        return (byte)(c >> 8 | c << 8);
    }

    public short mac2bshort(int n) {
        return (short)((short)n >> 8 | (short)n << 8);
    }

    public int mac2blong(int n) {
        return n >> 24 | n << 24 | (n & 0xFF0000) >> 8 | (n & 0xFF00) << 8;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int n) {
        this.dataLength = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeImage() {
        block11: {
            try {
                Object object;
                if (this.imageFile != null) {
                    this.imageFile.close();
                    this.imageFile = null;
                }
                if (this.readAheadCache == null) break block11;
                if (this.readAheadCache.getRequestHandler() != null) {
                    this.readAheadCache.getRequestHandler().stopThread();
                    object = this.readAheadCache.getCacheLock();
                    synchronized (object) {
                        this.readAheadCache.getCacheLock().notifyAll();
                    }
                }
                if (this.readAheadCache.getCacheManager() != null) {
                    this.readAheadCache.getCacheManager().stopThread();
                    object = this.readAheadCache.getCacheSync();
                    synchronized (object) {
                        this.readAheadCache.getCacheSync().notifyAll();
                    }
                }
                this.readAheadCache.stopThread();
                this.readAheadCache = null;
            }
            catch (IOException iOException) {
                this.imageFile = null;
                Debug.out.println(iOException);
            }
        }
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean bl) {
        this.firstTime = bl;
    }
}

