/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.hid.USBKeyboardRep;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class JVStatusBar {
    private JPanel statusBar;
    private JLabel statusMsg;
    private JToggleButton numLockLED;
    private JToggleButton capsLockLED;
    private JToggleButton scrollLockLED;
    private JToggleButton leftAlt;
    private JToggleButton rightAlt;
    private JToggleButton leftCtrl;
    private JToggleButton rightCtrl;
    private static final String INIT_STATUS_MSG_STRING = LocaleStrings.getString("N_1_JVS");
    private static final String RESET_STATUS_MSG_STRING = "";
    public static String OTHER_MOUISE_MODE_MSG = "";
    public static final int STATUSBAR_HEIGHT = 25;
    private JPanel statusMsgPanel = new JPanel();
    public JPanel iconPanel;

    public JVStatusBar() {
        this.statusMsg = new JLabel();
        this.initStatusMessage();
        this.statusMsgPanel.add(this.statusMsg);
        this.leftAlt = new JToggleButton("LALT", null, false);
        this.rightAlt = new JToggleButton("RALT", null, false);
        this.leftCtrl = new JToggleButton("LCTRL", null, false);
        this.rightCtrl = new JToggleButton("RCTRL", null, false);
        this.iconPanel = new JPanel();
        this.numLockLED = new JToggleButton("Num", null, false);
        this.capsLockLED = new JToggleButton("Caps", null, false);
        this.scrollLockLED = new JToggleButton("Scroll", null, false);
        this.initKeyboardLED();
        this.iconPanel.add(this.leftAlt);
        this.iconPanel.add(this.leftCtrl);
        this.iconPanel.add(this.rightAlt);
        this.iconPanel.add(this.rightCtrl);
        this.iconPanel.add(this.numLockLED);
        this.iconPanel.add(this.capsLockLED);
        this.iconPanel.add(this.scrollLockLED);
        this.statusBar = new JPanel();
        this.statusBar.setSize(0, 25);
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.add((Component)this.statusMsgPanel, "West");
        this.statusBar.add(Box.createHorizontalGlue());
        this.statusBar.add((Component)this.iconPanel, "East");
    }

    private void initStatusMessage() {
        this.statusMsg.setText(INIT_STATUS_MSG_STRING);
        this.statusMsg.setFocusTraversalKeysEnabled(false);
    }

    public void setStatus(String string) {
        this.statusMsg.setText(string);
        this.statusMsg.setForeground(Color.BLACK);
    }

    public String getStatus() {
        return this.statusMsg.getText();
    }

    public void resetStatus() {
        this.statusMsg.setText(RESET_STATUS_MSG_STRING);
        if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() == USBMouseRep.OTHER_MOUSE_MODE) {
            this.statusMsg.setText(OTHER_MOUISE_MODE_MSG);
            this.statusMsg.setForeground(Color.BLUE);
        } else if (JViewerApp.getInstance().getZoomOption() == "FitToHostResolution" && !JViewerApp.getInstance().getJVMenu().getMenuEnable("FitToHostResolution").booleanValue()) {
            this.statusMsg.setText(LocaleStrings.getString("N_2_JVS"));
            this.statusMsg.setForeground(Color.BLUE);
        }
    }

    private void initKeyboardLED() {
        this.numLockLED.setFont(new Font("Aharoni", 1, 12));
        this.numLockLED.setForeground(Color.gray);
        this.numLockLED.setRequestFocusEnabled(false);
        this.numLockLED.setHorizontalTextPosition(0);
        this.numLockLED.setHorizontalAlignment(0);
        this.numLockLED.setMaximumSize(new Dimension(40, 15));
        this.numLockLED.setMinimumSize(new Dimension(40, 15));
        this.numLockLED.setCursor(new Cursor(12));
        this.numLockLED.setFocusTraversalKeysEnabled(false);
        this.numLockLED.setBorder(BorderFactory.createEtchedBorder(1));
        this.numLockLED.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JVStatusBar.this.sendLEDStatusFromStatusBar(144, 4, true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JVStatusBar.this.sendLEDStatusFromStatusBar(144, 4, false);
            }
        });
        this.capsLockLED.setFont(new Font("Aharoni", 1, 12));
        this.capsLockLED.setForeground(Color.gray);
        this.capsLockLED.setRequestFocusEnabled(false);
        this.capsLockLED.setHorizontalTextPosition(0);
        this.capsLockLED.setHorizontalAlignment(0);
        this.capsLockLED.setMaximumSize(new Dimension(40, 15));
        this.capsLockLED.setMinimumSize(new Dimension(40, 15));
        this.capsLockLED.setCursor(new Cursor(12));
        this.capsLockLED.setFocusTraversalKeysEnabled(false);
        this.capsLockLED.setBorder(BorderFactory.createEtchedBorder(1));
        this.capsLockLED.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JVStatusBar.this.sendLEDStatusFromStatusBar(20, 1, true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JVStatusBar.this.sendLEDStatusFromStatusBar(20, 1, false);
            }
        });
        this.scrollLockLED.setFont(new Font("Aharoni", 1, 12));
        this.scrollLockLED.setForeground(Color.gray);
        this.scrollLockLED.setRequestFocusEnabled(false);
        this.scrollLockLED.setHorizontalTextPosition(0);
        this.scrollLockLED.setHorizontalAlignment(0);
        this.scrollLockLED.setMaximumSize(new Dimension(40, 15));
        this.scrollLockLED.setMinimumSize(new Dimension(40, 15));
        this.scrollLockLED.setCursor(new Cursor(12));
        this.scrollLockLED.setFocusTraversalKeysEnabled(false);
        this.scrollLockLED.setBorder(BorderFactory.createEtchedBorder(1));
        this.scrollLockLED.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JVStatusBar.this.sendLEDStatusFromStatusBar(145, 1, true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JVStatusBar.this.sendLEDStatusFromStatusBar(145, 1, false);
            }
        });
        this.leftAlt.setFont(new Font("Aharoni", 1, 12));
        this.leftAlt.setForeground(Color.gray);
        this.leftAlt.setRequestFocusEnabled(false);
        this.leftAlt.setHorizontalTextPosition(0);
        this.leftAlt.setHorizontalAlignment(0);
        this.leftAlt.setMaximumSize(new Dimension(40, 15));
        this.leftAlt.setMinimumSize(new Dimension(40, 15));
        this.leftAlt.setCursor(new Cursor(12));
        this.leftAlt.setFocusTraversalKeysEnabled(false);
        this.leftAlt.setBorder(BorderFactory.createEtchedBorder(1));
        this.leftAlt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (JVStatusBar.this.leftAlt.isSelected()) {
                    JViewerApp.getInstance().OnKeyboardHoldLeftAltKey(true);
                } else {
                    JViewerApp.getInstance().OnKeyboardHoldLeftAltKey(false);
                }
            }
        });
        this.rightAlt.setFont(new Font("Aharoni", 1, 12));
        this.rightAlt.setForeground(Color.gray);
        this.rightAlt.setRequestFocusEnabled(false);
        this.rightAlt.setHorizontalTextPosition(0);
        this.rightAlt.setHorizontalAlignment(0);
        this.rightAlt.setMaximumSize(new Dimension(40, 15));
        this.rightAlt.setMinimumSize(new Dimension(40, 15));
        this.rightAlt.setCursor(new Cursor(12));
        this.rightAlt.setFocusTraversalKeysEnabled(false);
        this.rightAlt.setBorder(BorderFactory.createEtchedBorder(1));
        this.rightAlt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (JVStatusBar.this.rightAlt.isSelected()) {
                    JViewerApp.getInstance().OnKeyboardHoldRightAltKey(true);
                } else {
                    JViewerApp.getInstance().OnKeyboardHoldRightAltKey(false);
                }
            }
        });
        this.leftCtrl.setFont(new Font("Aharoni", 1, 12));
        this.leftCtrl.setForeground(Color.gray);
        this.leftCtrl.setRequestFocusEnabled(false);
        this.leftCtrl.setHorizontalTextPosition(0);
        this.leftCtrl.setHorizontalAlignment(0);
        this.leftCtrl.setMaximumSize(new Dimension(40, 15));
        this.leftCtrl.setMinimumSize(new Dimension(40, 15));
        this.leftCtrl.setCursor(new Cursor(12));
        this.leftCtrl.setFocusTraversalKeysEnabled(false);
        this.leftCtrl.setBorder(BorderFactory.createEtchedBorder(1));
        this.leftCtrl.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (JVStatusBar.this.leftCtrl.isSelected()) {
                    JViewerApp.getInstance().OnKeyboardHoldLeftCtrlKey(true);
                } else {
                    JViewerApp.getInstance().OnKeyboardHoldLeftCtrlKey(false);
                }
            }
        });
        this.rightCtrl.setFont(new Font("Aharoni", 1, 12));
        this.rightCtrl.setForeground(Color.gray);
        this.rightCtrl.setRequestFocusEnabled(false);
        this.rightCtrl.setHorizontalTextPosition(0);
        this.rightCtrl.setHorizontalAlignment(0);
        this.rightCtrl.setMaximumSize(new Dimension(40, 15));
        this.rightCtrl.setMinimumSize(new Dimension(40, 15));
        this.rightCtrl.setCursor(new Cursor(12));
        this.rightCtrl.setFocusTraversalKeysEnabled(false);
        this.rightCtrl.setBorder(BorderFactory.createEtchedBorder(1));
        this.rightCtrl.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (JVStatusBar.this.rightCtrl.isSelected()) {
                    JViewerApp.getInstance().OnKeyboardHoldRightCtrlKey(true);
                } else {
                    JViewerApp.getInstance().OnKeyboardHoldRightCtrlKey(false);
                }
            }
        });
    }

    private void sendLEDStatusFromStatusBar(int n, int n2, boolean bl) {
        KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(n, n2, bl);
        kVMClient.sendKMMessage(uSBKeyboardRep);
    }

    private void setLEDStatus(JToggleButton jToggleButton, boolean bl) {
        if (bl) {
            jToggleButton.setForeground(Color.red);
        } else {
            jToggleButton.setForeground(Color.gray);
        }
    }

    public void setKeyboardLEDStatus(byte by) {
        if ((by & 1) != 0) {
            this.setLEDStatus(this.numLockLED, true);
        } else {
            this.setLEDStatus(this.numLockLED, false);
        }
        if ((by & 2) != 0) {
            this.setLEDStatus(this.capsLockLED, true);
        } else {
            this.setLEDStatus(this.capsLockLED, false);
        }
        if ((by & 4) != 0) {
            this.setLEDStatus(this.scrollLockLED, true);
        } else {
            this.setLEDStatus(this.scrollLockLED, false);
        }
    }

    public JPanel getStatusBar() {
        return this.statusBar;
    }

    public JToggleButton getLeftAlt() {
        return this.leftAlt;
    }

    public JToggleButton getRightAlt() {
        return this.rightAlt;
    }

    public JToggleButton getLeftCtrl() {
        return this.leftCtrl;
    }

    public JToggleButton getRightCtrl() {
        return this.rightCtrl;
    }

    public void enableStatusBar(boolean bl) {
        this.leftAlt.setEnabled(bl);
        this.leftCtrl.setEnabled(bl);
        this.rightAlt.setEnabled(bl);
        this.rightCtrl.setEnabled(bl);
        this.numLockLED.setEnabled(bl);
        this.capsLockLED.setEnabled(bl);
        this.scrollLockLED.setEnabled(bl);
    }
}

