/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.ClientConfig;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.videorecord.URLProcessor;
import com.ami.vmedia.VMApp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class StandAloneConnectionDialog
extends JDialog
implements ActionListener,
ItemListener {
    private final int WIDTH = 410;
    private final int HEIGHT = 280;
    private final int SECURE_CONNECT = 1;
    private final int HTTPS_CONNECTION_SUCCESS = 0;
    private final int ADMIN_USER = 4;
    private final int OEM_PROPRIETARY_USER = 5;
    private final int KVM_VMEDIA = 0;
    private final int VMEDIA_APP = 1;
    private final int MANAGE_VIDEO = 2;
    private String hostIP = null;
    private String username = null;
    private String password = null;
    private String webSessionToken = null;
    private String csrfToken = null;
    private static String selectedLocale = "EN";
    private int secWebPort = 443;
    private JPanel textPanel;
    private JPanel btnPanel;
    private JPanel helpPanel;
    private JPanel progressPanel;
    private JPanel bottomPanel;
    private JTable videoTable;
    private JLabel ipLabel;
    private JLabel portLabel;
    private JLabel unameLabel;
    private JLabel passwdLabel;
    private JLabel localeLabel;
    private JLabel appTypeLabel;
    private JTextField ipText;
    private JTextField portText;
    private JTextField unameText;
    private JPasswordField passwdText;
    private JButton launchBtn;
    private JButton cancelBtn;
    private JComboBox localeList;
    private JComboBox appTypeList;
    private JLabel helpTextLabel;
    private DefaultTableModel model;
    private JRadioButton playVideoRBtn;
    private JRadioButton saveVideoRBtn;
    private ButtonGroup videoOption;
    private JProgressBar launchProgressBar;
    private URLProcessor urlProcessor;
    private Validator validator;
    private DialogKeyListener keyListener;
    private DialogWindowListener windowListener;
    private TextFieldFocusListener textFieldFocusListener;
    private boolean validate = true;
    private boolean firstCheck = true;
    private boolean webLogIn = false;
    private boolean buttonsEnabled = false;
    private String[][] videoFile;
    private int remotePathSupport = 0;
    private int appType = 0;

    public StandAloneConnectionDialog(JFrame jFrame, String string, int n, String string2, String string3) {
        super(jFrame, LocaleStrings.getString("S_1_SACD") + JViewer.getTitle(), false);
        this.username = string2;
        this.password = string3;
        this.hostIP = string;
        this.secWebPort = n;
        selectedLocale = JViewer.getLanguage();
        this.windowListener = new DialogWindowListener();
        this.addWindowListener(this.windowListener);
        this.constructDialog();
        this.enableDialog();
        if (JViewer.getArgLength() > 0 && !JViewer.isUnknownArgs() && JViewer.isStandAloneSupportedApps(JViewer.getLaunch())) {
            this.showDialog();
        }
    }

    private void constructDialog() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.keyListener = new DialogKeyListener();
        this.textFieldFocusListener = new TextFieldFocusListener();
        this.setBounds(new Rectangle((dimension.width - 410) / 2, (dimension.height - 280) / 2, 410, 280));
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        this.ipLabel = new JLabel(LocaleStrings.getString("S_2_SACD") + " : ");
        this.textPanel.add((Component)this.ipLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.gridy = 1;
        this.portLabel = new JLabel(LocaleStrings.getString("S_3_SACD") + " : ");
        this.textPanel.add((Component)this.portLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.unameLabel = new JLabel(LocaleStrings.getString("S_4_SACD") + " : ");
        this.textPanel.add((Component)this.unameLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.passwdLabel = new JLabel(LocaleStrings.getString("S_5_SACD") + " : ");
        this.textPanel.add((Component)this.passwdLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.localeLabel = new JLabel(LocaleStrings.getString("S_21_SACD") + " : ");
        this.textPanel.add((Component)this.localeLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.appTypeLabel = new JLabel(LocaleStrings.getString("S_34_SACD") + " : ");
        this.textPanel.add((Component)this.appTypeLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        this.ipText = new JTextField();
        if (this.hostIP == null) {
            this.ipText.setText("");
        } else {
            this.ipText.setText(this.hostIP);
        }
        this.ipText.addKeyListener(this.keyListener);
        this.ipText.addFocusListener(this.textFieldFocusListener);
        this.textPanel.add((Component)this.ipText, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.gridy = 1;
        this.portText = new JTextField();
        if (this.secWebPort < 0) {
            this.portText.setText("");
        } else {
            this.portText.setText(String.valueOf(this.secWebPort));
        }
        this.portText.addKeyListener(this.keyListener);
        this.portText.addFocusListener(this.textFieldFocusListener);
        this.textPanel.add((Component)this.portText, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.unameText = new JTextField();
        this.unameText.setText(this.username);
        this.unameText.addKeyListener(this.keyListener);
        this.unameText.addFocusListener(this.textFieldFocusListener);
        this.textPanel.add((Component)this.unameText, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.passwdText = new JPasswordField();
        this.passwdText.setText(this.password);
        this.passwdText.addKeyListener(this.keyListener);
        this.passwdText.addFocusListener(this.textFieldFocusListener);
        this.textPanel.add((Component)this.passwdText, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.localeList = new JComboBox<String>(JViewer.getSupportedLocales());
        Locale locale = new Locale(selectedLocale.toLowerCase());
        String string = locale.getDisplayLanguage(new Locale(selectedLocale));
        this.localeList.setSelectedItem(string + " - [" + selectedLocale + "]");
        this.localeList.setAutoscrolls(true);
        this.localeList.addItemListener(this);
        this.textPanel.add((Component)this.localeList, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.appTypeList = new JComboBox<String>(this.getStandAloneAppType());
        this.appTypeList.setSelectedIndex(0);
        this.appTypeList.setAutoscrolls(true);
        this.appTypeList.addItemListener(this);
        this.textPanel.add((Component)this.appTypeList, gridBagConstraints);
        this.getContentPane().add((Component)this.textPanel, "North");
        this.helpPanel = new JPanel();
        this.helpTextLabel = new JLabel(LocaleStrings.getString("S_40_SACD"));
        this.helpPanel.add(this.helpTextLabel);
        this.progressPanel = new JPanel();
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 15, 5, 10);
        gridBagConstraints.weightx = 0.0;
        this.launchBtn = new JButton(LocaleStrings.getString("S_6_SACD"));
        this.btnPanel.add((Component)this.launchBtn, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 5, 5, 10);
        gridBagConstraints.gridx = -1;
        this.cancelBtn = new JButton(LocaleStrings.getString("S_7_SACD"));
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.addKeyListener(this.keyListener);
        this.btnPanel.add((Component)this.cancelBtn, gridBagConstraints);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.bottomPanel.add((Component)this.helpPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        this.bottomPanel.add((Component)this.btnPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.setAlwaysOnTop(true);
        this.pack();
        JViewerApp.getOEMManager().getOEMStandAloneConnectionDialog().customizeDialogComponents(this.getContentPane());
    }

    private void clearDialog() {
        this.getContentPane().removeAll();
        this.textPanel.removeAll();
        this.textPanel.updateUI();
        this.getContentPane().add((Component)this.textPanel, "North");
        this.getContentPane().add(this.btnPanel);
    }

    private void constructTableDialog() {
        this.clearDialog();
        Object[] objectArray = new Object[]{LocaleStrings.getString("S_32_SACD"), LocaleStrings.getString("S_33_SACD")};
        this.model = new DefaultTableModel((Object[][])null, objectArray);
        this.videoTable = new JTable(this.model){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.textPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        JTableHeader jTableHeader = this.videoTable.getTableHeader();
        jTableHeader.setFont(new Font("Tahoma", 1, 12));
        this.videoTable.setCellEditor(null);
        this.videoTable.addKeyListener(this.keyListener);
        this.videoTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!StandAloneConnectionDialog.this.buttonsEnabled) {
                    StandAloneConnectionDialog.this.enableDialog();
                    StandAloneConnectionDialog.this.buttonsEnabled = true;
                }
            }
        });
        this.videoTable.setBackground(Color.white);
        JTableHeader jTableHeader2 = this.videoTable.getTableHeader();
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "", 1, 1);
        jTableHeader2.setBorder(titledBorder);
        this.videoTable.getTableHeader().setPreferredSize(new Dimension(50, 23));
        JScrollPane jScrollPane = new JScrollPane(this.videoTable);
        gridBagConstraints.gridy = 1;
        this.textPanel.add((Component)jScrollPane, gridBagConstraints);
        this.helpPanel.removeAll();
        this.helpPanel.setLayout(new GridBagLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 10, 5, 10);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        this.videoOption = new ButtonGroup();
        this.playVideoRBtn = new JRadioButton(LocaleStrings.getString("S_30_SACD"));
        this.playVideoRBtn.setSelected(true);
        this.videoOption.add(this.playVideoRBtn);
        this.helpPanel.add((Component)this.playVideoRBtn, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        this.saveVideoRBtn = new JRadioButton(LocaleStrings.getString("S_31_SACD"));
        this.videoOption.add(this.saveVideoRBtn);
        this.helpPanel.add((Component)this.saveVideoRBtn, gridBagConstraints2);
        this.helpPanel.revalidate();
        this.helpPanel.repaint();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        this.textPanel.add((Component)this.helpPanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.textPanel.add((Component)this.btnPanel, gridBagConstraints);
        this.launchBtn.setText(LocaleStrings.getString("A_3_GLOBAL"));
        this.textPanel.updateUI();
        this.getContentPane().add(this.textPanel);
        this.setTitle(LocaleStrings.getString("S_29_SACD"));
    }

    private void showDialog() {
        this.disableDialog();
        this.validate = true;
        this.validator = new Validator();
        this.validator.start();
        this.setVisible(true);
    }

    private JDialog getDialog() {
        return this;
    }

    public JProgressBar getProgressBar() {
        return this.launchProgressBar;
    }

    private void enableDialog() {
        if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
            this.setDialogTitle(LocaleStrings.getString("S_1_SACD"));
        }
        this.ipText.setEditable(true);
        this.portText.setEditable(true);
        this.unameText.setEditable(true);
        this.passwdText.setEditable(true);
        this.launchBtn.setEnabled(true);
        this.launchBtn.addActionListener(this);
        this.launchBtn.addKeyListener(this.keyListener);
        String string = JViewer.getLaunch();
        if (JViewer.isStandAloneSupportedApps(string) && this.firstCheck) {
            if (string.compareToIgnoreCase("JViewer") == 0) {
                this.appTypeList.setSelectedIndex(0);
                JViewer.setApptype("StandAlone");
            } else if (string.compareToIgnoreCase("VMApp") == 0) {
                this.appTypeList.setSelectedIndex(1);
                JViewer.setApptype("VMApp");
            } else if (string.compareToIgnoreCase("SaveVideo") == 0) {
                this.appTypeList.setSelectedIndex(2);
                JViewer.setApptype("SaveVideo");
            } else if (string.compareToIgnoreCase("PlayVideo") == 0) {
                this.appTypeList.setSelectedIndex(2);
                JViewer.setApptype("PlayVideo");
            }
            this.appTypeList.setEnabled(false);
        } else if (!JViewer.isStandAloneSupportedApps(string)) {
            this.appTypeList.setEnabled(true);
        }
        if (!JViewer.isDefaultLang() && this.firstCheck) {
            this.localeList.setEnabled(false);
        } else if (JViewer.isDefaultLang()) {
            this.localeList.setEnabled(true);
        }
        this.showProgress(false);
        this.setVisible(true);
    }

    private void disableDialog() {
        this.setDialogTitle(LocaleStrings.getString("S_8_SACD"));
        this.launchBtn.requestFocus();
        this.ipText.setEditable(false);
        this.portText.setEditable(false);
        this.unameText.setEditable(false);
        this.passwdText.setEditable(false);
        this.launchBtn.setEnabled(false);
        this.launchBtn.removeActionListener(this);
        this.launchBtn.removeKeyListener(this.keyListener);
        this.localeList.setEnabled(false);
        this.appTypeList.setEnabled(false);
        this.showProgress(true);
    }

    private void showProgress(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        if (bl) {
            this.helpTextLabel.setText("");
            this.bottomPanel.remove(this.helpPanel);
            this.progressPanel.removeAll();
            this.progressPanel.setLayout(new GridBagLayout());
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            gridBagConstraints.ipady = 5;
            this.launchProgressBar = new JProgressBar();
            this.progressPanel.add((Component)this.launchProgressBar, gridBagConstraints);
            this.launchProgressBar.setString(LocaleStrings.getString("S_8_SACD"));
            this.launchProgressBar.setStringPainted(true);
            this.launchProgressBar.setIndeterminate(true);
            gridBagConstraints.insets = new Insets(10, 10, 5, 10);
            gridBagConstraints.ipady = 0;
            this.bottomPanel.add((Component)this.progressPanel, gridBagConstraints);
        } else {
            this.bottomPanel.remove(this.progressPanel);
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                gridBagConstraints.insets = new Insets(5, 10, 5, 10);
                this.helpTextLabel.setText(LocaleStrings.getString("S_40_SACD"));
                this.bottomPanel.add((Component)this.helpPanel, gridBagConstraints);
            } else {
                this.helpTextLabel.setText("");
            }
            this.repaint();
        }
    }

    private int getWebSessionToken() {
        int n = -1;
        this.urlProcessor = new URLProcessor(null, 1);
        this.urlProcessor.setHostIP(this.hostIP);
        n = this.urlProcessor.processRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/rpc/WEBSES/create.asp?WEBVAR_USERNAME=" + this.username + "&WEBVAR_PASSWORD=" + this.password);
        try {
            if (n == -6) {
                this.validate = false;
                this.enableDialog();
                this.ipText.setText(JViewer.getIp());
                this.unameText.setText(null);
                this.passwdText.setText(null);
                JOptionPane.showMessageDialog(this.getDialog(), LocaleStrings.getString("S_10_SACD"), JViewer.getTitle() + LocaleStrings.getString("S_9_SACD"), 0);
                this.unameText.requestFocus();
            } else if (n == 0) {
                this.getProgressBar().setString(LocaleStrings.getString("S_44_SACD"));
                this.webSessionToken = this.urlProcessor.getValue("'SESSION_COOKIE' : '", ',');
                this.webSessionToken.trim();
                this.webSessionToken = this.webSessionToken.substring(0, this.webSessionToken.lastIndexOf(39));
                JViewer.setWebSessionToken(this.webSessionToken);
                JViewer.setPassword(this.password);
            } else if (n == -1) {
                this.showProgress(false);
                JOptionPane.showMessageDialog(this.getDialog(), LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                this.windowListener.windowClosing(null);
            } else if (n == -7) {
                this.windowListener.windowClosing(null);
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            this.showProgress(false);
            JOptionPane.showMessageDialog(this.getDialog(), LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
            this.windowListener.windowClosing(null);
        }
        return n;
    }

    private int getKVMPrivilege() {
        int n = 0;
        this.urlProcessor = new URLProcessor(this.webSessionToken, 1);
        int n2 = this.urlProcessor.processRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/rpc/getrole.asp");
        try {
            if (n2 == 0) {
                this.getProgressBar().setString(LocaleStrings.getString("S_45_SACD"));
                n = Integer.parseInt(this.urlProcessor.getValue("'EXTENDED_PRIV' : ", ' '));
            } else if (n2 == -7) {
                this.windowListener.windowClosing(null);
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n = -1;
        }
        JViewer.setKVMPrivilege(n);
        if (JViewer.isStandAloneApp()) {
            if (!JViewer.isKVMEnabled()) {
                this.resetDialogAndShowMessage(LocaleStrings.getString("S_12_SACD") + this.username + LocaleStrings.getString("S_13_SACD"));
                n2 = -1;
            }
        } else if (JViewer.isVMApp() && !JViewer.isVMediaEnabled()) {
            this.resetDialogAndShowMessage(LocaleStrings.getString("S_12_SACD") + this.username + LocaleStrings.getString("S_43_SACD"));
            n2 = -1;
        }
        return n2;
    }

    private void getAdviserSessionToken() {
        String string = null;
        this.urlProcessor = new URLProcessor(this.webSessionToken, 1);
        int n = this.urlProcessor.processRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/rpc/getsessiontoken.asp");
        try {
            if (n == 0) {
                this.getProgressBar().setString(LocaleStrings.getString("S_49_SACD"));
                string = this.urlProcessor.getValue("'SESSION_TOKEN' : '", ',');
                string.trim();
                string = string.substring(0, string.lastIndexOf(39));
                JViewer.setSessionCookies(string);
            } else if (n == -1) {
                this.showProgress(false);
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                this.windowListener.windowClosing(null);
            } else if (n == -7) {
                this.windowListener.windowClosing(null);
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            this.showProgress(false);
            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
            this.windowListener.windowClosing(null);
        }
    }

    private void getAdviserConfig() {
        block31: {
            int n = 3;
            int n2 = 15;
            long l = 0L;
            byte by = 0;
            String string = "AD";
            this.urlProcessor = new URLProcessor(this.webSessionToken, 1);
            try {
                int n3 = this.urlProcessor.processRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/rpc/getadvisercfg.asp");
                if (n3 == 0) {
                    this.getProgressBar().setString(LocaleStrings.getString("S_46_SACD"));
                    int n4 = Integer.parseInt(this.urlProcessor.getValue("'V_STR_KVM_STATUS' : ", ','));
                    if (n4 == 0) {
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_14_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        this.windowListener.windowClosing(null);
                    }
                    int n5 = Integer.parseInt(this.urlProcessor.getValue("'V_STR_SECURE_CHANNEL' : ", ','));
                    JViewer.setSecureChannel(n5);
                    int n6 = Integer.parseInt(this.urlProcessor.getValue("'V_STR_KVM_PORT' : ", ','));
                    int n7 = Integer.parseInt(this.urlProcessor.getValue("'V_STR_WEB_PORT' : ", ','));
                    if (JViewer.isSinglePortEnabled()) {
                        JViewer.setKVMPort(n7);
                        JViewer.setUseSSL(true);
                    } else {
                        JViewer.setKVMPort(n6);
                        if (n5 == 0) {
                            JViewer.setUseSSL(false);
                        } else if (n5 == 1) {
                            JViewer.setUseSSL(true);
                        }
                    }
                    try {
                        l = Long.parseLong(this.urlProcessor.getValue("'V_STR_OEM_FEATURE_STATUS' : ", ' '));
                        JViewer.setOEMFeatureStatus(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Debug.out.println(numberFormatException);
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_36_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        l = 0L;
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_36_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        l = 0L;
                    }
                    if ((JViewer.getOEMFeatureStatus() & 0x20L) == 32L) {
                        JViewer.setKVMReconnectEnabled(true);
                        try {
                            n = Integer.parseInt(this.urlProcessor.getValue("'V_STR_RETRY_COUNT' : ", ','));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_40_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        }
                        catch (Exception exception) {
                            Debug.out.println(exception);
                            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_40_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        }
                        JViewer.setRetryCount(n);
                        try {
                            n2 = Integer.parseInt(this.urlProcessor.getValue("'V_STR_RETRY_INTERVAL' : ", ','));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_39_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        }
                        catch (Exception exception) {
                            Debug.out.println(exception);
                            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_39_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        }
                        JViewer.setRetryInterval(n2);
                    }
                    try {
                        by = Byte.parseByte(this.urlProcessor.getValue("'V_STR_KVM_LICENSE_STATUS' : ", ','));
                        JViewer.setKVMLicenseStatus(by);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Debug.out.print(numberFormatException);
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_37_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        JViewer.setKVMLicenseStatus((byte)0);
                    }
                    catch (Exception exception) {
                        Debug.out.print(exception);
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_37_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        JViewer.setKVMLicenseStatus((byte)0);
                    }
                    try {
                        string = this.urlProcessor.getValue("'V_STR_KEYBOARD_LAYOUT' : ", ',');
                        if (string.startsWith("'") && string.endsWith("'")) {
                            try {
                                int n8 = string.indexOf(39) + 1;
                                int n9 = string.lastIndexOf(39);
                                string = string.substring(n8, n9);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                Debug.out.println(indexOutOfBoundsException);
                                string = "AD";
                            }
                            catch (Exception exception) {
                                Debug.out.println(exception);
                                string = "AD";
                            }
                        }
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                        string = "AD";
                    }
                    JViewer.setKeyboardLayout(string);
                    JViewer.setKVM_Num_CD(JViewer.getKVM_Num_CD());
                    JViewer.setKVM_Num_HD(JViewer.getKVM_Num_HD());
                    break block31;
                }
                if (n3 == -1) {
                    JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_15_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                    this.windowListener.windowClosing(null);
                } else if (n3 == -7) {
                    this.windowListener.windowClosing(null);
                }
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_15_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                this.windowListener.windowClosing(null);
            }
        }
    }

    private String[][] findVideoData(String string) {
        String string2 = null;
        String string3 = null;
        if (JViewer.isRestService()) {
            string2 = "\"file\": \"";
            string3 = "\"fileinfo\": \"";
        } else {
            string2 = "'FILE_NAME' : '";
            string3 = "'FILE_INFO' : '";
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        int n6 = -1;
        int n7 = this.getOccurances(string, string2);
        if (n7 > 0) {
            this.videoFile = new String[n7][n5];
            String string4 = string;
            for (int i = 0; i < n7; ++i) {
                String string5 = null;
                String string6 = null;
                string6 = string2;
                string5 = string4 = string4.substring(n2);
                n = string5.indexOf(string2);
                string5 = string5.substring(n);
                n3 = n2 = string5.indexOf("}");
                if (n > 0 && n2 > 0) {
                    string5 = string5.substring(0, n2);
                    for (n4 = 0; n4 < n5; ++n4) {
                        if (string6 == null) {
                            string6 = string3;
                            string5 = string5.substring(string5.indexOf(string6));
                        }
                        if ((n2 = string5.indexOf("\",", string6.length())) < 0) {
                            n2 = string5.indexOf(92);
                        }
                        this.videoFile[i][n4] = string5.substring(string6.length(), n2).trim();
                        this.videoFile[i][n4].trim();
                        n6 = this.videoFile[i][n4].indexOf(92);
                        if (n6 >= 0) {
                            String string7;
                            this.videoFile[i][n4] = string7 = this.videoFile[i][n4].substring(0, n6) + this.videoFile[i][n4].substring(n6 + 1);
                        }
                        if (this.videoFile[i][n4].indexOf(39) > 0) {
                            this.videoFile[i][n4] = this.videoFile[i][n4].substring(0, this.videoFile[i][n4].indexOf(39));
                        }
                        if (string6.equalsIgnoreCase(string3)) {
                            n6 = this.videoFile[i][0].lastIndexOf(47);
                            n6 = n6 == -1 ? 0 : ++n6;
                            this.model.addRow(new Object[]{this.videoFile[i][0].substring(n6), this.videoFile[i][1]});
                        }
                        string6 = null;
                    }
                }
                n2 = n + n3 + 1;
            }
        } else {
            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_28_SACD"), LocaleStrings.getString("A_6_GLOBAL"), 1);
            this.windowListener.windowClosing(null);
        }
        return this.videoFile;
    }

    public int getOccurances(String string, String string2) {
        int n = 0;
        int n2 = 0;
        String string3 = new String(string);
        while ((n2 = string3.indexOf(string2, n2)) != -1) {
            ++n;
            n2 += string2.length();
        }
        return n;
    }

    private void getVideoInfo() {
        String string = null;
        int n = -1;
        this.constructTableDialog();
        this.urlProcessor = new URLProcessor(this.webSessionToken, 1);
        try {
            if (JViewer.isRestService()) {
                this.urlProcessor.setHostIP(this.hostIP);
                n = this.urlProcessor.restProcessRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/api/logs/video");
            } else {
                n = this.urlProcessor.processRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/rpc/getvideoinfo.asp");
            }
            if (n == 0) {
                string = new String(this.urlProcessor.getData());
                this.findVideoData(string);
                this.getContentPane().invalidate();
                this.getContentPane().validate();
            } else if (n == -1) {
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_25_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                this.windowListener.windowClosing(null);
            } else if (n == -7) {
                this.windowListener.windowClosing(null);
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_25_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
            this.windowListener.windowClosing(null);
        }
    }

    private void getVMediaConfig() {
        block15: {
            this.urlProcessor = new URLProcessor(this.webSessionToken, 1);
            int n = this.urlProcessor.processRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/rpc/getvmediacfg.asp");
            if (n == 0) {
                try {
                    this.getProgressBar().setString(LocaleStrings.getString("S_47_SACD"));
                    String string = this.urlProcessor.getValue("'V_SINGLE_PORT_ENABLED' : ", ',');
                    if (1 == Integer.parseInt(string)) {
                        JViewer.setSinglePortEnabled(true);
                    } else {
                        JViewer.setSinglePortEnabled(false);
                    }
                    string = this.urlProcessor.getValue("'V_MEDIA_LICENSE_STATUS' : ", ',');
                    JViewer.setMediaLicenseStatus((byte)Integer.parseInt(string));
                    if (!JViewer.isSinglePortEnabled()) {
                        string = this.urlProcessor.getValue("'V_STR_SECURE_CHANNEL' : ", ',');
                        int n2 = Integer.parseInt(string);
                        JViewer.setVMSecureChannel(n2);
                        if (n2 == 0) {
                            JViewer.setVMUseSSL(false);
                            string = this.urlProcessor.getValue("'V_STR_CD_PORT' : ", ',');
                            JViewer.setCdserver_port(Integer.parseInt(string));
                            string = this.urlProcessor.getValue("'V_STR_HD_PORT' : ", ',');
                            JViewer.setHdserver_port(Integer.parseInt(string));
                        } else if (n2 == 1) {
                            JViewer.setVMUseSSL(true);
                            string = this.urlProcessor.getValue("'V_STR_CD_SECURE_PORT' : ", ',');
                            JViewer.setCdserver_port(Integer.parseInt(string));
                            string = this.urlProcessor.getValue("'V_STR_HD_SECURE_PORT' : ", ',');
                            JViewer.setHdserver_port(Integer.parseInt(string));
                        }
                    }
                    string = this.urlProcessor.getValue("'V_NUM_CD' : ", ',');
                    JViewer.setNum_CD((byte)Integer.parseInt(string));
                    string = this.urlProcessor.getValue("'V_NUM_HD' : ", ',');
                    JViewer.setNum_HD((byte)Integer.parseInt(string));
                    string = this.urlProcessor.getValue("'V_CD_STATUS' : ", ',');
                    JViewer.setCD_State(Integer.parseInt(string));
                    string = this.urlProcessor.getValue("'V_HD_STATUS' : ", ',');
                    JViewer.setHD_State(Integer.parseInt(string));
                    string = this.urlProcessor.getValue("'V_KVM_NUM_CD' : ", ',');
                    JViewer.setKVM_Num_CD((byte)Integer.parseInt(string));
                    string = this.urlProcessor.getValue("'V_KVM_NUM_HD' : ", ',');
                    JViewer.setKVM_Num_HD((byte)Integer.parseInt(string));
                    string = this.urlProcessor.getValue("'V_POWER_SAVE_MODE' : ", ' ');
                    if (string != null) {
                        JViewer.setPowerSaveMode((byte)Integer.parseInt(string));
                        break block15;
                    }
                    Debug.out.println("V_POWER_SAVE_MODE not found in the response data");
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.out.println(numberFormatException);
                    JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_16_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                    this.windowListener.windowClosing(null);
                }
                catch (NullPointerException nullPointerException) {
                    Debug.out.println(nullPointerException);
                    JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_16_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                    this.windowListener.windowClosing(null);
                }
            } else if (n == -1) {
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_16_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                this.windowListener.windowClosing(null);
            } else if (n == -7) {
                this.windowListener.windowClosing(null);
            }
        }
    }

    public void logoutWebSession() {
        if (JViewer.getWebSessionToken() == null) {
            return;
        }
        if (JViewer.isKVMReconnectEnabled() && JViewerApp.getInstance().getRetryConnection()) {
            return;
        }
        if (!JViewer.isStandAloneApp() && !JViewer.isVMApp() && JViewerApp.getInstance().getVideorecordapp() != null) {
            JViewerApp.getInstance().getVideorecordapp().lockVideoFile(false);
        }
        if (this.webLogIn) {
            int n = -1;
            this.urlProcessor = new URLProcessor(JViewer.getWebSessionToken(), 1);
            n = JViewer.isRestService() ? this.urlProcessor.restProcessRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/api/session") : this.urlProcessor.processRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/rpc/WEBSES/logout.asp");
            if (n != 0) {
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_17_SACD"), LocaleStrings.getString("S_18_SACD"), 1);
            } else {
                this.webLogIn = false;
                URLProcessor.setCsrfToken(null);
                if (JViewerApp.getInstance().getM_webSession_token() != null) {
                    JViewerApp.getInstance().setM_webSession_token(null);
                }
            }
        }
        try {
            if (URLProcessor.getSocket() != null) {
                URLProcessor.getSocket().close();
                URLProcessor.setSocket(null);
            }
        }
        catch (IOException iOException) {
            Debug.out.println("Exception: while closing the socket : " + iOException);
        }
    }

    private void manageVideo() {
        int n = this.videoTable.getSelectedRowCount();
        int[] nArray = this.videoTable.getSelectedRows();
        String[] stringArray = new String[n];
        if (n > 0) {
            try {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = this.videoFile[nArray[i]][0];
                }
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            if (stringArray.length > 0) {
                JViewer.setVideoFile(stringArray);
                int n2 = this.checkFileAccess();
                if (n2 == -5) {
                    JOptionPane.showMessageDialog(this, LocaleStrings.getString("U_3_VR"), LocaleStrings.getString("A_6_GLOBAL"), 1);
                } else if (n2 == -2) {
                    JOptionPane.showMessageDialog(this, LocaleStrings.getString("Z_3_URLP"), LocaleStrings.getString("A_5_GLOBAL"), 0);
                } else {
                    this.setVisible(false);
                    this.dispose();
                    JViewerApp.getInstance().constructUI();
                    JViewer.recording();
                }
            } else {
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_34_SACD"), LocaleStrings.getString("S_26_SACD"), 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_34_SACD"), LocaleStrings.getString("S_26_SACD"), 1);
        }
    }

    private void selectAppType() {
        if (this.appType == 0) {
            JViewer.setApptype("StandAlone");
            this.onConnectBtn();
        } else if (this.appType == 1) {
            JViewer.setApptype("VMApp");
            this.onConnectBtn();
        } else if (this.appType == 2) {
            if (this.launchBtn.getText().equals(LocaleStrings.getString("A_3_GLOBAL"))) {
                if (this.playVideoRBtn.isSelected()) {
                    if (this.videoTable.getSelectedRowCount() == 1) {
                        JViewer.setApptype("PlayVideo");
                        this.manageVideo();
                    } else {
                        JOptionPane.showMessageDialog(JViewerApp.getInstance().getConnectionDialog(), LocaleStrings.getString("S_35_SACD"), LocaleStrings.getString("S_26_SACD"), 1);
                    }
                } else if (this.saveVideoRBtn.isSelected()) {
                    JViewer.setApptype("SaveVideo");
                    this.manageVideo();
                }
            } else {
                JViewer.setApptype("SaveVideo");
                this.onConnectBtn();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.launchBtn)) {
            this.selectAppType();
        } else if (actionEvent.getSource().equals(this.cancelBtn)) {
            this.onCancelBtn();
        }
    }

    private void onConnectBtn() {
        this.hostIP = this.ipText.getText();
        this.secWebPort = JViewer.getWebPortNumber(this.portText.getText());
        this.username = this.unameText.getText();
        this.password = " ";
        char[] cArray = this.passwdText.getPassword();
        for (int i = 0; i < cArray.length; ++i) {
            this.password = this.password + cArray[i];
            cArray[i] = '\u0000';
        }
        this.password = this.password.trim();
        this.showDialog();
    }

    private void onConnectionSuccess() {
        this.validate = false;
        this.showProgress(false);
        if (!JViewer.isplayerapp() && !JViewer.isdownloadapp()) {
            this.setVisible(false);
            this.dispose();
        }
        if (JViewer.isStandAloneApp()) {
            JViewerApp.getInstance().constructUI();
            JViewer.redirect();
        } else if (JViewer.isVMApp()) {
            VMApp.launchApp();
            this.logoutWebSession();
        }
    }

    private void onCancelBtn() {
        if (this.isWebLogIn()) {
            this.logoutWebSession();
        }
        this.dispose();
        this.windowListener.windowClosing(null);
    }

    private String getDialogTitle() {
        return this.getTitle().trim();
    }

    private void setDialogTitle(String string) {
        this.setTitle(string);
    }

    public DialogWindowListener getWindowListener() {
        return this.windowListener;
    }

    public static String replaceAllPattern(String string, String string2, String string3) {
        int n = 0;
        int n2 = 1;
        String string4 = "";
        for (int i = 0; i < n2; ++i) {
            if ((n = string.indexOf(string2, n)) < 0) continue;
            if (string.indexOf(string2, n += string2.length()) == n) {
                ++n2;
            }
            string4 = string4 + string2;
        }
        try {
            if (string4.length() <= 0) {
                return string;
            }
            string = string.replaceFirst(string4, string3);
        }
        catch (NullPointerException nullPointerException) {
            Debug.out.println("REPLACE ALL PATTERN : ");
            Debug.out.println(nullPointerException);
            return string;
        }
        return StandAloneConnectionDialog.replaceAllPattern(string, string2, string3);
    }

    public static boolean getWrapperLibrary(String string) {
        String string2 = null;
        if (JViewer.is64bit()) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                string2 = "lib/win64/";
            } else if (System.getProperty("os.name").startsWith("Linux")) {
                string2 = "lib/linux64/";
            } else if (System.getProperty("os.name").startsWith("Mac")) {
                string2 = "lib/mac64/";
            }
        }
        if (string != null) {
            File file;
            String string3 = null;
            string3 = JViewer.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if ((string3 = string3.substring(0, string3.lastIndexOf(47))).contains("%20")) {
                string3 = string3.replaceAll("%20", "\\ ");
            }
            String string4 = "Jar" + File.separator + JViewer.getIp() + File.separator + "lib";
            if (System.getProperty("os.name").startsWith("Windows") && string4.contains(":")) {
                string4 = StandAloneConnectionDialog.replaceAllPattern(string4, ":", "_");
            }
            if (!(file = new File(string4 = string3 + File.separator + string4)).exists()) {
                file.mkdirs();
            }
            File file2 = new File(file + File.separator + string);
            try {
                InputStream inputStream = JViewer.class.getResourceAsStream(string2 + string);
                if ((JViewerApp.getInstance().isLinuxClient() || JViewerApp.getInstance().isMacClient()) && !StandAloneConnectionDialog.isUnixFileClosed(file2)) {
                    inputStream.close();
                    return false;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while (inputStream.available() > 0) {
                    fileOutputStream.write(inputStream.read());
                }
                fileOutputStream.close();
                inputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Debug.out.println(fileNotFoundException);
                return false;
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                return false;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                return false;
            }
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.localeList) && itemEvent.getStateChange() == 2) {
            selectedLocale = (String)this.localeList.getSelectedItem();
            String string = " - [";
            int n = selectedLocale.indexOf(string) + string.length();
            int n2 = selectedLocale.indexOf("]");
            selectedLocale = selectedLocale.substring(n, n2);
            JViewer.setLanguage(selectedLocale);
            this.localeList.removeItemListener(this);
            this.onLanguageChange();
            this.localeList.addItemListener(this);
        }
        if (itemEvent.getSource().equals(this.appTypeList) && itemEvent.getStateChange() == 2) {
            this.appType = this.appTypeList.getSelectedIndex();
            if (this.appType == -1) {
                this.appType = 0;
            }
            if (this.appType == 0) {
                this.helpTextLabel.setText(LocaleStrings.getString("S_40_SACD"));
            }
            if (this.appType == 1) {
                this.helpTextLabel.setText(LocaleStrings.getString("S_41_SACD"));
            }
            if (this.appType == 2) {
                this.helpTextLabel.setText(LocaleStrings.getString("S_42_SACD"));
            }
            this.pack();
        }
    }

    private void onLanguageChange() {
        this.setTitle(LocaleStrings.getString("S_1_SACD"));
        this.ipLabel.setText(LocaleStrings.getString("S_2_SACD") + " : ");
        this.portLabel.setText(LocaleStrings.getString("S_3_SACD") + " : ");
        this.unameLabel.setText(LocaleStrings.getString("S_4_SACD") + " : ");
        this.passwdLabel.setText(LocaleStrings.getString("S_5_SACD") + " : ");
        this.localeLabel.setText(LocaleStrings.getString("S_21_SACD") + " : ");
        this.appTypeLabel.setText(LocaleStrings.getString("S_34_SACD") + " : ");
        this.launchBtn.setText(LocaleStrings.getString("S_6_SACD"));
        this.cancelBtn.setText(LocaleStrings.getString("S_7_SACD"));
        this.helpTextLabel.setText(LocaleStrings.getString("S_40_SACD"));
        String[] stringArray = JViewer.getSupportedLocales();
        int n = this.localeList.getSelectedIndex();
        this.localeList.removeAllItems();
        for (String string : stringArray) {
            this.localeList.addItem(string);
        }
        this.localeList.setSelectedIndex(n);
        String[] stringArray2 = this.getStandAloneAppType();
        int n2 = this.appTypeList.getSelectedIndex();
        this.appTypeList.removeAllItems();
        for (String string : stringArray2) {
            this.appTypeList.addItem(string);
        }
        this.appTypeList.setSelectedIndex(n2);
        this.pack();
    }

    public static String getSelectedLocale() {
        return selectedLocale;
    }

    public static void setSelectedLocale(String string) {
        selectedLocale = string;
    }

    public int getRemotePathSupport() {
        return this.remotePathSupport;
    }

    public void setRemotePathSupport(int n) {
        this.remotePathSupport = n;
    }

    public boolean isWebLogIn() {
        return this.webLogIn;
    }

    public void setWebLogIn(boolean bl) {
        this.webLogIn = bl;
    }

    public URLProcessor getUrlProcessor() {
        return this.urlProcessor;
    }

    private String[] getStandAloneAppType() {
        String[] stringArray = new String[]{LocaleStrings.getString("S_38_SACD"), LocaleStrings.getString("S_39_SACD"), LocaleStrings.getString("S_27_SACD")};
        return stringArray;
    }

    private void resetDialogAndShowMessage(String string) {
        this.validate = false;
        this.enableDialog();
        this.ipText.setText(JViewer.getIp());
        this.unameText.setText(null);
        this.passwdText.setText(null);
        JOptionPane.showMessageDialog(this.getDialog(), string, LocaleStrings.getString("S_9_SACD"), 0);
        this.unameText.requestFocus();
    }

    public int restGetCSRFToken() {
        this.urlProcessor = new URLProcessor(null, 1);
        this.urlProcessor.setHostIP(this.hostIP);
        int n = this.urlProcessor.restProcessRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/api/session?username=" + this.username + "&password=" + this.password);
        try {
            if (n == 0) {
                this.getProgressBar().setString(LocaleStrings.getString("S_48_SACD"));
                int n2 = -1;
                n2 = Integer.parseInt(this.urlProcessor.getValue("\"extendedpriv\": ", ','));
                JViewer.setKVMPrivilege(n2);
                this.webSessionToken = this.urlProcessor.getValue("Set-Cookie: ", ';');
                JViewer.setWebSessionToken(this.webSessionToken);
                this.csrfToken = this.urlProcessor.getValue("\"CSRFToken\": ", ' ');
                this.csrfToken.trim();
                URLProcessor.setCsrfToken(this.csrfToken.substring(1, this.csrfToken.length() - 1));
                JViewer.setPassword(this.password);
            } else if (n == -6) {
                this.validate = false;
                this.enableDialog();
                this.ipText.setText(JViewer.getIp());
                this.unameText.setText(null);
                this.passwdText.setText(null);
                JOptionPane.showMessageDialog(this.getDialog(), LocaleStrings.getString("S_10_SACD"), JViewer.getTitle() + LocaleStrings.getString("S_9_SACD"), 0);
                this.unameText.requestFocus();
            } else if (n == -7) {
                this.windowListener.windowClosing(null);
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            this.showProgress(false);
            JOptionPane.showMessageDialog(this.getDialog(), LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
            this.windowListener.windowClosing(null);
        }
        return n;
    }

    private void restGetVMediaConfig() {
        block18: {
            long l = 0L;
            this.urlProcessor = new URLProcessor(this.webSessionToken, 1);
            this.urlProcessor.setHostIP(this.hostIP);
            int n = this.urlProcessor.restProcessRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/api/settings/media/instance");
            if (n == 0) {
                try {
                    this.getProgressBar().setString(LocaleStrings.getString("S_47_SACD"));
                    String string = this.urlProcessor.getValue("\"single_port_enabled\": ", ',');
                    if (1 == Integer.parseInt(string)) {
                        JViewer.setSinglePortEnabled(true);
                    } else {
                        JViewer.setSinglePortEnabled(false);
                    }
                    string = this.urlProcessor.getValue("\"license\": ", ',');
                    JViewer.setMediaLicenseStatus((byte)Integer.parseInt(string));
                    if (!JViewer.isSinglePortEnabled()) {
                        string = this.urlProcessor.getValue("\"secure_channel\": ", ',');
                        int n2 = Integer.parseInt(string);
                        JViewer.setVMSecureChannel(n2);
                        if (n2 == 0) {
                            JViewer.setVMUseSSL(false);
                            string = this.urlProcessor.getValue("\"cd_port\": ", ',');
                            JViewer.setCdserver_port(Integer.parseInt(string));
                            string = this.urlProcessor.getValue("\"hd_port\": ", ',');
                            JViewer.setHdserver_port(Integer.parseInt(string));
                        } else if (n2 == 1) {
                            JViewer.setVMUseSSL(true);
                            string = this.urlProcessor.getValue("\"cd_secure_port\": ", ',');
                            JViewer.setCdserver_port(Integer.parseInt(string));
                            string = this.urlProcessor.getValue("\"hd_secure_port\": ", ',');
                            JViewer.setHdserver_port(Integer.parseInt(string));
                        }
                    }
                    try {
                        l = Long.parseLong(this.urlProcessor.getValue("\"oemFeature\": ", ' '));
                        JViewer.setOEMFeatureStatus(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Debug.out.println(numberFormatException);
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_36_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        l = 0L;
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_36_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        l = 0L;
                    }
                    string = this.urlProcessor.getValue("\"num_cd\": ", ',');
                    JViewer.setNum_CD((byte)Integer.parseInt(string));
                    string = this.urlProcessor.getValue("\"num_hd\": ", ',');
                    JViewer.setNum_HD((byte)Integer.parseInt(string));
                    string = this.urlProcessor.getValue("\"cd_status\": ", ',');
                    JViewer.setCD_State(Integer.parseInt(string));
                    string = this.urlProcessor.getValue("\"hd_status\": ", ',');
                    JViewer.setHD_State(Integer.parseInt(string));
                    string = this.urlProcessor.getValue("\"kvm_num_cd\": ", ',');
                    JViewer.setKVM_Num_CD((byte)Integer.parseInt(string));
                    string = this.urlProcessor.getValue("\"kvm_num_hd\": ", ',');
                    JViewer.setKVM_Num_HD((byte)Integer.parseInt(string));
                    string = this.urlProcessor.getValue("\"power_save_mode\": ", ',');
                    if (string != null) {
                        JViewer.setPowerSaveMode((byte)Integer.parseInt(string));
                        break block18;
                    }
                    Debug.out.println("power_save_mode not found in the response data");
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.out.println(numberFormatException);
                    JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_16_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                    this.windowListener.windowClosing(null);
                }
                catch (NullPointerException nullPointerException) {
                    Debug.out.println(nullPointerException);
                    JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_16_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                    this.windowListener.windowClosing(null);
                }
            } else if (n == -1) {
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_16_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                this.windowListener.windowClosing(null);
            } else if (n == -7) {
                this.windowListener.windowClosing(null);
            }
        }
    }

    private void restGetAdviserConfig() {
        block31: {
            int n = 3;
            int n2 = 15;
            byte by = 0;
            String string = "AD";
            this.urlProcessor = new URLProcessor(this.webSessionToken, 1);
            this.urlProcessor.setHostIP(this.hostIP);
            try {
                int n3 = this.urlProcessor.restProcessRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/api/settings/media/adviser");
                if (n3 == 0) {
                    this.getProgressBar().setString(LocaleStrings.getString("S_46_SACD"));
                    int n4 = Integer.parseInt(this.urlProcessor.getValue("\"status\": ", ','));
                    if (n4 == 0) {
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_14_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        this.windowListener.windowClosing(null);
                    }
                    int n5 = Integer.parseInt(this.urlProcessor.getValue("\"secure_channel\": ", ','));
                    JViewer.setSecureChannel(n5);
                    int n6 = Integer.parseInt(this.urlProcessor.getValue("\"kvm_port\": ", ','));
                    int n7 = Integer.parseInt(this.urlProcessor.getValue("\"web_port\": ", ','));
                    if (JViewer.isSinglePortEnabled()) {
                        JViewer.setKVMPort(n7);
                        if (JViewer.getWebSecure() == 0) {
                            JViewer.setUseSSL(false);
                        } else if (JViewer.getWebSecure() == 1) {
                            JViewer.setUseSSL(true);
                        }
                    } else {
                        JViewer.setKVMPort(n6);
                        if (n5 == 0) {
                            JViewer.setUseSSL(false);
                        } else if (n5 == 1) {
                            JViewer.setUseSSL(true);
                        }
                    }
                    if ((JViewer.getOEMFeatureStatus() & 0x20L) == 32L) {
                        JViewer.setKVMReconnectEnabled(true);
                        try {
                            n = Integer.parseInt(this.urlProcessor.getValue("\"retry_count\": ", ','));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_40_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        }
                        catch (Exception exception) {
                            Debug.out.println(exception);
                            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_40_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        }
                        JViewer.setRetryCount(n);
                        try {
                            n2 = Integer.parseInt(this.urlProcessor.getValue("\"retry_interval\": ", ','));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_39_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        }
                        catch (Exception exception) {
                            Debug.out.println(exception);
                            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_39_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        }
                        JViewer.setRetryInterval(n2);
                    }
                    try {
                        by = Byte.parseByte(this.urlProcessor.getValue("\"license\": ", ','));
                        JViewer.setKVMLicenseStatus(by);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Debug.out.print(numberFormatException);
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_37_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        JViewer.setKVMLicenseStatus((byte)0);
                    }
                    catch (Exception exception) {
                        Debug.out.print(exception);
                        JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_37_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                        JViewer.setKVMLicenseStatus((byte)0);
                    }
                    try {
                        string = this.urlProcessor.getValue("\"keyboard_layout\": ", ' ');
                        if (string.startsWith("\"") && string.endsWith("\"")) {
                            try {
                                int n8 = string.indexOf(34) + 1;
                                int n9 = string.lastIndexOf(34);
                                string = string.substring(n8, n9);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                Debug.out.println(indexOutOfBoundsException);
                                string = "AD";
                            }
                            catch (Exception exception) {
                                Debug.out.println(exception);
                                string = "AD";
                            }
                        }
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                        string = "AD";
                    }
                    JViewer.setKeyboardLayout(string);
                    JViewer.setKVM_Num_CD(JViewer.getKVM_Num_CD());
                    JViewer.setKVM_Num_HD(JViewer.getKVM_Num_HD());
                    break block31;
                }
                if (n3 == -1) {
                    JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_15_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                    this.windowListener.windowClosing(null);
                } else if (n3 == -7) {
                    this.windowListener.windowClosing(null);
                }
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_15_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                this.windowListener.windowClosing(null);
            }
        }
    }

    private void restGetAdviserSessionToken() {
        String string = null;
        this.urlProcessor = new URLProcessor(this.webSessionToken, 1);
        this.urlProcessor.setHostIP(this.hostIP);
        int n = this.urlProcessor.restProcessRequest(JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort + "/api/kvm/token");
        try {
            if (n == 0) {
                this.getProgressBar().setString(LocaleStrings.getString("S_49_SACD"));
                string = this.urlProcessor.getValue("\"token\": ", ',');
                JViewer.setSessionCookies(string.substring(1, string.length() - 1));
            } else if (n == -1) {
                this.showProgress(false);
                JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                this.windowListener.windowClosing(null);
            } else if (n == -7) {
                this.windowListener.windowClosing(null);
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            this.showProgress(false);
            JOptionPane.showMessageDialog(this, LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
            this.windowListener.windowClosing(null);
        }
    }

    public void setWebSessionToken(String string) {
        this.webSessionToken = string;
    }

    public static boolean isUnixFileClosed(File file) {
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            process = new ProcessBuilder("lsof", "|", "grep", file.getAbsolutePath()).start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains(file.getAbsolutePath())) continue;
                bufferedReader.close();
                process.destroy();
                return false;
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            return false;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
        }
        process.destroy();
        return true;
    }

    private int checkFileAccess() {
        int n = 1;
        int n2 = -2;
        String[] stringArray = JViewer.getVideoFile();
        String string = JViewer.getProtocol() + "://" + this.hostIP + ":" + this.secWebPort;
        if (stringArray[0] != null && stringArray[0].length() > 0) {
            URLProcessor uRLProcessor = new URLProcessor(JViewer.getWebSessionToken(), n);
            if (JViewer.isRestService()) {
                string = string + "/api/logs/video-log?file_name=" + stringArray[0] + "&file_access=" + 4;
                n2 = uRLProcessor.restProcessRequest(string);
            } else {
                string = string + "/rpc/downloadvideo.asp?FILE_NAME=" + stringArray[0] + "&FILE_ACCESS=" + 4;
                n2 = uRLProcessor.processRequest(string);
            }
        }
        return n2;
    }

    class Validator
    extends Thread {
        Validator() {
        }

        @Override
        public void run() {
            while (StandAloneConnectionDialog.this.validate) {
                String string = "";
                JTextField jTextField = null;
                if (StandAloneConnectionDialog.this.hostIP == null || StandAloneConnectionDialog.this.hostIP.length() == 0) {
                    string = string + "\n* " + LocaleStrings.getString("S_2_SACD");
                    jTextField = StandAloneConnectionDialog.this.ipText;
                } else if (JViewer.getServerIP(StandAloneConnectionDialog.this.hostIP) == null) {
                    string = string + "\n* " + LocaleStrings.getString("S_2_SACD");
                    StandAloneConnectionDialog.this.ipText.selectAll();
                    jTextField = StandAloneConnectionDialog.this.ipText;
                } else {
                    JViewer.setServerIP(JViewer.getServerIP(StandAloneConnectionDialog.this.hostIP));
                    StandAloneConnectionDialog.this.hostIP = JViewer.getIp();
                }
                if (StandAloneConnectionDialog.this.secWebPort < 0) {
                    string = string + "\n* " + LocaleStrings.getString("S_3_SACD");
                    StandAloneConnectionDialog.this.portText.setText("");
                    if (jTextField == null) {
                        jTextField = StandAloneConnectionDialog.this.portText;
                    }
                } else {
                    JViewer.setWebPort(StandAloneConnectionDialog.this.secWebPort);
                    JViewer.setWebSecure(1);
                }
                if (StandAloneConnectionDialog.this.username == null || StandAloneConnectionDialog.this.username.length() == 0) {
                    string = string + "\n* " + LocaleStrings.getString("S_4_SACD");
                    if (jTextField == null) {
                        jTextField = StandAloneConnectionDialog.this.unameText;
                    }
                } else {
                    JViewer.setUsername(StandAloneConnectionDialog.this.username);
                }
                if (string.length() != 0) {
                    StandAloneConnectionDialog.this.validate = false;
                    StandAloneConnectionDialog.this.firstCheck = false;
                    StandAloneConnectionDialog.this.enableDialog();
                    if (JViewer.getArgLength() > 0 || !StandAloneConnectionDialog.this.firstCheck) {
                        JOptionPane.showMessageDialog(StandAloneConnectionDialog.this.getDialog(), LocaleStrings.getString("S_19_SACD") + string, LocaleStrings.getString("S_9_SACD"), 1);
                    }
                    StandAloneConnectionDialog.this.firstCheck = false;
                    jTextField.requestFocus();
                    jTextField.selectAll();
                    return;
                }
                if (JViewer.isStandalone() || JViewer.isVMApp()) {
                    StandAloneConnectionDialog.this.getDialog().setAlwaysOnTop(false);
                    JViewer.setClientCfg(new ClientConfig());
                    StandAloneConnectionDialog.this.getDialog().setAlwaysOnTop(true);
                }
                JViewer.setWebSecure(1);
                int n = JViewerApp.getOEMManager().getOEMAuthentication().authenticate(StandAloneConnectionDialog.this.username, StandAloneConnectionDialog.this.password);
                if (n == 0) {
                    int n2 = StandAloneConnectionDialog.this.restGetCSRFToken();
                    if (n2 < 0) {
                        if (n2 == -6) {
                            StandAloneConnectionDialog.this.validate = false;
                            return;
                        }
                        JViewer.setRestService(false);
                        if (StandAloneConnectionDialog.this.getWebSessionToken() < 0) {
                            StandAloneConnectionDialog.this.validate = false;
                            return;
                        }
                        StandAloneConnectionDialog.this.webLogIn = true;
                        if (StandAloneConnectionDialog.this.getKVMPrivilege() < 0) {
                            StandAloneConnectionDialog.this.validate = false;
                            StandAloneConnectionDialog.this.logoutWebSession();
                            return;
                        }
                        StandAloneConnectionDialog.this.getVMediaConfig();
                        StandAloneConnectionDialog.this.getAdviserConfig();
                        StandAloneConnectionDialog.this.getAdviserSessionToken();
                    } else {
                        JViewer.setRestService(true);
                        StandAloneConnectionDialog.this.webLogIn = true;
                        if (JViewer.isStandAloneApp()) {
                            if (!JViewer.isKVMEnabled()) {
                                StandAloneConnectionDialog.this.resetDialogAndShowMessage(LocaleStrings.getString("S_12_SACD") + StandAloneConnectionDialog.this.username + LocaleStrings.getString("S_13_SACD"));
                                StandAloneConnectionDialog.this.validate = false;
                                StandAloneConnectionDialog.this.logoutWebSession();
                                return;
                            }
                        } else if (JViewer.isVMApp() && !JViewer.isVMediaEnabled()) {
                            StandAloneConnectionDialog.this.resetDialogAndShowMessage(LocaleStrings.getString("S_12_SACD") + StandAloneConnectionDialog.this.username + LocaleStrings.getString("S_43_SACD"));
                            StandAloneConnectionDialog.this.validate = false;
                            StandAloneConnectionDialog.this.logoutWebSession();
                            return;
                        }
                        StandAloneConnectionDialog.this.restGetVMediaConfig();
                        StandAloneConnectionDialog.this.restGetAdviserConfig();
                        StandAloneConnectionDialog.this.restGetAdviserSessionToken();
                    }
                    if (JViewer.isStandAloneApp()) {
                        if (JViewer.getKVMLicenseStatus() != 1) {
                            Debug.out.println("JVIEWER LICENSE STATUS : " + JViewer.getKVMLicenseStatus());
                            JOptionPane.showMessageDialog(StandAloneConnectionDialog.this.getDialog(), LocaleStrings.getString("1_6_JVIEWER"), LocaleStrings.getString("1_3_JVIEWER"), 0);
                            StandAloneConnectionDialog.this.windowListener.windowClosing(null);
                        }
                    } else if (JViewer.isVMApp()) {
                        if (JViewer.getMediaLicenseStatus() != 1) {
                            Debug.out.println("VMEDIA LICENSE STATUS : " + JViewer.getMediaLicenseStatus());
                            JOptionPane.showMessageDialog(StandAloneConnectionDialog.this.getDialog(), LocaleStrings.getString("1_7_JVIEWER"), LocaleStrings.getString("1_3_JVIEWER"), 0);
                            StandAloneConnectionDialog.this.windowListener.windowClosing(null);
                        }
                    } else {
                        StandAloneConnectionDialog.this.getVideoInfo();
                        String string2 = JViewer.getLaunch();
                        if (JViewer.isStandAloneSupportedApps(string2)) {
                            if (string2.compareToIgnoreCase("SaveVideo") == 0) {
                                StandAloneConnectionDialog.this.playVideoRBtn.setEnabled(false);
                                StandAloneConnectionDialog.this.saveVideoRBtn.setSelected(true);
                            } else if (string2.compareToIgnoreCase("PlayVideo") == 0) {
                                StandAloneConnectionDialog.this.playVideoRBtn.setSelected(true);
                                StandAloneConnectionDialog.this.saveVideoRBtn.setEnabled(false);
                            }
                        }
                    }
                    if (!JViewer.isSinglePortEnabled() && (JViewer.isStandAloneApp() || JViewer.isVMApp())) {
                        StandAloneConnectionDialog.this.logoutWebSession();
                    }
                    StandAloneConnectionDialog.this.onConnectionSuccess();
                    continue;
                }
                if (n == 1) {
                    StandAloneConnectionDialog.this.onConnectionSuccess();
                    continue;
                }
                StandAloneConnectionDialog.this.validate = false;
                return;
            }
        }
    }

    class TextFieldFocusListener
    extends FocusAdapter {
        TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource().toString().contains("JTextField") || focusEvent.getSource().toString().contains("JPasswordField")) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.selectAll();
            }
        }
    }

    class DialogWindowListener
    extends WindowAdapter {
        DialogWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (StandAloneConnectionDialog.this.webLogIn) {
                StandAloneConnectionDialog.this.logoutWebSession();
            }
            JViewer.exit(0);
        }
    }

    class DialogKeyListener
    extends KeyAdapter {
        DialogKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (keyEvent.getSource().equals(StandAloneConnectionDialog.this.cancelBtn)) {
                    StandAloneConnectionDialog.this.onCancelBtn();
                } else {
                    StandAloneConnectionDialog.this.selectAppType();
                }
            }
        }
    }

    public abstract class MyTableModel
    extends AbstractTableModel {
        public boolean isEditable() {
            return false;
        }
    }
}

