/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.SoftBevelBorder;

public class UserDefMacro
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JList jList = null;
    private JButton jAddButton = null;
    private JButton jDeleteButton = null;
    private JButton jCloseButton = null;
    private JDialog jAddDialog = null;
    private JLabel jAddLabel = null;
    private JTextArea jShowTextField = null;
    private JTextArea jUserInfo = null;
    private JButton jOKButton = null;
    private DefaultListModel model;
    private JScrollPane pane;
    private JButton jClearButton = null;
    private JButton jClearAllButton = null;
    private JButton jWindowsButton = null;
    private JButton jTabButton = null;
    private JButton jAltF4Button = null;
    private JButton jPrintScreen = null;
    private HashMap<String, String> macroMap;
    private HashMap<String, String> previousMap;
    private String code;
    private boolean addMacro = false;
    public static final int WIDTH = 615;
    public static final int HEIGHT = 355;

    private JScrollPane getJList() {
        if (this.jList == null) {
            this.model = new DefaultListModel();
            try {
                this.macroMap = JViewerApp.getInstance().getAddMacro().getMacroMap();
                if (this.macroMap != null) {
                    Set<Map.Entry<String, String>> set = this.macroMap.entrySet();
                    for (Map.Entry<String, String> entry : set) {
                        this.model.addElement(entry.getKey());
                    }
                    this.jList = new JList(this.model);
                    this.pane = new JScrollPane(this.jList);
                    this.jList.setBounds(new Rectangle(5, 5, 600, 270));
                    this.pane.setBounds(new Rectangle(5, 5, 600, 270));
                    this.jList.setVisible(true);
                    this.pane.setVisible(true);
                }
            }
            catch (NullPointerException nullPointerException) {
                Debug.out.println(nullPointerException);
            }
        }
        return this.pane;
    }

    private JButton getJAddButton() {
        if (this.jAddButton == null) {
            this.jAddButton = new JButton();
            this.jAddButton.setText(LocaleStrings.getString("T_2_UDM"));
            this.jAddButton.setSize(this.jAddButton.getPreferredSize());
            this.jAddButton.setVisible(true);
            this.jAddButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = UserDefMacro.this.model.size();
                    JViewerApp.getInstance().getAddMacro();
                    if (n < 20) {
                        UserDefMacro.this.getJAddDialog();
                        UserDefMacro.this.jShowTextField.setCaretPosition(0);
                        UserDefMacro.this.jShowTextField.setRequestFocusEnabled(true);
                        UserDefMacro.this.jShowTextField.requestFocus();
                    } else {
                        JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("T_3_UDM") + 20 + LocaleStrings.getString("T_4_UDM"), LocaleStrings.getString("T_1_UDM"), 1);
                    }
                }
            });
        }
        return this.jAddButton;
    }

    private JButton getJDeleteButton() {
        if (this.jDeleteButton == null) {
            this.jDeleteButton = new JButton();
            this.jDeleteButton.setText(LocaleStrings.getString("T_5_UDM"));
            this.jDeleteButton.setSize(this.jDeleteButton.getPreferredSize());
            this.jDeleteButton.setVisible(true);
            this.jDeleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int[] nArray = UserDefMacro.this.jList.getSelectedIndices();
                    String[] stringArray = new String[nArray.length];
                    for (n = 0; n < nArray.length; ++n) {
                        stringArray[n] = UserDefMacro.this.model.get(nArray[n]).toString();
                    }
                    for (n = 0; n < nArray.length; ++n) {
                        UserDefMacro.this.model.removeElement(stringArray[n]);
                        UserDefMacro.this.macroMap.remove(stringArray[n]);
                    }
                }
            });
        }
        return this.jDeleteButton;
    }

    private JButton getJCloseButton() {
        if (this.jCloseButton == null) {
            this.jCloseButton = new JButton();
            this.jCloseButton.setText(LocaleStrings.getString("T_6_UDM"));
            this.jCloseButton.setSize(this.jCloseButton.getPreferredSize());
            this.jCloseButton.setVisible(true);
            this.jCloseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserDefMacro.this.onCloseDialog();
                }
            });
        }
        return this.jCloseButton;
    }

    public void onCloseDialog() {
        JViewerApp.getInstance().getAddMacro().setMacroMap(this.macroMap);
        JViewerApp.getInstance().getAddMacro().parseKeycodeSendBMC();
        JViewerApp.getInstance().getAddMacro().removeMacroMenu();
        JViewerApp.getInstance().getAddMacro().removeToolbarMacro();
        JViewerApp.getInstance().getAddMacro().addMacroMenu(this.macroMap);
        JViewerApp.getInstance().getAddMacro().addToolbarMacro(this.macroMap);
        this.addMacro = false;
        this.dispose();
    }

    private JDialog getJAddDialog() {
        if (this.jAddDialog == null) {
            this.jAddDialog = new JDialog(this);
            this.jAddDialog.setSize(new Dimension(650, 260));
            this.jAddDialog.setTitle(LocaleStrings.getString("T_7_UDM"));
            this.jAddDialog.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 5, 5);
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            this.jAddDialog.getContentPane().add((Component)this.getUserInfoPanel(), gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 1;
            this.jAddDialog.getContentPane().add((Component)this.getMacroButtonPanle(), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.jAddDialog.getContentPane().add((Component)this.getMacroDispalyTextPanel(), gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 5, 2, 5);
            gridBagConstraints.gridy = 3;
            this.jAddDialog.getContentPane().add((Component)this.getControlButtonPanel(), gridBagConstraints);
            this.jAddDialog.setResizable(false);
            this.jAddDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    UserDefMacro.this.addMacro = false;
                    UserDefMacro.this.jShowTextField.setText("");
                    UserDefMacro.this.jAddDialog.dispose();
                }
            });
        }
        this.addMacro = true;
        this.jAddDialog.setVisible(true);
        this.jAddDialog.setLocation(JViewerApp.getInstance().getPopUpWindowPosition(650, 260));
        return this.jAddDialog;
    }

    private JPanel getUserInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jAddLabel = new JLabel();
        this.jAddLabel.setText(LocaleStrings.getString("T_9_UDM"));
        this.jAddLabel.setSize(this.jAddLabel.getPreferredSize());
        jPanel.add((Component)this.jAddLabel, gridBagConstraints);
        this.jUserInfo = new JTextArea();
        this.jUserInfo.setEditable(false);
        this.jUserInfo.setCursor(null);
        this.jUserInfo.setOpaque(false);
        this.jUserInfo.setFocusable(false);
        this.jUserInfo.setFont(new Font("Dialog", 1, 12));
        this.jUserInfo.setText(LocaleStrings.getString("T_8_UDM"));
        this.jUserInfo.setWrapStyleWord(true);
        this.jUserInfo.setSize(this.jUserInfo.getPreferredSize());
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.jUserInfo, gridBagConstraints);
        return jPanel;
    }

    private JPanel getMacroButtonPanle() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.getJWindowsButton(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.getJTabButton(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.getAltF4Button(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.getPrintScreen(), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getMacroDispalyTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.getJShowTextField(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getControlButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.getJClearButton(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.getJClearAllButton(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.getJOKButton(), gridBagConstraints);
        return jPanel;
    }

    private JTextArea getJShowTextField() {
        if (this.jShowTextField == null) {
            this.jShowTextField = new JTextArea();
            this.jShowTextField.enableInputMethods(false);
            this.jShowTextField.setEditable(false);
            this.jShowTextField.setBorder(new SoftBevelBorder(1));
            this.jShowTextField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 524 || keyEvent.getKeyCode() == 157 || keyEvent.getKeyCode() == 0) {
                        return;
                    }
                    UserDefMacro.this.displayHotkey(keyEvent.getKeyCode(), keyEvent.getKeyLocation());
                    keyEvent.consume();
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }
            });
        } else {
            this.jShowTextField.setText("");
        }
        return this.jShowTextField;
    }

    private JButton getJOKButton() {
        if (this.jOKButton == null) {
            this.jOKButton = new JButton();
            this.jOKButton.setText(LocaleStrings.getString("A_3_GLOBAL"));
            this.jOKButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = UserDefMacro.this.jShowTextField.getText();
                    if (UserDefMacro.this.model.size() < 20) {
                        for (int i = 0; i < UserDefMacro.this.model.size(); ++i) {
                            if (!UserDefMacro.this.model.elementAt(i).equals(string)) continue;
                            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("T_19_UDM"), LocaleStrings.getString("T_1_UDM"), 1);
                            UserDefMacro.this.jShowTextField.setText("");
                            UserDefMacro.this.jShowTextField.requestFocus();
                            UserDefMacro.this.code = "";
                            return;
                        }
                        if (string.length() > 0) {
                            UserDefMacro.this.macroMap.put(string, UserDefMacro.this.code);
                            UserDefMacro.this.model.addElement(string);
                        }
                        UserDefMacro.this.code = "";
                        UserDefMacro.this.jShowTextField.setText("");
                        UserDefMacro.this.jAddDialog.dispose();
                        UserDefMacro.this.jAddDialog = null;
                    } else {
                        JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("T_3_UDM") + 20 + LocaleStrings.getString("T_4_UDM"), LocaleStrings.getString("T_1_UDM"), 1);
                    }
                }
            });
        }
        return this.jOKButton;
    }

    private JButton getJClearButton() {
        if (this.jClearButton == null) {
            this.jClearButton = new JButton();
            this.jClearButton.setText(LocaleStrings.getString("T_10_UDM"));
            this.jClearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    String string = new String();
                    String string2 = UserDefMacro.this.jShowTextField.getText();
                    String[] stringArray = string2.split("[+]");
                    String[] stringArray2 = UserDefMacro.this.code.split("[+]");
                    String string3 = new String();
                    String string4 = new String();
                    if (stringArray.length != 0) {
                        for (n = 0; n < stringArray.length - 1; ++n) {
                            string3 = string3.concat(stringArray[n]);
                            string3 = string3.concat("+");
                        }
                        for (n = 0; n < stringArray2.length - 2; ++n) {
                            string4 = string4.concat(stringArray2[n]);
                            string4 = string4.concat("+");
                        }
                    } else {
                        string4 = "";
                        UserDefMacro.this.code = "";
                        string = "";
                    }
                    if (string3.length() > 1) {
                        n = string3.lastIndexOf(43);
                        int n2 = string4.lastIndexOf(43);
                        string = string3.substring(0, n);
                        UserDefMacro.this.code = string4.substring(0, n2);
                    } else {
                        UserDefMacro.this.code = "";
                    }
                    UserDefMacro.this.jShowTextField.setText(string);
                    UserDefMacro.this.jShowTextField.setCaretPosition(0);
                    UserDefMacro.this.jShowTextField.setRequestFocusEnabled(true);
                    UserDefMacro.this.jShowTextField.requestFocus();
                }
            });
        }
        return this.jClearButton;
    }

    private JButton getJClearAllButton() {
        if (this.jClearAllButton == null) {
            this.jClearAllButton = new JButton();
            this.jClearAllButton.setText(LocaleStrings.getString("T_11_UDM"));
            this.jClearAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserDefMacro.this.jShowTextField.setText("");
                    UserDefMacro.this.jShowTextField.requestFocus();
                    UserDefMacro.this.code = "";
                }
            });
        }
        return this.jClearAllButton;
    }

    private JButton getJWindowsButton() {
        if (this.jWindowsButton == null) {
            this.jWindowsButton = new JButton();
            this.jWindowsButton.setText("Windows");
            this.jWindowsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = UserDefMacro.this.jShowTextField.getText();
                    String string2 = Integer.toString(524);
                    if (string.length() == 0) {
                        UserDefMacro.this.code = UserDefMacro.this.code.concat(string2);
                        UserDefMacro.this.code = UserDefMacro.this.code.concat("+2");
                        string = string.concat("Windows(" + LocaleStrings.getString("T_12_UDM") + ")");
                    } else {
                        String[] stringArray = string.split("[+]");
                        int n = stringArray.length;
                        JViewerApp.getInstance().getAddMacro();
                        if (n < 6) {
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+" + string2);
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+2");
                            string = string.concat("+Windows(" + LocaleStrings.getString("T_12_UDM") + ")");
                        } else {
                            UserDefMacro.this.maxMacroLimitMessage();
                        }
                    }
                    UserDefMacro.this.jShowTextField.setText(string);
                    UserDefMacro.this.jShowTextField.requestFocus();
                }
            });
        }
        return this.jWindowsButton;
    }

    private JButton getJTabButton() {
        if (this.jTabButton == null) {
            this.jTabButton = new JButton();
            this.jTabButton.setText("Tab");
            this.jTabButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = UserDefMacro.this.jShowTextField.getText();
                    String string2 = Integer.toString(9);
                    if (string.length() == 0) {
                        string = string.concat("Tab");
                        UserDefMacro.this.code = UserDefMacro.this.code.concat(string2);
                        UserDefMacro.this.code = UserDefMacro.this.code.concat("+1");
                    } else {
                        String[] stringArray = string.split("[+]");
                        if (stringArray.length < 6) {
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+" + string2);
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+1");
                            string = string.concat("+Tab");
                        } else {
                            UserDefMacro.this.maxMacroLimitMessage();
                        }
                    }
                    UserDefMacro.this.jShowTextField.setText(string);
                    UserDefMacro.this.jShowTextField.requestFocus();
                }
            });
        }
        return this.jTabButton;
    }

    private JButton getAltF4Button() {
        if (this.jAltF4Button == null) {
            this.jAltF4Button = new JButton();
            this.jAltF4Button.setText("Alt+F4");
            this.jAltF4Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = UserDefMacro.this.jShowTextField.getText();
                    String string2 = Integer.toString(18);
                    if (string.length() == 0) {
                        string = string.concat("Alt(" + LocaleStrings.getString("T_12_UDM") + ")");
                        UserDefMacro.this.code = UserDefMacro.this.code.concat(string2);
                        UserDefMacro.this.code = UserDefMacro.this.code.concat("+2");
                        UserDefMacro.this.code = UserDefMacro.this.code.concat("+" + Integer.toString(115));
                        UserDefMacro.this.code = UserDefMacro.this.code.concat("+1");
                        string = string.concat("+F4");
                    } else {
                        String[] stringArray = string.split("[+]");
                        if (stringArray.length < 5) {
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+" + string2);
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+2");
                            string = string.concat("+Alt(" + LocaleStrings.getString("T_12_UDM") + ")");
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+" + Integer.toString(115));
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+1");
                            string = string.concat("+F4");
                        } else if (stringArray.length == 5) {
                            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), 5 + LocaleStrings.getString("T_17_UDM") + "Alt+F4" + LocaleStrings.getString("T_18_UDM"), LocaleStrings.getString("T_7_UDM"), 1);
                        } else {
                            UserDefMacro.this.maxMacroLimitMessage();
                        }
                    }
                    UserDefMacro.this.jShowTextField.setText(string);
                    UserDefMacro.this.jShowTextField.requestFocus();
                }
            });
        }
        return this.jAltF4Button;
    }

    private JButton getPrintScreen() {
        if (this.jPrintScreen == null) {
            this.jPrintScreen = new JButton();
            this.jPrintScreen.setText("Print Screen");
            this.jPrintScreen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = UserDefMacro.this.jShowTextField.getText();
                    String string2 = Integer.toString(154);
                    if (string.length() == 0) {
                        string = string.concat("Print Screen");
                        UserDefMacro.this.code = UserDefMacro.this.code.concat(string2);
                        UserDefMacro.this.code = UserDefMacro.this.code.concat("+1");
                    } else {
                        String[] stringArray = string.split("[+]");
                        if (stringArray.length < 6) {
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+" + string2);
                            UserDefMacro.this.code = UserDefMacro.this.code.concat("+1");
                            string = string.concat("+Print Screen");
                        } else {
                            UserDefMacro.this.maxMacroLimitMessage();
                        }
                    }
                    UserDefMacro.this.jShowTextField.setText(string);
                    UserDefMacro.this.jShowTextField.requestFocus();
                }
            });
        }
        return this.jPrintScreen;
    }

    public UserDefMacro(Frame frame) {
        super(frame);
        this.initialize();
        this.code = new String();
        if (this.macroMap == null) {
            this.macroMap = new HashMap();
        }
        HashMap<String, String> hashMap = JViewerApp.getInstance().getAddMacro().getMacroMap();
        this.previousMap = new HashMap();
        Set<Map.Entry<String, String>> set = hashMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            this.previousMap.put(entry.getKey(), entry.getValue());
        }
    }

    private void initialize() {
        this.setSize(615, 355);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getJContentPane(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setTitle(LocaleStrings.getString("T_1_UDM"));
        this.setResizable(false);
        this.setVisible(true);
        this.setLocation(JViewerApp.getInstance().getPopUpWindowPosition(615, 355));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                UserDefMacro.this.onCloseDialog();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJList(), null);
            this.jContentPane.setVisible(true);
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2, 10, 10));
            this.buttonPanel.add((Component)this.getJAddButton(), null);
            this.buttonPanel.add((Component)this.getJDeleteButton(), null);
            this.buttonPanel.add((Component)this.getJCloseButton(), null);
            this.buttonPanel.setVisible(true);
        }
        return this.buttonPanel;
    }

    public void displayHotkey(int n, int n2) {
        String string = null;
        String string2 = this.jShowTextField.getText();
        String[] stringArray = string2.split("[+]");
        string = KeyEvent.getKeyText(n);
        if (string.equals("NumPad +")) {
            string = "NumPad " + LocaleStrings.getString("T_16_UDM");
        }
        if (stringArray.length < 6) {
            if (string2.length() == 0) {
                this.jShowTextField.append(string);
                if (n2 != 1) {
                    switch (n2) {
                        case 2: {
                            this.jShowTextField.append("(" + LocaleStrings.getString("T_12_UDM") + ")");
                            break;
                        }
                        case 3: {
                            this.jShowTextField.append("(" + LocaleStrings.getString("T_13_UDM") + ")");
                            break;
                        }
                    }
                }
                String string3 = Integer.toString(n);
                this.code = this.code.concat(string3);
                this.code = this.code.concat("+" + n2);
            } else {
                String string4 = Integer.toString(n);
                this.code = this.code.concat("+" + string4);
                this.code = this.code.concat("+" + n2);
                this.jShowTextField.append("+" + string);
                if (n2 != 1) {
                    switch (n2) {
                        case 2: {
                            this.jShowTextField.append("(" + LocaleStrings.getString("T_12_UDM") + ")");
                            break;
                        }
                        case 3: {
                            this.jShowTextField.append("(" + LocaleStrings.getString("T_13_UDM") + ")");
                            break;
                        }
                    }
                }
            }
        } else {
            this.maxMacroLimitMessage();
        }
    }

    public boolean isAddMacro() {
        return this.addMacro;
    }

    private void maxMacroLimitMessage() {
        JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("T_14_UDM") + 6 + LocaleStrings.getString("T_15_UDM"), LocaleStrings.getString("T_7_UDM"), 1);
    }
}

