/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.ImagesToVideo;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.videorecord.DisplayVideoDataTask;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.TimerTask;
import javax.imageio.ImageIO;

class VideoRecordStart
extends TimerTask {
    JViewerApp RCApp = JViewerApp.getInstance();
    private int init_fps = 0;
    private Date CurrTime = new Date(0L);
    private Date RunTime = new Date(0L);
    private int num_blank_frames = 0;
    private static final int VIDEO_FPS = 3;

    VideoRecordStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 333;
        this.CurrTime = new Date(System.currentTimeMillis() / 1000L);
        this.RunTime = this.RCApp.getM_videorecord().TimeToRun;
        if (!JViewer.isdownloadapp()) {
            this.RCApp.getM_wndFrame().getWindowMenu().setMessage(LocaleStrings.getString("U_3_VR") + "(" + (this.RunTime.getTime() - this.CurrTime.getTime()) + " Sec)");
        }
        if (this.CurrTime.before(this.RunTime) && !JViewer.isdownloadapp()) {
            this.captureFrames();
            try {
                Object object = this.RCApp.getM_videorecord().obj;
                synchronized (object) {
                    this.RCApp.getM_videorecord().obj.wait(n);
                }
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        } else if ((DisplayVideoDataTask.run || this.CurrTime.getTime() <= this.RunTime.getTime()) && JViewer.isdownloadapp()) {
            try {
                Object object = this.RCApp.getM_videorecord().obj;
                synchronized (object) {
                    if (VideoRecord.TotalFrames == 0 && JViewerApp.getInstance().getVideorecordapp().getVideoFrameBuffer().size() == 0) {
                        this.RCApp.getM_videorecord().obj.wait();
                    } else {
                        this.RCApp.getM_videorecord().obj.wait(n);
                    }
                }
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            if (VideoRecord.Recording_Started) {
                this.captureFrames();
            }
        } else {
            this.cancel();
            this.RCApp.getM_videorecord().OnVideoRecordStop();
        }
    }

    public void makeVideo(String string) throws MalformedURLException {
        this.CurrTime = new Date(System.currentTimeMillis() / 1000L);
        long l = this.RunTime.getTime() - this.CurrTime.getTime();
        if (l < 0L) {
            l = 0L;
        }
        long l2 = !JViewer.isdownloadapp() && !JViewer.isplayerapp() ? (long)VideoRecord.RecordStopTimer - l : JViewerApp.getInstance().getVideorecordapp().getDuration();
        String string2 = JViewerApp.getInstance().getM_videorecord().Temp_store_Path;
        ImagesToVideo imagesToVideo = new ImagesToVideo(string, string2, VideoRecord.TotalFrames, l2);
    }

    public File getFile(int n, String string) {
        String string2 = "file" + n + ".jpeg";
        File file = new File(string, string2);
        return file;
    }

    private void captureFrames() {
        if (JViewerApp.getInstance().getKVMClient().m_isBlank) {
            ++this.num_blank_frames;
            Debug.out.println("num_blank_frames " + this.num_blank_frames);
            if (!JViewerApp.getInstance().getM_videorecord().singleVideo) {
                return;
            }
        }
        File file = this.getFile(VideoRecord.TotalFrames, this.RCApp.getM_videorecord().Temp_store_Path);
        ++VideoRecord.TotalFrames;
        try {
            file.createNewFile();
            ImageIO.write((RenderedImage)this.RCApp.getRCView().getImage(), "jpeg", file);
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            String string = LocaleStrings.getString("V_12_VRS");
            this.cancel();
            this.RCApp.getM_videorecord().OnLowDiskSpace(file, string);
            VideoRecord.Record_Interrupted = true;
            this.RCApp.getM_videorecord().OnVideoRecordStop();
        }
        this.init_fps = this.RCApp.getVidClnt().getM_frameRate();
        VideoRecord.fps += this.init_fps;
    }

    public int getNum_blank_frames() {
        return this.num_blank_frames;
    }

    public void setNum_blank_frames(int n) {
        this.num_blank_frames = n;
    }
}

