/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.HarddiskRedir;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.Component;
import java.awt.Window;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ConfPkt {
    public static final int NAME_MAX_LENGTH = 17;
    private char[] serviceName = new char[17];
    private byte currentState;
    private char[] interfaceName = new char[17];
    private int nonSecureAccessPort;
    private int secureAccessPort;
    private int sessionInactivityTimeout;
    private byte maxAllowedSessions;
    private byte currentActiveSession;
    private int maxSessionInactivityTimeout;
    private int minSessionInactivityTimeout;
    public static final String SERV_CD_MEDIA = "cd-media";
    public static final String SERV_HD_MEDIA = "hd-media";
    public static final int CONF_PKT_SIZE = 57;
    public static final short CONF_SERVICE_COUNT = 5;
    public static final short CHANGE_CURR_STATE = 0;
    public static final short CHANGE_IFACE_NAME = 1;
    public static final short CHANGE_NON_SEC_PORT = 2;
    public static final short CHANGE_SEC_PORT = 3;
    public static final short CHANGE_TIME_OUT = 4;
    public static final short CHANGE_MAX_SESSION = 5;
    public static final short CHANGE_CURR_ACTIVE_SESS = 6;
    public static final short CHANGE_MAX_TIME_OUT = 7;
    public static final short CHANGE_MIN_TIME_OUT = 8;
    public static boolean confModified = false;

    public ConfPkt(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray2 = new byte[17];
        byteBuffer.get(byArray2);
        this.serviceName = new String(byArray2).toCharArray();
        this.currentState = byteBuffer.get();
        byteBuffer.get(byArray2);
        this.interfaceName = new String(byArray2).toCharArray();
        this.nonSecureAccessPort = byteBuffer.getInt();
        this.secureAccessPort = byteBuffer.getInt();
        this.sessionInactivityTimeout = byteBuffer.getInt();
        this.maxAllowedSessions = byteBuffer.get();
        this.currentActiveSession = byteBuffer.get();
        this.maxSessionInactivityTimeout = byteBuffer.getInt();
        this.minSessionInactivityTimeout = byteBuffer.getInt();
    }

    public String getServiceName() {
        return new String(this.serviceName).trim();
    }

    public void setServiceName(char[] cArray) {
        this.serviceName = cArray;
    }

    public byte getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(byte by) {
        this.currentState = by;
    }

    public String getInterfaceName() {
        return new String(this.interfaceName).trim();
    }

    public void setInterfaceName(char[] cArray) {
        this.interfaceName = cArray;
    }

    public int getNonSecureAccessPort() {
        return this.nonSecureAccessPort;
    }

    public void setNonSecureAccessPort(int n) {
        this.nonSecureAccessPort = n;
    }

    public int getSecureAccessPort() {
        return this.secureAccessPort;
    }

    public void setSecureAccessPort(int n) {
        this.secureAccessPort = n;
    }

    public int getSessionInactivityTimeout() {
        return this.sessionInactivityTimeout;
    }

    public void setSessionInactivityTimeout(int n) {
        this.sessionInactivityTimeout = n;
    }

    public byte getMaxAllowedSessions() {
        return this.maxAllowedSessions;
    }

    public void setMaxAllowedSessions(byte by) {
        this.maxAllowedSessions = by;
    }

    public byte getCurrentActiveSession() {
        return this.currentActiveSession;
    }

    public void setCurrentActiveSession(byte by) {
        this.currentActiveSession = by;
    }

    public int getMaxSessionInactivityTimeout() {
        return this.maxSessionInactivityTimeout;
    }

    public void setMaxSessionInactivityTimeout(int n) {
        this.maxSessionInactivityTimeout = n;
    }

    public int getMinSessionInactivityTimeout() {
        return this.minSessionInactivityTimeout;
    }

    public void setMinSessionInactivityTimeout(int n) {
        this.minSessionInactivityTimeout = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showConfDataChangeMsg(String string) {
        confModified = true;
        JViewerApp.getInstance().syncVMediaRedirection();
        Window window = JViewer.getMainFrame();
        if (JViewerApp.getInstance().getVMDialog() != null) {
            window = JViewerApp.getInstance().getVMDialog();
        } else if (JViewerApp.getInstance().getM_videorecord() != null && JViewerApp.getInstance().getM_videorecord().getM_videoPath() != null) {
            window = JViewerApp.getInstance().getM_videorecord().getM_videoPath();
        }
        String string2 = this.getServiceName();
        InfoDialog.showDialog((Component)window, string2 + LocaleStrings.getString("X_1_CP") + "\n" + string + LocaleStrings.getString("X_2_CP"), LocaleStrings.getString("X_3_CP"), 1);
        if (string2.equalsIgnoreCase("kvm") || string2.equalsIgnoreCase("web")) {
            JViewerApp.getInstance().getM_frame().windowClosed();
        }
        Object object = CDROMRedir.getSyncObj();
        synchronized (object) {
            CDROMRedir.getSyncObj().notify();
        }
        object = HarddiskRedir.getSyncObj();
        synchronized (object) {
            HarddiskRedir.getSyncObj().notify();
        }
    }
}

