/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import java.net.Socket;
import java.nio.ByteBuffer;

public class FragReader
implements KVMReader {
    private KVMClient m_client;
    private byte[] m_frameBuf;
    private ByteBuffer m_frameByteBuf;
    private int m_fragIx;
    private int m_frameIx;

    public FragReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_frameBuf = new byte[9216000];
        this.m_frameIx = 0;
        this.m_frameByteBuf = ByteBuffer.wrap(this.m_frameBuf);
    }

    @Override
    public void initialize() {
        if ((this.m_client.m_fragNum & Short.MAX_VALUE) == 0) {
            this.m_frameIx = 0;
        }
        this.m_frameByteBuf.position(this.m_frameIx);
        this.m_frameByteBuf.limit(this.m_frameIx + this.m_client.m_pktHdr.pktSize - 2);
        this.m_fragIx = 0;
    }

    @Override
    public int read(Socket socket) {
        Object object;
        try {
            object = new byte[this.m_frameByteBuf.remaining()];
            this.m_fragIx = this.m_client.read_data(socket, (byte[])object);
            this.m_frameByteBuf.put((byte[])object);
            if (this.m_fragIx < 0) {
                return -1;
            }
        }
        catch (Exception exception) {
            Debug.out.println("FRAG_RDR ");
            Debug.out.println(exception);
            return -1;
        }
        if (this.m_fragIx == this.m_client.m_pktHdr.pktSize - 2) {
            this.m_frameIx += this.m_fragIx;
            if (0 != (this.m_client.m_fragNum & 0x8000)) {
                this.m_frameByteBuf.limit(this.m_frameIx);
                this.m_client.onNewFrame(this.m_frameByteBuf);
                this.m_frameIx = 0;
            }
            object = this.m_client.getHdrReader();
            object.initialize();
            this.m_client.setState((KVMReader)object);
        }
        return 0;
    }
}

