/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.gui.JViewerApp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;

public class UserDataPacket {
    public static final int USER_DATA_LENGTH = 134;
    public static final int USER_NAME_LENGTH = 64;
    public static final int CLIENT_IP_LENGTH = 65;
    private UserData userData = null;
    private Hashtable<String, UserData> userDataTable = null;
    private int numUsers = 1;
    private String[] userInfo = null;

    public UserDataPacket(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[134];
        String string = null;
        this.numUsers = byteBuffer.capacity() / 134;
        this.userDataTable = new Hashtable();
        this.userInfo = new String[this.numUsers];
        for (int i = 0; i < this.numUsers; ++i) {
            byteBuffer.get(byArray);
            this.userData = new UserData(byArray);
            string = this.userData.getSessionIndex() + " : " + this.userData.getUserName() + "( " + JViewerApp.getInstance().getIpmiPrivText(this.userData.getIpmiPriv()) + ") : " + this.userData.getClientIP();
            this.userDataTable.put(string, this.userData);
            this.userInfo[i] = string;
        }
    }

    public Hashtable<String, UserData> getUserDataTable() {
        return this.userDataTable;
    }

    public void setUserDataTable(Hashtable<String, UserData> hashtable) {
        this.userDataTable = hashtable;
    }

    public String[] getUserInfo() {
        return this.userInfo;
    }

    public int getNumUsers() {
        return this.numUsers;
    }

    public UserData getUserData(String string) {
        UserData userData = this.userDataTable.get(string);
        return userData;
    }

    public ByteBuffer createUserDataBuffer(String string) {
        ByteBuffer byteBuffer = null;
        byte[] byArray = null;
        int n = -1;
        this.userData = this.userDataTable.get(string);
        byArray = new byte[64];
        byArray = this.userData.getUserName().getBytes();
        byteBuffer = ByteBuffer.allocate(134);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        byteBuffer.put(byArray);
        for (n = byteBuffer.position(); n < 64; ++n) {
            byteBuffer.put((byte)0);
        }
        byArray = new byte[65];
        byArray = this.userData.getClientIP().getBytes();
        byteBuffer.put(byArray);
        for (n = byteBuffer.position(); n < 129; ++n) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put((byte)this.userData.getSessionIndex());
        byteBuffer.rewind();
        return byteBuffer;
    }

    class UserData {
        private String userName;
        private String clientIP;
        private int sessionIndex;
        private int ipmiPriv;

        public UserData(byte[] byArray) {
            ByteBuffer byteBuffer = null;
            byte[] byArray2 = new byte[64];
            byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.get(byArray2);
            this.userName = new String(byArray2).trim();
            byArray2 = new byte[65];
            byteBuffer.get(byArray2);
            this.clientIP = new String(byArray2).trim();
            this.sessionIndex = byteBuffer.get();
            this.ipmiPriv = byteBuffer.getInt();
        }

        public String getUserName() {
            return this.userName;
        }

        public String getClientIP() {
            return this.clientIP;
        }

        public int getSessionIndex() {
            return this.sessionIndex;
        }

        public int getIpmiPriv() {
            return this.ipmiPriv;
        }
    }
}

