/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.videorecord;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.videorecord.URLHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

public class URLProcessor
extends URLHandler {
    private byte[] data;
    private static final int FILE_LOCKED = -1;
    public static final int FILE_NOT_FOUND = -2;
    public static final int EMPTY_FILE = -3;
    public static final int RECORDING_IN_PROGRESS = -5;
    public static final int INVALID_SESSION_TOKEN = 2;
    public static final int HTTP_CONNECTION_SUCCESS = 0;
    private static final int HTTP_REQUEST_SUCCESS = 200;
    public static final int HTTP_REQUEST_FAILURE = -1;
    public static final int INVALID_CREDENTIALS = -6;
    public static final int INVALID_SERVER_CERT = -7;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final String DEF_DELIMITER = " ";
    private static final int HTTP_FILE_NOT_FOUND = 404;
    public static final int RESET_FILE_ACCESS = 0;
    public static final int SET_FILE_ACCESS = 1;
    public static final int CHECK_FILE_ACCESS = 4;
    private static final int REST_RECORDING_IN_PROGRESS = 1442;
    private static final String UNAUTHORIZED = "401 Unauthorized";
    private static final String NOT_FOUND = "404 Not Found";
    private static final String DYNAMIC_DATA_END = "//Dynamic data end";
    private static final String ZERO = "0";
    private static final int SUCCESS = 0;
    private static final int FAILURE = -1;
    private String hostIP = null;
    private String uriString = null;
    private static Socket socket = null;
    private final String USER_AGENT_NAME = "JViewer";
    private final String USER_AGENT_TAG = "User-Agent";
    private final String NEWLINE = "\r\n";
    private static String csrfToken = null;
    private int downloadStatus = -1;

    public URLProcessor(String string, int n) {
        this.sesCookie = string;
        this.secureConnect = n;
    }

    public URLProcessor() {
    }

    public int processRequest(String string) {
        int n = 0;
        int n2 = -1;
        if (JViewer.isRestService()) {
            return this.restProcessRequest(string);
        }
        if (socket == null) {
            try {
                int n3 = JViewer.isWebSecure() ? 1 : 0;
                socket = JViewerApp.getInstance().getConnection().createSocket(InetAddress.getByName(JViewer.getIp()), JViewer.getWebPort(), n3);
            }
            catch (UnknownHostException unknownHostException) {
                Debug.out.println(unknownHostException);
            }
            if (socket == null) {
                return -7;
            }
        }
        this.uriString = string;
        if (this.writeRequestToSocket(socket, null) != 0) {
            return -1;
        }
        if (string.contains(".asp")) {
            n2 = this.getServerResponseData();
            if (n2 != 0) {
                try {
                    if (socket != null) {
                        socket.close();
                        URLProcessor.setSocket(null);
                    }
                }
                catch (Exception exception) {
                    URLProcessor.setSocket(null);
                    Debug.out.println(exception);
                }
                return n2;
            }
        } else {
            return this.getDataFromSocket();
        }
        n = Integer.parseInt(this.getValueOf(new String(this.data), "HAPI_STATUS:", ' ').trim());
        if (n < 0) {
            if (n == -6) {
                return -6;
            }
            if (JViewer.isdownloadapp() || JViewer.isplayerapp()) {
                if (n == -5) {
                    return -5;
                }
                JViewerApp.getInstance().getVideorecordapp().disposeInformationDialog();
                if (n == -1) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("Z_2_URLP"), LocaleStrings.getString("A_5_GLOBAL"), 0);
                    return -1;
                }
                if (n == -2) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("Z_3_URLP"), LocaleStrings.getString("A_5_GLOBAL"), 0);
                    return -2;
                }
            }
        }
        return n;
    }

    public String getValue(String string, char c) {
        String string2 = null;
        String string3 = new String(this.data);
        int n = string3.indexOf(string);
        int n2 = string3.indexOf(c, n + string.length());
        if (n2 < 0) {
            n2 = string3.indexOf(DEF_DELIMITER, n + string.length());
        }
        if (n > 0 && n2 > 0) {
            string2 = string3.substring(n + string.length(), n2).trim();
        }
        return string2;
    }

    public String getValueOf(String string, String string2, char c) {
        String string3 = "";
        if (string != null && string2 != null && string.length() > 0 && string2.length() > 0) {
            int n = string.indexOf(string2) + string2.length();
            int n2 = string.indexOf(c, n);
            if (n > 0 && n2 > 0) {
                string3 = string.substring(n, n2).trim();
            }
        }
        return string3;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void downloadFile(String string) {
        Downloader downloader = new Downloader(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int download(String string) throws IOException {
        int n = 0;
        long l = 0L;
        this.uriString = string;
        boolean bl = false;
        if (socket == null) {
            return -1;
        }
        if (this.writeRequestToSocket(socket, null) != 0) {
            return -1;
        }
        File file = new File(JViewerApp.getInstance().getVideorecordapp().Videotmpstorepath[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        try {
            byte[] byArray = new byte[0x100000];
            if (this.getHTTPResponseHeader(bufferedInputStream) != 0) {
                int n2 = -1;
                return n2;
            }
            if (this.data.toString().contains(NOT_FOUND)) {
                int n3 = -2;
                return n3;
            }
            int n4 = Integer.parseInt(this.getValueOf(new String(this.data), "Content-Length:", '\r').trim());
            if (n4 <= 0) {
                int n5 = -3;
                return n5;
            }
            while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                if ((l += (long)n) < (long)n4) continue;
                Debug.out.println("Read till content length !");
                break;
            }
        }
        catch (Exception exception) {
            Debug.out.println("Exception : while reading bytes from input stream " + exception);
            bl = true;
            return bl ? 1 : 0;
        }
        finally {
            try {
                fileOutputStream.close();
                if (bl) {
                    ((InputStream)bufferedInputStream).close();
                    return -1;
                }
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                return -1;
            }
        }
        return 0;
    }

    public int writeRequestToSocket(Socket socket, String string) {
        if (JViewer.isRestService()) {
            return this.restWriteRequestToSocket(socket, string);
        }
        int n = 0;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            printWriter.print("GET " + this.uriString + " HTTP/1.1" + "\r\n");
            printWriter.print("Host: " + this.hostIP + "\r\n");
            printWriter.print("Accept: */*\r\n");
            printWriter.print("User-Agent: JViewer\r\n");
            if (this.sesCookie != null) {
                printWriter.print("Cookie: SessionCookie=" + this.sesCookie + "\r\n");
            }
            if (string != null && string.length() > 0) {
                printWriter.print(string + "\r\n");
            }
            printWriter.print("\r\n");
            printWriter.flush();
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            n = -1;
        }
        return n;
    }

    public int getServerResponseData() {
        int n = 0;
        BufferedReader bufferedReader = null;
        String string = "";
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith(DYNAMIC_DATA_END) && !string2.equals(ZERO)) {
                if (string2.contains(NOT_FOUND)) {
                    n = -2;
                    break;
                }
                if (string2.contains(UNAUTHORIZED)) {
                    n = -6;
                    break;
                }
                string = string + string2 + "\n";
            }
        }
        catch (Exception exception) {
            n = -1;
            URLProcessor.setSocket(null);
            Debug.out.println(exception);
        }
        this.data = string.getBytes();
        return n;
    }

    public int getHTTPResponseHeader(InputStream inputStream) {
        int n = 0;
        int n2 = 0;
        String string = null;
        try {
            try {
                while ((n = inputStream.read()) != -1) {
                    if (!(string = string + (char)n).contains("\r\n\r\n")) continue;
                    Debug.out.println("Read till header end");
                }
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                n2 = -1;
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n2 = -1;
        }
        if (n2 == 0) {
            this.data = string.getBytes();
        }
        return n2;
    }

    public static Socket getSocket() {
        return socket;
    }

    public static void setSocket(Socket socket) {
        URLProcessor.socket = socket;
    }

    private int getDataFromSocket() {
        BufferedInputStream bufferedInputStream = null;
        String string = null;
        try {
            bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            return -1;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        int n2 = 0;
        if (this.getHTTPResponseHeader(bufferedInputStream) != 0) {
            return -1;
        }
        if (this.data == null) {
            return -1;
        }
        string = new String(this.data);
        if (string.contains("404") || string.contains("404&nbsp;Not Found")) {
            return -2;
        }
        int n3 = Integer.parseInt(this.getValueOf(string, "Content-Length:", '\r').trim());
        try {
            while ((n = bufferedInputStream.read()) != -1 && ++n2 < n3) {
                byteArrayOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            return -1;
        }
        this.data = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            bufferedInputStream.close();
            socket.close();
            URLProcessor.setSocket(null);
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            return -1;
        }
        return 0;
    }

    public String getUriString() {
        return this.uriString;
    }

    public void setUriString(String string) {
        this.uriString = string;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String string) {
        this.hostIP = string;
    }

    public int restProcessRequest(String string) {
        Debug.out.println("urlPath: " + string);
        int n = -1;
        if (socket == null) {
            try {
                int n2 = JViewer.isWebSecure() ? 1 : 0;
                socket = JViewerApp.getInstance().getConnection().createSocket(InetAddress.getByName(JViewer.getIp()), JViewer.getWebPort(), n2);
            }
            catch (UnknownHostException unknownHostException) {
                Debug.out.println(unknownHostException);
            }
            if (socket == null) {
                return -7;
            }
        }
        this.uriString = string;
        if (this.restWriteRequestToSocket(socket, null) != 0) {
            return -1;
        }
        if (string.contains("/api/logs/help-data")) {
            n = this.getDataFromSocket();
        } else {
            n = this.getServerResponseData();
            if (n == 0) {
                String string2;
                if (string.contains("/api/logs/video-log") && string.contains("file_access=4") && this.data != null && (string2 = new String(this.data)) != null && string2.length() > 0 && string2.contains("code")) {
                    try {
                        if (Integer.parseInt(this.getValueOf(string2, "\"code\": ", ' ').trim()) == 1442) {
                            n = -5;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        Debug.out.println(numberFormatException);
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                    }
                }
            } else {
                try {
                    if (socket != null) {
                        socket.close();
                        URLProcessor.setSocket(null);
                    }
                }
                catch (Exception exception) {
                    URLProcessor.setSocket(null);
                    Debug.out.println(exception);
                }
            }
        }
        return n;
    }

    public int restWriteRequestToSocket(Socket socket, String string) {
        int n = 0;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            if (csrfToken == null && this.sesCookie == null) {
                printWriter.print("POST " + this.uriString + " HTTP/1.1" + "\r\n");
            } else if (this.uriString.contains("/api/logs/video-log")) {
                printWriter.print("PUT " + this.uriString + " HTTP/1.1" + "\r\n");
            } else if (this.uriString.contains("/kvm/token") || this.uriString.contains("/settings/media/instance") || this.uriString.contains("/api/settings/media/adviser") || this.uriString.contains("/api/logs/video") || this.uriString.contains("/api/logs/help-data")) {
                printWriter.print("GET " + this.uriString + " HTTP/1.1" + "\r\n");
            } else {
                printWriter.print("DELETE " + this.uriString + " HTTP/1.1" + "\r\n");
            }
            printWriter.print("Accept: */*\r\n");
            printWriter.print("User-Agent: JViewer\r\n");
            printWriter.print("Host: " + this.hostIP + "\r\n");
            printWriter.print("Connection: Keep-Alive\r\n");
            if (this.uriString.contains("/api/session")) {
                printWriter.print("Content-Length: 0\r\n");
            }
            if (csrfToken != null) {
                printWriter.print("X-CSRFTOKEN: " + csrfToken + "\r\n");
            }
            if (this.sesCookie != null) {
                printWriter.print("Cookie: " + this.sesCookie + "\r\n");
            }
            if (string != null && string.length() > 0) {
                printWriter.print(string + "\r\n");
            }
            printWriter.print("\r\n");
            printWriter.flush();
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            n = -1;
        }
        return n;
    }

    public static String getCsrfToken() {
        return csrfToken;
    }

    public static void setCsrfToken(String string) {
        csrfToken = string;
    }

    public int getDownloadStatus() {
        return this.downloadStatus;
    }

    class Downloader
    extends Thread {
        String urlPath;

        public Downloader(String string) {
            this.urlPath = string;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                URLProcessor.this.downloadStatus = URLProcessor.this.download(this.urlPath);
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                URLProcessor.this.downloadStatus = -1;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                URLProcessor.this.downloadStatus = -1;
            }
            finally {
                JViewerApp.getInstance().getVideorecordapp().disposeInformationDialog();
            }
        }
    }
}

