/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Units;

public abstract class Metafile
extends HSLFPictureData {
    protected static byte[] compress(byte[] bytes, int offset, int length) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream(out);
        deflater.write(bytes, offset, length);
        deflater.close();
        return out.toByteArray();
    }

    public Dimension getImageDimension() {
        int prefixLen = 16 * this.getUIDInstanceCount();
        Header header = new Header();
        header.read(this.getRawData(), prefixLen);
        return new Dimension((int)Math.round(Units.toPoints((long)((long)header.size.getWidth()))), (int)Math.round(Units.toPoints((long)((long)header.size.getHeight()))));
    }

    public static class Header {
        private int wmfsize;
        private final Rectangle bounds = new Rectangle();
        private final Dimension size = new Dimension();
        private int zipsize;
        private int compression = 0;
        private int filter = 254;

        public void read(byte[] data, int offset) {
            int pos = offset;
            this.wmfsize = LittleEndian.getInt((byte[])data, (int)pos);
            int left = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            int top = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            int right = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            int bottom = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            this.bounds.setBounds(left, top, right - left, bottom - top);
            int width = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            int height = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            this.size.setSize(width, height);
            this.zipsize = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            this.compression = LittleEndian.getUByte((byte[])data, (int)(pos += 4));
            this.filter = LittleEndian.getUByte((byte[])data, (int)(++pos));
            ++pos;
        }

        public void write(OutputStream out) throws IOException {
            byte[] header = new byte[34];
            int pos = 0;
            LittleEndian.putInt((byte[])header, (int)pos, (int)this.wmfsize);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.bounds.x);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.bounds.y);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)(this.bounds.x + this.bounds.width));
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)(this.bounds.y + this.bounds.height));
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.size.width);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.size.height);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.zipsize);
            header[pos += 4] = 0;
            header[++pos] = (byte)this.filter;
            ++pos;
            out.write(header);
        }

        public int getSize() {
            return 34;
        }

        public int getWmfSize() {
            return this.wmfsize;
        }

        protected void setWmfSize(int wmfSize) {
            this.wmfsize = wmfSize;
        }

        protected void setZipSize(int zipSize) {
            this.zipsize = zipSize;
        }

        public Rectangle getBounds() {
            return (Rectangle)this.bounds.clone();
        }

        protected void setBounds(Rectangle bounds) {
            this.bounds.setBounds(bounds);
        }

        protected void setDimension(Dimension size) {
            this.size.setSize(size);
        }
    }
}

