/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.IUSBRedirSession;
import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.CDROMProtocol;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.iusb.vCDMonitorThread;
import com.ami.kvm.imageredir.IUSBHeader;
import com.ami.kvm.imageredir.cd.CDImage;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.StandAloneConnectionDialog;
import com.ami.vmedia.VMApp;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JOptionPane;

public class CDROMRedir
extends Thread {
    private PacketMaster packetMaster;
    private CDROMProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean physicalDrive;
    private int CDDevice_no;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private String sourceCDROM = null;
    private int nBytesRedirected = 0;
    private boolean cdReconnect = false;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    private static final int AUTH_CMD = 242;
    private static final int MAX_READ_SECTORS = 64;
    private static final int MAX_READ_SIZE = 131072;
    private static final int MAX_READ_DATA_SIZE = 1024;
    private static final int SCSI_GET_STATUS_COUNT_SEC = 50;
    private boolean cdImageEjected = false;
    private boolean cdServiceRestarted = false;
    private boolean cdImageRedirected = false;
    private vCDMonitorThread vMThread = null;
    private int cdInstanceNum;
    private String errorMessage = " ";
    private static Object syncObj = new Object();
    private boolean confModified = false;
    private boolean cdRedirectionKilled = false;
    private CDImage newCDImage = null;
    private boolean cdStoppedByUser = false;
    private int cdromRedirStatus;
    private int cdROMDeviceStatus;
    private int cdStopMode;
    private boolean command_sent = false;
    private boolean Get_notification_scsi_support = false;
    private int Get_notification_scsi_counter = 0;

    private native String[] listCDROMDrives();

    private native void newCDROMReader(boolean var1);

    private native void deleteCDROMReader();

    private native boolean openCDROM(byte[] var1);

    private native void closeCDROM();

    private native int executeCDROMSCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String getVersion();

    private static void loadWrapperLibrary() {
        String string = null;
        File file = null;
        String string2 = JViewer.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if ((string2 = string2.substring(0, string2.lastIndexOf(47))).contains("%20")) {
            string2 = string2.replaceAll("%20", "\\ ");
        }
        String string3 = File.separator + "Jar" + File.separator + JViewer.getIp() + File.separator + "lib" + File.separator;
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string3 = StandAloneConnectionDialog.replaceAllPattern(string3, ":", "_");
                string = string2 + string3 + "javacdromwrapper.dll";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("javacdromwrapper.dll")) {
                    Debug.out.println("Unable to extract the javacdromwrapper.dll");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "javacdromwrapper.dll";
            }
        } else if (System.getProperty("os.name").startsWith("Linux")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string = string2 + string3 + "libjavacdromwrapper.so";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("libjavacdromwrapper.so")) {
                    Debug.out.println("Unable to extract the libjavacdromwrapper.so");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "libjavacdromwrapper.so";
            }
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string = string2 + string3 + "libjavacdromwrapper.jnilib";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("libjavacdromwrapper.jnilib")) {
                    Debug.out.println("libjavacdromwrapper.jnilib");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "libjavacdromwrapper.jnilib";
            }
        }
        try {
            System.load(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.out.println(unsatisfiedLinkError);
            CDROMRedir.showLibraryLoadError();
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            CDROMRedir.showLibraryLoadError();
        }
    }

    public CDROMRedir(boolean bl) {
        this.physicalDrive = bl;
        this.cdromRedirStatus = 0;
        this.cdROMDeviceStatus = 1;
        this.cdStopMode = 0;
        this.protocol = new CDROMProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(1024);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131134);
    }

    private int cdromConnect(String string, int n, boolean bl) throws IOException {
        this.packetMaster = new PacketMaster(string, n, false, this.protocol, bl);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        if (JViewer.isSinglePortEnabled()) {
            if (JViewerApp.getInstance().getSinglePortKvm().setHTTPConnect("CDMEDIA") < 0) {
                VMApp.getInstance().getIUSBRedirSession().setCDStopMode(6, this.CDDevice_no);
                return -1;
            }
            this.packetMaster.setSock(JViewerApp.getInstance().getSinglePortKvm().getHttpsock());
        } else if (this.packetMaster.connectVmedia(bl) < 0) {
            VMApp.getInstance().getIUSBRedirSession().setCDStopMode(6, this.CDDevice_no);
            return -1;
        }
        return 0;
    }

    private void cdromDisconnect() {
        try {
            this.packetMaster.VmediaSockclose();
        }
        catch (IOException iOException) {
            System.err.println(LocaleStrings.getString("4_6_CDROMREDIR") + iOException.getMessage());
        }
    }

    public boolean startRedirection(String string, String string2, int n, String string3, int n2, boolean bl) throws RedirectionException {
        Object object;
        Object object2;
        block27: {
            if (this.running) {
                return true;
            }
            this.CDDevice_no = n;
            try {
                if (this.cdromConnect(string, n2, bl) < 0) {
                    return false;
                }
                this.SendAuth_SessionToken(string3);
                IUSBSCSI.SendMediaInfo(this.packetMaster, this.packetWriteBuffer, string2);
                this.packetMaster.setSocketTimeout();
                object2 = this.recvRequest();
                this.cdInstanceNum = ((IUSBSCSI)object2).instanceNum;
                if (((IUSBSCSI)object2).opcode == 241) {
                    if (((IUSBSCSI)object2).connectionStatus == 5) {
                        this.cdromDisconnect();
                        this.setErrorMessage(LocaleStrings.getString("4_17_CDROMREDIR"));
                        return false;
                    }
                    if (((IUSBSCSI)object2).connectionStatus == 8) {
                        this.cdromDisconnect();
                        this.setErrorMessage(LocaleStrings.getString("4_18_CDROMREDIR"));
                        return false;
                    }
                    if (((IUSBSCSI)object2).connectionStatus == 13) {
                        this.cdromDisconnect();
                        this.setErrorMessage(LocaleStrings.getString("F_136_JVM"));
                        return false;
                    }
                    if (((IUSBSCSI)object2).connectionStatus != 1) {
                        if (((IUSBSCSI)object2).connectionStatus == 3 && JViewer.isVMApp()) {
                            this.stopRedirection();
                            this.setErrorMessage(LocaleStrings.getString("6_52_IUSBREDIR"));
                        } else if (((IUSBSCSI)object2).m_otherIP != null) {
                            this.cdromDisconnect();
                            if (((IUSBSCSI)object2).m_otherIP.equalsIgnoreCase("127.0.0.1") || ((IUSBSCSI)object2).m_otherIP.equalsIgnoreCase("::1")) {
                                this.setErrorMessage(LocaleStrings.getString("4_19_CDROMREDIR"));
                            } else {
                                this.setErrorMessage(LocaleStrings.getString("4_7_CDROMREDIR") + ((IUSBSCSI)object2).m_otherIP);
                            }
                        }
                        return false;
                    }
                    break block27;
                }
                this.cdromDisconnect();
                throw new RedirProtocolException(LocaleStrings.getString("4_8_CDROMREDIR") + ((IUSBSCSI)object2).opcode);
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                throw new RedirectionException(iOException.getMessage());
            }
        }
        if (((JViewer.getOEMFeatureStatus() & 0x40L) != 64L || this.isPhysicalDevice()) && this.nativeReaderPointer == -1L) {
            this.newCDROMReader(this.physicalDrive);
        }
        this.sourceCDROM = string2;
        object2 = new File(this.sourceCDROM);
        if ((JViewer.getOEMFeatureStatus() & 0x40L) != 64L && !this.isPhysicalDevice() && !((File)object2).exists()) {
            this.setErrorMessage(LocaleStrings.getString("4_10_CDROMREDIR"));
            this.deleteCDROMReader();
            this.cdromDisconnect();
            return false;
        }
        if ((JViewer.getOEMFeatureStatus() & 0x40L) != 64L || this.isPhysicalDevice()) {
            try {
                if (!this.openCDROM(string2.getBytes("UTF-8"))) {
                    this.setErrorMessage(LocaleStrings.getString("4_11_CDROMREDIR"));
                    this.deleteCDROMReader();
                    this.cdromDisconnect();
                    return false;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.out.println(LocaleStrings.getString("4_12_CDROMREDIR"));
                Debug.out.println(unsupportedEncodingException);
            }
        } else {
            object = new File(string2);
            this.newCDImage = new CDImage((File)object);
            if (!this.newCDImage.isOpened()) {
                this.setErrorMessage(LocaleStrings.getString("6_9_IUSBREDIR"));
                this.cdromDisconnect();
                return false;
            }
        }
        if (!JViewer.isVMApp()) {
            JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)1);
        }
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        object = VMApp.getInstance().getIUSBRedirSession();
        if (!JViewer.isVMApp()) {
            if (!JViewerApp.getInstance().getRetryConnection()) {
                InfoDialog.showDialog((Component)JViewerApp.getInstance().getVMDialog(), LocaleStrings.getString("4_13_CDROMREDIR"), LocaleStrings.getString("A_6_GLOBAL"), 1);
            }
        } else {
            InfoDialog.showDialog((Component)VMApp.getVMFrame(), LocaleStrings.getString("4_13_CDROMREDIR"), LocaleStrings.getString("A_6_GLOBAL"), 1);
        }
        this.cdromRedirStatus = 1;
        if (((IUSBRedirSession)object).isCDROMPhysicalDrive(n)) {
            this.vMThread = new vCDMonitorThread(this.CDDevice_no);
            this.vMThread.startCDROMMonitor();
        }
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (!this.isPhysicalDevice() && this.newCDImage != null) {
            this.newCDImage.closeImage();
            this.newCDImage = null;
        }
        if (this.running) {
            if (this.Get_notification_scsi_support) {
                this.command_sent = true;
                do {
                    try {
                        CDROMRedir.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.Get_notification_scsi_counter > 50) {
                        this.command_sent = false;
                        this.Get_notification_scsi_counter = 0;
                    }
                    ++this.Get_notification_scsi_counter;
                } while (this.command_sent);
                this.Get_notification_scsi_support = false;
            }
            try {
                if (!this.isCdServiceRestarted()) {
                    IUSBSCSI.sendCommandToMediaServer(this.packetMaster, this.packetWriteBuffer, null, 247);
                }
            }
            catch (Exception exception) {
                Debug.out.println("Sending MEDIA_SESSION_DISCONNECT command to media server failed : " + exception);
            }
            this.stopRunning = true;
            this.cdromDisconnect();
            try {
                this.redirThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.err.println(LocaleStrings.getString("4_14_CDROMREDIR"));
            }
            if (!JViewer.isVMApp()) {
                JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)0);
            }
            this.running = false;
            this.stopRunning = false;
            if ((JViewer.getOEMFeatureStatus() & 0x40L) != 64L || this.isPhysicalDevice()) {
                this.closeCDROM();
                this.deleteCDROMReader();
            }
        }
        this.nBytesRedirected = 0;
        this.cdromRedirStatus = 0;
        return true;
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket();
    }

    public boolean isRedirActive() {
        return this.running;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            if (this.Get_notification_scsi_support) {
                this.command_sent = true;
                do {
                    try {
                        CDROMRedir.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.Get_notification_scsi_counter > 50) {
                        this.command_sent = false;
                        this.Get_notification_scsi_counter = 0;
                    }
                    ++this.Get_notification_scsi_counter;
                } while (this.command_sent);
                this.Get_notification_scsi_support = false;
            }
            if (!this.isPhysicalDevice() && this.newCDImage != null) {
                this.newCDImage.closeImage();
                this.newCDImage = null;
            }
            this.stopRunning = true;
            this.cdromDisconnect();
            this.running = false;
            this.stopRunning = false;
            if ((JViewer.getOEMFeatureStatus() & 0x40L) != 64L || this.isPhysicalDevice()) {
                this.closeCDROM();
                this.deleteCDROMReader();
            }
            JViewerApp.getInstance().reportCDROMAbnormal(this.CDDevice_no);
        }
        this.cdromRedirStatus = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        int n2 = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI iUSBSCSI = this.recvRequest();
                if (iUSBSCSI == null) continue;
                if ((JViewer.getOEMFeatureStatus() & 0x40L) != 64L || this.isPhysicalDevice()) {
                    n2 = this.executeCDROMSCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                } else {
                    if (iUSBSCSI.opcode == 243) {
                        IUSBSCSI.sendCommandToMediaServer(this.packetMaster, this.packetWriteBuffer, null, 243);
                        continue;
                    }
                    this.newCDImage.executeSCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                    n2 = this.newCDImage.getDataLength() + 61;
                }
                if (n2 >= 0 && n2 <= this.packetWriteBuffer.capacity()) {
                    this.packetWriteBuffer.limit(n2);
                }
                this.packetWriteBuffer.position(0);
                if (iUSBSCSI.opcode == 246) {
                    this.cdRedirectionKilled = true;
                    return;
                }
                if (iUSBSCSI.opcode == 247) {
                    this.cdServiceRestarted = true;
                    return;
                }
                IUSBSCSI iUSBSCSI2 = new IUSBSCSI(this.packetWriteBuffer, true);
                if (iUSBSCSI.opcode == 74 && iUSBSCSI2.dataLen == 37) {
                    this.Get_notification_scsi_support = true;
                }
                if (this.command_sent && iUSBSCSI.opcode == 74 && iUSBSCSI2.dataLen == 37) {
                    iUSBSCSI2.data.put(34, (byte)0);
                    iUSBSCSI2.data.put(33, (byte)1);
                    iUSBSCSI2.data.put(36, (byte)0);
                }
                this.packetMaster.sendPacket(iUSBSCSI2);
                this.nBytesRedirected += (n += n2) / 1024;
                n %= 1024;
                if (this.command_sent && iUSBSCSI.opcode == 74 && iUSBSCSI2.dataLen == 37) {
                    this.command_sent = false;
                }
                if (iUSBSCSI.opcode != 27 || iUSBSCSI.Lba != 2) continue;
                this.cdImageEjected = true;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                if (this.stopRunning) continue;
                if (JViewer.isKVMReconnectEnabled() && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPING && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPED && JViewerApp.getInstance().getRetryConnection()) {
                    Debug.out.println("\n CD redierction thread returned .because of KVM Reconnect in progress\n");
                    return;
                }
                Object object = CDROMRedir.getSyncObj();
                synchronized (object) {
                    try {
                        if (!this.confModified) {
                            CDROMRedir.getSyncObj().wait(10000L);
                            if (this.cdStoppedByUser) {
                                return;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                if (!this.confModified) {
                    VMApp.getInstance().getIUSBRedirSession().setCDStopMode(5, this.CDDevice_no);
                } else {
                    this.confModified = false;
                }
                this.Get_notification_scsi_support = false;
                this.stopRedirectionAbnormal();
                return;
            }
        }
        Debug.out.println("Exiting the CDROM/ISO Redirection thread");
    }

    public String[] getCDROMList() throws RedirectionException {
        if (!this.physicalDrive) {
            this.DisplayErrorMsg(LocaleStrings.getString("4_15_CDROMREDIR"));
            return null;
        }
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(true);
        }
        String[] stringArray = this.listCDROMDrives();
        if (this.nativeReaderPointer == -1L) {
            this.deleteCDROMReader();
        }
        return stringArray;
    }

    public String getLIBCDROMVersion() {
        String string;
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(false);
            string = this.getVersion();
            this.deleteCDROMReader();
        } else {
            string = this.getVersion();
        }
        return string;
    }

    public void DisplayErrorMsg(String string) {
        if (JViewer.isVMApp()) {
            VMApp.getInstance().generalErrorMessage(LocaleStrings.getString("4_16_CDROMREDIR"), string);
        } else {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage(LocaleStrings.getString("4_16_CDROMREDIR"), string);
        }
    }

    public void handleError(String string) {
        this.DisplayErrorMsg(string);
    }

    public String getSourceDrive() {
        return this.sourceCDROM;
    }

    public boolean isPhysicalDevice() {
        return this.physicalDrive;
    }

    public void SendAuth_SessionToken(String string) throws RedirectionException, IOException {
        int n = 0;
        int n2 = JViewerApp.getInstance().getSessionTokenType();
        if (n2 == 0) {
            n = 128;
            this.packetWriteBuffer.clear();
            this.packetWriteBuffer.limit(160);
        } else if (n2 == 1) {
            n = 240;
            this.packetWriteBuffer.clear();
            this.packetWriteBuffer.limit(272);
        }
        IUSBHeader iUSBHeader = new IUSBHeader(n);
        iUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(string.getBytes());
        this.packetWriteBuffer.position(23);
        this.packetWriteBuffer.put((byte)this.CDDevice_no);
        this.packetWriteBuffer.position(0);
        IUSBSCSI iUSBSCSI = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(iUSBSCSI);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    public static Object getSyncObj() {
        return syncObj;
    }

    public boolean isConfModified() {
        return this.confModified;
    }

    public void setConfModified(boolean bl) {
        this.confModified = bl;
    }

    public int getCdInstanceNum() {
        return this.cdInstanceNum;
    }

    public boolean isCdImageRedirected() {
        return this.cdImageRedirected;
    }

    public void setCdImageRedirected(boolean bl) {
        this.cdImageRedirected = bl;
    }

    public boolean isCdImageEjected() {
        return this.cdImageEjected;
    }

    public boolean isCdRedirectionKilled() {
        return this.cdRedirectionKilled;
    }

    public void setCdReconnect(boolean bl) {
        this.cdReconnect = bl;
    }

    public boolean getCdReconnect() {
        return this.cdReconnect;
    }

    public boolean isCdStoppedByUser() {
        return this.cdStoppedByUser;
    }

    public void setCdStoppedByUser(boolean bl) {
        this.cdStoppedByUser = bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setCdRedirectionKilled(boolean bl) {
        this.cdRedirectionKilled = bl;
    }

    public int getCdromRedirStatus() {
        return this.cdromRedirStatus;
    }

    public void setCdromRedirStatus(int n) {
        this.cdromRedirStatus = n;
    }

    public int getCdROMDeviceStatus() {
        return this.cdROMDeviceStatus;
    }

    public void setCdROMDeviceStatus(int n) {
        this.cdROMDeviceStatus = n;
    }

    public int getCdStopMode() {
        return this.cdStopMode;
    }

    public void setCdStopMode(int n) {
        this.cdStopMode = n;
    }

    public boolean isCdServiceRestarted() {
        return this.cdServiceRestarted;
    }

    private static void showLibraryLoadError() {
        if (JViewer.isVMApp() || JViewer.isStandalone()) {
            JOptionPane.showMessageDialog(VMApp.getVMFrame(), LocaleStrings.getString("6_53_IUSBREDIR"), LocaleStrings.getString("1_3_JVIEWER"), 0);
            VMApp.exit(0);
        }
    }

    static {
        try {
            if (!JViewer.isdownloadapp() && !JViewer.isplayerapp()) {
                if (JViewer.isjviewerapp()) {
                    System.loadLibrary("javacdromwrapper");
                } else {
                    CDROMRedir.loadWrapperLibrary();
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(LocaleStrings.getString("4_2_CDROMREDIR"));
        }
    }
}

