/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.IUSBRedirSession;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.HarddiskProtocol;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.iusb.vHarddiskMonitorThread;
import com.ami.kvm.imageredir.IUSBHeader;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.StandAloneConnectionDialog;
import com.ami.vmedia.VMApp;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JOptionPane;

public class HarddiskRedir
extends Thread {
    private PacketMaster packetMaster;
    private HarddiskProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean physicalDevice;
    private int HDDevice_no;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private String sourceHarddisk = null;
    private int nBytesRedirected = 0;
    private int hdInstanceNum;
    private boolean hdReconnect = false;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    private static final int AUTH_CMD = 242;
    private static final int SET_HARDDISK_TYPE = 244;
    private static final int MAX_READ_SECTORS = 256;
    private static final int MAX_READ_SIZE = 131072;
    private boolean hdImageEjected = false;
    private boolean hdImageRedirected = false;
    private boolean hdServiceRestarted = false;
    public static String PHYSICAL_DRIVE = LocaleStrings.getString("A_5_DP");
    public static String LOGICAL_DRIVE = LocaleStrings.getString("A_6_DP");
    public static final int READ_WRITE = 1;
    public static final int READ_ONLY = 2;
    public static final int SECTOR_RANGE_ERROR = -1;
    public static final int ALREADY_IN_USE = -3;
    public static final int MEDIA_ERROR = -4;
    int Drive_Type;
    String[] ListDrive_USB = null;
    String[] ListDrive_Fixed = null;
    private vHarddiskMonitorThread vMThread = null;
    private String errorMessage = " ";
    private static Object syncObj = new Object();
    private boolean confModified = false;
    private boolean hdRedirectionKilled = false;
    private boolean hdStoppedByUser = false;
    private int harddiskRedirStatus;
    private int hardDiskDeviceStatus;
    private int hdStopMode;

    private native String[] listHardDrivesFixed();

    private native String[] listHardDrives();

    private native void newHarddiskReader(boolean var1);

    private native void deleteHarddiskReader();

    private native int openHarddisk(byte[] var1, boolean var2);

    private native void closeHarddisk();

    private native int executeHarddiskSCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String getVersion();

    private static void loadWrapperLibrary() {
        String string = null;
        File file = null;
        String string2 = JViewer.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if ((string2 = string2.substring(0, string2.lastIndexOf(47))).contains("%20")) {
            string2 = string2.replaceAll("%20", "\\ ");
        }
        String string3 = File.separator + "Jar" + File.separator + JViewer.getIp() + File.separator + "lib" + File.separator;
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string3 = StandAloneConnectionDialog.replaceAllPattern(string3, ":", "_");
                string = string2 + string3 + "javaharddiskwrapper.dll";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("javaharddiskwrapper.dll")) {
                    Debug.out.println("Unable to extract the javaharddiskwrapper.dll");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "javaharddiskwrapper.dll";
            }
        } else if (System.getProperty("os.name").startsWith("Linux")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string = string2 + string3 + "libjavaharddiskwrapper.so";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("libjavaharddiskwrapper.so")) {
                    Debug.out.println("Unable to extract the libjavaharddiskwrapper.so");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "libjavaharddiskwrapper.so";
            }
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string = string2 + string3 + "libjavaharddiskwrapper.jnilib";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("libjavaharddiskwrapper.jnilib")) {
                    Debug.out.println("Unable to extract the libjavaharddiskwrapper.jnlib");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "libjavaharddiskwrapper.jnilib";
            }
        }
        try {
            System.load(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.out.println(unsatisfiedLinkError);
            HarddiskRedir.showLibraryLoadError();
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            HarddiskRedir.showLibraryLoadError();
        }
    }

    public HarddiskRedir(boolean bl) {
        this.physicalDevice = bl;
        this.harddiskRedirStatus = 0;
        this.hardDiskDeviceStatus = 1;
        this.hdStopMode = 0;
        this.protocol = new HarddiskProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(131134);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131134);
    }

    private int harddiskConnect(String string, int n, boolean bl) throws IOException {
        this.packetMaster = new PacketMaster(string, n, false, this.protocol, bl);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        if (JViewer.isSinglePortEnabled()) {
            if (JViewerApp.getInstance().getSinglePortKvm().setHTTPConnect("HDMEDIA") < 0) {
                VMApp.getInstance().getIUSBRedirSession().setHDStopMode(6, this.HDDevice_no);
                return -1;
            }
            this.packetMaster.setSock(JViewerApp.getInstance().getSinglePortKvm().getHttpsock());
        } else if (this.packetMaster.connectVmedia(bl) < 0) {
            VMApp.getInstance().getIUSBRedirSession().setHDStopMode(6, this.HDDevice_no);
            return -1;
        }
        return 0;
    }

    private void harddiskDisconnect() {
        try {
            this.packetMaster.VmediaSockclose();
        }
        catch (IOException iOException) {
            System.err.println(LocaleStrings.getString("AB_5_HDREDIR") + iOException.getMessage());
        }
    }

    public boolean startRedirection(String string, String string2, int n, String string3, int n2, boolean bl) throws RedirectionException {
        Object object;
        IUSBRedirSession iUSBRedirSession;
        block43: {
            if (this.running) {
                return true;
            }
            this.HDDevice_no = n;
            iUSBRedirSession = null;
            iUSBRedirSession = VMApp.getInstance().getIUSBRedirSession();
            try {
                if (this.harddiskConnect(string, n2, bl) < 0) {
                    return false;
                }
                this.SendAuth_SessionToken(string3);
                IUSBSCSI.SendMediaInfo(this.packetMaster, this.packetWriteBuffer, string2);
                this.packetMaster.setSocketTimeout();
                object = this.recvRequest();
                this.hdInstanceNum = ((IUSBSCSI)object).instanceNum;
                if (((IUSBSCSI)object).opcode == 241) {
                    if (((IUSBSCSI)object).connectionStatus == 5) {
                        this.harddiskDisconnect();
                        this.setErrorMessage(LocaleStrings.getString("4_17_CDROMREDIR"));
                        return false;
                    }
                    if (((IUSBSCSI)object).connectionStatus == 8) {
                        this.harddiskDisconnect();
                        this.setErrorMessage(LocaleStrings.getString("AB_8_HDREDIR") + ((IUSBSCSI)object).m_otherIP);
                        return false;
                    }
                    if (((IUSBSCSI)object).connectionStatus == 13) {
                        this.harddiskDisconnect();
                        this.setErrorMessage(LocaleStrings.getString("F_136_JVM"));
                        return false;
                    }
                    if (((IUSBSCSI)object).connectionStatus != 1) {
                        this.harddiskDisconnect();
                        if (((IUSBSCSI)object).connectionStatus == 3 && JViewer.isVMApp()) {
                            this.stopRedirection();
                            this.setErrorMessage(LocaleStrings.getString("6_52_IUSBREDIR"));
                        } else if (((IUSBSCSI)object).m_otherIP != null) {
                            if (((IUSBSCSI)object).m_otherIP.equalsIgnoreCase("127.0.0.1") || ((IUSBSCSI)object).m_otherIP.equalsIgnoreCase("::1")) {
                                this.setErrorMessage(LocaleStrings.getString("4_19_CDROMREDIR"));
                            } else {
                                this.setErrorMessage(LocaleStrings.getString("4_7_CDROMREDIR") + ((IUSBSCSI)object).m_otherIP);
                            }
                        }
                        return false;
                    }
                    break block43;
                }
                this.harddiskDisconnect();
                throw new RedirectionException(LocaleStrings.getString("4_8_CDROMREDIR") + ((IUSBSCSI)object).opcode);
            }
            catch (IOException iOException) {
                throw new RedirectionException(iOException.getMessage());
            }
        }
        if (this.nativeReaderPointer == -1L) {
            this.newHarddiskReader(this.physicalDevice);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.sourceHarddisk = string2 = string2.trim();
            if (this.isPhysicalDevice()) {
                char c;
                object = string2.substring(string2.indexOf(91));
                string2 = string2.substring(0, string2.indexOf(91));
                String string4 = "";
                int n3 = 0;
                while (n3 < string2.lastIndexOf(45) + 1) {
                    if (' ' == (c = string2.charAt(n3++))) continue;
                    string4 = string4 + c;
                }
                string2 = string4;
                string2 = string2.replaceFirst("-", "");
                for (n3 = 0; n3 < ((String)object).indexOf(93); ++n3) {
                    c = ((String)object).charAt(n3);
                    if (c == '[' || c == ']' || c == '-') continue;
                    string2 = string2 + c;
                }
                string2 = string2 + ((String)object).substring(n3 + 1);
            }
        } else if (this.isPhysicalDevice()) {
            object = string2.split("-");
            this.sourceHarddisk = string2;
            string2 = object[0].trim();
        } else {
            this.sourceHarddisk = string2 = string2.trim();
        }
        try {
            int n4;
            object = string2;
            if (JViewer.getLanguage() != "EN") {
                if (string2.startsWith(LocaleStrings.getString("AB_9_HDREDIR"))) {
                    object = "PhysicalDrive" + string2.substring(string2.indexOf(45) - 1);
                } else if (string2.startsWith(LocaleStrings.getString("AB_10_HDREDIR"))) {
                    object = "LogicalDrive" + string2.substring(string2.indexOf(45) - 1);
                }
            }
            if ((n4 = this.openHarddisk(((String)object).getBytes("UTF-8"), this.isPhysicalDevice())) < 0) {
                if (n4 == -3) {
                    if (iUSBRedirSession.isHarddiskPhysicalDrive(this.HDDevice_no)) {
                        this.setErrorMessage(LocaleStrings.getString("6_37_IUSBREDIR"));
                    } else {
                        this.setErrorMessage(LocaleStrings.getString("AB_12_HDREDIR"));
                    }
                } else if (n4 == -4 || n4 == -1) {
                    this.setErrorMessage(LocaleStrings.getString("AB_11_HDREDIR"));
                }
                System.err.println(LocaleStrings.getString("AB_6_HDREDIR"));
                this.deleteHarddiskReader();
                this.harddiskDisconnect();
                return false;
            }
            if (n4 == 2) {
                if ((JViewer.getOEMFeatureStatus() & 2L) == 2L) {
                    if (iUSBRedirSession.isHarddiskPhysicalDrive(this.HDDevice_no)) {
                        this.setErrorMessage(LocaleStrings.getString("6_37_IUSBREDIR"));
                    } else {
                        this.setErrorMessage(LocaleStrings.getString("AB_13_HDREDIR"));
                    }
                    System.err.println(LocaleStrings.getString("AB_6_HDREDIR") + n4);
                    this.deleteHarddiskReader();
                    this.harddiskDisconnect();
                    return false;
                }
                if (!JViewer.isVMApp()) {
                    if (!JViewerApp.getInstance().getRetryConnection()) {
                        InfoDialog.showDialog((Component)JViewerApp.getInstance().getVMDialog(), LocaleStrings.getString("4_13_CDROMREDIR"), LocaleStrings.getString("A_6_GLOBAL"), 1);
                    }
                } else {
                    InfoDialog.showDialog((Component)VMApp.getVMFrame(), LocaleStrings.getString("4_13_CDROMREDIR"), LocaleStrings.getString("A_6_GLOBAL"), 1);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(LocaleStrings.getString("4_12_CDROMREDIR"));
        }
        if (!JViewer.isVMApp()) {
            JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)1);
        }
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        if (iUSBRedirSession.isHarddiskPhysicalDrive(this.HDDevice_no)) {
            this.vMThread = new vHarddiskMonitorThread(this.HDDevice_no);
            this.vMThread.startharddiskMonitor();
        }
        this.running = true;
        this.harddiskRedirStatus = 1;
        return true;
    }

    public boolean stopRedirection() {
        if (this.running) {
            try {
                if (!this.hdServiceRestarted) {
                    IUSBSCSI.sendCommandToMediaServer(this.packetMaster, this.packetWriteBuffer, null, 247);
                }
            }
            catch (Exception exception) {
                Debug.out.println("Sending MEDIA_SESSION_DISCONNECT command to media server failed : " + exception);
            }
            this.stopRunning = true;
            this.harddiskDisconnect();
            try {
                this.redirThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.err.println(LocaleStrings.getString("AB_7_HDREDIR"));
            }
            if (!JViewer.isVMApp()) {
                JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)0);
            }
            this.harddiskDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeHarddisk();
            this.deleteHarddiskReader();
        }
        this.nBytesRedirected = 0;
        this.harddiskRedirStatus = 0;
        return true;
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket();
    }

    public boolean isRedirActive() {
        return this.running;
    }

    public String getSourceDrive() {
        return this.sourceHarddisk;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            this.stopRunning = true;
            this.harddiskDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeHarddisk();
            this.deleteHarddiskReader();
            JViewerApp.getInstance().reportHarddiskAbnormal(this.HDDevice_no);
        }
        this.harddiskRedirStatus = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI iUSBSCSI = this.recvRequest();
                if (iUSBSCSI == null) continue;
                int n2 = this.executeHarddiskSCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                this.packetWriteBuffer.limit(n2);
                if (iUSBSCSI.opcode == 244) {
                    this.packetWriteBuffer.position(11);
                    this.packetWriteBuffer.putInt(31);
                    this.packetWriteBuffer.limit(++n2);
                    this.packetWriteBuffer.position(this.packetWriteBuffer.limit() - 1);
                    this.packetWriteBuffer.put((byte)this.getDrive_Type());
                }
                this.packetWriteBuffer.position(0);
                if (iUSBSCSI.opcode == 246) {
                    Debug.out.println("EXIT COMMAND RECEIVED IN Harddisk : " + iUSBSCSI.opcode);
                    this.hdRedirectionKilled = true;
                } else if (iUSBSCSI.opcode == 247) {
                    this.hdServiceRestarted = true;
                    return;
                }
                IUSBSCSI iUSBSCSI2 = new IUSBSCSI(this.packetWriteBuffer, true);
                this.packetMaster.sendPacket(iUSBSCSI2);
                this.nBytesRedirected += (n += n2) / 1024;
                n %= 1024;
                if (iUSBSCSI.opcode != 27 || iUSBSCSI.Lba != 2) continue;
                this.hdImageEjected = true;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                if (this.stopRunning) continue;
                if (JViewer.isKVMReconnectEnabled() && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPING && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPED && JViewerApp.getInstance().getRetryConnection()) {
                    Debug.out.println("\n Harddisk redierction thread returned .because of KVM Reconnect in progress\n");
                    return;
                }
                Object object = HarddiskRedir.getSyncObj();
                synchronized (object) {
                    try {
                        if (!this.confModified) {
                            HarddiskRedir.getSyncObj().wait(10000L);
                            if (this.hdStoppedByUser) {
                                return;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                if (!this.confModified) {
                    VMApp.getInstance().getIUSBRedirSession().setHDStopMode(5, this.HDDevice_no);
                } else {
                    this.confModified = false;
                }
                this.stopRedirectionAbnormal();
                return;
            }
        }
    }

    public String[] getEntireHarddiskList() {
        int n;
        if (!this.physicalDevice) {
            this.DisplayErrorMsg("Cannot get Hard disk drive list during Hard disk IMAGE redirection");
            return null;
        }
        if (this.nativeReaderPointer == -1L) {
            this.newHarddiskReader(true);
        }
        String[] stringArray = this.listHardDrives();
        String[] stringArray2 = this.listHardDrivesFixed();
        String[] stringArray3 = null;
        if (stringArray != null && stringArray2 != null) {
            stringArray3 = new String[stringArray.length + stringArray2.length];
        } else if (stringArray2 == null) {
            stringArray3 = new String[stringArray.length];
        } else if (stringArray == null) {
            stringArray3 = new String[stringArray2.length];
        }
        int n2 = 0;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                stringArray3[n2] = stringArray[n];
                ++n2;
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray3[n2] = stringArray2[n];
                ++n2;
            }
        }
        return stringArray3;
    }

    public String[] getUSBHDDList() {
        String[] stringArray;
        block9: {
            block8: {
                if (!this.physicalDevice) {
                    this.DisplayErrorMsg("Cannot get Hard Disk drive list during hard disk IMAGE redirection");
                    return null;
                }
                if (this.nativeReaderPointer == -1L) {
                    this.newHarddiskReader(true);
                }
                if ((stringArray = this.listHardDrives()) == null) {
                    return stringArray;
                }
                PHYSICAL_DRIVE = LocaleStrings.getString("A_5_DP");
                LOGICAL_DRIVE = LocaleStrings.getString("A_6_DP");
                if (!System.getProperty("os.name").startsWith("Win")) break block8;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string;
                    String string2;
                    int n;
                    String string3 = stringArray[i];
                    String string4 = string3.substring(0, 1);
                    String string5 = string3.substring(2);
                    String string6 = "[";
                    for (n = 0; n < string5.length() - 1; ++n) {
                        string6 = string6 + string5.charAt(n) + "-";
                    }
                    if (string5.charAt(n) == 'l') {
                        string6 = string6.substring(0, string6.length() - 1);
                        string6 = string6 + "]";
                        string2 = LOGICAL_DRIVE;
                    } else {
                        string6 = string6 + string5.charAt(n) + "]";
                        string2 = PHYSICAL_DRIVE;
                    }
                    stringArray[i] = string = string2.concat("-").concat(string4).concat("-").concat(string6);
                }
                break block9;
            }
            if (!System.getProperty("os.name").equals("Linux")) break block9;
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                String string7 = stringArray[i];
                stringArray[i] = string = string7.substring(0, string7.length() - 1);
            }
        }
        return stringArray;
    }

    public String[] getHarddiskFixedList() {
        String[] stringArray;
        block9: {
            block8: {
                if (!this.physicalDevice) {
                    this.DisplayErrorMsg("Cannot get hard disk drive list during Hard disk IMAGE redirection");
                    return null;
                }
                if (this.nativeReaderPointer == -1L) {
                    this.newHarddiskReader(true);
                }
                if ((stringArray = this.listHardDrivesFixed()) == null) {
                    return null;
                }
                PHYSICAL_DRIVE = LocaleStrings.getString("A_5_DP");
                LOGICAL_DRIVE = LocaleStrings.getString("A_6_DP");
                if (!System.getProperty("os.name").startsWith("Win")) break block8;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string;
                    String string2;
                    int n;
                    String string3 = stringArray[i];
                    String string4 = string3.substring(0, 1);
                    String string5 = string3.substring(2);
                    String string6 = "[";
                    for (n = 0; n < string5.length() - 1; ++n) {
                        string6 = string6 + string5.charAt(n) + "-";
                    }
                    if (string5.charAt(n) == 'l') {
                        string6 = string6.substring(0, string6.length() - 1);
                        string6 = string6 + "]";
                        string2 = LOGICAL_DRIVE;
                    } else {
                        string6 = string6 + string5.charAt(n) + "]";
                        string2 = PHYSICAL_DRIVE;
                    }
                    stringArray[i] = string = string2.concat("-").concat(string4).concat("-").concat(string6);
                }
                break block9;
            }
            if (!System.getProperty("os.name").equals("Linux")) break block9;
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                String string7 = stringArray[i];
                stringArray[i] = string = string7.substring(0, string7.length() - 1);
            }
        }
        return stringArray;
    }

    public String getLIBHARDDISKVersion() {
        String string;
        if (this.nativeReaderPointer == -1L) {
            this.newHarddiskReader(false);
            string = this.getVersion();
            this.deleteHarddiskReader();
        } else {
            string = this.getVersion();
        }
        return string;
    }

    public void DisplayErrorMsg(String string) {
        if (JViewer.isVMApp()) {
            VMApp.getInstance().generalErrorMessage(LocaleStrings.getString("4_16_CDROMREDIR"), string);
        } else {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage(LocaleStrings.getString("4_16_CDROMREDIR"), string);
        }
    }

    public void handleError(String string) {
        this.DisplayErrorMsg(string);
    }

    public boolean isPhysicalDevice() {
        return this.physicalDevice;
    }

    public void SendAuth_SessionToken(String string) throws RedirectionException, IOException {
        int n = 0;
        int n2 = JViewerApp.getInstance().getSessionTokenType();
        if (n2 == 0) {
            n = 128;
            this.packetWriteBuffer.clear();
            this.packetWriteBuffer.limit(160);
        } else if (n2 == 1) {
            n = 240;
            this.packetWriteBuffer.clear();
            this.packetWriteBuffer.limit(272);
        }
        IUSBHeader iUSBHeader = new IUSBHeader(n);
        iUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(string.getBytes());
        this.packetWriteBuffer.position(22);
        this.packetWriteBuffer.put((byte)this.getDrive_Type());
        this.packetWriteBuffer.put((byte)this.HDDevice_no);
        this.packetWriteBuffer.position(0);
        IUSBSCSI iUSBSCSI = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(iUSBSCSI);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    public int getDrive_Type() {
        Debug.out.println("GEt DRIVE TYPE:" + this.Drive_Type);
        return this.Drive_Type;
    }

    public static Object getSyncObj() {
        return syncObj;
    }

    public boolean isConfModified() {
        return this.confModified;
    }

    public void setConfModified(boolean bl) {
        this.confModified = bl;
    }

    public void setDrive_Type(int n) {
        this.Drive_Type = n;
    }

    public int getHdInstanceNum() {
        return this.hdInstanceNum;
    }

    public boolean isHdImageRedirected() {
        return this.hdImageRedirected;
    }

    public void setHdImageRedirected(boolean bl) {
        this.hdImageRedirected = bl;
    }

    public boolean isHdImageEjected() {
        return this.hdImageEjected;
    }

    public boolean isHdRedirectionKilled() {
        return this.hdRedirectionKilled;
    }

    public void setHdReconnect(boolean bl) {
        this.hdReconnect = bl;
    }

    public boolean getHdReconnect() {
        return this.hdReconnect;
    }

    public boolean isHdStoppedByUser() {
        return this.hdStoppedByUser;
    }

    public void setHdStoppedByUser(boolean bl) {
        this.hdStoppedByUser = bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setHdRedirectionKilled(boolean bl) {
        this.hdRedirectionKilled = bl;
    }

    public int getHarddiskRedirStatus() {
        return this.harddiskRedirStatus;
    }

    public void setHarddiskRedirStatus(int n) {
        this.harddiskRedirStatus = n;
    }

    public int getHardDiskDeviceStatus() {
        return this.hardDiskDeviceStatus;
    }

    public void setHardDiskDeviceStatus(int n) {
        this.hardDiskDeviceStatus = n;
    }

    public int getHdStopMode() {
        return this.hdStopMode;
    }

    public void setHdStopMode(int n) {
        this.hdStopMode = n;
    }

    public boolean isHdServiceRestarted() {
        return this.hdServiceRestarted;
    }

    private static void showLibraryLoadError() {
        if (JViewer.isVMApp() || JViewer.isStandalone()) {
            JOptionPane.showMessageDialog(VMApp.getVMFrame(), LocaleStrings.getString("6_53_IUSBREDIR"), LocaleStrings.getString("1_3_JVIEWER"), 0);
            VMApp.exit(0);
        }
    }

    static {
        try {
            if (!JViewer.isdownloadapp() && !JViewer.isplayerapp()) {
                if (JViewer.isjviewerapp()) {
                    System.loadLibrary("javaharddiskwrapper");
                } else {
                    HarddiskRedir.loadWrapperLibrary();
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(LocaleStrings.getString("AB_2_HDREDIR"));
        }
    }
}

