/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.HarddiskRedir;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;

public class IUSBRedirSession {
    public static final byte AUTH_USER_PKT_SIZE = 98;
    public static final short WEB_AUTH_PKT_MAX_SIZE = 98;
    public static final short SSI_AUTH_PKT_MAX_SIZE = 210;
    public static final int DEVICE_REDIR_STATUS_IDLE = 0;
    public static final int DEVICE_REDIR_STATUS_CONNECTED = 1;
    public static final int JVIEWER = 2;
    public static final int VMAPP = 4;
    public static final int MAX_IMAGE_LENGTH = 256;
    public static final int DEVICE_INFO_MAX_SIZE = 260;
    public static final byte STOP_NORMAL = 0;
    public static final byte STOP_ON_EJECT = 1;
    public static final byte STOP_ON_TERMINATE = 2;
    public static final byte STOP_ON_DEVICE_REMOVAL = 3;
    public static final byte STOP_ON_SERVER_RESTART = 4;
    public static final byte STOP_ON_CONNECTION_LOSS = 5;
    public static final byte STOP_PORT_NOT_IN_LISTEN = 6;
    public static final byte DEVICE_USED = 0;
    public static final byte DEVICE_FREE = 1;
    public static final int CONNECTION_ACCEPTED = 1;
    public static final int CONNECTION_PERM_DENIED = 5;
    public static final int CONNECTION_INVALID_SESSION_TOKEN = 3;
    public static final int CONNECTION_MAX_USER = 8;
    public static final int LICENSE_EXPIRED = 13;
    public static final int LINUX_DRIVE_TYPE_USB = 0;
    public static final int LINUX_DRIVE_TYPE_HDD = 1;
    public static final int WINDOWS_DRIVE_TYPE_USB = 2;
    public static final int WINDOWS_DRIVE_TYPE_HDD = 3;
    public static final byte MEDIA_TYPE_HDD = 0;
    public static final byte MEDIA_TYPE_USB = -128;
    public CDROMRedir[] cdromSession;
    public HarddiskRedir[] hardDiskSession;
    private boolean cdButtonRedirState = false;
    private boolean hdButtonRedirState = false;
    private JTable statusTable;
    private JTable devStatusTable;
    private final int BYTES_READ_COL = 3;

    public IUSBRedirSession() {
        int n = 0;
        int n2 = 0;
        n = VMApp.getInstance().getNumCD();
        n2 = VMApp.getInstance().getNumHD();
        this.cdromSession = new CDROMRedir[n];
        this.hardDiskSession = new HarddiskRedir[n2];
    }

    public boolean StartCDROMRedir(String string, int n, int n2, boolean bl, String string2) {
        String string3 = JViewer.getIp();
        if (string3 == null) {
            this.showErrorMessage(LocaleStrings.getString("6_6_IUSBREDIR"), LocaleStrings.getString("6_1_IUSBREDIR") + LocaleStrings.getString("6_6_IUSBREDIR"));
            return false;
        }
        if (string2.length() == 0) {
            this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_2_IUSBREDIR") + LocaleStrings.getString("6_6_IUSBREDIR"));
            return false;
        }
        try {
            if (this.cdromSession[n2] != null) {
                if (this.cdromSession[n2].isRedirActive()) {
                    this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_3_IUSBREDIR"));
                    return false;
                }
                this.cdromSession[n2] = null;
                System.gc();
            }
            this.cdromSession[n2] = new CDROMRedir(true);
            if (!this.cdromSession[n2].startRedirection(string3, string2, n2, string, n, bl)) {
                if (this.cdromSession[n2].getErrorMessage() == null && this.cdromSession[n2].getErrorMessage().length() == 0) {
                    this.showErrorMessage(LocaleStrings.getString("6_6_IUSBREDIR"), LocaleStrings.getString("6_4_IUSBREDIR"));
                } else if (this.cdromSession[n2].getErrorMessage() != " ") {
                    this.showErrorMessage(LocaleStrings.getString("6_6_IUSBREDIR"), this.cdromSession[n2].getErrorMessage());
                }
                this.cdromSession[n2].setErrorMessage(" ");
                this.StopCDROMRedir(n2, 0);
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.showErrorMessage(LocaleStrings.getString("6_6_IUSBREDIR"), LocaleStrings.getString("6_5_IUSBREDIR"));
            this.StopCDROMRedir(n2, 0);
            return false;
        }
        catch (RedirectionException redirectionException) {
            this.showErrorMessage(LocaleStrings.getString("6_6_IUSBREDIR"), redirectionException.getMessage());
            this.StopCDROMRedir(n2, 0);
            return false;
        }
        catch (Exception exception) {
            this.showErrorMessage(LocaleStrings.getString("6_6_IUSBREDIR"), exception.getMessage());
            this.StopCDROMRedir(n2, 0);
            return false;
        }
        return true;
    }

    public boolean StopCDROMRedir(int n, int n2) {
        int n3 = 0;
        if (this.cdromSession[n] != null) {
            if (!this.cdromSession[n].stopRedirection()) {
                this.showErrorMessage(LocaleStrings.getString("6_33_IUSBREDIR"), LocaleStrings.getString("6_7_IUSBREDIR"));
                return false;
            }
            if (this.cdromSession[n].getCdReconnect()) {
                return true;
            }
            n3 = this.cdromSession[n].getCdStopMode();
            if (n3 != 6) {
                this.setCDStopMode(n2, n);
            }
            this.cdromSession[n] = null;
            System.gc();
        }
        return true;
    }

    public boolean StartISORedir(String string, int n, int n2, boolean bl, String string2) {
        String string3 = JViewer.getIp();
        if (string3 == null) {
            this.showErrorMessage(LocaleStrings.getString("6_8_IUSBREDIR"), LocaleStrings.getString("6_1_IUSBREDIR") + LocaleStrings.getString("6_8_IUSBREDIR"));
            return false;
        }
        if (string2.length() == 0) {
            this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_9_IUSBREDIR") + LocaleStrings.getString("6_8_IUSBREDIR"));
            return false;
        }
        if (!string2.toLowerCase().endsWith(".iso") && !string2.toLowerCase().endsWith(".nrg")) {
            this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_9_IUSBREDIR") + LocaleStrings.getString("6_49_IUSBREDIR"));
            return false;
        }
        try {
            if (this.cdromSession[n2] != null) {
                if (this.cdromSession[n2].isRedirActive()) {
                    this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_3_IUSBREDIR"));
                    return false;
                }
                this.cdromSession[n2] = null;
                System.gc();
            }
            this.cdromSession[n2] = new CDROMRedir(false);
            if (!this.cdromSession[n2].startRedirection(string3, string2, n2, string, n, bl)) {
                if (this.cdromSession[n2].getErrorMessage() == null && this.cdromSession[n2].getErrorMessage().length() == 0) {
                    this.showErrorMessage(LocaleStrings.getString("6_8_IUSBREDIR"), LocaleStrings.getString("6_11_IUSBREDIR"));
                } else if (this.cdromSession[n2].getErrorMessage() != " ") {
                    this.showErrorMessage(LocaleStrings.getString("6_8_IUSBREDIR"), this.cdromSession[n2].getErrorMessage());
                }
                this.cdromSession[n2].setErrorMessage(" ");
                this.StopISORedir(n2, 0);
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.showErrorMessage(LocaleStrings.getString("6_8_IUBREDIR"), LocaleStrings.getString("6_12_IUSBREDIR"));
            this.StopISORedir(n2, 0);
            return false;
        }
        catch (RedirectionException redirectionException) {
            this.showErrorMessage(LocaleStrings.getString("6_8_IUSBREDIR"), redirectionException.getMessage());
            this.StopISORedir(n2, 0);
            return false;
        }
        catch (Exception exception) {
            this.showErrorMessage(LocaleStrings.getString("6_8_IUSBREDIR"), exception.getMessage());
            this.StopISORedir(n2, 0);
            return false;
        }
        return true;
    }

    public boolean StopISORedir(int n, int n2) {
        return this.StopCDROMRedir(n, n2);
    }

    public boolean StartHarddiskRedir(String string, int n, int n2, boolean bl, String string2, byte by) {
        String string3 = JViewer.getIp();
        if (string3 == null) {
            this.showErrorMessage(LocaleStrings.getString("6_13_IUSBREDIR"), LocaleStrings.getString("6_1_IUSBREDIR"));
            return false;
        }
        if (string2.length() == 0) {
            this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_14_IUSBREDIR") + LocaleStrings.getString("6_13_IUSBREDIR"));
            return false;
        }
        try {
            if (this.hardDiskSession[n2] != null) {
                if (this.hardDiskSession[n2].isRedirActive()) {
                    this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_15_IUSBREDIR"));
                    return false;
                }
                this.hardDiskSession[n2] = null;
                System.gc();
            }
            this.hardDiskSession[n2] = new HarddiskRedir(true);
            this.hardDiskSession[n2].setDrive_Type(by);
            if (!this.hardDiskSession[n2].startRedirection(string3, string2, n2, string, n, bl)) {
                if (this.hardDiskSession[n2].getErrorMessage() == null && this.hardDiskSession[n2].getErrorMessage().length() == 0) {
                    this.showErrorMessage(LocaleStrings.getString("6_13_IUSBREDIR"), LocaleStrings.getString("6_16_IUSBREDIR"));
                } else if (this.hardDiskSession[n2].getErrorMessage() != " ") {
                    this.showErrorMessage(LocaleStrings.getString("6_13_IUSBREDIR"), this.hardDiskSession[n2].getErrorMessage());
                }
                this.hardDiskSession[n2].setErrorMessage(" ");
                this.StopHarddiskRedir(n2, 0);
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.out.println(unsatisfiedLinkError);
            this.showErrorMessage(LocaleStrings.getString("6_13_IUSBREDIR"), LocaleStrings.getString("6_17_IUSBREDIR"));
            this.StopHarddiskRedir(n2, 0);
            return false;
        }
        catch (RedirectionException redirectionException) {
            this.showErrorMessage(LocaleStrings.getString("6_13_IUSBREDIR"), redirectionException.getMessage());
            this.StopHarddiskRedir(n2, 0);
            return false;
        }
        return true;
    }

    public boolean StopHarddiskRedir(int n, int n2) {
        int n3 = 0;
        if (this.hardDiskSession[n] != null) {
            if (!this.hardDiskSession[n].stopRedirection()) {
                this.showErrorMessage(LocaleStrings.getString("6_34_IUSBREDIR"), LocaleStrings.getString("6_36_IUSBREDIR"));
                return false;
            }
            if (this.hardDiskSession[n].getHdReconnect()) {
                return true;
            }
            n3 = this.hardDiskSession[n].getHdStopMode();
            if (n3 != 6) {
                this.setHDStopMode(n2, n);
            }
            this.hardDiskSession[n] = null;
            System.gc();
        }
        return true;
    }

    public boolean StartharddiskImageRedir(String string, int n, int n2, boolean bl, String string2, byte by) {
        String string3 = JViewer.getIp();
        if (string3 == null) {
            this.showErrorMessage(LocaleStrings.getString("6_27_IUSBREDIR"), LocaleStrings.getString("6_1_IUSBREDIR"));
            return false;
        }
        if (string2.length() == 0) {
            this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_9_IUSBREDIR") + LocaleStrings.getString("6_27_IUSBREDIR"));
            return false;
        }
        if (!string2.toLowerCase().endsWith(".img") && !string2.toLowerCase().endsWith(".ima")) {
            this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_9_IUSBREDIR") + LocaleStrings.getString("6_51_IUSBREDIR"));
            return false;
        }
        try {
            if (this.hardDiskSession[n2] != null) {
                if (this.hardDiskSession[n2].isRedirActive()) {
                    this.showErrorMessage(LocaleStrings.getString("6_32_IUSBREDIR"), LocaleStrings.getString("6_28_IUSBREDIR"));
                    return false;
                }
                this.hardDiskSession[n2] = null;
                System.gc();
            }
            this.hardDiskSession[n2] = new HarddiskRedir(false);
            this.hardDiskSession[n2].setDrive_Type(by);
            if (!this.hardDiskSession[n2].startRedirection(string3, string2, n2, string, n, bl)) {
                if (this.hardDiskSession[n2].getErrorMessage() == null && this.hardDiskSession[n2].getErrorMessage().length() == 0) {
                    this.showErrorMessage(LocaleStrings.getString("6_27_IUSBREDIR"), LocaleStrings.getString("6_29_IUSBREDIR"));
                } else if (this.hardDiskSession[n2].getErrorMessage() != " ") {
                    this.showErrorMessage(LocaleStrings.getString("6_27_IUSBREDIR"), this.hardDiskSession[n2].getErrorMessage());
                }
                this.hardDiskSession[n2].setErrorMessage(" ");
                this.StopHarddiskImageRedir(n2, 0);
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.showErrorMessage(LocaleStrings.getString("6_27_IUSBREDIR"), LocaleStrings.getString("6_30_IUSBREDIR"));
            this.StopHarddiskImageRedir(n2, 0);
            return false;
        }
        catch (RedirectionException redirectionException) {
            this.showErrorMessage(LocaleStrings.getString("6_27_IUSBREDIR"), redirectionException.getMessage());
            this.StopHarddiskImageRedir(n2, 0);
            return false;
        }
        return true;
    }

    public boolean startDeviceRedirection(int n, String string, int n2, int n3, boolean bl, String string2, boolean bl2) {
        boolean bl3 = false;
        switch (n) {
            case 0: {
                if (bl2) {
                    bl3 = this.StartCDROMRedir(string, n2, n3, bl, string2);
                    break;
                }
                bl3 = this.StartISORedir(string, n2, n3, bl, string2);
                break;
            }
            case 2: {
                if (bl2) {
                    byte by = this.getMediaType(string2);
                    bl3 = this.StartHarddiskRedir(string, n2, n3, bl, string2, by);
                    break;
                }
                byte by = -128;
                bl3 = this.StartharddiskImageRedir(string, n2, n3, bl, string2, by);
            }
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopDeviceRedirection(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        switch (n) {
            case 0: {
                Object object = CDROMRedir.getSyncObj();
                synchronized (object) {
                    CDROMRedir.getSyncObj().notify();
                }
                this.StopCDROMRedir(n2, n3);
                break;
            }
            case 2: {
                Object object = HarddiskRedir.getSyncObj();
                synchronized (object) {
                    HarddiskRedir.getSyncObj().notify();
                }
                this.StopHarddiskRedir(n2, n3);
            }
        }
        return bl;
    }

    public boolean StopHarddiskImageRedir(int n, int n2) {
        return this.StopHarddiskRedir(n, n2);
    }

    public String getLIBCDROMVersion(int n) {
        String string;
        try {
            if (this.cdromSession[n] == null) {
                this.cdromSession[n] = new CDROMRedir(false);
                string = this.cdromSession[n].getLIBCDROMVersion();
                this.cdromSession[n] = null;
                System.gc();
            } else {
                string = this.cdromSession[n].getLIBCDROMVersion();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            string = LocaleStrings.getString("6_31_IUSBREDIR");
        }
        return string;
    }

    public String cdImageSelector(String string) {
        JVFrame jVFrame = JViewerApp.getInstance().getMainWindow();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileFilter(new CDImageFilter());
        if (jFileChooser.showOpenDialog(jVFrame) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public boolean isCDROMPhysicalDrive(int n) {
        return this.cdromSession[n] != null && this.cdromSession[n].isPhysicalDevice();
    }

    public boolean isHarddiskPhysicalDrive(int n) {
        return this.hardDiskSession[n] != null && this.hardDiskSession[n].isPhysicalDevice();
    }

    public String floppyImageSelector(String string) {
        JVFrame jVFrame = JViewerApp.getInstance().getMainWindow();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileFilter(new FloppyImageFilter());
        if (jFileChooser.showOpenDialog(jVFrame) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public void stopCDROMAbnormal(int n) {
        try {
            System.gc();
            this.cdromSession[n].setCdromRedirStatus(0);
            this.cdromSession[n] = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.gc();
            Debug.out.println(arrayIndexOutOfBoundsException);
        }
    }

    public void stopHarddiskAbnormal(int n) {
        try {
            System.gc();
            this.hardDiskSession[n].setHarddiskRedirStatus(0);
            this.hardDiskSession[n] = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.gc();
            Debug.out.println(arrayIndexOutOfBoundsException);
        }
    }

    public int getCDROMRedirStatus(int n) {
        int n2 = 0;
        try {
            if (this.cdromSession[n] != null) {
                n2 = this.cdromSession[n].getCdromRedirStatus();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.out.println(arrayIndexOutOfBoundsException);
            n2 = 0;
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n2 = 0;
        }
        return n2;
    }

    public int getHarddiskRedirStatus(int n) {
        int n2 = 0;
        try {
            if (this.hardDiskSession[n] != null) {
                n2 = this.hardDiskSession[n].getHarddiskRedirStatus();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.out.println(arrayIndexOutOfBoundsException);
            n2 = 0;
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n2 = 0;
        }
        return n2;
    }

    public int getDeviceRedirStatus(int n, int n2) {
        int n3 = 0;
        try {
            switch (n) {
                case 0: {
                    n3 = this.getCDROMRedirStatus(n2);
                    break;
                }
                case 2: {
                    n3 = this.getHarddiskRedirStatus(n2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.out.println(arrayIndexOutOfBoundsException);
            n3 = 0;
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n3 = 0;
        }
        return n3;
    }

    public String getCDROMSource(int n) {
        if (this.cdromSession[n] != null) {
            return this.cdromSession[n].getSourceDrive();
        }
        return new String("");
    }

    public String getHarddiskSource(int n) {
        if (this.hardDiskSession[n] != null) {
            return this.hardDiskSession[n].getSourceDrive();
        }
        return new String("");
    }

    public String getDeviceRedirSource(int n, int n2) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.getCDROMSource(n2);
                break;
            }
            case 2: {
                string = this.getHarddiskSource(n2);
            }
        }
        return string;
    }

    public int getCDROMReadBytes(int n) {
        if (this.cdromSession[n] != null) {
            return this.cdromSession[n].getBytesRedirected();
        }
        return 0;
    }

    public int getHarddiskReadBytes(int n) {
        if (this.hardDiskSession[n] != null) {
            return this.hardDiskSession[n].getBytesRedirected();
        }
        return 0;
    }

    public boolean isImageRedirected(int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = this.getCdromSession(n2).isCdImageRedirected();
                break;
            }
            case 2: {
                bl = this.getHarddiskSession(n2).isHdImageRedirected();
            }
        }
        return bl;
    }

    public void setImageRedirected(int n, int n2, boolean bl) {
        switch (n) {
            case 0: {
                this.getCdromSession(n2).setCdImageRedirected(bl);
                break;
            }
            case 2: {
                this.getHarddiskSession(n2).setHdImageRedirected(bl);
            }
        }
    }

    public CDROMRedir getCdromSession(int n) {
        CDROMRedir cDROMRedir = null;
        if (n < this.cdromSession.length) {
            cDROMRedir = this.cdromSession[n];
        }
        return cDROMRedir;
    }

    public void setCdromSession(CDROMRedir cDROMRedir, int n) {
        this.cdromSession[n] = cDROMRedir;
    }

    public HarddiskRedir getHarddiskSession(int n) {
        HarddiskRedir harddiskRedir = null;
        if (n < this.hardDiskSession.length) {
            harddiskRedir = this.hardDiskSession[n];
        }
        return harddiskRedir;
    }

    public void setHarddiskSession(HarddiskRedir harddiskRedir, int n) {
        this.hardDiskSession[n] = harddiskRedir;
    }

    public int getCDInstanceNumber(int n) {
        return this.cdromSession[n].getCdInstanceNum();
    }

    public int getHDInstanceNumber(int n) {
        return this.hardDiskSession[n].getHdInstanceNum();
    }

    public int getDeviceInstanceNumber(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 = this.getCDInstanceNumber(n2);
                break;
            }
            case 2: {
                n3 = this.getHDInstanceNumber(n2);
            }
        }
        return n3;
    }

    public void updateCDToolbarButtonStatus(boolean bl) {
        if (bl != this.cdButtonRedirState) {
            if (bl) {
                URL uRL = JViewer.class.getResource("res/CDR.png");
                JViewerApp.getInstance().getM_wndFrame().getToolbar().getCDBtn().setIcon(new ImageIcon(uRL));
                JViewerApp.getInstance().getM_wndFrame().getToolbar().getCDBtn().setToolTipText(LocaleStrings.getString("G_21_VMD"));
                this.cdButtonRedirState = true;
            } else {
                URL uRL = JViewer.class.getResource("res/CD.png");
                JViewerApp.getInstance().getM_wndFrame().getToolbar().getCDBtn().setIcon(new ImageIcon(uRL));
                JViewerApp.getInstance().getM_wndFrame().getToolbar().getCDBtn().setToolTipText(LocaleStrings.getString("G_20_VMD"));
                this.cdButtonRedirState = false;
            }
        }
    }

    public void updateHDToolbarButtonStatus(boolean bl) {
        if (bl != this.hdButtonRedirState) {
            if (bl) {
                URL uRL = JViewer.class.getResource("res/HDR.png");
                JViewerApp.getInstance().getM_wndFrame().getToolbar().getHardddiskBtn().setIcon(new ImageIcon(uRL));
                JViewerApp.getInstance().getM_wndFrame().getToolbar().getHardddiskBtn().setToolTipText(LocaleStrings.getString("G_25_VMD"));
                this.hdButtonRedirState = true;
            } else {
                URL uRL = JViewer.class.getResource("res/HD.png");
                JViewerApp.getInstance().getM_wndFrame().getToolbar().getHardddiskBtn().setIcon(new ImageIcon(uRL));
                JViewerApp.getInstance().getM_wndFrame().getToolbar().getHardddiskBtn().setToolTipText(LocaleStrings.getString("G_24_VMD"));
                this.hdButtonRedirState = false;
            }
        }
    }

    public int getCDROMDeviceStatus(int n) {
        int n2 = 1;
        try {
            if (this.cdromSession[n] != null) {
                n2 = this.cdromSession[n].getCdROMDeviceStatus();
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n2 = 1;
        }
        return n2;
    }

    public void setCDROMDeviceStatus(int n, int n2) {
        try {
            this.cdromSession[n].setCdROMDeviceStatus(n2);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
    }

    public int getHardDiskDeviceStatus(int n) {
        int n2 = 1;
        try {
            if (this.hardDiskSession[n] != null) {
                n2 = this.hardDiskSession[n].getHardDiskDeviceStatus();
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n2 = 1;
        }
        return n2;
    }

    public void setHardDiskDeviceStatus(int n, int n2) {
        try {
            this.hardDiskSession[n].setHardDiskDeviceStatus(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDeviceStatus(int n, int n2) {
        int n3 = 1;
        switch (n) {
            case 0: {
                n3 = this.getCDROMDeviceStatus(n2);
                break;
            }
            case 2: {
                n3 = this.getHardDiskDeviceStatus(n2);
            }
        }
        return n3;
    }

    public void setDeviceStatus(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                this.setCDROMDeviceStatus(n2, n3);
                break;
            }
            case 2: {
                this.setHardDiskDeviceStatus(n2, n3);
            }
        }
    }

    public void setDeviceStopMode(int n, int n2, boolean bl) {
        switch (n) {
            case 0: {
                this.getCdromSession(n2).setCdStoppedByUser(bl);
                break;
            }
            case 2: {
                this.getHarddiskSession(n2).setHdStoppedByUser(bl);
            }
        }
    }

    public byte getMediaType(String string) {
        int n;
        block4: {
            String[] stringArray;
            block5: {
                n = 0;
                if (string == null) break block4;
                stringArray = this.getEntireHarddiskList();
                if (!System.getProperty("os.name").startsWith("Win")) break block5;
                String string2 = string.substring(string.indexOf(45) + 1, string.indexOf(91) - 1);
                int n2 = Integer.parseInt(string2);
                for (String string3 : stringArray) {
                    Debug.out.println("DRIVE : " + string3);
                    String string4 = string3.substring(0, 1);
                    int n3 = Integer.parseInt(string4);
                    if (n3 != n2) continue;
                    String string5 = string3.substring(1, 2);
                    int n4 = Integer.parseInt(string5);
                    if (n4 == 3) {
                        n = 0;
                        continue;
                    }
                    if (n4 != 2) continue;
                    n = -128;
                }
                break block4;
            }
            if (!System.getProperty("os.name").equals("Linux")) break block4;
            for (String string6 : stringArray) {
                String string7 = string6.substring(0, string6.length() - 1);
                String[] stringArray2 = string.split("-");
                String string8 = stringArray2[0].trim();
                Debug.out.println("string::" + string + "Drive_name::" + string7);
                Debug.out.println("COMPARED::" + string7.compareTo(string8));
                if (string7.compareTo(string8) != 0) continue;
                String string9 = string6.substring(string6.length() - 1, string6.length());
                int n5 = Integer.parseInt(string9);
                if (n5 == 1) {
                    n = 0;
                    continue;
                }
                if (n5 != 0) continue;
                n = -128;
            }
        }
        return (byte)n;
    }

    public String[] getEntireHarddiskList() {
        String[] stringArray = null;
        HarddiskRedir harddiskRedir = new HarddiskRedir(true);
        stringArray = harddiskRedir.getEntireHarddiskList();
        System.gc();
        return stringArray;
    }

    private void showErrorMessage(String string, String string2) {
        if (!JViewer.isVMApp()) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage(string, string2);
        } else {
            VMApp.getInstance().generalErrorMessage(string, string2);
        }
    }

    public int getCDStopMode(int n) {
        int n2;
        try {
            if (this.cdromSession[n] == null) {
                return 0;
            }
            n2 = this.cdromSession[n].getCdStopMode();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.out.println(arrayIndexOutOfBoundsException);
            arrayIndexOutOfBoundsException.printStackTrace();
            n2 = 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debug.out.println(exception);
            n2 = 0;
        }
        return n2;
    }

    public void setCDStopMode(int n, int n2) {
        try {
            this.cdromSession[n2].setCdStopMode(n);
            this.showStopStatus(0, n2, n);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            exception.printStackTrace();
            this.cdromSession[n2].setCdStopMode(0);
        }
    }

    public int getHDStopMode(int n) {
        int n2;
        try {
            if (this.hardDiskSession[n] == null) {
                return 0;
            }
            n2 = this.hardDiskSession[n].getHdStopMode();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.out.println(arrayIndexOutOfBoundsException);
            n2 = 0;
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n2 = 0;
        }
        return n2;
    }

    public void setHDStopMode(int n, int n2) {
        try {
            this.hardDiskSession[n2].setHdStopMode(n);
            this.showStopStatus(2, n2, n);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            this.hardDiskSession[n2].setHdStopMode(0);
        }
    }

    private void showStopStatus(int n, int n2, int n3) {
        if (n == 0) {
            this.statusTable = VMApp.getVMPane().getStatusTabPanel().getCDStatusTable().getStatusTable();
            this.devStatusTable = VMApp.getVMPane().getCDStatusTable();
        } else if (n == 2) {
            this.statusTable = VMApp.getVMPane().getStatusTabPanel().getHDStatusTable().getStatusTable();
            this.devStatusTable = VMApp.getVMPane().getHDStatusTable();
        } else {
            return;
        }
        if (n3 == 0) {
            this.statusTable.setValueAt(LocaleStrings.getString("AL_8_ST"), n2, 3);
            this.devStatusTable.setValueAt(LocaleStrings.getString("AL_8_ST"), n2, 3);
        } else if (n3 == 1) {
            this.statusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_10_ST") + "</b></font></html>", n2, 3);
            this.devStatusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_10_ST") + "</b></font></html>", n2, 3);
        } else if (n3 == 2) {
            this.statusTable.setValueAt("<html><font color=\"Red\"><font size =\"3\"><b>" + LocaleStrings.getString("AL_11_ST") + "</b></font></html>", n2, 3);
            this.devStatusTable.setValueAt("<html><font color=\"Red\"><font size =\"3\"><b>" + LocaleStrings.getString("AL_11_ST") + "</b></font></html>", n2, 3);
        } else if (n3 == 3) {
            this.statusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_12_ST") + "</b></font></html>", n2, 3);
            this.devStatusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_12_ST") + "</b></font></html>", n2, 3);
        } else if (n3 == 4) {
            this.statusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_13_ST") + "</b></font></html>", n2, 3);
            this.devStatusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_13_ST") + "</b></font></html>", n2, 3);
        } else if (n3 == 5) {
            this.statusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_14_ST") + "</b></font></html>", n2, 3);
            this.devStatusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_14_ST") + "</b></font></html>", n2, 3);
        } else if (n3 == 6) {
            this.statusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_15_ST") + "</b></font></html>", n2, 3);
            this.devStatusTable.setValueAt("<html><font color=\"Red\" font size =\"3\"><b>" + LocaleStrings.getString("AL_15_ST") + "</b></font></html>", n2, 3);
        }
    }

    class FloppyImageFilter
    extends FileFilter {
        FloppyImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.toLowerCase().endsWith(".img") || string.toLowerCase().endsWith(".ima") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "IMG(*.img, *.IMG), IMA(*.ima, *.IMA)";
        }
    }

    class CDImageFilter
    extends FileFilter {
        CDImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            boolean bl = false;
            if (new ISOImageFilter().accept(file) || new NRGImageFilter().accept(file)) {
                bl = true;
            }
            return bl;
        }

        @Override
        public String getDescription() {
            return "ISO(*.iso, *.ISO), NRG(*.nrg, *.NRG)";
        }
    }

    class NRGImageFilter
    extends FileFilter {
        NRGImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.toLowerCase().endsWith(".nrg") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.nrg; *.NRG";
        }
    }

    class ISOImageFilter
    extends FileFilter {
        ISOImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.toLowerCase().endsWith(".iso") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.iso; *.ISO";
        }
    }
}

