/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.isocaching;

import com.ami.kvm.isocaching.ReadAheadCache;
import com.ami.kvm.jviewer.Debug;
import java.util.NoSuchElementException;

public class CacheManager
extends Thread {
    public static final int MAX_FREE_BANKS_COUNT = 128;
    private ReadAheadCache readAheadCache = null;
    private int freeBankCount = 256;
    private boolean running = false;
    private boolean sortCache = false;
    private boolean cleanUpCache = false;

    public CacheManager(ReadAheadCache readAheadCache) {
        this.readAheadCache = readAheadCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            Object object = this.readAheadCache.getCacheLock();
            synchronized (object) {
                if (this.isCleanUpCache()) {
                    this.readAheadCache.setCacheLocked(true);
                    this.cleanUpCache();
                    this.readAheadCache.setCacheLocked(false);
                    this.readAheadCache.getCacheLock().notifyAll();
                    this.setCleanUpCache(false);
                }
                try {
                    this.readAheadCache.getCacheLock().wait();
                }
                catch (InterruptedException interruptedException) {
                    Debug.out.println(interruptedException);
                }
            }
        }
    }

    public void cleanUpCache() {
        int n;
        for (n = 0; n < 128 && this.readAheadCache.getSectorDataCache().size() > 0; ++n) {
            try {
                this.readAheadCache.getSectorDataCache().removeLast().getSectorKey();
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                Debug.out.println(noSuchElementException);
                break;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                break;
            }
        }
        this.setFreeBankCount(n);
        System.gc();
    }

    public void startThread() {
        this.running = true;
        this.start();
    }

    public void stopThread() {
        this.running = false;
    }

    public int getFreeBankCount() {
        return this.freeBankCount;
    }

    public void setFreeBankCount(int n) {
        this.freeBankCount = n;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isSortCache() {
        return this.sortCache;
    }

    public void setSortCache(boolean bl) {
        this.sortCache = bl;
    }

    public boolean isCleanUpCache() {
        return this.cleanUpCache;
    }

    public void setCleanUpCache(boolean bl) {
        this.cleanUpCache = bl;
    }
}

