/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.StandAloneConnectionDialog;
import com.ami.vmedia.VMApp;
import java.io.File;
import javax.swing.JOptionPane;

public class ClientConfig {
    private native String GetKeyboardName();

    private native byte GetLEDStatus();

    private native byte SetLEDStatus(byte var1);

    private native String getVersion();

    private static void loadWrapperLibrary() {
        String string = null;
        String string2 = JViewer.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if ((string2 = string2.substring(0, string2.lastIndexOf(47))).contains("%20")) {
            string2 = string2.replaceAll("%20", "\\ ");
        }
        String string3 = File.separator + "Jar" + File.separator + JViewer.getIp() + File.separator + "lib" + File.separator;
        File file = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string3 = StandAloneConnectionDialog.replaceAllPattern(string3, ":", "_");
                string = string2 + string3 + "javaclientconfwrapper.dll";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("javaclientconfwrapper.dll")) {
                    Debug.out.println("Unable to extract the javaclientconfwrapper.dll");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "javaclientconfwrapper.dll";
            }
        } else if (System.getProperty("os.name").startsWith("Linux")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string = string2 + string3 + "libjavaclientconfwrapper.so";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("libjavaclientconfwrapper.so")) {
                    Debug.out.println("Unable to extract the libjavaclientconfwrapper.so");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "libjavaclientconfwrapper.so";
            }
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
                string = string2 + string3 + "libjavaclientconfwrapper.jnilib";
                file = new File(string);
                if (!StandAloneConnectionDialog.getWrapperLibrary("libjavaclientconfwrapper.jnilib")) {
                    Debug.out.println("Unable to extract the libjavaclientconfwrapper.jnilib");
                    string = null;
                }
            } else {
                string = System.getProperty("user.dir") + string3 + "libjavaclientconfwrapper.jnilib";
            }
        }
        try {
            System.load(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.out.println(unsatisfiedLinkError);
            ClientConfig.showLibraryLoadError();
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            ClientConfig.showLibraryLoadError();
        }
    }

    public String getLIBVersion() {
        return this.getVersion();
    }

    public byte ReadKeybdLEDStatus() {
        byte by = 0;
        try {
            by = this.GetLEDStatus();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.out.println("UnsatisfiedLinkError");
            Debug.out.println(unsatisfiedLinkError);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        return by;
    }

    public void setKeyboardLEDStatus(byte by) {
        try {
            this.SetLEDStatus(by);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.out.println("UnsatisfiedLinkError");
            Debug.out.println(unsatisfiedLinkError);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
    }

    public String ReadKeybdType() {
        String string = null;
        try {
            string = this.GetKeyboardName();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.out.println("UnsatisfiedLinkError");
            Debug.out.println(unsatisfiedLinkError);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        return string;
    }

    private static void showLibraryLoadError() {
        if (JViewer.isVMApp()) {
            JOptionPane.showMessageDialog(VMApp.getVMFrame(), LocaleStrings.getString("5_3_CLIENTCFG"), LocaleStrings.getString("1_3_JVIEWER"), 0);
            VMApp.exit(0);
        } else {
            JOptionPane.showMessageDialog(JViewer.getMainFrame(), LocaleStrings.getString("5_3_CLIENTCFG"), LocaleStrings.getString("1_3_JVIEWER"), 0);
            if (JViewerApp.getInstance() != null) {
                if (JViewerApp.getInstance().getM_frame() != null) {
                    JViewerApp.getInstance().getM_frame().windowClosed();
                } else {
                    JViewer.exit(0);
                }
            }
        }
    }

    static {
        try {
            if (!JViewer.isdownloadapp() && !JViewer.isplayerapp()) {
                if (JViewer.isjviewerapp()) {
                    System.loadLibrary("javaclientconfwrapper");
                } else {
                    ClientConfig.loadWrapperLibrary();
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.out.println(LocaleStrings.getString("5_1_CLIENTCFG"));
        }
    }
}

