/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.videorecord.URLProcessor;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import javax.swing.JApplet;

public class WebPreviewer
extends JApplet
implements Runnable,
ActionListener {
    private byte[] m_frameBuf;
    private ByteBuffer m_frameByteBuf;
    private static final String SERVER_IP = "serverip";
    private static final String KVM_PORT = "kvmport";
    private static final String KVM_SECURE = "kvmsecure";
    private static final String WEB_PORT = "webport";
    private static final String SINGLE_PORT = "singleport";
    private static final String WEB_COOKIE = "webcookie";
    private static final String KVM_RECONN = "kvmreconnect";
    private static final String WEB_SECURE = "websecure";
    public static final byte BUTTON_WIDTH = 80;
    public static final byte BUTTON_HEIGHT = 20;
    private static final byte MSG_AREA_HEIGHT = 30;
    public static final byte RETRY_COUNT = 10;
    private static JViewerView m_view;
    private static byte retryCount;
    private int CatchSize = 0;
    private byte m_capStatus;
    private Thread paintTh;
    private boolean doPaint = false;
    byte[] ip;
    Button Capture1 = null;
    String serverip;
    int kvmport = 0;
    int kvmsecure = 0;
    int websecure = -1;
    int webport = 0;
    boolean useSSL = false;
    int kvmReconnect = 0;
    private Socket socket = null;
    private DataInputStream in = null;
    String webtok;
    int singlePort = -1;
    int contentLength = 0;
    String urlPath = null;
    URLProcessor processor = null;

    @Override
    public void init() {
        this.setLayout(null);
        this.setBackground(Color.black);
        JViewer.setApptype(this.getParameter("apptype").trim());
        JViewerApp.getInstance().getConnection().setWebSSLVerify(false);
        JViewerApp.getInstance().getConnection().setKvmSSLVerify(false);
        this.processor = new URLProcessor();
        if (JViewer.isWebPreviewer()) {
            this.Capture1 = new Button("Refresh");
        } else if (JViewer.isBSODViewer()) {
            this.Capture1 = new Button("Download");
        }
        if (this.Capture1 != null) {
            this.Capture1.setBounds(5, 5, 80, 20);
            this.Capture1.addActionListener(this);
            this.add(this.Capture1);
            this.Capture1.setEnabled(false);
        }
        m_view = JViewerApp.getInstance().getM_view();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            Dimension dimension = this.getSize();
            int n = 0;
            BufferedImage bufferedImage = JViewerApp.getInstance().getPrepare_buf().getM_image();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height - n);
            if (JViewer.isWebPreviewer()) {
                n = 30;
                graphics.setColor(Color.yellow);
                graphics.clearRect(0, 0, dimension.width, dimension.height);
                if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_FAILURE) {
                    graphics.drawString("Capture Failed", 90, 20);
                } else if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_IN_PROGRESS) {
                    graphics.drawString("Capturing....", 90, 20);
                } else if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CONNECT_FAILURE) {
                    n = 50;
                    graphics.drawString("Unable to connect to video server", 5, 40);
                } else if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_INVALID_SERVERIP) {
                    graphics.drawString("INVALID SERVER IP" + this.serverip, 90, 20);
                } else if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_HOST_POWER_OFF) {
                    n = 50;
                    graphics.drawString("Host is powered OFF or is in Sleep Mode", 5, 40);
                } else {
                    graphics.drawString(m_view.viewWidth() + " x " + m_view.viewHeight(), 90, 20);
                }
                rectangle = new Rectangle(0, 0, dimension.width, dimension.height - (n + 1));
            }
            BufferedImage bufferedImage2 = WebPreviewer.reduce(bufferedImage, dimension.width, dimension.height - n);
            Rectangle rectangle2 = rectangle.intersection(graphics.getClipBounds());
            BufferedImage bufferedImage3 = bufferedImage2.getSubimage(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            if (JViewer.isWebPreviewer()) {
                graphics.drawImage(bufferedImage3, rectangle2.x + 5, rectangle2.y + n, null);
            } else if (JViewer.isBSODViewer()) {
                graphics.drawImage(bufferedImage3, rectangle2.x, rectangle2.y, null);
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
    }

    public static BufferedImage reduce(BufferedImage bufferedImage, int n, int n2) {
        Image image = bufferedImage.getScaledInstance(n, n2, 16);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Override
    public void start() {
        if (this.paintTh == null) {
            this.paintTh = new Thread((Runnable)this, "paint");
            this.doPaint = true;
            this.paintTh.start();
        }
    }

    @Override
    public void stop() {
        this.doPaint = false;
        if (this.paintTh != null) {
            this.paintTh = null;
        }
    }

    @Override
    public void run() {
        while (this.doPaint) {
            if (JViewer.isWebPreviewer()) {
                this.startCapture();
                this.Capture1.setEnabled(true);
                this.mywait();
                continue;
            }
            if (!JViewer.isBSODViewer()) continue;
            this.captureBSOD();
            this.Capture1.setEnabled(true);
            this.mywait();
        }
    }

    public synchronized void mywait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            Debug.out.println(interruptedException);
        }
    }

    public synchronized void mynotifyAll() {
        this.notifyAll();
    }

    public void startCapture() {
        try {
            this.serverip = this.getParameter(SERVER_IP).trim();
            this.kvmport = Integer.parseInt(this.getParameter(KVM_PORT).trim());
            this.kvmsecure = Integer.parseInt(this.getParameter(KVM_SECURE).trim());
            this.webport = Integer.parseInt(this.getParameter(WEB_PORT).trim());
            this.webtok = this.getParameter(WEB_COOKIE).trim();
            this.singlePort = Integer.parseInt(this.getParameter(SINGLE_PORT).trim());
            this.kvmReconnect = Integer.parseInt(this.getParameter(KVM_RECONN).trim());
            this.websecure = Integer.parseInt(this.getParameter(WEB_SECURE).trim());
        }
        catch (NullPointerException nullPointerException) {
            Debug.out.println(nullPointerException);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.out.println(numberFormatException);
        }
        this.urlPath = this.websecure == 1 ? "https://" + this.serverip + ":" + this.webport + "/capture/webPreview.cap" : "http://" + this.serverip + ":" + this.webport + "/capture/webPreview.cap";
        this.processor.setUriString(this.urlPath);
        this.singlePort = Integer.parseInt(this.getParameter(SINGLE_PORT).trim());
        if (this.singlePort == 1) {
            JViewer.setSinglePortEnabled(true);
        } else {
            JViewer.setSinglePortEnabled(false);
        }
        if (this.kvmReconnect == 1) {
            JViewer.setKVMReconnectEnabled(true);
        } else {
            JViewer.setKVMReconnectEnabled(false);
        }
        this.ip = JViewer.getServerIP(this.serverip);
        if (this.serverip.compareTo("") == 0) {
            this.m_capStatus = JViewerApp.WEB_PREVIEWER_INVALID_SERVERIP;
        } else if (this.webport <= 0) {
            this.m_capStatus = JViewerApp.WEB_PREVIEWER_INVALID_WEBPORT;
        } else if (this.websecure <= -1) {
            this.m_capStatus = JViewerApp.WEB_PREVIEWER_INVALID_WEBSECURE;
        } else {
            if (this.kvmsecure == 1) {
                this.useSSL = true;
            }
            JViewer.setWebSessionToken(this.webtok);
            JViewerApp.getInstance().setWebPreviewerCaptureStatus(JViewerApp.WEB_PREVIEWER_CAPTURE_IN_PROGRESS);
            JViewerApp.getInstance().OnConnectToServer(this.serverip, this.kvmport, this.webport, "asdfa", this.useSSL, this.webtok);
            JViewerApp.getInstance().getKVMClient().setM_redirection(true);
            while (true) {
                this.m_capStatus = JViewerApp.getInstance().getWebPreviewerCaptureStatus();
                if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_SUCCESS || retryCount == 10 || this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_FAILURE || this.m_capStatus == JViewerApp.WEB_PREVIEWER_HOST_POWER_OFF) {
                    JViewerApp.getInstance().OnVideoStopRedirection();
                    break;
                }
                if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CONNECT_FAILURE) break;
                try {
                    retryCount = (byte)(retryCount + 1);
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Debug.out.println(interruptedException);
                }
            }
        }
        if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_FAILURE || this.m_capStatus == JViewerApp.WEB_PREVIEWER_CONNECT_FAILURE || this.m_capStatus == JViewerApp.WEB_PREVIEWER_INVALID_SERVERIP || this.m_capStatus == JViewerApp.WEB_PREVIEWER_HOST_POWER_OFF || this.m_capStatus == JViewerApp.WEB_PREVIEWER_INVALID_WEBPORT || this.m_capStatus == JViewerApp.WEB_PREVIEWER_INVALID_WEBSECURE) {
            retryCount = 0;
            this.Capture1.setEnabled(true);
            this.repaint();
            return;
        }
        this.getFrameImage();
    }

    private void captureBSOD() {
        try {
            this.serverip = this.getParameter(SERVER_IP).trim();
            this.webport = Integer.parseInt(this.getParameter(WEB_PORT).trim());
            this.websecure = Integer.parseInt(this.getParameter(WEB_SECURE).trim());
        }
        catch (NullPointerException nullPointerException) {
            Debug.out.println(nullPointerException);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.out.println(numberFormatException);
        }
        if (this.serverip.compareTo("") == 0 || this.webport <= 0 || this.websecure <= -1) {
            Debug.out.println("Invalid parameters");
            return;
        }
        this.urlPath = this.websecure == 1 ? "https://" + this.serverip + ":" + this.webport + "/bsod/crashscreen.cap" : "http://" + this.serverip + ":" + this.webport + "/bsod/crashscreen.cap";
        this.processor.setUriString(this.urlPath);
        this.ip = JViewer.getServerIP(this.serverip);
        JViewerApp.getInstance().OnConnectToServer(this.ip);
        this.getFrameImage();
    }

    private void getFrameImage() {
        try {
            this.socket = this.websecure == 1 ? JViewerApp.getInstance().getConnection().createSocket(InetAddress.getByName(JViewer.getIp()), this.webport, this.websecure) : JViewerApp.getInstance().getConnection().createSocket(InetAddress.getByName(JViewer.getIp()), this.webport, this.websecure);
            this.processor.writeRequestToSocket(this.socket, null);
            this.processor.getHTTPResponseHeader(this.socket.getInputStream());
            try {
                this.contentLength = Integer.parseInt(this.processor.getValueOf(new String(this.processor.getData()), "Content-Length:", '\r').trim());
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            this.in = new DataInputStream(this.socket.getInputStream());
            this.m_frameBuf = new byte[4608000];
            this.m_frameByteBuf = ByteBuffer.wrap(this.m_frameBuf);
            if (JViewer.isBSODViewer()) {
                JViewerApp.getSoc_manager().getSOCJVVideo().socreadframeattributes(this.in);
                JViewerApp.getSoc_manager().getSOCJVVideo().socreadframeattributes(this.in);
            }
            this.readFrameData();
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            this.repaint();
        }
        catch (Exception exception) {
            this.m_capStatus = JViewerApp.WEB_PREVIEWER_CONNECT_FAILURE;
            Debug.out.println(exception);
            this.repaint();
        }
    }

    private void readFrameData() {
        retryCount = 0;
        byte[] byArray = new byte[4096];
        int n = 0;
        this.CatchSize = 0;
        this.m_frameByteBuf.position(0);
        n = 0;
        try {
            while ((n = this.in.read(byArray)) > 0) {
                for (int i = 0; i < n; ++i) {
                    if (this.CatchSize + i >= this.m_frameBuf.length) continue;
                    this.m_frameBuf[this.CatchSize + i] = byArray[i];
                }
                if (this.CatchSize + n < this.m_frameBuf.length) {
                    this.CatchSize += n;
                }
                if (this.CatchSize < this.contentLength) continue;
            }
            this.in.close();
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
        }
        this.m_frameByteBuf.limit(this.CatchSize);
        this.m_frameByteBuf.position(this.CatchSize);
        JViewerApp.getInstance().getKVMClient().onNewFrame(this.m_frameByteBuf);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.Capture1) {
            if (this.Capture1.getLabel().equalsIgnoreCase("Refresh")) {
                this.Capture1.setEnabled(false);
                JViewerApp.getInstance().setWebPreviewerCaptureStatus(JViewerApp.WEB_PREVIEWER_CAPTURE_IN_PROGRESS);
                this.m_capStatus = JViewerApp.WEB_PREVIEWER_CAPTURE_IN_PROGRESS;
                this.repaint();
                this.mynotifyAll();
            } else if (this.Capture1.getLabel().equalsIgnoreCase("Download")) {
                this.Capture1.setEnabled(false);
                JViewerApp.getInstance().onVideoCaptureScreen();
                this.Capture1.setEnabled(true);
            }
        }
    }

    static {
        retryCount = 0;
    }
}

