/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.ClientConfig;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.hid.KeyProcessor;
import com.ami.kvm.jviewer.hid.USBKeyProcessorAZERTY;
import com.ami.kvm.jviewer.hid.USBKeyProcessorEnglish;
import com.ami.kvm.jviewer.hid.USBKeyProcessorJapaneseHost;
import com.ami.kvm.jviewer.hid.USBKeyProcessorQWERTY;
import com.ami.kvm.jviewer.hid.USBKeyProcessorQWERTZ;
import com.ami.kvm.jviewer.hid.USBKeyProcessorTurkishF;
import com.ami.kvm.jviewer.hid.USBKeyboardRep;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import java.awt.event.KeyEvent;
import java.util.HashMap;

public class AutoKeyboardLayout {
    public static final int KBD_TYPE_AUTO = 0;
    public static final int KBD_TYPE_FRENCH = 1036;
    public static final int KBD_TYPE_SPANISH = 1034;
    public static final int KBD_TYPE_GERMAN = 1031;
    public static final int KBD_TYPE_ENGLISH_US = 1033;
    public static final int KBD_TYPE_JAPANESE = 1041;
    public static final int KBD_TYPE_ENGLISH_UK = 2057;
    public static final int KBD_TYPE_GERMAN_SWISS = 2055;
    public static final int KBD_TYPE_FRENCH_BELGIUM = 2060;
    public static final int KBD_TYPE_ITALIAN = 1040;
    public static final int KBD_TYPE_DANISH = 1030;
    public static final int KBD_TYPE_FINNISH = 1035;
    public static final int KBD_TYPE_NORWEGIAN = 1044;
    public static final int KBD_TYPE_PORTUGUESE = 2070;
    public static final int KBD_TYPE_SWEDISH = 1053;
    public static final int KBD_TYPE_DUTCH_NL = 1043;
    public static final int KBD_TYPE_DUTCH_BE = 2067;
    public static final int KBD_TYPE_TURKISH_F = 66591;
    public static final int KBD_TYPE_TURKISH_Q = 1055;
    private KeyProcessor m_keyprocessor = null;
    private int keyboardType;
    public static boolean DEAD_FLAG = false;
    public static boolean SHIFT_FLAG = false;
    public static int SHIFT_KEY_POSITION = 0;
    public static boolean ALT_GR_FLAG = false;
    public static boolean PLUS_FLAG = false;
    public static boolean JAPANESE_FLAG = false;
    public HashMap<Integer, Integer> French_linuxMap;
    public HashMap<Integer, Integer> French_WinMap;
    public HashMap<Integer, Integer> French_Alt_gr_linuxMap;
    public HashMap<Integer, Integer> Spanish_Map;
    public HashMap<Integer, Integer> Spanish_Alt_gr_linuxMap;
    public HashMap<Integer, Integer> German_Map;
    public HashMap<Integer, Integer> German_Map_Alt_gr_linuxMap;
    public HashMap<Integer, Integer> German_Swiss_Map;
    public HashMap<Integer, Integer> French_Belgium_Map;
    private byte[] bdata;
    private int hostKeyboardType = 0;

    public AutoKeyboardLayout() {
        this.get_keybd_type();
        this.getHostKeyboardType();
        this.ongetKeyprocessor();
        JViewerApp.getInstance().getM_USBKeyRep().setM_USBKeyProcessor(this.ongetKeyprocessor());
        this.French_linuxMap = new HashMap();
        this.French_Alt_gr_linuxMap = new HashMap();
        this.French_WinMap = new HashMap();
        this.Spanish_Map = new HashMap();
        this.Spanish_Alt_gr_linuxMap = new HashMap();
        this.German_Map = new HashMap();
        this.German_Map_Alt_gr_linuxMap = new HashMap();
        this.German_Swiss_Map = new HashMap();
        this.French_Belgium_Map = new HashMap();
        this.French_WinMap.put(178, 192);
        this.French_WinMap.put(249, 222);
        this.French_WinMap.put(37, 222);
        this.French_linuxMap.put(339, 192);
        this.French_linuxMap.put(233, 50);
        this.French_linuxMap.put(50, 50);
        this.French_linuxMap.put(34, 51);
        this.French_linuxMap.put(51, 51);
        this.French_linuxMap.put(232, 55);
        this.French_linuxMap.put(55, 55);
        this.French_linuxMap.put(231, 57);
        this.French_linuxMap.put(57, 57);
        this.French_linuxMap.put(224, 48);
        this.French_linuxMap.put(48, 48);
        this.French_linuxMap.put(249, 52);
        this.French_linuxMap.put(37, 52);
        this.French_Alt_gr_linuxMap.put(38, 49);
        this.French_Alt_gr_linuxMap.put(126, 50);
        this.French_Alt_gr_linuxMap.put(35, 51);
        this.French_Alt_gr_linuxMap.put(123, 52);
        this.French_Alt_gr_linuxMap.put(91, 53);
        this.French_Alt_gr_linuxMap.put(124, 54);
        this.French_Alt_gr_linuxMap.put(96, 55);
        this.French_Alt_gr_linuxMap.put(92, 56);
        this.French_Alt_gr_linuxMap.put(94, 57);
        this.French_Alt_gr_linuxMap.put(64, 48);
        this.French_Alt_gr_linuxMap.put(93, 522);
        this.French_Alt_gr_linuxMap.put(125, 61);
        this.French_Alt_gr_linuxMap.put(164, 515);
        this.French_Alt_gr_linuxMap.put(8364, 69);
        this.Spanish_Map.put(170, 192);
        this.Spanish_Map.put(186, 192);
        this.Spanish_Map.put(92, 192);
        this.Spanish_Map.put(231, 92);
        this.Spanish_Map.put(199, 92);
        this.Spanish_Map.put(125, 92);
        this.Spanish_Map.put(241, 59);
        this.Spanish_Map.put(209, 59);
        this.Spanish_Alt_gr_linuxMap.put(92, 192);
        this.Spanish_Alt_gr_linuxMap.put(124, 49);
        this.Spanish_Alt_gr_linuxMap.put(64, 50);
        this.Spanish_Alt_gr_linuxMap.put(35, 51);
        this.Spanish_Alt_gr_linuxMap.put(126, 52);
        this.Spanish_Alt_gr_linuxMap.put(189, 53);
        this.Spanish_Alt_gr_linuxMap.put(172, 54);
        this.Spanish_Alt_gr_linuxMap.put(93, 93);
        this.Spanish_Alt_gr_linuxMap.put(123, 129);
        this.Spanish_Alt_gr_linuxMap.put(91, 91);
        this.Spanish_Alt_gr_linuxMap.put(8364, 53);
        this.Spanish_Alt_gr_linuxMap.put(125, 92);
        this.German_Map.put(223, 45);
        this.German_Map.put(63, 45);
        this.German_Map.put(92, 47);
        this.German_Map.put(252, 91);
        this.German_Map.put(220, 91);
        this.German_Map.put(246, 59);
        this.German_Map.put(214, 59);
        this.German_Map.put(228, 222);
        this.German_Map.put(196, 222);
        this.German_Map.put(130, 192);
        this.German_Map_Alt_gr_linuxMap.put(178, 50);
        this.German_Map_Alt_gr_linuxMap.put(179, 51);
        this.German_Map_Alt_gr_linuxMap.put(123, 55);
        this.German_Map_Alt_gr_linuxMap.put(91, 56);
        this.German_Map_Alt_gr_linuxMap.put(93, 57);
        this.German_Map_Alt_gr_linuxMap.put(125, 48);
        this.German_Map_Alt_gr_linuxMap.put(126, 521);
        this.German_Map_Alt_gr_linuxMap.put(181, 77);
        this.German_Map_Alt_gr_linuxMap.put(64, 81);
        this.German_Map_Alt_gr_linuxMap.put(8364, 69);
        this.German_Map_Alt_gr_linuxMap.put(92, 47);
        this.German_Map_Alt_gr_linuxMap.put(124, 153);
        this.German_Swiss_Map.put(167, 192);
        this.German_Swiss_Map.put(176, 192);
        this.German_Swiss_Map.put(39, 45);
        this.German_Swiss_Map.put(63, 45);
        this.German_Swiss_Map.put(252, 91);
        this.German_Swiss_Map.put(232, 91);
        this.German_Swiss_Map.put(246, 59);
        this.German_Swiss_Map.put(233, 59);
        this.German_Swiss_Map.put(228, 222);
        this.German_Swiss_Map.put(224, 222);
        this.German_Swiss_Map.put(45, 47);
        this.German_Swiss_Map.put(95, 47);
        this.French_Belgium_Map.put(178, 192);
        this.French_Belgium_Map.put(179, 192);
        this.French_Belgium_Map.put(249, 222);
        this.French_Belgium_Map.put(37, 222);
        this.French_Belgium_Map.put(181, 92);
        this.French_Belgium_Map.put(163, 92);
    }

    private void get_keybd_type() {
        String string = null;
        ClientConfig clientConfig = new ClientConfig();
        string = clientConfig.ReadKeybdType();
        Debug.out.println("Keybdtype" + string);
        String string2 = System.getProperty("os.name");
        Debug.out.println("Os_name" + string2);
        if (string2.equalsIgnoreCase("Linux")) {
            this.keyboardType = string.equalsIgnoreCase("US") ? 1033 : (string.equalsIgnoreCase("FR") ? 1036 : (string.equalsIgnoreCase("DE") ? 1031 : (string.equalsIgnoreCase("ES") ? 1034 : (string.equalsIgnoreCase("JP") ? 1041 : (string.equalsIgnoreCase("GB") ? 2057 : (string.equalsIgnoreCase("DE-CH") ? 2055 : (string.equalsIgnoreCase("FR-BE") ? 2060 : (string.equalsIgnoreCase("IT") ? 1040 : (string.equalsIgnoreCase("DA") ? 1030 : (string.equalsIgnoreCase("FI") ? 1035 : (string.equalsIgnoreCase("NO") ? 1044 : (string.equalsIgnoreCase("PT") ? 2070 : (string.equalsIgnoreCase("SV") ? 1053 : (string.equalsIgnoreCase("NL-NL") ? 1043 : (string.equalsIgnoreCase("NL-BE") ? 2067 : (string.equalsIgnoreCase("TR_F") ? 66591 : (string.equalsIgnoreCase("TR_Q") ? 1055 : 1033)))))))))))))))));
        } else {
            try {
                string = string.substring(string.length() - 5, string.length());
                this.keyboardType = Integer.parseInt(string, 16);
                Debug.out.println("JViewerView.KBD_TYPE" + this.keyboardType);
            }
            catch (Exception exception) {
                Debug.out.println("Unknown Language");
                Debug.out.println(exception);
            }
        }
    }

    private void getHostKeyboardType() {
        String string = JViewer.getKeyboardLayout();
        this.hostKeyboardType = string.equalsIgnoreCase("US") ? 1033 : (string.equalsIgnoreCase("FR") ? 1036 : (string.equalsIgnoreCase("DE") ? 1031 : (string.equalsIgnoreCase("ES") ? 1034 : (string.equalsIgnoreCase("JP") ? 1041 : (string.equalsIgnoreCase("GB") ? 2057 : (string.equalsIgnoreCase("DE-CH") ? 2055 : (string.equalsIgnoreCase("FR-BE") ? 2060 : (string.equalsIgnoreCase("IT") ? 1040 : (string.equalsIgnoreCase("DA") ? 1030 : (string.equalsIgnoreCase("FI") ? 1035 : (string.equalsIgnoreCase("NO") ? 1044 : (string.equalsIgnoreCase("PT") ? 2070 : (string.equalsIgnoreCase("SV") ? 1053 : (string.equalsIgnoreCase("NL-NL") ? 1043 : (string.equalsIgnoreCase("NL-BE") ? 2067 : (string.equalsIgnoreCase("TR_F") ? 66591 : (string.equalsIgnoreCase("TR_Q") ? 1055 : 0)))))))))))))))));
    }

    public int getKeyboardType() {
        this.get_keybd_type();
        return this.keyboardType;
    }

    public void setKeyboardType(int n) {
        if (this.keyboardType != n) {
            if (n == 0) {
                this.get_keybd_type();
            } else {
                this.keyboardType = n;
            }
            this.m_keyprocessor = null;
        }
    }

    public void setHostKeyboardType(int n) {
        if (this.hostKeyboardType != n) {
            this.hostKeyboardType = n;
            this.m_keyprocessor = null;
        }
    }

    public boolean OnkeyTyped(KeyEvent keyEvent) {
        int n = 0;
        char c = keyEvent.getKeyChar();
        switch (this.keyboardType) {
            case 1034: {
                if (keyEvent.getKeyLocation() != 4) {
                    n = this.getKeyboardKeycode(this.Spanish_Map, c, 1034);
                }
                if (keyEvent.getModifiersEx() == 8192) {
                    n = this.getKeyboardKeycode(this.Spanish_Alt_gr_linuxMap, c, 1034);
                    this.OnSendALTGR_Keyevent(n);
                    break;
                }
                this.OnSend_Keyevent(n);
                return true;
            }
            case 1036: {
                if (keyEvent.getModifiers() == 1) {
                    SHIFT_FLAG = true;
                }
                if (System.getProperty("os.name").equals("Linux")) {
                    if (keyEvent.getKeyLocation() != 4) {
                        n = this.getKeyboardKeycode(this.French_linuxMap, c, 1036);
                    }
                    if (DEAD_FLAG && n < 0) {
                        DEAD_FLAG = false;
                    }
                }
                if (keyEvent.getKeyLocation() != 4) {
                    n = this.getKeyboardKeycode(this.French_WinMap, c, 1036);
                }
                if (keyEvent.getModifiersEx() == 8192) {
                    n = this.getKeyboardKeycode(this.French_Alt_gr_linuxMap, c, 1036);
                    this.OnSendALTGR_Keyevent(n);
                    break;
                }
                if (n <= 0) break;
                this.OnSend_Keyevent(n);
                return true;
            }
            case 2060: {
                if (keyEvent.getModifiers() == 1) {
                    SHIFT_FLAG = true;
                }
                if (keyEvent.getKeyLocation() != 4) {
                    n = this.getKeyboardKeycode(this.French_Belgium_Map, c, 1036);
                }
                if (keyEvent.getModifiersEx() == 8192) {
                    n = this.getKeyboardKeycode(this.French_Alt_gr_linuxMap, c, 1036);
                    this.OnSendALTGR_Keyevent(n);
                    break;
                }
                if (n <= 0) break;
                this.OnSend_Keyevent(n);
                return true;
            }
            case 2055: {
                if (keyEvent.getModifiers() == 1) {
                    SHIFT_FLAG = true;
                }
                if (keyEvent.getKeyLocation() != 4) {
                    n = this.getKeyboardKeycode(this.German_Swiss_Map, c, 2055);
                }
                if (keyEvent.getModifiersEx() == 8192) {
                    n = this.getKeyboardKeycode(this.French_Alt_gr_linuxMap, c, 1036);
                    this.OnSendALTGR_Keyevent(n);
                    break;
                }
                if (n <= 0) break;
                this.OnSend_Keyevent(n);
                return true;
            }
            case 1031: {
                if (c == '\u00df' || c == '?') {
                    this.OnSend_Keyevent(47);
                    return true;
                }
                if (keyEvent.getModifiers() == 1) {
                    SHIFT_FLAG = true;
                }
                if (keyEvent.getKeyLocation() != 4) {
                    n = this.getKeyboardKeycode(this.German_Map, c, 1031);
                    if (DEAD_FLAG && n < 0) {
                        DEAD_FLAG = false;
                    }
                }
                if (keyEvent.getModifiersEx() == 8192) {
                    n = this.getKeyboardKeycode(this.German_Map_Alt_gr_linuxMap, c, 1031);
                    this.OnSendALTGR_Keyevent(n);
                    break;
                }
                if (n <= 0) break;
                this.OnSend_Keyevent(n);
                return true;
            }
        }
        return false;
    }

    private void OnSendALTGR_Keyevent(int n) {
        KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep uSBKeyboardRep = JViewerApp.getInstance().getM_USBKeyRep();
        uSBKeyboardRep.set(17, 2, false);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 3, false);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 3, true);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(n, 1, true);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(n, 1, false);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 3, false);
        kVMClient.sendKMMessage(uSBKeyboardRep);
    }

    private void OnSend_Keyevent(int n) {
        KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep uSBKeyboardRep = JViewerApp.getInstance().getM_USBKeyRep();
        uSBKeyboardRep.set(n, 1, true);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(n, 1, false);
        kVMClient.sendKMMessage(uSBKeyboardRep);
    }

    private void OnSendShiftGrave_Keyevent(int n, int n2) {
        KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep uSBKeyboardRep = JViewerApp.getInstance().getM_USBKeyRep();
        uSBKeyboardRep.set(16, n2, true);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(n, 1, true);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(16, n2, false);
        kVMClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(n, 1, false);
        kVMClient.sendKMMessage(uSBKeyboardRep);
    }

    public boolean OnkeyPressed(KeyEvent keyEvent) {
        KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep uSBKeyboardRep = JViewerApp.getInstance().getM_USBKeyRep();
        switch (this.keyboardType) {
            case 1031: 
            case 1034: 
            case 1036: {
                int n = keyEvent.getModifiersEx();
                if (n == 8192) {
                    return true;
                }
                if (n == 640) {
                    return true;
                }
                if (this.keyboardType != 1031) break;
                if (keyEvent.getKeyChar() == '~') {
                    this.OnSend_Keyevent(61);
                    return true;
                }
                if (keyEvent.getKeyCode() != 521) break;
                PLUS_FLAG = true;
                break;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public boolean OnkeyReleased(KeyEvent keyEvent) {
        KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep uSBKeyboardRep = JViewerApp.getInstance().getM_USBKeyRep();
        if ((keyEvent.getModifiersEx() & 0x200) == 512 && this.keyboardType == 1033 && !JViewerApp.getInstance().isFullKeyboardEnabled()) {
            return true;
        }
        int n = keyEvent.getKeyCode();
        switch (this.keyboardType) {
            case 1031: {
                if (!System.getProperty("os.name").equals("Linux")) break;
                if (n == 130 && !SHIFT_FLAG) {
                    this.OnSend_Keyevent(192);
                    DEAD_FLAG = true;
                    return true;
                }
                if (n == 521 && !PLUS_FLAG && keyEvent.getModifiers() == 32) {
                    this.OnSendALTGR_Keyevent(521);
                    PLUS_FLAG = false;
                    return true;
                }
                if (n == 129 && !SHIFT_FLAG) {
                    this.OnSend_Keyevent(61);
                    DEAD_FLAG = true;
                    return true;
                }
                if (n == 129 && SHIFT_FLAG) {
                    this.OnSendShiftGrave_Keyevent(61, SHIFT_KEY_POSITION);
                    DEAD_FLAG = true;
                    return true;
                }
                if (DEAD_FLAG) {
                    this.OnSend_Keyevent(n);
                    DEAD_FLAG = false;
                    SHIFT_FLAG = false;
                    return true;
                }
                if (n == 16) {
                    SHIFT_FLAG = true;
                    SHIFT_KEY_POSITION = keyEvent.getKeyLocation();
                    DEAD_FLAG = false;
                } else {
                    SHIFT_FLAG = false;
                    DEAD_FLAG = false;
                    SHIFT_KEY_POSITION = 0;
                }
                PLUS_FLAG = false;
                break;
            }
            case 1036: {
                if (!System.getProperty("os.name").equals("Linux")) break;
                if (n == 130 && !SHIFT_FLAG) {
                    this.OnSend_Keyevent(91);
                    DEAD_FLAG = true;
                    return true;
                }
                if (n == 130 && SHIFT_FLAG) {
                    this.OnSendShiftGrave_Keyevent(91, SHIFT_KEY_POSITION);
                    DEAD_FLAG = true;
                    return true;
                }
                if (DEAD_FLAG) {
                    this.OnSend_Keyevent(n);
                    DEAD_FLAG = false;
                    SHIFT_FLAG = false;
                    SHIFT_KEY_POSITION = 0;
                    return true;
                }
                if (n == 16) {
                    SHIFT_FLAG = true;
                    SHIFT_KEY_POSITION = keyEvent.getKeyLocation();
                    DEAD_FLAG = false;
                    break;
                }
                SHIFT_FLAG = false;
                SHIFT_KEY_POSITION = 0;
                DEAD_FLAG = false;
                break;
            }
            case 1034: {
                if (!System.getProperty("os.name").equals("Linux")) break;
                if (n == 129 && !SHIFT_FLAG && !ALT_GR_FLAG) {
                    this.OnSend_Keyevent(129);
                    DEAD_FLAG = !DEAD_FLAG;
                    return true;
                }
                if (n == 128 && !SHIFT_FLAG && !ALT_GR_FLAG) {
                    this.OnSend_Keyevent(128);
                    DEAD_FLAG = !DEAD_FLAG;
                    return true;
                }
                if (n == 129 && SHIFT_FLAG && !ALT_GR_FLAG) {
                    this.OnSendShiftGrave_Keyevent(129, SHIFT_KEY_POSITION);
                    DEAD_FLAG = !DEAD_FLAG;
                    return true;
                }
                if (n == 128 && SHIFT_FLAG && !ALT_GR_FLAG) {
                    this.OnSendShiftGrave_Keyevent(128, SHIFT_KEY_POSITION);
                    DEAD_FLAG = !DEAD_FLAG;
                    return true;
                }
                if (DEAD_FLAG && !ALT_GR_FLAG) {
                    this.OnSend_Keyevent(n);
                    DEAD_FLAG = false;
                    SHIFT_FLAG = false;
                    SHIFT_KEY_POSITION = 0;
                    return true;
                }
                if (n == 16) {
                    SHIFT_FLAG = true;
                    SHIFT_KEY_POSITION = keyEvent.getKeyLocation();
                    DEAD_FLAG = false;
                    ALT_GR_FLAG = false;
                    break;
                }
                SHIFT_FLAG = false;
                SHIFT_KEY_POSITION = 0;
                DEAD_FLAG = false;
                ALT_GR_FLAG = false;
            }
        }
        return false;
    }

    public KeyProcessor ongetKeyprocessor() {
        if (this.m_keyprocessor == null) {
            this.m_keyprocessor = JViewerApp.getInstance().getJVMenu().getMenuSelected("Auto detect") != false ? this.selectKeyProcessor(this.keyboardType) : this.selectKeyProcessor(this.hostKeyboardType);
        }
        return this.m_keyprocessor;
    }

    private KeyProcessor selectKeyProcessor(int n) {
        USBKeyProcessorEnglish uSBKeyProcessorEnglish;
        switch (n) {
            case 1041: {
                uSBKeyProcessorEnglish = new USBKeyProcessorJapaneseHost();
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("JP", true);
                break;
            }
            case 1031: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTZ(4);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("DE", true);
                break;
            }
            case 1036: {
                uSBKeyProcessorEnglish = new USBKeyProcessorAZERTY(3);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("FR", true);
                break;
            }
            case 1034: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(2);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("ES", true);
                break;
            }
            case 2057: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(1);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("GB", true);
                break;
            }
            case 2055: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTZ(8);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("DE-CH", true);
                break;
            }
            case 2060: {
                uSBKeyProcessorEnglish = new USBKeyProcessorAZERTY(13);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("FR-BE", true);
                break;
            }
            case 1040: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(5);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("IT", true);
                break;
            }
            case 1030: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(6);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("DA", true);
                break;
            }
            case 1035: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(7);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("FI", true);
                break;
            }
            case 1044: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(9);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("NO", true);
                break;
            }
            case 2070: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(10);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("PT", true);
                break;
            }
            case 1053: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(11);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("SV", true);
                break;
            }
            case 1043: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(21);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("NL-NL", true);
                break;
            }
            case 2067: {
                uSBKeyProcessorEnglish = new USBKeyProcessorAZERTY(14);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("NL-BE", true);
                break;
            }
            case 66591: {
                uSBKeyProcessorEnglish = new USBKeyProcessorTurkishF();
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("TR_F", true);
                break;
            }
            case 1055: {
                uSBKeyProcessorEnglish = new USBKeyProcessorQWERTY(18);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("TR_Q", true);
                break;
            }
            default: {
                uSBKeyProcessorEnglish = JViewerApp.getInstance().getJVMenu().getMenuSelected("Auto detect") != false ? new USBKeyProcessorEnglish() : new USBKeyProcessorQWERTY(0);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("US", true);
            }
        }
        return uSBKeyProcessorEnglish;
    }

    public void initKeyProcessor() {
        this.m_keyprocessor = null;
    }

    private int getKeyboardKeycode(HashMap<Integer, Integer> hashMap, int n, int n2) {
        try {
            return hashMap.get(n);
        }
        catch (Exception exception) {
            switch (n2) {
                case 1036: {
                    Debug.out.println("Exception in KBD_TYPE_FRENCH" + exception);
                    break;
                }
                case 1034: {
                    Debug.out.println("Exception in KBD_TYPE_SPANISH" + exception);
                    break;
                }
                case 1031: {
                    Debug.out.println("Exception in KBD_TYPE_GERMAN" + exception);
                    break;
                }
                case 1033: {
                    Debug.out.println("Exception in KBD_TYPE_ENGLISH" + exception);
                    break;
                }
                case 1041: {
                    Debug.out.println("Exception in KBD_TYPE_JAPANESE" + exception);
                }
            }
            return -1;
        }
    }
}

