/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.hid.USBKeyboardRep;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class FSLEDStatusBar
extends JDialog {
    private static final byte NUM_LOCK = 1;
    private static final byte CAPS_LOCK = 2;
    private static final byte SCROLL_LOCK = 4;
    private static final String NUM = "NUM";
    private static final String CAPS = "CAPS";
    private static final String SCROLL = "SCROLL";
    private boolean autoHide = false;
    private JLabel numLockLED;
    private JLabel capsLockLED;
    private JLabel scrollLockLED;
    private Color bgColor = new Color(250, 250, 250, 0);
    public static final int WIDTH = 160;
    public static final int HEIGHT = 20;

    public FSLEDStatusBar(JDialog jDialog) {
        super(jDialog);
        this.numLockLED = this.createLEDLabel(NUM);
        this.capsLockLED = this.createLEDLabel(CAPS);
        this.scrollLockLED = this.createLEDLabel(SCROLL);
        this.setLayout(new GridLayout(1, 3));
        this.add(this.numLockLED);
        this.add(this.capsLockLED);
        this.add(this.scrollLockLED);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        this.setResizable(false);
        this.setUndecorated(true);
        this.setVisible(false);
    }

    private JLabel createLEDLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setName(string);
        jLabel.setFont(new Font("Dialog", 1, 10));
        jLabel.setForeground(Color.gray);
        jLabel.setBackground(this.bgColor);
        jLabel.setRequestFocusEnabled(false);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setHorizontalAlignment(0);
        jLabel.setCursor(new Cursor(12));
        jLabel.setFocusTraversalKeysEnabled(false);
        jLabel.setBorder(BorderFactory.createEtchedBorder(1));
        jLabel.addMouseListener(new FSToolBarMouseListener());
        return jLabel;
    }

    private void sendLEDStatusFromStatusBar(int n, int n2, boolean bl) {
        KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(n, n2, bl);
        kVMClient.sendKMMessage(uSBKeyboardRep);
    }

    private void setLEDStatus(JLabel jLabel, boolean bl) {
        if (bl) {
            jLabel.setForeground(Color.red);
        } else {
            jLabel.setForeground(Color.gray);
        }
        jLabel.repaint();
    }

    public void setLEDStatus(byte by) {
        if ((by & 1) != 0) {
            this.setLEDStatus(this.numLockLED, true);
        } else {
            this.setLEDStatus(this.numLockLED, false);
        }
        if ((by & 2) != 0) {
            this.setLEDStatus(this.capsLockLED, true);
        } else {
            this.setLEDStatus(this.capsLockLED, false);
        }
        if ((by & 4) != 0) {
            this.setLEDStatus(this.scrollLockLED, true);
        } else {
            this.setLEDStatus(this.scrollLockLED, false);
        }
    }

    public boolean isAutoHide() {
        return this.autoHide;
    }

    public void setAutoHide(boolean bl) {
        this.autoHide = bl;
    }

    class FSToolBarMouseListener
    extends MouseAdapter {
        JLabel ledLabel;
        String labelName;
        int keyCode;
        int keyLocation;

        FSToolBarMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.ledLabel = (JLabel)mouseEvent.getSource();
            this.labelName = this.ledLabel.getName();
            if (this.labelName == FSLEDStatusBar.NUM) {
                this.keyCode = 144;
                this.keyLocation = 4;
            } else if (this.labelName == FSLEDStatusBar.CAPS) {
                this.keyCode = 20;
                this.keyLocation = 1;
            } else if (this.labelName == FSLEDStatusBar.SCROLL) {
                this.keyCode = 145;
                this.keyLocation = 1;
            }
            FSLEDStatusBar.this.sendLEDStatusFromStatusBar(this.keyCode, this.keyLocation, true);
            JViewerApp.getInstance().getRCView().requestFocus();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.ledLabel = (JLabel)mouseEvent.getSource();
            this.labelName = this.ledLabel.getName();
            if (this.labelName == FSLEDStatusBar.NUM) {
                this.keyCode = 144;
                this.keyLocation = 4;
            } else if (this.labelName == FSLEDStatusBar.CAPS) {
                this.keyCode = 20;
                this.keyLocation = 1;
            } else if (this.labelName == FSLEDStatusBar.SCROLL) {
                this.keyCode = 145;
                this.keyLocation = 1;
            }
            FSLEDStatusBar.this.sendLEDStatusFromStatusBar(this.keyCode, this.keyLocation, false);
            JViewerApp.getInstance().getRCView().requestFocus();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (FSLEDStatusBar.this.autoHide) {
                JViewerApp.getInstance().getM_fsFrame().getM_menuBar().showMenu();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (FSLEDStatusBar.this.autoHide) {
                JViewerApp.getInstance().getM_fsFrame().getM_menuBar().hideMenu();
            }
        }
    }
}

