/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.KVMSharing;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.KeyStroke;

public abstract class JVMenu {
    public static boolean INITIAL_MENU_STATUS = true;
    public static final String VIDEO = "Video";
    public static final String VIDEO_PAUSE_REDIRECTION = "VideoPauseRedirection";
    public static final String VIDEO_RESUME_REDIRECTION = "VideoResumeRedirection";
    public static final String VIDEO_REFRESH = "VideoRefresh";
    public static final String VIDEO_CAPTURE_SCREEN = "VideoCaptureScreen";
    public static final String VIDEO_HOST_DISPLAY_UNLOCK = "VideoHostDisplayUnlock";
    public static final String VIDEO_HOST_DISPLAY_LOCK = "VideoHostDisplayLock";
    public static final String VIDEO_FULL_SCREEN = "VideoFullScreen";
    public static final String VIDEO_EXIT = "VideoExit";
    public static final String KEYBOARD = "Keyboard";
    public static final String KEYBOARD_RIGHT_CTRL_KEY = "KeyboardHoldRightCtrlKey";
    public static final String KEYBOARD_RIGHT_ALT_KEY = "KeyboardHoldRightAltKey";
    public static final String KEYBOARD_LEFT_CTRL_KEY = "KeyboardHoldLeftCtrlKey";
    public static final String KEYBOARD_LEFT_ALT_KEY = "KeyboardHoldLeftAltKey";
    public static final String KEYBOARD_LEFT_WINKEY_PRESSHOLD = "KeyboardLeftWindowsKeyHoldDown";
    public static final String KEYBOARD_LEFT_WINKEY_PRESSRELEASE = "KeyboardLeftWindowsKeyPressRelease";
    public static final String KEYBOARD_RIGHT_WINKEY_PRESSHOLD = "KeyboardRightWindowsKeyHoldDown";
    public static final String KEYBOARD_RIGHT_WINKEY_PRESSRELEASE = "KeyboardRightWindowsKeyPressRelease";
    public static final String KEYBOARD_CTRL_ALT_DEL = "KeyboardCtrlAltDel";
    public static final String KEYBOARD_CONTEXT_MENU = "KeyboardContextMenu";
    public static final String KEYBOARD_HOTKEYS = "Hotkeys";
    public static final String KEYBOARD_ADD_HOTKEYS = "Add Hotkeys";
    public static final String KEYBOARD_FULL_KEYBOARD = "Full Keyborad Support";
    public static final String LINUX_HOST = "Linux host";
    public static final String WINDOWS_HOST = "Windows host";
    public static final String AUTOMATIC_LANGUAGE = "Auto detect";
    public static final String KEYBOARD_LAYOUT = "Keyboard Layout";
    public static final String PHYSICAL_KEYBOARD = "PhysicalKeyboard";
    public static final String PKBRD_LANGUAGE_ENGLISH_US = "US";
    public static final String PKBRD_LANGUAGE_ENGLISH_UK = "GB";
    public static final String PKBRD_LANGUAGE_FRENCH_FRANCE = "FR";
    public static final String PKBRD_LANGUAGE_FRENCH_BELGIUM = "FR-BE";
    public static final String PKBRD_LANGUAGE_GERMAN_GER = "DE";
    public static final String PKBRD_LANGUAGE_GERMAN_SWISS = "DE-CH";
    public static final String PKBRD_LANGUAGE_JAPANESE = "JP";
    public static final String PKBRD_LANGUAGE_SPANISH = "ES";
    public static final String PKBRD_LANGUAGE_ITALIAN = "IT";
    public static final String PKBRD_LANGUAGE_DANISH = "DA";
    public static final String PKBRD_LANGUAGE_FINNISH = "FI";
    public static final String PKBRD_LANGUAGE_NORWEGIAN = "NO";
    public static final String PKBRD_LANGUAGE_PORTUGUESE = "PT";
    public static final String PKBRD_LANGUAGE_SWEDISH = "SV";
    public static final String PKBRD_LANGUAGE_DUTCH_NL = "NL-NL";
    public static final String PKBRD_LANGUAGE_DUTCH_BE = "NL-BE";
    public static final String PKBRD_LANGUAGE_TURKISH_F = "TR_F";
    public static final String PKBRD_LANGUAGE_TURKISH_Q = "TR_Q";
    public static final String PKBRD_NONE = "NONE";
    public static final String SOFTKEYBOARD = "SoftKeyboard";
    public static final String SKBRD_LANGUAGE = "SKBD_";
    public static final String SKBRD_LANGUAGE_ENGLISH_US = "SKBD_English(United States)";
    public static final String SKBRD_LANGUAGE_ENGLISH_UK = "SKBD_English(United Kingdom)";
    public static final String SKBRD_LANGUAGE_SPANISH = "SKBD_Spanish";
    public static final String SKBRD_LANGUAGE_FRENCH = "SKBD_French";
    public static final String SKBRD_LANGUAGE_GERMAN_GER = "SKBD_German(Germany)";
    public static final String SKBRD_LANGUAGE_ITALIAN = "SKBD_Italian";
    public static final String SKBRD_LANGUAGE_DANISH = "SKBD_Danish";
    public static final String SKBRD_LANGUAGE_FINNISH = "SKBD_Finnish";
    public static final String SKBRD_LANGUAGE_GERMAN_SWITZ = "SKBD_German(Switzerland)";
    public static final String SKBRD_LANGUAGE_NORWEGIAN_NOR = "SKBD_Norwegian(Norway)";
    public static final String SKBRD_LANGUAGE_PORTUGUESE = "SKBD_Portuguese(Portugal)";
    public static final String SKBRD_LANGUAGE_SWEDISH = "SKBD_Swedish";
    public static final String SKBRD_LANGUAGE_HEBREW = "SKBD_Hebrew";
    public static final String SKBRD_LANGUAGE_FRENCH_BELGIUM = "SKBD_French(Belgium)";
    public static final String SKBRD_LANGUAGE_DUTCH_BELGIUM = "SKBD_Dutch(Belgium)";
    public static final String SKBRD_LANGUAGE_DUTCH_NL = "SKBD_Dutch(Netherlands)";
    public static final String SKBRD_LANGUAGE_RUSSIAN = "SKBD_Russian";
    public static final String SKBRD_LANGUAGE_JAPANESE_Q = "SKBD_Japanese - Q";
    public static final String SKBRD_LANGUAGE_JAPANESE_H = "SKBD_Japanese Hiragana";
    public static final String SKBRD_LANGUAGE_JAPANESE_K = "SKBD_Japanese Katakana";
    public static final String SKBRD_LANGUAGE_TURKISH_F = "SKBD_Turkish - F";
    public static final String SKBRD_LANGUAGE_TURKISH_Q = "SKBD_Turkish - Q";
    public static final int LANGUAGE_ENGLISH_US = 0;
    public static final int LANGUAGE_ENGLISH_UK = 1;
    public static final int LANGUAGE_SPANISH = 2;
    public static final int LANGUAGE_FRENCH = 3;
    public static final int LANGUAGE_GERMAN_GER = 4;
    public static final int LANGUAGE_ITALIAN = 5;
    public static final int LANGUAGE_DANISH = 6;
    public static final int LANGUAGE_FINNISH = 7;
    public static final int LANGUAGE_GERMAN_SWISS = 8;
    public static final int LANGUAGE_NORWEGIAN_NOR = 9;
    public static final int LANGUAGE_PORTUGUESE = 10;
    public static final int LANGUAGE_SWEDISH = 11;
    public static final int LANGUAGE_HEBREW = 12;
    public static final int LANGUAGE_FRENCH_BELGIUM = 13;
    public static final int LANGUAGE_DUTCH_BELGIUM = 14;
    public static final int LANGUAGE_RUSSIAN = 15;
    public static final int LANGUAGE_JAPANESE_Q = 16;
    public static final int LANGUAGE_TURKISH_F = 17;
    public static final int LANGUAGE_TURKISH_Q = 18;
    public static final int LANGUAGE_JAPANESE_H = 19;
    public static final int LANGUAGE_JAPANESE_K = 20;
    public static final int LANGUAGE_DUTCH_NL = 21;
    public static final byte RELATIVE_MODE = 1;
    public static final byte ABSOLUTE_MODE = 2;
    public static final byte OTHER_MODE = 3;
    public static final String OPTION = "Options";
    public static final String MOUSE = "Mouse";
    public static final String MOUSE_CLIENTCURSOR_CONTROL = "MouseShowCursor";
    public static final String CALIBRATEMOUSETHRESHOLD = "Calibrate Mouse Threshold";
    public static final String MOUSE_MODE = "MouseMode";
    public static final String MOUSE_RELATIVE_MODE = "Relative";
    public static final String MOUSE_ABSOLUTE_MODE = "Absolute";
    public static final String MOUSE_OTHER_MODE = "Other";
    public static final String OPTIONS_BANDWIDTH = "Bandwidth";
    public static final String OPTIONS_BANDWIDTH_AUTO_DETECT = "OptionsBandwidthAutoDetect";
    public static final String OPTIONS_BANDWIDTH_256KBPS = "OptionsBandwidth256Kbps";
    public static final String OPTIONS_BANDWIDTH_512KBPS = "OptionsBandwidth512Kbps";
    public static final String OPTIONS_BANDWIDTH_1MBPS = "OptionsBandwidth1Mbps";
    public static final String OPTIONS_BANDWIDTH_10MBPS = "OptionsBandwidth10Mbps";
    public static final String OPTIONS_BANDWIDTH_100MBPS = "OptionsBandwidth100Mbps";
    public static final String OPTIONS_KEYBOARD_MOUSE_ENCRYPTION = "OptionsKeyboardMouseEncryption";
    public static final String ZOOM = "Video Zoom";
    public static final String ZOOM_IN = "Zoom In";
    public static final String ZOOM_OUT = "Zoom Out";
    public static final String ACTUAL_SIZE = "ActualSize";
    public static final String FIT_TO_CLIENT_RES = "FitToClientResolution";
    public static final String FIT_TO_HOST_RES = "FitToHostResolution";
    public static final String ZOOM_OPTION_NONE = "ZoomOption None";
    public static final String OPTIONS_GUI_LANGUAGE = "GUI Languages";
    public static final String OPTIONS_GUI_LANGUAGE_LOCALE = "Locale";
    public static final String LOCALE_CODE_START_DELIM = " - [";
    public static final String LOCALE_CODE_END_DELIM = "]";
    public static final String OPTIONS_IPMI_COMMAND = "IPMICommand";
    public static final String OPTIONS_REQUEST_FULL_PERMISSION = "RequestFullPermission";
    public static final String OPTIONS_BLOCK_FULL_PERMISSION = "BlockFullPermission";
    public static final String OPTIONS_BLOCK_WITH_VIDEO_ONLY = "AllowonlyVideo";
    public static final String OPTIONS_BLOCK_WITH_DENY = "DenyAccess";
    public static final String MEDIA = "Media";
    public static final String DEVICE_MEDIA_DIALOG = "DeviceMediaDialog";
    public static final String HELP_ABOUT_RCONSOLE = "HelpAboutJViewer";
    public static final String VIDEO_RECORD = "VideoRecord";
    public static final String VIDEO_RECORD_SETTINGS = "VideoRecordSettings";
    public static final String VIDEO_RECORD_START = "VideoRecordStart";
    public static final String VIDEO_RECORD_STOP = "VideoRecordStop";
    public static final String POWER_CONTROL = "Power";
    public static final String POWER_RESET_SERVER = "Reset Server";
    public static final String POWER_OFF_IMMEDIATE = "Immediate Shutdown";
    public static final String POWER_OFF_ORDERLY = "Orderly Shutdown";
    public static final String POWER_ON_SERVER = "Power On Server";
    public static final String POWER_CYCLE_SERVER = "Power Cycle Server";
    public static final String ACTIVE_USERS = "Active Users";
    public JLabel menu_string;
    protected JVMenuListener m_menuListener = new JVMenuListener();
    protected static JVMenuStatusListener m_menuStatus = new JVMenuStatusListener();
    protected Hashtable<String, JMenuItem> m_menuItems = new Hashtable();
    protected Hashtable<String, JMenu> m_menu = new Hashtable();
    protected static Hashtable<String, Boolean> m_menuItems_setselected = new Hashtable();
    protected static Hashtable<String, Boolean> m_menuItems_setenabled = new Hashtable();
    protected static Hashtable<String, String> m_menustatusbar_text = new Hashtable();
    protected static Hashtable<String, Character> menuMnemonics = new Hashtable();
    protected static Hashtable<String, KeyStroke> menuAccelerator = new Hashtable();
    public static String previous_bandwidth = "OptionsBandwidth100Mbps";
    public static int m_mouseMode = USBMouseRep.ABSOLUTE_MOUSE_MODE;
    protected static JComboBox combo;
    public JSlider slider;
    public JLabel label_size;
    private JLabel label_Text;
    public static double m_scale;
    public static int keyBoardLayout;
    public static int softkeyBoardLayout;
    protected static String[] KVMPartialExceptionMenuItems;
    protected static String[] KVMPartialExceptionSOCMenuItems;
    protected static String[] KVMPartialExceptionOEMMenuItems;
    private JMenu macroSubMenu;

    public JMenuItem getMenuItem(String string) {
        return this.m_menuItems.get(string);
    }

    public JMenu getMenu(String string) {
        return this.m_menu.get(string);
    }

    public Boolean getMenuEnable(String string) {
        return m_menuItems_setenabled.get(string);
    }

    public Boolean SetMenuEnable(String string, Boolean bl) {
        return m_menuItems_setenabled.put(string, bl);
    }

    public Boolean getMenuSelected(String string) {
        return m_menuItems_setselected.get(string);
    }

    public Boolean SetMenuSelected(String string, Boolean bl) {
        return m_menuItems_setselected.put(string, bl);
    }

    public void notifyMenuStateEnable(String string, boolean bl) {
        if (this.getMenuItem(string) != null) {
            this.getMenuItem(string).setEnabled(bl);
            this.SetMenuEnable(string, bl);
        }
    }

    public void notifyMenuEnable(String string, boolean bl) {
        this.getMenu(string).setEnabled(bl);
        this.SetMenuEnable(string, bl);
    }

    public void notifyMenuStateSelected(String string, boolean bl) {
        this.getMenuItem(string).setSelected(bl);
        this.SetMenuSelected(string, bl);
    }

    public void notifyMouseMode(byte by) {
        if (by == USBMouseRep.RELATIVE_MOUSE_MODE) {
            this.notifyMenuStateEnable(CALIBRATEMOUSETHRESHOLD, true);
        } else {
            this.notifyMenuStateEnable(CALIBRATEMOUSETHRESHOLD, false);
        }
    }

    public void refreshMenu() {
        Boolean bl;
        Map.Entry<String, Boolean> entry;
        Set<Map.Entry<String, Boolean>> set = m_menuItems_setselected.entrySet();
        Iterator<Map.Entry<String, Boolean>> iterator = set.iterator();
        Set<Map.Entry<String, Boolean>> set2 = m_menuItems_setenabled.entrySet();
        Iterator<Map.Entry<String, Boolean>> iterator2 = set2.iterator();
        String string = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            try {
                entry = iterator.next();
                string = entry.getKey();
                bl = entry.getValue();
                bl2 = bl;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            this.notifyMenuStateSelected(string, bl2);
        }
        while (iterator2.hasNext()) {
            try {
                entry = iterator2.next();
                string = entry.getKey();
                bl = entry.getValue();
                bl2 = bl;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            try {
                this.notifyMenuStateEnable(string, bl2);
            }
            catch (Exception exception) {
                this.notifyMenuEnable(string, bl2);
                Debug.out.println(exception);
            }
        }
    }

    public void enableMenu(String[] stringArray, boolean bl, boolean bl2) {
        Set<Map.Entry<String, Boolean>> set = m_menuItems_setenabled.entrySet();
        Iterator<Map.Entry<String, Boolean>> iterator = set.iterator();
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, Boolean> entry = iterator.next();
                string = entry.getKey();
                Boolean bl5 = entry.getValue();
                bl3 = bl5;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            try {
                bl3 = bl;
                bl4 = false;
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.equals(stringArray[i])) continue;
                        bl4 = true;
                        break;
                    }
                }
                if (string.startsWith(OPTIONS_GUI_LANGUAGE_LOCALE)) continue;
                if (string.startsWith(SKBRD_LANGUAGE) && KVMSharing.KVM_REQ_GIVEN == 0) {
                    this.notifyMenuStateEnable(string, true);
                    continue;
                }
                if (bl4) continue;
                if (bl2) {
                    this.notifyMenuStateEnable(string, bl3);
                    continue;
                }
                if (this.getMenuItem(string) == null) continue;
                this.getMenuItem(string).setEnabled(bl);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    public void changeMenuItemLanguage() {
        Set<Map.Entry<String, JMenuItem>> set = this.m_menuItems.entrySet();
        Iterator<Map.Entry<String, JMenuItem>> iterator = set.iterator();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, JMenuItem> entry = iterator.next();
                string = entry.getKey();
                JMenuItem jMenuItem = JViewerApp.getInstance().getJVMenu().getMenuItem(string.toString());
                String string6 = LOCALE_CODE_START_DELIM;
                String string7 = jMenuItem.getText();
                if (jMenuItem.getActionCommand().startsWith(OPTIONS_GUI_LANGUAGE_LOCALE)) {
                    Locale locale;
                    if (!string7.contains(string6) || !string7.endsWith(LOCALE_CODE_END_DELIM) || (string5 = this.getLocaleCode(string7)).length() != 2 || (string2 = (string4 = (locale = new Locale(string5.toLowerCase())).getDisplayLanguage(new Locale(JViewer.getLanguage()))).concat(string6).concat(string5).concat(LOCALE_CODE_END_DELIM)) == null) continue;
                    jMenuItem.setText(string2);
                    continue;
                }
                string2 = LocaleStrings.getStringKey(jMenuItem.getText());
                if (jMenuItem.equals(this.getMenuItem(HELP_ABOUT_RCONSOLE))) {
                    jMenuItem.setText(LocaleStrings.getString("F_69_JVM") + JViewer.getTitle());
                    continue;
                }
                if (string2 == null) continue;
                string3 = LocaleStrings.getString(string2);
                if (string3 == null) {
                    string3 = LocaleStrings.getSOCString(string2);
                }
                jMenuItem.setText(string3);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    public void changeMenuLanguage() {
        Set<Map.Entry<String, JMenu>> set = this.m_menu.entrySet();
        Iterator<Map.Entry<String, JMenu>> iterator = set.iterator();
        String string = null;
        String string2 = null;
        String string3 = null;
        JMenu jMenu = null;
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, JMenu> entry = iterator.next();
                string = entry.getKey();
                jMenu = JViewerApp.getInstance().getJVMenu().getMenu(string.toString());
                string3 = LocaleStrings.getStringKey(jMenu.getText());
                if (string3 == null) continue;
                string2 = LocaleStrings.getString(string3);
                if (string2 == null) {
                    string2 = LocaleStrings.getSOCString(string3);
                }
                jMenu.setText(string2);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    public void changeStatusBarLanguage() {
        Set<Map.Entry<String, String>> set = m_menustatusbar_text.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, String> entry = iterator.next();
                string = entry.getKey();
                string2 = entry.getValue();
                if (string2.toString().startsWith(LocaleStrings.getPreviousLocaleString("F_119_JVM"))) {
                    string6 = this.getLocaleCode(string2.toString());
                    Locale locale = new Locale(string6.toLowerCase());
                    string5 = locale.getDisplayLanguage(new Locale(JViewer.getLanguage()));
                    string3 = LocaleStrings.getString("F_119_JVM") + string5 + LOCALE_CODE_START_DELIM + string6 + LOCALE_CODE_END_DELIM;
                    if (string3 == null) continue;
                    m_menustatusbar_text.put(string.toString(), string3);
                    continue;
                }
                if (string2.toString().startsWith(LocaleStrings.getPreviousLocaleString("F_75_JVM"))) {
                    string4 = this.localizeKeboardLayoutMenuStatus(string2.toString());
                    if (string2.toString().endsWith(LocaleStrings.getPreviousLocaleString("F_76_JVM"))) {
                        string4 = string4 + LocaleStrings.getString("F_76_JVM");
                    } else if (string2.toString().endsWith(LocaleStrings.getPreviousLocaleString("F_116_JVM"))) {
                        string4 = string4 + LocaleStrings.getString("F_116_JVM");
                    }
                    m_menustatusbar_text.put(string.toString(), string4);
                    continue;
                }
                string3 = LocaleStrings.getStringKey(string2.toString());
                if (string3 == null) continue;
                string4 = LocaleStrings.getString(string3);
                if (string4 == null) {
                    string4 = LocaleStrings.getSOCString(string3);
                }
                m_menustatusbar_text.put(string.toString(), string4);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    private String localizeKeboardLayoutMenuStatus(String string) {
        String string2 = LocaleStrings.getString("F_75_JVM");
        if (string.contains(LocaleStrings.getPreviousLocaleString("F_77_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_77_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_78_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_78_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_79_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_79_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_80_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_80_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_81_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_81_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_82_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_82_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_83_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_83_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_84_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_84_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_85_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_85_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_86_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_86_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_87_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_87_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_88_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_88_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_89_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_89_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_90_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_90_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_91_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_91_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_92_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_92_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_93_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_93_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_94_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_94_JVM");
        } else if (string.contains(LocaleStrings.getPreviousLocaleString("F_95_JVM"))) {
            string2 = string2 + LocaleStrings.getString("F_95_JVM");
        }
        return string2;
    }

    protected JMenu createMenu(String string, String string2, char c, String string3) {
        JMenu jMenu = new JMenu(string);
        if (c != ' ') {
            jMenu.setMnemonic(c);
            menuMnemonics.put(string2, Character.valueOf(c));
        }
        if (string2 != null && string2.length() != 0) {
            jMenu.setActionCommand(string2);
            this.m_menu.put(string2, jMenu);
            if (string3 != null) {
                jMenu.addMouseListener(m_menuStatus);
                m_menustatusbar_text.put(string2, string3);
            }
        }
        return jMenu;
    }

    protected JMenuItem createMenuItem(String string, char c, int n, int n2, String string2, String string3) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this.m_menuListener);
        jMenuItem.addMouseListener(m_menuStatus);
        if (c != ' ') {
            jMenuItem.setMnemonic(c);
            menuMnemonics.put(string2, Character.valueOf(c));
        }
        if (n != 0 && n2 != 0) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
            menuAccelerator.put(string2, KeyStroke.getKeyStroke(n, n2));
        }
        jMenuItem.setActionCommand(string2);
        this.m_menuItems.put(string2, jMenuItem);
        m_menustatusbar_text.put(string2, string3);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setenabled.put(string2, true);
        }
        return jMenuItem;
    }

    protected JMenuItem createMenuItem(String string, char c, String string2, String string3) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this.m_menuListener);
        jMenuItem.addMouseListener(m_menuStatus);
        if (c != ' ') {
            jMenuItem.setMnemonic(c);
            menuMnemonics.put(string2, Character.valueOf(c));
        }
        jMenuItem.setActionCommand(string2);
        this.m_menuItems.put(string2, jMenuItem);
        m_menustatusbar_text.put(string2, string3);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setenabled.put(string2, true);
        }
        return jMenuItem;
    }

    protected JMenuItem createMenuItem(String string, char c, String string2, String string3, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this.m_menuListener);
        jMenuItem.addMouseListener(m_menuStatus);
        if (c != ' ') {
            jMenuItem.setMnemonic(c);
            menuMnemonics.put(string2, Character.valueOf(c));
        }
        jMenuItem.setActionCommand(string2);
        jMenuItem.setEnabled(bl);
        this.m_menuItems.put(string2, jMenuItem);
        m_menustatusbar_text.put(string2, string3);
        return jMenuItem;
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(String string, char c, int n, int n2, String string2, String string3) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.addActionListener(this.m_menuListener);
        jCheckBoxMenuItem.addMouseListener(m_menuStatus);
        if (c != ' ') {
            jCheckBoxMenuItem.setMnemonic(c);
            menuMnemonics.put(string2, Character.valueOf(c));
        }
        jCheckBoxMenuItem.setActionCommand(string2);
        if (n != 0 && n2 != 0) {
            jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
            menuAccelerator.put(string2, KeyStroke.getKeyStroke(n, n2));
        }
        this.m_menuItems.put(string2, jCheckBoxMenuItem);
        m_menustatusbar_text.put(string2, string3);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setselected.put(string2, false);
            m_menuItems_setenabled.put(string2, true);
        }
        return jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(String string, char c, String string2, String string3) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.addActionListener(this.m_menuListener);
        jCheckBoxMenuItem.addMouseListener(m_menuStatus);
        if (c != ' ') {
            jCheckBoxMenuItem.setMnemonic(c);
            menuMnemonics.put(string2, Character.valueOf(c));
        }
        jCheckBoxMenuItem.setActionCommand(string2);
        this.m_menuItems.put(string2, jCheckBoxMenuItem);
        m_menustatusbar_text.put(string2, string3);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setselected.put(string2, false);
            m_menuItems_setenabled.put(string2, true);
        }
        return jCheckBoxMenuItem;
    }

    protected JRadioButtonMenuItem createRadioButtonMenu(String string, String string2, String string3) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jRadioButtonMenuItem.addActionListener(this.m_menuListener);
        jRadioButtonMenuItem.addMouseListener(m_menuStatus);
        jRadioButtonMenuItem.setActionCommand(string2);
        this.m_menuItems.put(string2, jRadioButtonMenuItem);
        m_menustatusbar_text.put(string2, string3);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setselected.put(string2, false);
            m_menuItems_setenabled.put(string2, true);
        }
        return jRadioButtonMenuItem;
    }

    protected JMenu constructVideoMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_1_JVM"), VIDEO, 'V', LocaleStrings.getString("F_2_JVM"));
        JMenuItem jMenuItem = this.createMenuItem(LocaleStrings.getString("F_3_JVM"), 'P', 80, 8, VIDEO_PAUSE_REDIRECTION, LocaleStrings.getString("F_4_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_5_JVM"), 'R', 82, 8, VIDEO_RESUME_REDIRECTION, LocaleStrings.getString("F_6_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_7_JVM"), 'e', 69, 8, VIDEO_REFRESH, LocaleStrings.getString("F_8_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_134_JVM"), 'n', 0, 0, VIDEO_HOST_DISPLAY_UNLOCK, LocaleStrings.getString("F_135_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_137_JVM"), 'n', 0, 0, VIDEO_HOST_DISPLAY_LOCK, LocaleStrings.getString("F_138_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_121_JVM"), 'S', 83, 8, VIDEO_CAPTURE_SCREEN, LocaleStrings.getString("F_121_JVM"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_9_JVM"), 'F', 70, 8, VIDEO_FULL_SCREEN, LocaleStrings.getString("F_10_JVM"));
        if (JViewer.isStandalone()) {
            jMenu.add(jMenuItem);
        }
        jMenuItem.setEnabled(false);
        jMenu.addSeparator();
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_11_JVM"), ' ', VIDEO_EXIT, LocaleStrings.getString("F_12_JVM"));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu constructKeyboardMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_13_JVM"), KEYBOARD, 'K', LocaleStrings.getString("F_14_JVM"));
        JMenuItem jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_15_JVM"), 'C', KEYBOARD_RIGHT_CTRL_KEY, LocaleStrings.getString("F_18_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_16_JVM"), 'A', KEYBOARD_RIGHT_ALT_KEY, LocaleStrings.getString("F_19_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_17_JVM"), 't', KEYBOARD_LEFT_CTRL_KEY, LocaleStrings.getString("F_20_JVM"));
        jMenuItem.setDisplayedMnemonicIndex(11);
        jMenu.add(jMenuItem);
        jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_120_JVM"), 'l', KEYBOARD_LEFT_ALT_KEY, LocaleStrings.getString("F_21_JVM"));
        jMenuItem.setDisplayedMnemonicIndex(11);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenu jMenu2 = this.createMenu(LocaleStrings.getString("F_22_JVM"), LocaleStrings.getString("F_22_JVM"), ' ', null);
        jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_23_JVM"), ' ', KEYBOARD_LEFT_WINKEY_PRESSHOLD, LocaleStrings.getString("F_25_JVM"));
        jMenu2.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_24_JVM"), ' ', KEYBOARD_LEFT_WINKEY_PRESSRELEASE, LocaleStrings.getString("F_26_JVM"));
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenu2 = this.createMenu(LocaleStrings.getString("F_27_JVM"), LocaleStrings.getString("F_27_JVM"), ' ', null);
        jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_23_JVM"), ' ', KEYBOARD_RIGHT_WINKEY_PRESSHOLD, LocaleStrings.getString("F_28_JVM"));
        jMenu2.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_24_JVM"), ' ', KEYBOARD_RIGHT_WINKEY_PRESSRELEASE, LocaleStrings.getString("F_29_JVM"));
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenuItem = this.createMenuItem("Ctrl+Alt+Del", ' ', KEYBOARD_CTRL_ALT_DEL, LocaleStrings.getString("F_30_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_31_JVM"), ' ', KEYBOARD_CONTEXT_MENU, LocaleStrings.getString("F_32_JVM"));
        jMenu.add(jMenuItem);
        this.macroSubMenu = this.createMenu(LocaleStrings.getString("F_33_JVM"), LocaleStrings.getString("F_33_JVM"), ' ', null);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_34_JVM"), ' ', KEYBOARD_ADD_HOTKEYS, LocaleStrings.getString("F_35_JVM"));
        this.macroSubMenu.add(jMenuItem);
        jMenu.add(this.macroSubMenu);
        jMenu.addSeparator();
        jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_130_JVM"), ' ', KEYBOARD_FULL_KEYBOARD, LocaleStrings.getString("F_131_JVM"));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu constructMouseMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_36_JVM"), MOUSE, 'u', LocaleStrings.getString("F_114_JVM"));
        JMenuItem jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_37_JVM"), ' ', 67, 8, MOUSE_CLIENTCURSOR_CONTROL, LocaleStrings.getString("F_38_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_39_JVM"), ' ', 84, 8, CALIBRATEMOUSETHRESHOLD, LocaleStrings.getString("F_40_JVM"));
        jMenu.add(jMenuItem);
        JMenu jMenu2 = this.createMenu(LocaleStrings.getString("F_41_JVM"), LocaleStrings.getString("F_41_JVM"), ' ', null);
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_42_JVM"), MOUSE_ABSOLUTE_MODE, LocaleStrings.getString("F_43_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_44_JVM"), MOUSE_RELATIVE_MODE, LocaleStrings.getString("F_45_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_46_JVM"), MOUSE_OTHER_MODE, LocaleStrings.getString("F_47_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        return jMenu;
    }

    protected JMenu constructOptionsMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_48_JVM"), OPTION, 'O', LocaleStrings.getString("F_49_JVM"));
        JMenu jMenu2 = this.createMenu(LocaleStrings.getString("F_50_JVM"), null, ' ', null);
        m_menustatusbar_text.put(OPTIONS_BANDWIDTH, LocaleStrings.getString("F_51_JVM"));
        this.m_menu.put(OPTIONS_BANDWIDTH, jMenu2);
        JMenuItem jMenuItem = this.createMenuItem(LocaleStrings.getString("F_52_JVM"), ' ', OPTIONS_BANDWIDTH_AUTO_DETECT, LocaleStrings.getString("F_53_JVM"));
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = this.createRadioButtonMenu("256 Kbps", OPTIONS_BANDWIDTH_256KBPS, LocaleStrings.getString("F_54_JVM") + " 256 Kbps " + LocaleStrings.getString("F_55_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu("512 Kbps", OPTIONS_BANDWIDTH_512KBPS, LocaleStrings.getString("F_54_JVM") + " 512 Kbps " + LocaleStrings.getString("F_55_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu("1 Mbps", OPTIONS_BANDWIDTH_1MBPS, LocaleStrings.getString("F_54_JVM") + " 1 Mbps " + LocaleStrings.getString("F_55_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu("10 Mbps", OPTIONS_BANDWIDTH_10MBPS, LocaleStrings.getString("F_54_JVM") + " 10 Mbps " + LocaleStrings.getString("F_55_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu("100 Mbps", OPTIONS_BANDWIDTH_100MBPS, LocaleStrings.getString("F_54_JVM") + " 100 Mbps " + LocaleStrings.getString("F_55_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        if (!JViewer.isUseSSL() || !JViewer.isSinglePortEnabled()) {
            jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_56_JVM"), ' ', OPTIONS_KEYBOARD_MOUSE_ENCRYPTION, LocaleStrings.getString("F_57_JVM"));
            jMenu.add(jMenuItem);
        }
        jMenu2 = this.createMenu(LocaleStrings.getString("F_58_JVM"), null, ' ', null);
        m_menustatusbar_text.put(ZOOM, LocaleStrings.getString("F_59_JVM"));
        this.m_menu.put(ZOOM, jMenu2);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_60_JVM"), ' ', ZOOM_IN, LocaleStrings.getString("F_61_JVM"));
        jMenu2.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_62_JVM"), ' ', ZOOM_OUT, LocaleStrings.getString("F_63_JVM"));
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_122_JVM"), ACTUAL_SIZE, LocaleStrings.getString("F_123_JVM"));
        buttonGroup2.add(jMenuItem);
        jMenuItem.setSelected(true);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_124_JVM"), FIT_TO_CLIENT_RES, LocaleStrings.getString("F_125_JVM"));
        buttonGroup2.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_126_JVM"), FIT_TO_HOST_RES, LocaleStrings.getString("F_127_JVM"));
        buttonGroup2.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(ZOOM_OPTION_NONE, ZOOM_OPTION_NONE, ZOOM_OPTION_NONE);
        buttonGroup2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_128_JVM"), ' ', OPTIONS_IPMI_COMMAND, LocaleStrings.getString("F_129_JVM"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu2 = this.createMenu(LocaleStrings.getString("F_117_JVM"), null, ' ', null);
        m_menustatusbar_text.put(OPTIONS_GUI_LANGUAGE, LocaleStrings.getString("F_118_JVM"));
        this.m_menu.put(OPTIONS_GUI_LANGUAGE, jMenu2);
        buttonGroup = new ButtonGroup();
        String string = null;
        String[] stringArray = JViewer.getSupportedLocales();
        for (int i = 0; i < stringArray.length; ++i) {
            string = this.getLocaleCode(stringArray[i]);
            jMenuItem = this.createRadioButtonMenu(stringArray[i], OPTIONS_GUI_LANGUAGE_LOCALE + string, LocaleStrings.getString("F_119_JVM") + stringArray[i]);
            buttonGroup.add(jMenuItem);
            jMenu2.add(jMenuItem);
        }
        this.notifyMenuStateSelected(OPTIONS_GUI_LANGUAGE_LOCALE + JViewer.getLanguage(), true);
        jMenu.add(jMenu2);
        return jMenu;
    }

    protected JMenu constructDeviceRedirMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_64_JVM"), MEDIA, 'd', LocaleStrings.getString("F_65_JVM"));
        JMenuItem jMenuItem = this.createMenuItem(LocaleStrings.getString("F_66_JVM"), 'V', DEVICE_MEDIA_DIALOG, LocaleStrings.getString("F_65_JVM"));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu constructHelpMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_67_JVM"), HELP_ABOUT_RCONSOLE, 'H', LocaleStrings.getString("F_68_JVM"));
        JMenuItem jMenuItem = this.createMenuItem(LocaleStrings.getString("F_69_JVM") + JViewer.getTitle(), ' ', 112, 2, HELP_ABOUT_RCONSOLE, LocaleStrings.getString("F_68_JVM"));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu constructKeyboardLayoutMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_70_JVM"), KEYBOARD_LAYOUT, 'L', LocaleStrings.getString("F_71_JVM"));
        JMenuItem jMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("F_72_JVM"), ' ', AUTOMATIC_LANGUAGE, LocaleStrings.getString("F_73_JVM"));
        jMenu.add(jMenuItem);
        JMenu jMenu2 = this.createMenu(LocaleStrings.getString("F_115_JVM"), null, ' ', null);
        this.m_menu.put(PHYSICAL_KEYBOARD, jMenu2);
        m_menustatusbar_text.put(PHYSICAL_KEYBOARD, LocaleStrings.getString("F_115_JVM"));
        ButtonGroup buttonGroup = new ButtonGroup();
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setenabled.put(PHYSICAL_KEYBOARD, true);
        }
        JMenu jMenu3 = this.createMenu(LocaleStrings.getString("F_147_JVM"), " ", ' ', LocaleStrings.getString("F_148_JVM"));
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_143_JVM"), WINDOWS_HOST, LocaleStrings.getString("F_145_JVM"));
        buttonGroup.add(jMenuItem);
        ((Container)jMenu3).add(jMenuItem);
        jMenuItem.setSelected(true);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_144_JVM"), LINUX_HOST, LocaleStrings.getString("F_146_JVM"));
        buttonGroup.add(jMenuItem);
        ((Container)jMenu3).add(jMenuItem);
        jMenu2.add(jMenu3);
        jMenu2.addSeparator();
        buttonGroup = new ButtonGroup();
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_77_JVM"), PKBRD_LANGUAGE_ENGLISH_US, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_77_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_78_JVM"), PKBRD_LANGUAGE_ENGLISH_UK, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_78_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_80_JVM"), PKBRD_LANGUAGE_FRENCH_FRANCE, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_80_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_90_JVM"), PKBRD_LANGUAGE_FRENCH_BELGIUM, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_90_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_81_JVM"), PKBRD_LANGUAGE_GERMAN_GER, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_81_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_85_JVM"), PKBRD_LANGUAGE_GERMAN_SWISS, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_85_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_93_JVM"), PKBRD_LANGUAGE_JAPANESE, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_93_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_79_JVM"), PKBRD_LANGUAGE_SPANISH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_79_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_82_JVM"), PKBRD_LANGUAGE_ITALIAN, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_82_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_83_JVM"), PKBRD_LANGUAGE_DANISH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_83_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_84_JVM"), PKBRD_LANGUAGE_FINNISH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_84_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_86_JVM"), PKBRD_LANGUAGE_NORWEGIAN, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_86_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_87_JVM"), PKBRD_LANGUAGE_PORTUGUESE, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_87_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_88_JVM"), PKBRD_LANGUAGE_SWEDISH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_88_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_142_JVM"), PKBRD_LANGUAGE_DUTCH_NL, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_142_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_91_JVM"), PKBRD_LANGUAGE_DUTCH_BE, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_91_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_94_JVM"), PKBRD_LANGUAGE_TURKISH_F, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_94_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_95_JVM"), PKBRD_LANGUAGE_TURKISH_Q, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_95_JVM") + LocaleStrings.getString("F_116_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(PKBRD_NONE, PKBRD_NONE, PKBRD_NONE);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenu2 = this.createMenu(LocaleStrings.getString("F_74_JVM"), null, ' ', null);
        this.m_menu.put(SOFTKEYBOARD, jMenu2);
        m_menustatusbar_text.put(SOFTKEYBOARD, LocaleStrings.getString("F_74_JVM"));
        buttonGroup = new ButtonGroup();
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setenabled.put(SOFTKEYBOARD, true);
        }
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_77_JVM"), SKBRD_LANGUAGE_ENGLISH_US, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_77_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_78_JVM"), SKBRD_LANGUAGE_ENGLISH_UK, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_78_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_79_JVM"), SKBRD_LANGUAGE_SPANISH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_79_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_80_JVM"), SKBRD_LANGUAGE_FRENCH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_80_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_81_JVM"), SKBRD_LANGUAGE_GERMAN_GER, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_81_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_82_JVM"), SKBRD_LANGUAGE_ITALIAN, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_82_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_83_JVM"), SKBRD_LANGUAGE_DANISH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_83_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_84_JVM"), SKBRD_LANGUAGE_FINNISH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_84_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_85_JVM"), SKBRD_LANGUAGE_GERMAN_SWITZ, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_85_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_86_JVM"), SKBRD_LANGUAGE_NORWEGIAN_NOR, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_86_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_87_JVM"), SKBRD_LANGUAGE_PORTUGUESE, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_87_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_88_JVM"), SKBRD_LANGUAGE_SWEDISH, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_88_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_89_JVM"), SKBRD_LANGUAGE_HEBREW, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_89_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_90_JVM"), SKBRD_LANGUAGE_FRENCH_BELGIUM, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_90_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_142_JVM"), SKBRD_LANGUAGE_DUTCH_NL, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_142_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_91_JVM"), SKBRD_LANGUAGE_DUTCH_BELGIUM, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_91_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_92_JVM"), SKBRD_LANGUAGE_RUSSIAN, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_92_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_139_JVM"), SKBRD_LANGUAGE_JAPANESE_Q, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_139_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_140_JVM"), SKBRD_LANGUAGE_JAPANESE_H, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_140_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_141_JVM"), SKBRD_LANGUAGE_JAPANESE_K, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_141_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_94_JVM"), SKBRD_LANGUAGE_TURKISH_F, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_94_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = this.createRadioButtonMenu(LocaleStrings.getString("F_95_JVM"), SKBRD_LANGUAGE_TURKISH_Q, LocaleStrings.getString("F_75_JVM") + LocaleStrings.getString("F_95_JVM") + LocaleStrings.getString("F_76_JVM"));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        return jMenu;
    }

    protected JMenu constructVideoRecordMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_96_JVM"), VIDEO_RECORD, 'i', LocaleStrings.getString("F_97_JVM"));
        JMenuItem jMenuItem = this.createMenuItem(LocaleStrings.getString("F_98_JVM"), ' ', VIDEO_RECORD_START, LocaleStrings.getString("F_99_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_100_JVM"), ' ', VIDEO_RECORD_STOP, LocaleStrings.getString("F_101_JVM"), false);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_102_JVM"), ' ', VIDEO_RECORD_SETTINGS, LocaleStrings.getString("F_103_JVM"));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu constructPowerMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_104_JVM"), POWER_CONTROL, 'w', LocaleStrings.getString("F_105_JVM"));
        JMenuItem jMenuItem = this.createMenuItem(LocaleStrings.getString("F_106_JVM"), ' ', POWER_RESET_SERVER, LocaleStrings.getString("F_106_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_107_JVM"), ' ', POWER_OFF_IMMEDIATE, LocaleStrings.getString("F_107_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_108_JVM"), ' ', POWER_OFF_ORDERLY, LocaleStrings.getString("F_108_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_109_JVM"), ' ', POWER_ON_SERVER, LocaleStrings.getString("F_109_JVM"));
        jMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem(LocaleStrings.getString("F_110_JVM"), ' ', POWER_CYCLE_SERVER, LocaleStrings.getString("F_110_JVM"));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu constructUserMenu() {
        JMenu jMenu = this.createMenu(LocaleStrings.getString("F_111_JVM"), ACTIVE_USERS, 'A', LocaleStrings.getString("F_112_JVM"));
        int n = KVMClient.getNumUsers();
        String[] stringArray = KVMClient.getUserData();
        if (stringArray != null && n != 0) {
            for (int i = 0; i < n; ++i) {
                URL uRL;
                ImageIcon imageIcon = null;
                String string = stringArray[i].substring(stringArray[i].indexOf(":") + 1, stringArray[i].length()).trim();
                String string2 = stringArray[i].substring(0, stringArray[i].indexOf(":") - 1).trim();
                if (Integer.parseInt(string2) == JViewerApp.getInstance().getCurrentSessionId() && (uRL = JViewer.class.getResource("res/green.png")) != null) {
                    imageIcon = new ImageIcon(uRL);
                }
                jMenu.add(new JMenuItem(string, imageIcon));
            }
        }
        return jMenu;
    }

    public JMenuItem createCustomActiveuserMenuItem(final int n, String string, Icon icon) {
        JMenuItem jMenuItem = null;
        jMenuItem = KVMSharing.KVM_REQ_GIVEN == 0 ? new JMenuItem(string + "           ", icon) : new JMenuItem(string, icon);
        jMenuItem.setLayout(new FlowLayout(2, 5, 0));
        if (KVMSharing.KVM_REQ_GIVEN == 0 && icon == null) {
            URL uRL = JViewer.class.getResource("res/error.png");
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage();
            Image image2 = image.getScaledInstance(15, 15, 4);
            ImageIcon imageIcon2 = new ImageIcon(image2);
            JButton jButton = new JButton(imageIcon2);
            jButton.setToolTipText(LocaleStrings.getString("H_19_KVMS"));
            jButton.setMargin(new Insets(0, 2, 0, 2));
            jButton.setBorder(null);
            jMenuItem.add(jButton);
            jButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    JViewerApp.getInstance().OnTerminateActiveuser(n);
                }
            });
        }
        return jMenuItem;
    }

    public void updateUserMenu() {
        if (this.getMenu(ACTIVE_USERS) == null) {
            return;
        }
        JMenu jMenu = JViewerApp.getInstance().getM_frame().getMenu().getMenu(ACTIVE_USERS);
        jMenu.removeAll();
        int n = KVMClient.getNumUsers();
        String[] stringArray = KVMClient.getUserData();
        for (int i = 0; i < n; ++i) {
            URL uRL;
            ImageIcon imageIcon = null;
            String string = stringArray[i].substring(stringArray[i].indexOf(":") + 1, stringArray[i].length()).trim();
            String string2 = stringArray[i].substring(0, stringArray[i].indexOf(":") - 1).trim();
            if (Integer.parseInt(string2) == JViewerApp.getInstance().getCurrentSessionId() && (uRL = JViewer.class.getResource("res/green.png")) != null) {
                imageIcon = new ImageIcon(uRL);
            }
            jMenu.add(this.createCustomActiveuserMenuItem(Integer.parseInt(string2), string, imageIcon));
        }
    }

    protected void enableMenuMnemonics(boolean bl) {
        Set<Map.Entry<String, Character>> set = menuMnemonics.entrySet();
        Iterator<Map.Entry<String, Character>> iterator = set.iterator();
        String string = null;
        while (iterator.hasNext()) {
            Map.Entry<String, Character> entry = iterator.next();
            string = entry.getKey();
            Character c = entry.getValue();
            if (bl) {
                if (this.getMenu(string) != null) {
                    this.getMenu(string).setMnemonic('\u0000');
                    continue;
                }
                if (this.getMenuItem(string) == null) continue;
                this.getMenuItem(string).setMnemonic('\u0000');
                continue;
            }
            if (this.getMenu(string) != null) {
                this.getMenu(string).setMnemonic(c.charValue());
                continue;
            }
            if (this.getMenuItem(string) == null) continue;
            this.getMenuItem(string).setMnemonic(c.charValue());
        }
    }

    protected void enableMenuAccelerator(boolean bl) {
        Set<Map.Entry<String, KeyStroke>> set = menuAccelerator.entrySet();
        for (Map.Entry<String, KeyStroke> entry : set) {
            String string = entry.getKey();
            KeyStroke keyStroke = entry.getValue();
            if (bl) {
                if (this.getMenuItem(string) == null) continue;
                this.getMenuItem(string).setAccelerator(null);
                continue;
            }
            if (this.getMenuItem(string) == null) continue;
            this.getMenuItem(string).setAccelerator(keyStroke);
        }
    }

    protected JLabel constructZoomLabelText() {
        this.label_Text = new JLabel(LocaleStrings.getString("F_113_JVM") + "100%");
        return this.label_Text;
    }

    protected void addFullPermissionMenuItem() {
        if (this.getMenuItem(OPTIONS_REQUEST_FULL_PERMISSION) == null) {
            JMenu jMenu = this.getMenu(OPTION);
            JMenuItem jMenuItem = this.createMenuItem(LocaleStrings.getString("F_132_JVM"), ' ', OPTIONS_REQUEST_FULL_PERMISSION, LocaleStrings.getString("F_133_JVM"));
            jMenu.add(jMenuItem);
        }
    }

    public void removeFullPermissionMenuItem() {
        JViewerApp jViewerApp = JViewerApp.getInstance();
        if (this.getMenuItem(OPTIONS_REQUEST_FULL_PERMISSION) != null) {
            JMenuItem jMenuItem = this.getMenuItem(OPTIONS_REQUEST_FULL_PERMISSION);
            this.getMenu(OPTION).remove(jMenuItem);
            this.m_menuItems.remove(OPTIONS_REQUEST_FULL_PERMISSION);
        }
        jViewerApp.setFullPermissionRequest(false);
    }

    protected void addBlockPermissionMenuItem() {
        JMenu jMenu = this.getMenu(OPTION);
        JMenu jMenu2 = this.getMenu(OPTIONS_BLOCK_FULL_PERMISSION);
        if (jMenu2 == null) {
            jMenu2 = this.createMenu(LocaleStrings.getString("F_149_JVM"), OPTIONS_BLOCK_FULL_PERMISSION, ' ', LocaleStrings.getString("F_150_JVM"));
            jMenu.add(jMenu2);
            JCheckBoxMenuItem jCheckBoxMenuItem = this.createCheckBoxMenuItem(LocaleStrings.getString("H_2_KVMS"), ' ', OPTIONS_BLOCK_WITH_VIDEO_ONLY, LocaleStrings.getString("H_2_KVMS"));
            JCheckBoxMenuItem jCheckBoxMenuItem2 = this.createCheckBoxMenuItem(LocaleStrings.getString("H_3_KVMS"), ' ', OPTIONS_BLOCK_WITH_DENY, LocaleStrings.getString("H_3_KVMS"));
            jMenu2.add(jCheckBoxMenuItem);
            jMenu2.add(jCheckBoxMenuItem2);
            this.notifyMenuStateSelected(OPTIONS_BLOCK_WITH_VIDEO_ONLY, false);
            this.notifyMenuStateSelected(OPTIONS_BLOCK_WITH_DENY, false);
        } else {
            jMenu2.setVisible(true);
        }
    }

    public void removeBlockPermissionMenuItem() {
        JMenu jMenu = this.getMenu(OPTIONS_BLOCK_FULL_PERMISSION);
        if (jMenu != null) {
            this.notifyMenuStateSelected(OPTIONS_BLOCK_WITH_VIDEO_ONLY, false);
            this.notifyMenuStateSelected(OPTIONS_BLOCK_WITH_DENY, false);
            jMenu.setVisible(false);
        }
    }

    public void setZoomLabelText(String string) {
        this.label_Text.setText(LocaleStrings.getString("F_113_JVM") + string);
    }

    public Hashtable<String, JMenuItem> getM_menuItems() {
        return this.m_menuItems;
    }

    public void setM_menuItems(Hashtable<String, JMenuItem> hashtable) {
        this.m_menuItems = hashtable;
    }

    protected JLabel constructString() {
        this.menu_string = null;
        this.menu_string = new JLabel();
        this.menu_string.setVisible(true);
        return this.menu_string;
    }

    protected int RemoveString() {
        this.menu_string = null;
        return 0;
    }

    public Hashtable<String, JMenu> getM_menu() {
        return this.m_menu;
    }

    public void setM_menu(Hashtable<String, JMenu> hashtable) {
        this.m_menu = hashtable;
    }

    public static Hashtable<String, Character> getMenuMnemonics() {
        return menuMnemonics;
    }

    public static Hashtable<String, KeyStroke> getMenuAccelerator() {
        return menuAccelerator;
    }

    public JMenu getMacroSubMenu() {
        return this.macroSubMenu;
    }

    public void setMacroSubMenu(JMenu jMenu) {
        this.macroSubMenu = jMenu;
    }

    public static int getComponentIndex(Component component) {
        int n = -1;
        Container container = null;
        if (component != null && (container = component.getParent()) != null) {
            for (n = 0; n < container.getComponentCount(); ++n) {
                if (container.getComponent(n) != component) continue;
                return n;
            }
        } else {
            Debug.out.println("getComponentIndex() : component/component.getParent() is null");
        }
        return n;
    }

    private String getLocaleCode(String string) {
        String string2 = LOCALE_CODE_START_DELIM;
        int n = string.indexOf(string2) + string2.length();
        int n2 = string.indexOf(LOCALE_CODE_END_DELIM);
        String string3 = string.substring(n, n2);
        return string3;
    }

    static {
        m_scale = 1.0;
        keyBoardLayout = -1;
        softkeyBoardLayout = -1;
        KVMPartialExceptionMenuItems = new String[]{VIDEO_PAUSE_REDIRECTION, VIDEO_RESUME_REDIRECTION, VIDEO_REFRESH, VIDEO_CAPTURE_SCREEN, VIDEO_FULL_SCREEN, VIDEO_EXIT, OPTIONS_BANDWIDTH_AUTO_DETECT, OPTIONS_BANDWIDTH_256KBPS, OPTIONS_BANDWIDTH_512KBPS, OPTIONS_BANDWIDTH_1MBPS, OPTIONS_BANDWIDTH_10MBPS, OPTIONS_BANDWIDTH_100MBPS, ZOOM_IN, ZOOM_OUT, ACTUAL_SIZE, FIT_TO_CLIENT_RES, FIT_TO_HOST_RES, ZOOM_OPTION_NONE, VIDEO_RECORD_SETTINGS, VIDEO_RECORD_START, VIDEO_RECORD_STOP, HELP_ABOUT_RCONSOLE};
    }

    private static class JVMenuStatusListener
    extends MouseAdapter {
        private JVMenuStatusListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            String string;
            Object object;
            try {
                object = (JMenu)mouseEvent.getSource();
                string = ((AbstractButton)object).getActionCommand();
            }
            catch (Exception exception) {
                Debug.out.println(mouseEvent);
                string = ((JMenuItem)mouseEvent.getSource()).getActionCommand();
            }
            object = JViewerApp.getInstance();
            String string2 = m_menustatusbar_text.get(string);
            ((JViewerApp)object).setStatus(string2);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JViewerApp.getInstance().resetStatus();
        }
    }

    private class JVMenuListener
    implements ActionListener {
        private JVMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JViewerApp.getOEMManager().getOEMJVMenu().handleMenuEvents(actionEvent) == 1) {
                return;
            }
            String string = actionEvent.getActionCommand();
            JViewerApp jViewerApp = JViewerApp.getInstance();
            if (string.equals(JVMenu.VIDEO_PAUSE_REDIRECTION)) {
                jViewerApp.setM_userPause(true);
                jViewerApp.OnVideoPauseRedirection();
            } else if (string.equals(JVMenu.VIDEO_RESUME_REDIRECTION)) {
                jViewerApp.OnVideoResumeRedirection();
            } else if (string.equals(JVMenu.VIDEO_REFRESH)) {
                jViewerApp.OnVideoRefreshRedirection();
            } else if (string.equals(JVMenu.VIDEO_HOST_DISPLAY_UNLOCK)) {
                jViewerApp.onSendHostLock((byte)0);
            } else if (string.equals(JVMenu.VIDEO_HOST_DISPLAY_LOCK)) {
                jViewerApp.onSendHostLock((byte)1);
            } else if (string.equals(JVMenu.VIDEO_CAPTURE_SCREEN)) {
                jViewerApp.onVideoCaptureScreen();
            } else if (string.equals(JVMenu.VIDEO_FULL_SCREEN)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                jViewerApp.OnVideoFullScreen(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.VIDEO_EXIT)) {
                jViewerApp.OnVideoExit();
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_CTRL_KEY)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                jViewerApp.OnKeyboardHoldRightCtrlKey(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_ALT_KEY)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                jViewerApp.OnKeyboardHoldRightAltKey(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_CTRL_KEY)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                jViewerApp.OnKeyboardHoldLeftCtrlKey(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_ALT_KEY)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                jViewerApp.OnKeyboardHoldLeftAltKey(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSHOLD)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                jViewerApp.OnKeyboardLeftWindowsKeyHoldDown(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSRELEASE)) {
                jViewerApp.OnKeyboardLeftWindowsKeyPressRelease();
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSHOLD)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                jViewerApp.OnKeyboardRightWindowsKeyHoldDown(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSRELEASE)) {
                jViewerApp.OnKeyboardRightWindowsKeyPressRelease();
            } else if (string.equals(JVMenu.KEYBOARD_CTRL_ALT_DEL)) {
                if ((jViewerApp.getJVMenu().getMenuSelected(JVMenu.KEYBOARD_LEFT_CTRL_KEY).booleanValue() || jViewerApp.getJVMenu().getMenuSelected(JVMenu.KEYBOARD_RIGHT_CTRL_KEY).booleanValue()) && (jViewerApp.getJVMenu().getMenuSelected(JVMenu.KEYBOARD_LEFT_ALT_KEY).booleanValue() || jViewerApp.getJVMenu().getMenuSelected(JVMenu.KEYBOARD_RIGHT_ALT_KEY).booleanValue())) {
                    return;
                }
                jViewerApp.OnKeyboardAltCtrlDel();
            } else if (string.equals(JVMenu.KEYBOARD_CONTEXT_MENU)) {
                jViewerApp.OnKeyboardContextMenu();
            } else if (string.equals(JVMenu.KEYBOARD_FULL_KEYBOARD)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                JVMenu.this.SetMenuSelected(JVMenu.KEYBOARD_FULL_KEYBOARD, jCheckBoxMenuItem.getState());
                JViewerApp.getInstance().setFullKeyboardEnabled(jCheckBoxMenuItem.getState());
                JVMenu.this.enableMenuMnemonics(jCheckBoxMenuItem.getState());
                JVMenu.this.enableMenuAccelerator(jCheckBoxMenuItem.getState());
            } else if (!string.equals(JVMenu.WINDOWS_HOST) && !string.equals(JVMenu.LINUX_HOST)) {
                if (string.equals(JVMenu.KEYBOARD_ADD_HOTKEYS)) {
                    jViewerApp.OnAddMacro();
                } else if (string.equals(JVMenu.MOUSE_CLIENTCURSOR_CONTROL)) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    jViewerApp.OnShowCursor(jCheckBoxMenuItem.getState());
                } else if (string.equals(JVMenu.CALIBRATEMOUSETHRESHOLD)) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    if (JViewerApp.getInstance().GetRedirectionState() == JViewerApp.REDIR_STARTED) {
                        jViewerApp.OnCalibareteMouse(jCheckBoxMenuItem.getState());
                    } else {
                        JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected(JVMenu.CALIBRATEMOUSETHRESHOLD, false);
                    }
                } else if (string.equals(JVMenu.MOUSE_ABSOLUTE_MODE)) {
                    if (m_mouseMode != 2) {
                        jViewerApp.OnSendMouseMode((byte)2);
                    }
                } else if (string.equals(JVMenu.MOUSE_RELATIVE_MODE)) {
                    if (m_mouseMode != 1) {
                        jViewerApp.OnSendMouseMode((byte)1);
                    }
                } else if (string.equals(JVMenu.MOUSE_OTHER_MODE)) {
                    if (m_mouseMode != 3) {
                        jViewerApp.OnSendMouseMode((byte)3);
                    }
                } else if (string.equals(JVMenu.OPTIONS_BANDWIDTH_AUTO_DETECT)) {
                    jViewerApp.OnOptionsBandwidthAutoDetect();
                } else if (string.equals(JVMenu.OPTIONS_BANDWIDTH_256KBPS)) {
                    jViewerApp.OnOptionsBandwidth(32768);
                } else if (string.equals(JVMenu.OPTIONS_BANDWIDTH_512KBPS)) {
                    jViewerApp.OnOptionsBandwidth(65536);
                } else if (string.equals(JVMenu.OPTIONS_BANDWIDTH_1MBPS)) {
                    jViewerApp.OnOptionsBandwidth(131072);
                } else if (string.equals(JVMenu.OPTIONS_BANDWIDTH_10MBPS)) {
                    jViewerApp.OnOptionsBandwidth(0x140000);
                } else if (string.equals(JVMenu.OPTIONS_BANDWIDTH_100MBPS)) {
                    jViewerApp.OnOptionsBandwidth(0xC80000);
                } else if (string.equals(JVMenu.OPTIONS_KEYBOARD_MOUSE_ENCRYPTION)) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    jViewerApp.OnOptionsKeyboardMouseEncryption(jCheckBoxMenuItem.getState());
                } else if (string.startsWith(JVMenu.OPTIONS_IPMI_COMMAND)) {
                    jViewerApp.invokeIPMICommandDialog();
                } else if (string.startsWith(JVMenu.OPTIONS_GUI_LANGUAGE_LOCALE)) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string2 = JVMenu.this.getLocaleCode(jMenuItem.getText());
                    jViewerApp.OnGUILanguageChange(string2);
                } else if (string.equals(JVMenu.OPTIONS_REQUEST_FULL_PERMISSION)) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    jMenuItem.setEnabled(false);
                    jViewerApp.onSendFullPermissionRequest();
                } else if (string.equals(JVMenu.OPTIONS_BLOCK_WITH_VIDEO_ONLY)) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    JVMenu.this.SetMenuSelected(JVMenu.OPTIONS_BLOCK_WITH_VIDEO_ONLY, jCheckBoxMenuItem.isSelected());
                    JVMenu.this.notifyMenuStateSelected(JVMenu.OPTIONS_BLOCK_WITH_DENY, false);
                } else if (string.equals(JVMenu.OPTIONS_BLOCK_WITH_DENY)) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    JVMenu.this.SetMenuSelected(JVMenu.OPTIONS_BLOCK_WITH_DENY, jCheckBoxMenuItem.isSelected());
                    JVMenu.this.notifyMenuStateSelected(JVMenu.OPTIONS_BLOCK_WITH_VIDEO_ONLY, false);
                } else if (string.equals(JVMenu.HELP_ABOUT_RCONSOLE)) {
                    jViewerApp.OnHelpAboutJViewer();
                } else if (string.equals(JVMenu.DEVICE_MEDIA_DIALOG)) {
                    Debug.out.println("MEDIA LICENSE STATUS : " + JViewer.getMediaLicenseStatus());
                    if (JViewer.getMediaLicenseStatus() == 1) {
                        jViewerApp.OnvMedia(0);
                    } else {
                        InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("F_136_JVM"), LocaleStrings.getString("2_4_KVMCLIENT"), 1);
                    }
                } else if (string.equals(JVMenu.AUTOMATIC_LANGUAGE)) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    jViewerApp.onAutoKeyboardLayout(jCheckBoxMenuItem.getState(), true);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_ENGLISH_US)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_ENGLISH_US);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_ENGLISH_UK)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_ENGLISH_UK);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_FRENCH_FRANCE)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_FRENCH_FRANCE);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_FRENCH_BELGIUM)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_FRENCH_BELGIUM);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_GERMAN_GER)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_GERMAN_GER);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_GERMAN_SWISS)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_GERMAN_SWISS);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_JAPANESE)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_JAPANESE);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_SPANISH)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_SPANISH);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_ITALIAN)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_ITALIAN);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_DANISH)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_DANISH);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_FINNISH)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_FINNISH);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_NORWEGIAN)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_NORWEGIAN);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_PORTUGUESE)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_PORTUGUESE);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_SWEDISH)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_SWEDISH);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_DUTCH_NL)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_DUTCH_NL);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_DUTCH_BE)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_DUTCH_BE);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_TURKISH_F)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_TURKISH_F);
                } else if (string.equals(JVMenu.PKBRD_LANGUAGE_TURKISH_Q)) {
                    JViewerApp.getInstance().setKeyProcessor(JVMenu.PKBRD_LANGUAGE_TURKISH_Q);
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_ENGLISH_US)) {
                    jViewerApp.OnSkbrdDisplay(0);
                    keyBoardLayout = 0;
                    softkeyBoardLayout = 0;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_ENGLISH_UK)) {
                    jViewerApp.OnSkbrdDisplay(1);
                    keyBoardLayout = 1;
                    softkeyBoardLayout = 1;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_SPANISH)) {
                    jViewerApp.OnSkbrdDisplay(2);
                    keyBoardLayout = 2;
                    softkeyBoardLayout = 2;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_FRENCH)) {
                    jViewerApp.OnSkbrdDisplay(3);
                    keyBoardLayout = 3;
                    softkeyBoardLayout = 3;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_GERMAN_GER)) {
                    jViewerApp.OnSkbrdDisplay(4);
                    keyBoardLayout = 4;
                    softkeyBoardLayout = 4;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_ITALIAN)) {
                    jViewerApp.OnSkbrdDisplay(5);
                    keyBoardLayout = 5;
                    softkeyBoardLayout = 5;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_DANISH)) {
                    jViewerApp.OnSkbrdDisplay(6);
                    keyBoardLayout = 6;
                    softkeyBoardLayout = 6;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_FINNISH)) {
                    jViewerApp.OnSkbrdDisplay(7);
                    keyBoardLayout = 7;
                    softkeyBoardLayout = 7;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_GERMAN_SWITZ)) {
                    jViewerApp.OnSkbrdDisplay(8);
                    keyBoardLayout = 8;
                    softkeyBoardLayout = 8;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_NORWEGIAN_NOR)) {
                    jViewerApp.OnSkbrdDisplay(9);
                    keyBoardLayout = 9;
                    softkeyBoardLayout = 9;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_PORTUGUESE)) {
                    jViewerApp.OnSkbrdDisplay(10);
                    keyBoardLayout = 10;
                    softkeyBoardLayout = 10;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_SWEDISH)) {
                    jViewerApp.OnSkbrdDisplay(11);
                    keyBoardLayout = 11;
                    softkeyBoardLayout = 11;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_HEBREW)) {
                    jViewerApp.OnSkbrdDisplay(12);
                    keyBoardLayout = 12;
                    softkeyBoardLayout = 12;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_FRENCH_BELGIUM)) {
                    jViewerApp.OnSkbrdDisplay(13);
                    keyBoardLayout = 13;
                    softkeyBoardLayout = 13;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_DUTCH_BELGIUM)) {
                    jViewerApp.OnSkbrdDisplay(14);
                    keyBoardLayout = 14;
                    softkeyBoardLayout = 14;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_DUTCH_NL)) {
                    jViewerApp.OnSkbrdDisplay(21);
                    keyBoardLayout = 21;
                    softkeyBoardLayout = 21;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_RUSSIAN)) {
                    jViewerApp.OnSkbrdDisplay(15);
                    keyBoardLayout = 15;
                    softkeyBoardLayout = 15;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_JAPANESE_Q)) {
                    jViewerApp.OnSkbrdDisplay(16);
                    keyBoardLayout = 16;
                    softkeyBoardLayout = 16;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_JAPANESE_H)) {
                    jViewerApp.OnSkbrdDisplay(19);
                    keyBoardLayout = 19;
                    softkeyBoardLayout = 19;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_JAPANESE_K)) {
                    jViewerApp.OnSkbrdDisplay(20);
                    keyBoardLayout = 20;
                    softkeyBoardLayout = 20;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_TURKISH_F)) {
                    jViewerApp.OnSkbrdDisplay(17);
                    keyBoardLayout = 17;
                    softkeyBoardLayout = 17;
                } else if (string.equals(JVMenu.SKBRD_LANGUAGE_TURKISH_Q)) {
                    jViewerApp.OnSkbrdDisplay(18);
                    keyBoardLayout = 18;
                    softkeyBoardLayout = 18;
                } else if (string.equals(JVMenu.VIDEO_RECORD_START)) {
                    if (JViewerApp.getInstance().getM_videorecord() == null) {
                        JViewerApp.getInstance().setM_videorecord(new VideoRecord());
                        JViewerApp.getInstance().getM_videorecord().StoreLocation = JViewerApp.getInstance().VIDEO_RECORD_DEFAULT_PATH;
                        VideoRecord.RecordStopTimer = JViewerApp.getInstance().VIDEO_RECORD_DEFAULT_TIME;
                    }
                    jViewerApp.getM_videorecord().OnVideoRecordStart();
                } else if (string.equals(JVMenu.VIDEO_RECORD_STOP)) {
                    jViewerApp.getM_videorecord().OnVideoRecordStop();
                } else if (string.equals(JVMenu.VIDEO_RECORD_SETTINGS)) {
                    jViewerApp.OnVideoRecordSettings();
                } else if (string.equals(JVMenu.ZOOM_IN)) {
                    jViewerApp.OnVideoZoomIn();
                } else if (string.equals(JVMenu.ZOOM_OUT)) {
                    jViewerApp.OnVideoZoomOut();
                } else if (string.equals(JVMenu.ACTUAL_SIZE) || string.equals(JVMenu.FIT_TO_CLIENT_RES) || string.equals(JVMenu.FIT_TO_HOST_RES)) {
                    if (!string.equals(JViewerApp.getInstance().getZoomOption())) {
                        jViewerApp.onChangeZoomOptions(string);
                    }
                } else if (string.equals(JVMenu.POWER_RESET_SERVER)) {
                    jViewerApp.onSendPowerControlCommand(JVMenu.POWER_RESET_SERVER);
                } else if (string.equals(JVMenu.POWER_OFF_IMMEDIATE)) {
                    jViewerApp.onSendPowerControlCommand(JVMenu.POWER_OFF_IMMEDIATE);
                } else if (string.equals(JVMenu.POWER_OFF_ORDERLY)) {
                    jViewerApp.onSendPowerControlCommand(JVMenu.POWER_OFF_ORDERLY);
                } else if (string.equals(JVMenu.POWER_ON_SERVER)) {
                    jViewerApp.onSendPowerControlCommand(JVMenu.POWER_ON_SERVER);
                } else if (string.equals(JVMenu.POWER_CYCLE_SERVER)) {
                    jViewerApp.onSendPowerControlCommand(JVMenu.POWER_CYCLE_SERVER);
                } else if (string.startsWith("HK_")) {
                    Set<Map.Entry<String, String>> set = JViewerApp.getInstance().getAddMacro().macroMap.entrySet();
                    String string3 = string.substring(3);
                    for (Map.Entry<String, String> entry : set) {
                        String string4 = entry.getKey();
                        if (!string3.equals(string4)) continue;
                        JViewerApp.getInstance().OnsendMacrokeycode(entry.getValue());
                    }
                } else {
                    jViewerApp.getSoc_App().SOC_Menu_ActionMethod(actionEvent);
                }
            }
        }
    }
}

