/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVToolBar;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.videorecord.DisplayVideoDataTask;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;

public class RecorderToolBar
extends JVToolBar
implements MouseListener {
    private JToolBar m_recToolbar = new JToolBar();
    private int counter = 0;
    public JButton replayButton;
    public static final String PAUSE = "PAUSE";
    public static final String PLAY = "PLAY";
    private static JSlider slider;
    private static JPanel panel;
    private static JLabel label;

    public RecorderToolBar() {
        panel = new JPanel();
        label = new JLabel("0");
        slider = new JSlider(0, 200);
        slider.setEnabled(false);
        Dimension dimension = slider.getPreferredSize();
        slider.setPreferredSize(new Dimension(dimension.width + 500, dimension.height));
        slider.setMajorTickSpacing(20);
        slider.setVisible(false);
        label.setVisible(false);
        panel.add(slider);
        panel.add(label);
        panel.setVisible(false);
        this.replayButton = this.createButton("res/pause.png", LocaleStrings.getString("R_2_RT"), 33, 33, 33, 33);
        this.m_recToolbar.add(this.replayButton);
        EtchedBorder etchedBorder = new EtchedBorder(1);
        this.m_recToolbar.setBorder(etchedBorder);
        this.m_recToolbar.setFloatable(false);
        this.m_recToolbar.repaint();
    }

    @Override
    public JToolBar getToolBar() {
        return this.m_recToolbar;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.replayButton.getActionCommand().equals(PAUSE)) {
            if (DisplayVideoDataTask.getVideoDuration() != 0 && JViewer.isplayerapp()) {
                this.counter = DisplayVideoDataTask.getCounter();
                DisplayVideoDataTask.pause();
            }
            this.replayButton.setIcon(new ImageIcon(JViewer.class.getResource("res/play.png")));
            this.replayButton.setToolTipText(LocaleStrings.getString("R_1_RT"));
            this.replayButton.setActionCommand(PLAY);
            DisplayVideoDataTask.setPaused(true);
        } else if (this.replayButton.getActionCommand().equals(PLAY)) {
            if (DisplayVideoDataTask.getVideoDuration() != 0 && JViewer.isplayerapp()) {
                DisplayVideoDataTask.resume();
                DisplayVideoDataTask.setCounter(this.counter);
            }
            this.replayButton.setIcon(new ImageIcon(JViewer.class.getResource("res/pause.png")));
            this.replayButton.setToolTipText(LocaleStrings.getString("R_2_RT"));
            this.replayButton.setActionCommand(PAUSE);
            Object object = DisplayVideoDataTask.getPlayLock();
            synchronized (object) {
                DisplayVideoDataTask.setPaused(false);
                DisplayVideoDataTask.getPlayLock().notifyAll();
            }
        } else {
            JViewerApp.getInstance().getVideorecordapp().OnVideorecordStartRedirection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void disableButton(JButton jButton) {
        jButton.setEnabled(false);
        jButton.removeMouseListener(this);
    }

    public void enableButton(JButton jButton) {
        jButton.setEnabled(true);
        jButton.addMouseListener(this);
    }

    public static JPanel getPanel() {
        return panel;
    }

    public static JLabel getLabel() {
        return label;
    }

    public static void setLabel(JLabel jLabel) {
        label = jLabel;
    }

    public static JSlider getSlider() {
        return slider;
    }

    public static void setSlider(JSlider jSlider) {
        slider = jSlider;
    }

    public static void updateComponents(int n) {
        label.setVisible(true);
        slider.setVisible(true);
        panel.setVisible(true);
        slider.setMaximum(n * 10);
    }
}

